/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector.utils;

import fr.dyade.aaa.agent.conf.A3CML;
import fr.dyade.aaa.agent.conf.A3CMLConfig;
import fr.dyade.aaa.agent.conf.A3CMLServer;
import fr.dyade.aaa.agent.conf.A3CMLService;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.objectweb.joram.client.connector.utils.Wrapper;

public class RAConfig {
    private static final String RA_XML = "META-INF/ra.xml";
    private static final String JORAM_CONFIG_JAR = "joram-config.jar";
    private static final String A3SERVERS_XML = "a3servers.xml";
    private static final String A3DEBUG_CFG = "a3debug.cfg";
    private static final String RA_PROPERTIES = "ra.properties";
    private static final String JORAMADMIN_CFG = "joram-admin.cfg";
    private static final String JORAMADMIN_XML = "joramAdmin.xml";
    private static final int BUFFER_SIZE = 2048;
    private static boolean debug = false;
    private static boolean verbose = false;
    private static String confDir = null;
    private static String tmpDir = null;

    private RAConfig() {
    }

    public static void main(String[] args) throws Exception {
        RAConfig raconfig = new RAConfig();
        debug = new Boolean(System.getProperty("debug", "false"));
        String rarName = null;
        String jarName = null;
        String raProperties = null;
        String extractFile = null;
        String hostName = null;
        String port = null;
        String serverId = null;
        String path = null;
        String newFileName = null;
        String oldFileName = null;
        int command = -1;
        try {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-rar")) {
                    rarName = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-jar")) {
                    jarName = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-c")) {
                    command = 1;
                    ++i;
                    continue;
                }
                if (args[i].equals("-u")) {
                    command = 2;
                    raProperties = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-x")) {
                    command = 3;
                    extractFile = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-uhp")) {
                    command = 4;
                    hostName = args[i + 1];
                    port = args[i + 2];
                    serverId = args[i + 3];
                    i += 3;
                    continue;
                }
                if (args[i].equals("-ua3")) {
                    command = 5;
                    hostName = args[i + 1];
                    port = args[i + 2];
                    serverId = args[i + 3];
                    i += 3;
                    continue;
                }
                if (args[i].equals("-uz")) {
                    command = 6;
                    path = args[i + 1];
                    newFileName = args[i + 2];
                    oldFileName = args[i + 3];
                    i += 3;
                    continue;
                }
                if (args[i].equals("-conf")) {
                    confDir = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-v")) {
                    verbose = true;
                    ++i;
                    continue;
                }
                ++i;
            }
        }
        catch (Exception e) {
            RAConfig.usage();
            e.printStackTrace();
            System.exit(1);
        }
        tmpDir = System.getProperty("java.io.tmpdir") + "/";
        switch (command) {
            case 1: {
                if (rarName == null) {
                    RAConfig.usage();
                }
                raconfig.createRaProperties(rarName);
                break;
            }
            case 2: {
                if (raProperties == null) {
                    RAConfig.usage();
                }
                raconfig.updateRAR(raProperties);
                break;
            }
            case 3: {
                if (extractFile != null) {
                    if (rarName != null) {
                        raconfig.extractFromRAR(rarName, extractFile);
                        break;
                    }
                    if (jarName != null) {
                        raconfig.extractFromJAR(jarName, extractFile);
                        break;
                    }
                    RAConfig.usage();
                    break;
                }
                RAConfig.usage();
                break;
            }
            case 4: {
                if (rarName == null || hostName == null || port == null || serverId == null) {
                    RAConfig.usage();
                }
                raconfig.updateHostPort(rarName, hostName, port, new Short(serverId));
                break;
            }
            case 5: {
                if (rarName == null || hostName == null || port == null || serverId == null) {
                    RAConfig.usage();
                }
                raconfig.updateA3Servers(rarName, hostName, port, new Short(serverId));
                break;
            }
            case 6: {
                if (path != null && newFileName != null) {
                    if (rarName != null) {
                        raconfig.updateZIP(rarName, path, newFileName, oldFileName);
                    }
                    if (jarName == null) break;
                    raconfig.updateZIP(jarName, path, newFileName, oldFileName);
                    break;
                }
                RAConfig.usage();
                break;
            }
            default: {
                RAConfig.usage();
            }
        }
    }

    public static void usage() {
        StringBuffer buff = new StringBuffer();
        buff.append("\n\n");
        buff.append("\nConfigure your Joram RAR:");
        buff.append("\n  -resource adapter deployment descriptor (ra.xml)");
        buff.append("\n  -joram server configuration file (a3servers.xml)");
        buff.append("\n\n");
        buff.append("\nSimple: create ra.properties, modify ra.properties and update rar.");
        buff.append("\n  create ra.properties         : java RAconfig -rar rarName -c");
        buff.append("\n  update RAR                   : java RAconfig -u ra.properties");
        buff.append("\n");
        buff.append("\nChange host and port value in ra.xml and a3servers.xml.");
        buff.append("\n  update RAR (host/port)       : java RAconfig -rar rarName -uhp host port serverId");
        buff.append("\nChange host and port value only in a3servers.xml");
        buff.append("\n  update A3servers (host/port) : java RAconfig -rar rarName -ua3 host port serverId");
        buff.append("\n\n");
        buff.append("\nExpert: extract ra.xml and a3servers.xml (joram-config.jar), modify and update jar/rar.");
        buff.append("\n  extract file from RAR        : java RAconfig -rar rarName -x fileName");
        buff.append("\n  update RAR                   : java RAconfig -rar rarName -uz path newFileName oldFileName");
        buff.append("\n");
        buff.append("\n  extract file from JAR        : java RAconfig -jar jarName -x fileName");
        buff.append("\n  update JAR                   : java RAconfig -jar jarName -uz path newFileName oldFileName");
        buff.append("\n\n");
        buff.append("\nVerbose                        : -v");
        buff.append("\n\n");
        buff.append("\nexample :");
        buff.append("\n   java RAconfig -u ra.properties");
        buff.append("\n   java RAconfig -rar joram.rar -uhp localhost 16010 0");
        buff.append("\n   java RAconfig -rar joram.rar -uz META-INF/ra.xml ra.xml META-INF/ra.xml");
        buff.append("\n\n\n");
        System.out.println(buff.toString());
    }

    private void createRaProperties(String rarName) throws Exception {
        if (debug) {
            System.out.println("RAConfig.createRaProperties(" + rarName + ")");
        } else if (verbose) {
            System.out.println("create ra.properties " + rarName);
        }
        File file = new File(rarName);
        if (file.exists()) {
            ZipFile zipFile = new ZipFile(file.getAbsolutePath());
            Enumeration<? extends ZipEntry> zippedFiles = zipFile.entries();
            while (zippedFiles.hasMoreElements()) {
                ZipEntry currEntry = zippedFiles.nextElement();
                if (debug) {
                    System.out.println("RAConfig.createRaProperties : currEntry = " + currEntry);
                }
                if (!currEntry.getName().equalsIgnoreCase(RA_XML)) continue;
                InputStream reader = zipFile.getInputStream(currEntry);
                StringBuffer buff = new StringBuffer();
                buff.append("RAR_NAME  ");
                buff.append(file.getAbsolutePath());
                buff.append("\n");
                buff.append(this.parse(reader));
                this.createFile(RA_PROPERTIES, buff.toString());
                break;
            }
            zipFile.close();
        }
    }

    private void extractFromRAR(String rarName, String fileName) throws Exception {
        if (debug) {
            System.out.println("RAConfig.extractFromRAR(" + rarName + "," + fileName + ")");
        } else if (verbose) {
            System.out.println("extract \"" + fileName + "\" from \"" + rarName + "\"");
        }
        InputStream res = null;
        File file = new File(rarName);
        if (file.exists()) {
            ZipFile zipFile = new ZipFile(file.getAbsolutePath());
            Enumeration<? extends ZipEntry> zippedFiles = zipFile.entries();
            while (zippedFiles.hasMoreElements()) {
                InputStream reader;
                ZipEntry currEntry = zippedFiles.nextElement();
                if (debug) {
                    System.out.println("RAConfig.extractFromRAR : currEntry = " + currEntry);
                }
                if (currEntry.getName().equalsIgnoreCase(fileName) || currEntry.getName().equalsIgnoreCase("META-INF/" + fileName)) {
                    res = zipFile.getInputStream(currEntry);
                    break;
                }
                if (!currEntry.getName().endsWith(".jar") || (res = this.extractFromJAR(fileName, reader = zipFile.getInputStream(currEntry))) == null) continue;
                reader.close();
                break;
            }
            if (res != null) {
                this.createFile(fileName, res);
            }
            zipFile.close();
        }
    }

    private InputStream extractFromJAR(String fileName, InputStream reader) throws Exception {
        if (debug) {
            System.out.println("RAConfig.extractFromJAR(" + fileName + "," + reader + ")");
        }
        ZipInputStream stream = new ZipInputStream(reader);
        ZipEntry currEntry = stream.getNextEntry();
        while (stream.available() > 0 && currEntry != null) {
            if (currEntry.getName().equalsIgnoreCase(fileName)) {
                if (debug) {
                    System.out.println("RAConfig.extractFromJAR : currEntry = " + currEntry);
                } else if (verbose) {
                    System.out.println("extract \"" + fileName + "\" from JAR.");
                }
                return stream;
            }
            currEntry = stream.getNextEntry();
        }
        stream.close();
        return null;
    }

    private void extractFromJAR(String jarName, String fileName) throws Exception {
        if (debug) {
            System.out.println("RAConfig.extractFromJAR(" + jarName + "," + fileName + ")");
        } else if (verbose) {
            System.out.println("extract \"" + fileName + "\" from \"" + jarName + "\"");
        }
        JarFile jar = new JarFile(jarName);
        ZipEntry entry = jar.getEntry(fileName);
        if (debug) {
            System.out.println("RAConfig.extractFromJAR : entry = " + entry);
        }
        if (entry != null) {
            this.createFile(fileName, jar.getInputStream(entry));
        }
        jar.close();
    }

    private void dump(InputStream is, OutputStream os) throws Exception {
        int n = 0;
        byte[] buffer = new byte[2048];
        n = is.read(buffer);
        while (n > 0) {
            os.write(buffer, 0, n);
            n = is.read(buffer);
        }
    }

    private String getFileName(String path) throws Exception {
        int i = path.lastIndexOf("/");
        if (i > 0) {
            return path.substring(i + 1, path.length());
        }
        i = path.lastIndexOf("\\");
        if (i > 0) {
            return path.substring(i + 1, path.length());
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(String path, InputStream is) throws Exception {
        if (debug) {
            System.out.println("RAConfig.createFile(" + path + "," + is + ")");
        }
        String fileName = tmpDir + this.getFileName(path);
        if (debug) {
            System.out.println("RAConfig.createFile : fileName = " + fileName);
        } else if (verbose) {
            System.out.println("create file \"" + fileName + "\"");
        }
        new File(fileName).delete();
        FileOutputStream fos = new FileOutputStream(fileName);
        try {
            this.dump(is, fos);
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(String path, String input) throws Exception {
        if (debug) {
            System.out.println("RAConfig.createFile(" + path + "," + input + ")");
        }
        String fileName = tmpDir + this.getFileName(path);
        if (debug) {
            System.out.println("RAConfig.createFile : fileName = " + fileName);
        } else if (verbose) {
            System.out.println("create file \"" + fileName + "\"");
        }
        new File(fileName).delete();
        ByteArrayInputStream bis = new ByteArrayInputStream(input.getBytes());
        FileOutputStream fos = new FileOutputStream(fileName);
        try {
            this.dump(bis, fos);
        }
        finally {
            fos.close();
            bis.close();
        }
    }

    private String parse(String fileName) throws Exception {
        if (debug) {
            System.out.println("RAConfig.parse(" + fileName + ")");
        } else if (verbose) {
            System.out.println("parse \"" + fileName + "\"");
        }
        Wrapper wrapper = new Wrapper(debug);
        FileInputStream fis = new FileInputStream(fileName);
        return wrapper.parse(fis);
    }

    private String parse(InputStream is) throws Exception {
        if (debug) {
            System.out.println("RAConfig.parse(" + is + ")");
        }
        Wrapper wrapper = new Wrapper(debug);
        return wrapper.parse(is);
    }

    private String update(InputStream is, Map map) throws Exception {
        if (debug) {
            System.out.println("RAConfig.update(" + is + "," + map + ")");
        }
        Wrapper wrapper = new Wrapper(debug);
        return wrapper.update(is, map);
    }

    private void updateHostPort(String rarName, String hostName, String port, short serverId) throws Exception {
        if (debug) {
            System.out.println("RAConfig.updateHostPort(" + rarName + "," + hostName + "," + port + "," + serverId + ")");
        } else if (verbose) {
            System.out.println("update (ra.xml and a3server.xml) in \"" + rarName + "\" with host=" + hostName + " port=" + port + " serverId=" + serverId);
        }
        File file = new File(rarName);
        StringBuffer buff = new StringBuffer();
        buff.append("RAR_NAME  ");
        buff.append(file.getAbsolutePath());
        buff.append("\n[org.objectweb.joram.client.connector.JoramAdapter]");
        buff.append("\nHostName  ");
        buff.append(hostName);
        buff.append("\nServerPort  ");
        buff.append(port);
        buff.append("\nServerId  ");
        buff.append(serverId);
        String tempFile = "ra.properties_tmp";
        this.createFile(tempFile, buff.toString());
        this.updateRAR(tmpDir + tempFile);
        new File(tmpDir + tempFile).delete();
    }

    private void updateA3Servers(String rarName, String hostName, String port, short serverId) throws Exception {
        File f;
        if (debug) {
            System.out.println("RAConfig.updateA3Servers(" + rarName + "," + hostName + "," + port + "," + serverId + ")");
        } else if (verbose) {
            System.out.println("update (a3server.xml) in \"" + rarName + "\" host=" + hostName + " port=" + port + " serverId=" + serverId);
        }
        this.extractFromRAR(rarName, JORAM_CONFIG_JAR);
        this.extractFromJAR(tmpDir + JORAM_CONFIG_JAR, A3SERVERS_XML);
        if (confDir != null && (f = new File(confDir, A3SERVERS_XML)).exists()) {
            this.copy(f.getPath(), tmpDir + A3SERVERS_XML);
        }
        A3CMLConfig conf = A3CML.getXMLConfig(tmpDir + A3SERVERS_XML);
        A3CMLServer server = conf.getServer(serverId);
        server.hostname = hostName;
        A3CMLService service = server.getService("org.objectweb.joram.mom.proxies.tcp.TcpProxyService");
        service.args = port;
        A3CML.toXML(conf, null, tmpDir + A3SERVERS_XML);
        if (debug) {
            System.out.println("RAConfig.updateA3Servers : confDir=" + confDir);
        }
        if (confDir != null) {
            File f2 = new File(confDir, A3SERVERS_XML);
            if (f2.exists()) {
                this.copy(tmpDir + A3SERVERS_XML, f2.getPath());
            }
            if (new File(confDir, JORAMADMIN_CFG).exists()) {
                this.updateJoramAdminCfg(hostName, port);
            }
            if (new File(confDir, JORAMADMIN_XML).exists()) {
                this.updateJoramAdminXml(hostName, port);
            }
        }
        this.updateZIP(tmpDir + JORAM_CONFIG_JAR, A3SERVERS_XML, tmpDir + A3SERVERS_XML, A3SERVERS_XML);
        this.updateZIP(rarName, JORAM_CONFIG_JAR, tmpDir + JORAM_CONFIG_JAR, JORAM_CONFIG_JAR);
        new File(tmpDir + JORAM_CONFIG_JAR).delete();
        new File(tmpDir + A3SERVERS_XML).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copy(String file1, String file2) throws Exception {
        if (!new File(file1).exists()) {
            return false;
        }
        new File(file2).delete();
        FileInputStream fis = new FileInputStream(file1);
        FileOutputStream fos = new FileOutputStream(file2);
        try {
            this.dump(fis, fos);
            boolean bl = true;
            return bl;
        }
        finally {
            fos.close();
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJoramAdminCfg(String hostName, String port) throws Exception {
        File file = new File(confDir, JORAMADMIN_CFG);
        FileReader fileReader = new FileReader(file);
        BufferedReader reader = new BufferedReader(fileReader);
        boolean end = false;
        StringBuffer buff = new StringBuffer();
        while (!end) {
            String line = reader.readLine();
            if (line == null) {
                end = true;
                continue;
            }
            StringTokenizer tokenizer = new StringTokenizer(line);
            if (tokenizer.hasMoreTokens()) {
                String firstToken = tokenizer.nextToken();
                if (firstToken.equalsIgnoreCase("Host")) {
                    buff.append("Host   " + hostName + "\n");
                    continue;
                }
                if (firstToken.equalsIgnoreCase("Port")) {
                    buff.append("Port   " + port + "\n");
                    continue;
                }
            }
            buff.append(line + "\n");
        }
        file.delete();
        ByteArrayInputStream bis = new ByteArrayInputStream(buff.toString().getBytes());
        FileOutputStream fos = new FileOutputStream(file);
        try {
            this.dump(bis, fos);
        }
        finally {
            fos.close();
            bis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJoramAdminXml(String hostName, String port) throws Exception {
        File file = new File(confDir, JORAMADMIN_XML);
        FileReader fileReader = new FileReader(file);
        BufferedReader reader = new BufferedReader(fileReader);
        boolean end = false;
        StringBuffer buff = new StringBuffer();
        int i = -1;
        while (!end) {
            String line;
            block18: {
                int j;
                line = reader.readLine();
                if (line == null) {
                    end = true;
                    continue;
                }
                if (line.trim().startsWith("<connect")) {
                    while (true) {
                        if ((i = line.indexOf("host")) > 0) {
                            buff.append(line.substring(0, i + 10));
                            buff.append(hostName);
                            j = line.indexOf("\"", i + 11);
                            buff.append(line.substring(j, line.length()) + "\n");
                            if (line.trim().endsWith("/>")) {
                                line = reader.readLine();
                                break block18;
                            }
                            line = reader.readLine();
                            continue;
                        }
                        i = line.indexOf("port");
                        if (i > 0) {
                            buff.append(line.substring(0, i + 6));
                            buff.append(port);
                            j = line.indexOf("\"", i + 7);
                            buff.append(line.substring(j, line.length()) + "\n");
                            if (line.trim().endsWith("/>")) {
                                line = reader.readLine();
                                break block18;
                            }
                            line = reader.readLine();
                            continue;
                        }
                        buff.append(line + "\n");
                        if (line.trim().endsWith("/>")) {
                            line = reader.readLine();
                            break block18;
                        }
                        line = reader.readLine();
                    }
                }
                if (line.trim().startsWith("<tcp")) {
                    while (true) {
                        if ((i = line.indexOf("host")) > 0) {
                            buff.append(line.substring(0, i + 6));
                            buff.append(hostName);
                            j = line.indexOf("\"", i + 7);
                            buff.append(line.substring(j, line.length()) + "\n");
                            if (line.trim().endsWith("/>")) {
                                line = reader.readLine();
                                break;
                            }
                            line = reader.readLine();
                            continue;
                        }
                        i = line.indexOf("port");
                        if (i > 0) {
                            buff.append(line.substring(0, i + 6));
                            buff.append(port);
                            j = line.indexOf("\"", i + 7);
                            buff.append(line.substring(j, line.length()) + "\n");
                            if (line.trim().endsWith("/>")) {
                                line = reader.readLine();
                                break;
                            }
                            line = reader.readLine();
                            continue;
                        }
                        buff.append(line + "\n");
                        if (line.trim().endsWith("/>")) break;
                        line = reader.readLine();
                    }
                }
            }
            buff.append(line + "\n");
        }
        file.delete();
        ByteArrayInputStream bis = new ByteArrayInputStream(buff.toString().getBytes());
        FileOutputStream fos = new FileOutputStream(file);
        try {
            this.dump(bis, fos);
        }
        finally {
            fos.close();
            bis.close();
        }
    }

    private void updateRAR(String raProperties) throws Exception {
        File rarFile;
        if (debug) {
            System.out.println("RAConfig.updateRAR(" + raProperties + ")");
        }
        FileReader file = new FileReader(raProperties);
        LineNumberReader lnr = new LineNumberReader(file);
        String line = lnr.readLine();
        while (line != null && !line.startsWith("RAR_NAME")) {
            line = lnr.readLine();
        }
        int i = line.indexOf("RAR_NAME");
        String rarName = line.substring(i + "RAR_NAME".length()).trim();
        if (debug) {
            System.out.println("RAConfig.updateRAR : rarName = " + rarName);
        } else if (verbose) {
            System.out.println("update rar \"" + rarName + "\" with \"" + raProperties + "\"");
        }
        Hashtable<String, Hashtable> map = new Hashtable<String, Hashtable>();
        Hashtable prop = null;
        String nodeName = null;
        line = lnr.readLine();
        while (line != null) {
            if (line.startsWith("[")) {
                prop = new Hashtable();
                nodeName = line.substring(line.indexOf("[") + 1, line.indexOf("]"));
                map.put(nodeName.trim(), prop);
            } else {
                StringTokenizer st = new StringTokenizer(line);
                if (st.countTokens() == 2 && prop != null) {
                    prop.put(st.nextToken(), st.nextToken());
                }
            }
            line = lnr.readLine();
        }
        file.close();
        if (debug) {
            System.out.println("RAConfig.updateRAR : map = " + map);
        }
        if ((rarFile = new File(rarName)).exists()) {
            ZipFile zipFile = new ZipFile(rarFile.getAbsolutePath());
            Enumeration<? extends ZipEntry> zippedFiles = zipFile.entries();
            while (zippedFiles.hasMoreElements()) {
                ZipEntry currEntry = zippedFiles.nextElement();
                if (debug) {
                    System.out.println("RAConfig.updateRAR : currEntry = " + currEntry);
                }
                if (!currEntry.getName().equalsIgnoreCase(RA_XML)) continue;
                InputStream reader = zipFile.getInputStream(currEntry);
                this.createFile("ra.xml", this.update(reader, map));
                reader.close();
                break;
            }
            zipFile.close();
        }
        this.updateZIP(rarName, RA_XML, tmpDir + "ra.xml", RA_XML);
        prop = (Hashtable)map.get("org.objectweb.joram.client.connector.JoramAdapter");
        if (prop != null) {
            if (debug) {
                System.out.println("RAConfig.updateRAR : prop = " + prop);
            }
            String host = (String)prop.get("HostName");
            short serverId = -1;
            String sid = (String)prop.get("ServerId");
            if (sid != null) {
                serverId = new Short(sid);
            } else if (debug) {
                System.out.println("RAConfig.updateRAR : ServerId not found in ra.properties");
            }
            String port = (String)prop.get("ServerPort");
            if (host != null && host.length() > 0 && port != null && port.length() > 0 && serverId >= 0) {
                this.updateA3Servers(rarName, host, port, serverId);
            }
        }
        new File(tmpDir + "ra.xml").delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateZIP(String zipName, String path, String newFileName, String oldFileName) throws Exception {
        if (debug) {
            System.out.println("RAConfig.updateZIP(" + zipName + "," + path + "," + newFileName + "," + oldFileName + ")");
        } else if (verbose) {
            System.out.println("updateZIP \"" + zipName + "\", path \"" + path + "\", new file \"" + newFileName + "\", old file \"" + oldFileName + "\"");
        }
        ZipEntry entry = null;
        File file = new File(zipName);
        if (file.exists()) {
            ZipFile zipFile = new ZipFile(file.getAbsolutePath());
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            ZipOutputStream newZip = new ZipOutputStream(new FileOutputStream(new File(file.getAbsolutePath() + "_TMP")));
            while (zipEntries.hasMoreElements()) {
                entry = zipEntries.nextElement();
                if (entry.getName().equalsIgnoreCase(oldFileName)) continue;
                newZip.putNextEntry(new ZipEntry(entry.getName()));
                InputStream is = zipFile.getInputStream(entry);
                try {
                    this.dump(is, newZip);
                }
                finally {
                    newZip.closeEntry();
                    is.close();
                }
            }
            zipFile.close();
            entry = new ZipEntry(path);
            newZip.putNextEntry(entry);
            try {
                FileInputStream fis = new FileInputStream(newFileName);
                this.dump(fis, newZip);
                fis.close();
            }
            catch (Exception exc) {
                System.out.println("Error reading input file: " + newFileName + " " + exc);
                newZip.close();
                new File(file.getAbsolutePath() + "_TMP").delete();
                throw exc;
            }
            finally {
                newZip.flush();
                newZip.closeEntry();
                newZip.finish();
                newZip.close();
            }
            String toRename = file.getAbsolutePath() + "_TMP";
            new File(file.getAbsolutePath()).delete();
            new File(toRename).renameTo(file);
        }
    }
}

