/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.config.CMIConfigException;
import org.ow2.cmi.config.ProviderURLsParser;
import org.ow2.cmi.config.UtilConfig;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class JNDIConfig {
    private static final Log LOGGER = LogFactory.getLog(JNDIConfig.class);
    public static final String WRAPPED_PROTOCOL = "cmi.context.wrapped.protocol";
    public static final String INITIAL_PROVIDER_URLS = "cmi.context.provider.urls";
    public static final String WRAPPED_INITIAL_CONTEXT_FACTORY = "cmi.context.wrapped.factory";
    public static final String SERVER_MODE = "cmi.mode.server";
    private static volatile String protocol;

    private JNDIConfig() {
    }

    public static synchronized Hashtable<String, ?> getCMIEnv() throws CMIConfigException {
        return JNDIConfig.getCMIEnv(Thread.currentThread().getContextClassLoader().getResource("cmi.properties"));
    }

    public static synchronized Hashtable<String, ?> getCMIEnv(URL url) throws CMIConfigException {
        return JNDIConfig.getCMIEnv(UtilConfig.getPropertiesFromURL(url));
    }

    public static synchronized Hashtable<String, ?> getCMIEnv(Properties properties) throws CMIConfigException {
        Hashtable<String, Object> cmiEnv = new Hashtable<String, Object>();
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String s = (String)e.getValue();
            Object k = e.getKey();
            if (k.equals(INITIAL_PROVIDER_URLS)) {
                try {
                    ArrayList<String> providerURLs = new ArrayList<String>(ProviderURLsParser.parse(s));
                    cmiEnv.put(INITIAL_PROVIDER_URLS, providerURLs);
                    continue;
                }
                catch (MalformedURLException e1) {
                    LOGGER.error("Cannot parse provider urls {0}", s, e);
                    throw new CMIConfigException("Cannot parse provider urls " + s, e1);
                }
            }
            if (k.equals(WRAPPED_INITIAL_CONTEXT_FACTORY)) {
                cmiEnv.put(WRAPPED_INITIAL_CONTEXT_FACTORY, s);
                continue;
            }
            if (k.equals(WRAPPED_PROTOCOL)) {
                protocol = s;
                LOGGER.debug("The protocol is {0}", protocol);
                cmiEnv.put(WRAPPED_PROTOCOL, s);
                continue;
            }
            if (k.equals(SERVER_MODE)) {
                cmiEnv.put(SERVER_MODE, Boolean.valueOf(s));
                continue;
            }
            cmiEnv.put((String)k, s);
        }
        cmiEnv.put("java.naming.factory.initial", "org.ow2.cmi.jndi.context.CMIInitialContextFactory");
        String proDelegate = System.getProperty("javax.rmi.CORBA.PortableRemoteObjectClass");
        LOGGER.debug("Current PRO delegate is {0}", proDelegate);
        if (proDelegate == null || proDelegate != null && proDelegate.equals("com.sun.corba.se.impl.javax.rmi.PortableRemoteObject")) {
            LOGGER.debug("Using the class 'org.ow2.cmi.rmi.DefaultCMIPRODelegate' as PRO delegate", new Object[0]);
            System.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "org.ow2.cmi.rmi.DefaultCMIPRODelegate");
        }
        if (protocol == "iiop") {
            LOGGER.debug("Using the class 'com.sun.corba.se.impl.presentation.rmi.StubFactoryFactoryStaticImpl'as ORBDynamicStubFactoryFactory", new Object[0]);
            System.setProperty("com.sun.CORBA.ORBDynamicStubFactoryFactoryClass", "com.sun.corba.se.impl.presentation.rmi.StubFactoryFactoryStaticImpl");
        }
        return cmiEnv;
    }

    public static String getProtocol() {
        return protocol;
    }

    public static void setProtocol(String protocol) {
        JNDIConfig.protocol = protocol;
    }
}

