/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.cmi;

import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.cmi.controller.server.AbsServerClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.cmi.CmiConfigurationExtension;
import org.ow2.easybeans.server.ServerConfig;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CmiComponent
implements EZBComponent {
    private Log logger = LogFactory.getLog(CmiComponent.class);
    private ServerConfig config;
    private boolean lifecycleManaged = true;
    private ServerClusterViewManager clusterViewManager;

    public void init() throws EZBComponentException {
    }

    public void start() throws EZBComponentException {
        if (this.lifecycleManaged) {
            try {
                ConfigurationRepository.getServerConfiguration().enableCMI();
            }
            catch (Exception e) {
                this.logger.error("Cannot configure Carol to use CMI", e);
                throw new EZBComponentException("Cannot configure Carol to use CMI", e);
            }
            try {
                this.clusterViewManager = AbsServerClusterViewManager.start();
            }
            catch (Exception e) {
                this.logger.error("Cannot start the server-side manager", e);
                throw new EZBComponentException("Cannot start the server-side manager", e);
            }
        }
        this.config.addExtensionFactory(new CmiConfigurationExtension());
        this.logger.debug("The CMI configuration extension has been added.", new Object[0]);
    }

    public void stop() throws EZBComponentException {
        if (this.lifecycleManaged) {
            try {
                ConfigurationRepository.getServerConfiguration().disableCMI();
            }
            catch (Exception e) {
                this.logger.error("Cannot disable CMI in Carol", e);
            }
            if (this.clusterViewManager != null) {
                try {
                    ((AbsServerClusterViewManager)this.clusterViewManager).stop();
                }
                catch (Exception e) {
                    this.logger.error("Cannot stop the server-side manager", e);
                    throw new EZBComponentException("Cannot stop the server-side manager", e);
                }
            }
        }
    }

    public ServerConfig getServerConfig() {
        return this.config;
    }

    public void setServerConfig(ServerConfig config) {
        this.config = config;
    }

    public boolean isLifecycleManaged() {
        return this.lifecycleManaged;
    }

    public void setLifecycleManaged(boolean lifecycleManaged) {
        this.lifecycleManaged = lifecycleManaged;
    }
}

