/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.ow2.easybeans.api.EZBContainerConfig;
import org.ow2.easybeans.deployment.annotations.analyzer.configurator.metadata.ejbjar.EjbJarArchiveMetadataConfigurator;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.annotations.helper.ExtraMetadataHelper;
import org.ow2.easybeans.deployment.annotations.helper.ResolverHelper;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.LibrariesAnnotationMetadata;
import org.ow2.easybeans.deployment.xml.EJB3DeploymentDesc;
import org.ow2.easybeans.deployment.xml.EJB3DeploymentDescException;
import org.ow2.easybeans.deployment.xml.EasyBeansDeploymentDesc;
import org.ow2.easybeans.deployment.xml.helper.ExtractUsefullClasses;
import org.ow2.easybeans.deployment.xml.helper.MetadataMerge;
import org.ow2.easybeans.deployment.xml.helper.MetadataSpecificMerge;
import org.ow2.easybeans.deployment.xml.specific.EasyBeansDD;
import org.ow2.easybeans.deployment.xml.struct.EJB3;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.ArchiveScanner;
import org.ow2.util.scan.api.ArchiveScannerFactory;
import org.ow2.util.scan.api.ScanException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deployment {
    private static Log logger = LogFactory.getLog(Deployment.class);
    private IArchive archive = null;
    private List<IArchive> extraArchives = null;
    private EjbJarArchiveMetadataConfigurator ejbJarArchiveMetadataConfigurator;
    private EjbJarArchiveMetadata ejbJarArchiveMetadata;
    private EZBContainerConfig configuration;

    public Deployment(IArchive archive) {
        this.archive = archive;
        this.reset();
    }

    public Deployment(EZBContainerConfig configuration) {
        this(configuration.getArchive());
        this.configuration = configuration;
    }

    public void reset() {
        this.ejbJarArchiveMetadataConfigurator = new EjbJarArchiveMetadataConfigurator();
        this.ejbJarArchiveMetadata = this.ejbJarArchiveMetadataConfigurator.getEjbJarArchiveMetadata();
    }

    public void analyze() throws ScanException, EJB3DeploymentDescException, ResolverException {
        ArchiveScanner archiveScanner = ArchiveScannerFactory.getInstance().createArchiveScanner(this.archive);
        archiveScanner.addArchiveConfigurator(this.ejbJarArchiveMetadataConfigurator);
        EJB3 ejb3 = EJB3DeploymentDesc.getEjb3(this.archive);
        EasyBeansDD easyBeansDD = EasyBeansDeploymentDesc.getEasyBeansDD(this.archive);
        long tAnalyzeStart = System.currentTimeMillis();
        if (ejb3 != null && ejb3.isMetadataComplete()) {
            this.ejbJarArchiveMetadataConfigurator.setAnnotationParsingDesactived(true);
            List<String> nextClassNameToScan = ExtractUsefullClasses.extract(ejb3);
            ArrayList<EjbJarClassMetadata> metadataWithDirectDependencies = new ArrayList<EjbJarClassMetadata>();
            Collection<EjbJarClassMetadata> ejbJarClassMetadataCollection = this.ejbJarArchiveMetadata.getEjbJarClassMetadataCollection();
            archiveScanner.scanCollection(nextClassNameToScan);
            while (nextClassNameToScan.size() != 0) {
                nextClassNameToScan.clear();
                for (EjbJarClassMetadata ejbJarClassMetadata : ejbJarClassMetadataCollection) {
                    if (metadataWithDirectDependencies.contains(ejbJarClassMetadata)) continue;
                    nextClassNameToScan.add(ejbJarClassMetadata.getSuperName());
                    nextClassNameToScan.addAll(Arrays.asList(ejbJarClassMetadata.getInterfaces()));
                    metadataWithDirectDependencies.add(ejbJarClassMetadata);
                }
                archiveScanner.scanCollection(nextClassNameToScan);
            }
            archiveScanner.endScan();
        } else {
            this.ejbJarArchiveMetadataConfigurator.setAnnotationParsingDesactived(false);
            archiveScanner.scanAll();
        }
        if (logger.isDebugEnabled()) {
            long tAnalyzeStartEnd = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Analyze of file {0} took {1} ms.", this.archive.getName(), tAnalyzeStartEnd - tAnalyzeStart);
            }
        }
        LibrariesAnnotationMetadata librariesAnnotationMetadata = new LibrariesAnnotationMetadata();
        if (this.extraArchives != null) {
            ArrayList<EjbJarArchiveMetadata> ejbJarAnnotationMetadataList = new ArrayList<EjbJarArchiveMetadata>();
            for (IArchive extraArchive : this.extraArchives) {
                ArchiveScanner extraArchiveScanner = ArchiveScannerFactory.getInstance().createArchiveScanner(extraArchive);
                EjbJarArchiveMetadataConfigurator ejbJarExtraArchiveMetadataConfigurator = new EjbJarArchiveMetadataConfigurator();
                extraArchiveScanner.addArchiveConfigurator(ejbJarExtraArchiveMetadataConfigurator);
                extraArchiveScanner.scanAll();
                ejbJarAnnotationMetadataList.add(ejbJarExtraArchiveMetadataConfigurator.getEjbJarArchiveMetadata());
            }
            librariesAnnotationMetadata.setEjbJarAnnotationMetadataList(ejbJarAnnotationMetadataList);
        }
        ExtraMetadataHelper.complete(this.ejbJarArchiveMetadata, librariesAnnotationMetadata);
        this.ejbJarArchiveMetadata.setEjb3(ejb3);
        MetadataMerge.merge(this.ejbJarArchiveMetadata);
        this.ejbJarArchiveMetadata.setEasyBeansDD(easyBeansDD);
        MetadataSpecificMerge.merge(this.ejbJarArchiveMetadata);
        long tResolverStart = System.currentTimeMillis();
        ResolverHelper.resolve(this.ejbJarArchiveMetadata);
        if (logger.isDebugEnabled()) {
            long tResolverEnd = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Resolver on metadata from {0} took {1} ms.'", this.archive.getName(), tResolverEnd - tResolverStart);
            }
        }
        if (logger.isDebugEnabled()) {
            for (EjbJarClassMetadata classAnnotationMetadata : this.ejbJarArchiveMetadata.getEjbJarClassMetadataCollection()) {
                logger.debug("Result for class = " + classAnnotationMetadata, new Object[0]);
            }
        }
    }

    public EjbJarArchiveMetadata getEjbJarArchiveMetadata() {
        return this.ejbJarArchiveMetadata;
    }

    public void setExtraArchives(List<IArchive> extraArchives) {
        this.extraArchives = extraArchives;
    }

    public IArchive getArchive() {
        return this.archive;
    }

    public EZBContainerConfig getConfiguration() {
        return this.configuration;
    }
}

