/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.metadata.ejbjar;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ejb.ApplicationException;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.ow2.easybeans.deployment.annotations.ClassType;
import org.ow2.easybeans.deployment.annotations.InterceptorType;
import org.ow2.easybeans.deployment.annotations.JClassInterceptor;
import org.ow2.easybeans.deployment.annotations.exceptions.InterceptorsValidationException;
import org.ow2.easybeans.deployment.annotations.impl.JCommonBean;
import org.ow2.easybeans.deployment.annotations.impl.JInterceptors;
import org.ow2.easybeans.deployment.annotations.impl.JLocal;
import org.ow2.easybeans.deployment.annotations.impl.JMessageDriven;
import org.ow2.easybeans.deployment.annotations.impl.JRemote;
import org.ow2.easybeans.deployment.annotations.impl.JStateful;
import org.ow2.easybeans.deployment.annotations.impl.JStateless;
import org.ow2.easybeans.deployment.metadata.CommonClassMetadata;
import org.ow2.easybeans.deployment.metadata.CommonMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarFieldMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarMethodMetadata;
import org.ow2.easybeans.deployment.metadata.interfaces.IAnnotationSecurityPermitAll;
import org.ow2.easybeans.deployment.metadata.interfaces.IAnnotationSecurityRolesAllowed;
import org.ow2.easybeans.deployment.metadata.interfaces.IEJBInterceptors;
import org.ow2.easybeans.deployment.metadata.interfaces.IInterceptorExcludeDefaultInterceptors;
import org.ow2.easybeans.deployment.metadata.interfaces.ITransactionAttribute;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.api.IPoolMetadata;
import org.ow2.util.scan.api.metadata.structures.JClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbJarClassMetadata
extends CommonClassMetadata<EjbJarClassMetadata, EjbJarMethodMetadata, EjbJarFieldMetadata>
implements ITransactionAttribute,
IEJBInterceptors,
IAnnotationSecurityRolesAllowed,
IAnnotationSecurityPermitAll,
IInterceptorExcludeDefaultInterceptors,
IPoolMetadata {
    private EjbJarArchiveMetadata ejbJarArchiveMetadata = null;
    private JLocal jLocal = null;
    private JRemote jRemote = null;
    private JCommonBean jCommonBean = null;
    private JMessageDriven jMessageDriven = null;
    private JStateless jStateless = null;
    private JStateful jStateful = null;
    private boolean orderedInterceptors = false;
    private String localHome = null;
    private String remoteHome = null;
    private JInterceptors annotationInterceptors = null;
    private List<JClassInterceptor> globalEasyBeansInterceptors = null;
    private Map<InterceptorType, List<JClassInterceptor>> externalUserInterceptors = null;
    private Map<InterceptorType, List<JClassInterceptor>> internalUserInterceptors = null;
    private TransactionManagementType transactionManagementType = TransactionManagementType.CONTAINER;
    private TransactionAttributeType transactionAttributeType = TransactionAttributeType.REQUIRED;
    private ApplicationException applicationException = null;
    private ClassType classType = null;
    private List<EjbJarMethodMetadata> aroundInvokeMethodsMetadata = null;
    private LinkedList<EjbJarMethodMetadata> postConstructMethodsMetadata = null;
    private LinkedList<EjbJarMethodMetadata> preDestroyMethodsMetadata = null;
    private LinkedList<EjbJarMethodMetadata> postActivateMethodsMetadata = null;
    private LinkedList<EjbJarMethodMetadata> prePassivateMethodsMetadata = null;
    private boolean modified = false;
    private List<String> declareRoles = null;
    private List<String> rolesAllowed = null;
    private boolean permitAll = false;
    private String runAs = null;
    private boolean excludeDefaultInterceptors = false;
    private String remoteInterface = null;
    private IPoolConfiguration poolConfiguration;

    public EjbJarClassMetadata(JClass jClass, EjbJarArchiveMetadata ejbJarArchiveMetadata) {
        super(jClass);
        this.ejbJarArchiveMetadata = ejbJarArchiveMetadata;
        this.postConstructMethodsMetadata = new LinkedList();
        this.preDestroyMethodsMetadata = new LinkedList();
        this.postActivateMethodsMetadata = new LinkedList();
        this.prePassivateMethodsMetadata = new LinkedList();
    }

    public String getClassName() {
        return this.getJClass().getName();
    }

    public void setLocalInterfaces(JLocal jLocal) {
        this.jLocal = jLocal;
    }

    public void setRemoteInterfaces(JRemote jRemote) {
        this.jRemote = jRemote;
    }

    public JLocal getLocalInterfaces() {
        return this.jLocal;
    }

    public JRemote getRemoteInterfaces() {
        return this.jRemote;
    }

    public boolean isStateless() {
        return this.classType != null && this.classType == ClassType.STATELESS;
    }

    public boolean isStateful() {
        return this.classType != null && this.classType == ClassType.STATEFUL;
    }

    public boolean isSession() {
        return this.classType != null && (this.classType == ClassType.STATELESS || this.classType == ClassType.STATEFUL);
    }

    public boolean isMdb() {
        return this.classType != null && this.classType == ClassType.MDB;
    }

    public void setClassType(ClassType cType) {
        this.classType = cType;
    }

    public JMessageDriven getJMessageDriven() {
        return this.jMessageDriven;
    }

    public void setJMessageDriven(JMessageDriven messageDriven) {
        this.jMessageDriven = messageDriven;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1));
        sb.append("[\n");
        sb.append(super.toString());
        CommonMetadata.concatStringBuilder("className", this.getClassName(), sb);
        CommonMetadata.concatStringBuilder("superName", this.getJClass().getSuperName(), sb);
        CommonMetadata.concatStringBuilder("interfaces", this.getJClass().getInterfaces(), sb);
        CommonMetadata.concatStringBuilder("classType", (Object)this.classType, sb);
        CommonMetadata.concatStringBuilder("jLocal", this.jLocal, sb);
        CommonMetadata.concatStringBuilder("aroundInvokeMethodsMetadata", this.aroundInvokeMethodsMetadata, sb);
        CommonMetadata.concatStringBuilder("jRemote", this.jRemote, sb);
        CommonMetadata.concatStringBuilder("jMessageDriven", this.jMessageDriven, sb);
        CommonMetadata.concatStringBuilder("remoteHome", this.remoteHome, sb);
        CommonMetadata.concatStringBuilder("localHome", this.localHome, sb);
        CommonMetadata.concatStringBuilder("transactionManagementType", (Object)this.transactionManagementType, sb);
        CommonMetadata.concatStringBuilder("transactionAttributeType", (Object)this.transactionAttributeType, sb);
        CommonMetadata.concatStringBuilder("annotationInterceptors", this.annotationInterceptors, sb);
        CommonMetadata.concatStringBuilder("jAnnotationEJBs", this.getJEjbEJBs(), sb);
        CommonMetadata.concatStringBuilder("jAnnotationResources", this.getJAnnotationResources(), sb);
        CommonMetadata.concatStringBuilder("javaxPersistencePersistenceContexts", this.getJavaxPersistencePersistenceContexts(), sb);
        CommonMetadata.concatStringBuilder("javaxPersistencePersistenceUnits", this.getJavaxPersistencePersistenceUnits(), sb);
        for (EjbJarMethodMetadata methodAnnotationMetadata : this.getMethodMetadataCollection()) {
            CommonMetadata.concatStringBuilder("methods", methodAnnotationMetadata, sb);
        }
        CommonMetadata.concatStringBuilder("modified", this.modified, sb);
        CommonMetadata.concatStringBuilder("excludeDefaultInterceptors", this.excludeDefaultInterceptors, sb);
        CommonMetadata.concatStringBuilder("declareRoles", this.declareRoles, sb);
        CommonMetadata.concatStringBuilder("rolesAllowed", this.rolesAllowed, sb);
        CommonMetadata.concatStringBuilder("permitAll", this.permitAll, sb);
        CommonMetadata.concatStringBuilder("runAs", this.runAs, sb);
        sb.append("]");
        return sb.toString();
    }

    public String getRemoteHome() {
        return this.remoteHome;
    }

    public void setRemoteHome(String remoteHome) {
        this.remoteHome = remoteHome;
    }

    public String getLocalHome() {
        return this.localHome;
    }

    public void setLocalHome(String localHome) {
        this.localHome = localHome;
    }

    public TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    public void setTransactionManagementType(TransactionManagementType transactionManagementType) {
        this.transactionManagementType = transactionManagementType;
    }

    @Override
    public TransactionAttributeType getTransactionAttributeType() {
        return this.transactionAttributeType;
    }

    @Override
    public void setTransactionAttributeType(TransactionAttributeType transactionAttributeType) {
        this.transactionAttributeType = transactionAttributeType;
    }

    public JInterceptors getAnnotationInterceptors() {
        return this.annotationInterceptors;
    }

    @Override
    public void setAnnotationsInterceptors(JInterceptors annotationInterceptors) {
        this.annotationInterceptors = annotationInterceptors;
    }

    public ApplicationException getApplicationException() {
        return this.applicationException;
    }

    public void setApplicationException(ApplicationException applicationException) {
        this.applicationException = applicationException;
    }

    public boolean isBean() {
        return this.isStateless() || this.isStateful() || this.isMdb();
    }

    public String[] getInterfaces() {
        return this.getJClass().getInterfaces();
    }

    public String getSuperName() {
        return this.getJClass().getSuperName();
    }

    public EjbJarArchiveMetadata getEjbJarArchiveMetadata() {
        return this.ejbJarArchiveMetadata;
    }

    public Map<InterceptorType, List<JClassInterceptor>> getExternalUserEasyBeansInterceptors() {
        return this.externalUserInterceptors;
    }

    public void setExternalUserInterceptors(Map<InterceptorType, List<JClassInterceptor>> externalUserInterceptors) {
        this.externalUserInterceptors = externalUserInterceptors;
    }

    public Map<InterceptorType, List<JClassInterceptor>> getInternalUserEasyBeansInterceptors() {
        return this.internalUserInterceptors;
    }

    public void setInternalUserInterceptors(Map<InterceptorType, List<JClassInterceptor>> internalUserInterceptors) {
        this.internalUserInterceptors = internalUserInterceptors;
    }

    public List<JClassInterceptor> getGlobalEasyBeansInterceptors() {
        return this.globalEasyBeansInterceptors;
    }

    public void setGlobalEasyBeansInterceptors(List<JClassInterceptor> globalEasyBeansInterceptors) {
        this.globalEasyBeansInterceptors = globalEasyBeansInterceptors;
    }

    public boolean isAroundInvokeMethodMetadata() {
        return this.aroundInvokeMethodsMetadata != null;
    }

    public List<EjbJarMethodMetadata> getAroundInvokeMethodMetadatas() {
        return this.aroundInvokeMethodsMetadata;
    }

    public void addAroundInvokeMethodMetadata(EjbJarMethodMetadata aroundInvokeMethodMetadata) {
        if (this.aroundInvokeMethodsMetadata == null) {
            this.aroundInvokeMethodsMetadata = new ArrayList<EjbJarMethodMetadata>();
        }
        this.aroundInvokeMethodsMetadata.add(aroundInvokeMethodMetadata);
    }

    public LinkedList<EjbJarMethodMetadata> getPostConstructMethodsMetadata() {
        return this.postConstructMethodsMetadata;
    }

    public void addPostConstructMethodMetadata(EjbJarMethodMetadata postConstructMethodMetadata) {
        this.checkLifeCycleDuplicate(postConstructMethodMetadata, InterceptorType.POST_CONSTRUCT, this.getPostConstructMethodsMetadata());
        this.postConstructMethodsMetadata.addFirst(postConstructMethodMetadata);
    }

    private void checkLifeCycleDuplicate(EjbJarMethodMetadata postConstructMethodMetadata, InterceptorType itcType, List<EjbJarMethodMetadata> existingList) {
        EjbJarClassMetadata wantToAddClassMetadata = (EjbJarClassMetadata)postConstructMethodMetadata.getClassMetadata();
        if (postConstructMethodMetadata.isInherited()) {
            wantToAddClassMetadata = (EjbJarClassMetadata)postConstructMethodMetadata.getOriginalClassMetadata();
        }
        for (EjbJarMethodMetadata method : existingList) {
            EjbJarClassMetadata compareMetaData = method.isInherited() ? (EjbJarClassMetadata)method.getOriginalClassMetadata() : (EjbJarClassMetadata)method.getClassMetadata();
            if (!compareMetaData.equals(wantToAddClassMetadata)) continue;
            throw new InterceptorsValidationException("Class " + this.getClassName() + " has already a " + (Object)((Object)itcType) + " method which is " + method.getMethodName() + ", cannot set new method " + postConstructMethodMetadata.getMethodName());
        }
    }

    public LinkedList<EjbJarMethodMetadata> getPreDestroyMethodsMetadata() {
        return this.preDestroyMethodsMetadata;
    }

    public void addPreDestroyMethodMetadata(EjbJarMethodMetadata preDestroyMethodMetadata) {
        this.checkLifeCycleDuplicate(preDestroyMethodMetadata, InterceptorType.PRE_DESTROY, this.getPreDestroyMethodsMetadata());
        this.preDestroyMethodsMetadata.addFirst(preDestroyMethodMetadata);
    }

    public LinkedList<EjbJarMethodMetadata> getPostActivateMethodsMetadata() {
        return this.postActivateMethodsMetadata;
    }

    public void addPostActivateMethodMetadata(EjbJarMethodMetadata postActivateMethodMetadata) {
        this.checkLifeCycleDuplicate(postActivateMethodMetadata, InterceptorType.POST_ACTIVATE, this.getPostActivateMethodsMetadata());
        this.postActivateMethodsMetadata.addFirst(postActivateMethodMetadata);
    }

    public LinkedList<EjbJarMethodMetadata> getPrePassivateMethodsMetadata() {
        return this.prePassivateMethodsMetadata;
    }

    public void addPrePassivateMethodMetadata(EjbJarMethodMetadata prePassivateMethodMetadata) {
        this.checkLifeCycleDuplicate(prePassivateMethodMetadata, InterceptorType.PRE_PASSIVATE, this.getPrePassivateMethodsMetadata());
        this.prePassivateMethodsMetadata.addFirst(prePassivateMethodMetadata);
    }

    public boolean isInterceptor() {
        return this.aroundInvokeMethodsMetadata != null && this.aroundInvokeMethodsMetadata.size() > 0 || this.postConstructMethodsMetadata != null && this.postConstructMethodsMetadata.size() > 0 || this.preDestroyMethodsMetadata != null && this.preDestroyMethodsMetadata.size() > 0 || this.prePassivateMethodsMetadata != null && this.prePassivateMethodsMetadata.size() > 0 || this.postActivateMethodsMetadata != null && this.postActivateMethodsMetadata.size() > 0;
    }

    public JCommonBean getJCommonBean() {
        return this.jCommonBean;
    }

    public void setJCommonBean(JCommonBean commonBean) {
        String ejbName = commonBean.getName();
        if (ejbName == null || "".equals(ejbName)) {
            String className = this.getClassName();
            commonBean.setName(className.substring(className.lastIndexOf("/") + 1));
        }
        this.jCommonBean = commonBean;
    }

    public JStateful getJStateful() {
        return this.jStateful;
    }

    public void setJStateful(JStateful jStateful) {
        this.jStateful = jStateful;
    }

    public JStateless getJStateless() {
        return this.jStateless;
    }

    public void setJStateless(JStateless jStateless) {
        this.jStateless = jStateless;
    }

    public boolean wasModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    public void setDeclareRoles(List<String> declareRoles) {
        this.declareRoles = declareRoles;
    }

    public List<String> getDeclareRoles() {
        return this.declareRoles;
    }

    @Override
    public void setRolesAllowed(List<String> rolesAllowed) {
        this.rolesAllowed = rolesAllowed;
    }

    @Override
    public List<String> getRolesAllowed() {
        return this.rolesAllowed;
    }

    @Override
    public void setPermitAll(boolean permitAll) {
        this.permitAll = permitAll;
    }

    @Override
    public boolean hasPermitAll() {
        return this.permitAll;
    }

    public void setRunAs(String runAs) {
        this.runAs = runAs;
    }

    public String getRunAs() {
        return this.runAs;
    }

    @Override
    public boolean isExcludedDefaultInterceptors() {
        return this.excludeDefaultInterceptors;
    }

    @Override
    public void setExcludeDefaultInterceptors(boolean excludeDefaultInterceptors) {
        this.excludeDefaultInterceptors = excludeDefaultInterceptors;
    }

    public boolean isOrderedInterceptors() {
        return this.orderedInterceptors;
    }

    public void setOrderedInterceptors(boolean orderedInterceptors) {
        this.orderedInterceptors = orderedInterceptors;
    }

    public void setRemoteInterface(String remoteInterface) {
        this.remoteInterface = remoteInterface;
    }

    public String getRemoteInterface() {
        return this.remoteInterface;
    }

    public void setInterfaces(String[] array) {
        JClass jClass = this.getJClass();
        this.setJClass(new JClass(jClass.getVersion(), jClass.getAccess(), jClass.getName(), jClass.getSignature(), jClass.getSuperName(), array));
    }

    @Override
    public IPoolConfiguration getPoolConfiguration() {
        return this.poolConfiguration;
    }

    @Override
    public void setPoolConfiguration(IPoolConfiguration poolConfiguration) {
        this.poolConfiguration = poolConfiguration;
    }
}

