/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.xml;

import java.net.URL;
import java.util.Iterator;
import org.ow2.easybeans.deployment.xml.WARDeploymentDescException;
import org.ow2.easybeans.deployment.xml.parsing.ParsingException;
import org.ow2.easybeans.deployment.xml.parsing.WARDeploymentDescLoader;
import org.ow2.easybeans.deployment.xml.parsing.WARTLDLoader;
import org.ow2.easybeans.deployment.xml.struct.WAR;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class WARDeploymentDesc {
    private static Log logger = LogFactory.getLog(WARDeploymentDesc.class);

    private WARDeploymentDesc() {
    }

    public static WAR getWAR(IArchive archive) throws WARDeploymentDescException {
        URL webXmlURL = null;
        try {
            webXmlURL = archive.getResource("WEB-INF/web.xml");
        }
        catch (ArchiveException e) {
            throw new WARDeploymentDescException("Cannot get resource 'WEB-INF/web.xml' on the archive '" + archive.getName() + "'.");
        }
        WAR war = null;
        if (webXmlURL != null) {
            try {
                war = WARDeploymentDescLoader.loadDeploymentDescriptor(webXmlURL);
            }
            catch (ParsingException e) {
                throw new WARDeploymentDescException("Cannot parse URL '" + webXmlURL + "'.", e);
            }
        } else {
            war = new WAR();
        }
        Iterator<URL> itUrlResources = null;
        try {
            itUrlResources = archive.getResources();
        }
        catch (ArchiveException e) {
            throw new WARDeploymentDescException("Cannot get resources on the archive '" + archive.getName() + "'.");
        }
        while (itUrlResources.hasNext()) {
            URL url = itUrlResources.next();
            if (!url.getPath().endsWith(".tld")) continue;
            try {
                WARTLDLoader.scanTLD(url, war);
            }
            catch (ParsingException e) {
                logger.error("Cannot analyze the TLD file ''{0}''", url, e);
            }
        }
        return war;
    }
}

