/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.DescriptionGroupDesc;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.JonasMessageDestination;
import org.ow2.jonas.deployment.common.xml.MessageDestination;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.EntityBmpDesc;
import org.ow2.jonas.deployment.ejb.EntityCmp2Desc;
import org.ow2.jonas.deployment.ejb.ExcludeListDesc;
import org.ow2.jonas.deployment.ejb.MethodPermissionDesc;
import org.ow2.jonas.deployment.ejb.SessionDesc;
import org.ow2.jonas.deployment.ejb.SessionStatefulDesc;
import org.ow2.jonas.deployment.ejb.SessionStatelessDesc;
import org.ow2.jonas.deployment.ejb.xml.AssemblyDescriptor;
import org.ow2.jonas.deployment.ejb.xml.EjbJar;
import org.ow2.jonas.deployment.ejb.xml.Entity;
import org.ow2.jonas.deployment.ejb.xml.JonasEjbJar;
import org.ow2.jonas.deployment.ejb.xml.JonasEntity;
import org.ow2.jonas.deployment.ejb.xml.JonasRunAsMapping;
import org.ow2.jonas.deployment.ejb.xml.JonasSession;
import org.ow2.jonas.deployment.ejb.xml.MethodPermission;
import org.ow2.jonas.deployment.ejb.xml.Session;

public abstract class DeploymentDesc
extends DescriptionGroupDesc {
    protected Logger logger;
    protected String specVersion = null;
    protected HashMap beanDesc = new HashMap();
    protected AssemblyDescriptor asd = null;
    protected String fileName = null;
    protected String ejbClientJar = null;
    private List methodPermissionsDescList = null;
    private ExcludeListDesc excludeListDesc = null;
    protected JLinkedList jonasMDList = null;
    private String xmlContent = "";
    private String jonasXmlContent = "";
    private Map runAsMapping = null;

    public DeploymentDesc(ClassLoader classLoader, EjbJar ejbJar, JonasEjbJar jonasEjbJar, Logger l, String fileName) throws DeploymentDescException {
        this.logger = l;
        this.fileName = fileName;
        if (classLoader == null) {
            throw new DeploymentDescException("DeploymentDesc: Classloader is null");
        }
        this.specVersion = ejbJar.getVersion();
        this.ejbClientJar = ejbJar.getEjbClientJar();
        this.asd = ejbJar.getAssemblyDescriptor();
        this.runAsMapping = new HashMap();
        for (JonasRunAsMapping jonasRunAsMapping : jonasEjbJar.getJonasRunAsMappingList()) {
            String principalName = jonasRunAsMapping.getPrincipalName();
            String[] existingRunAsRoleMapping = (String[])this.runAsMapping.get(principalName);
            String[] newMappingRoles = null;
            int r = 0;
            if (existingRunAsRoleMapping == null) {
                newMappingRoles = new String[jonasRunAsMapping.getRoleNamesList().size()];
            } else {
                newMappingRoles = new String[jonasRunAsMapping.getRoleNamesList().size() + existingRunAsRoleMapping.length];
                System.arraycopy(existingRunAsRoleMapping, 0, newMappingRoles, 0, existingRunAsRoleMapping.length);
                r = existingRunAsRoleMapping.length;
            }
            Iterator itR = jonasRunAsMapping.getRoleNamesList().iterator();
            while (itR.hasNext()) {
                newMappingRoles[r] = (String)itR.next();
                ++r;
            }
            this.runAsMapping.put(principalName, newMappingRoles);
        }
        this.methodPermissionsDescList = new LinkedList();
        if (this.asd != null) {
            for (MethodPermission methodPermission : this.asd.getMethodPermissionList()) {
                this.methodPermissionsDescList.add(new MethodPermissionDesc(methodPermission));
            }
        }
        if (this.asd != null && this.asd.getExcludeList() != null) {
            this.excludeListDesc = new ExcludeListDesc(this.asd.getExcludeList());
        }
        this.jonasMDList = jonasEjbJar.getJonasMessageDestinationList();
        HashMap<String, JonasSession> jonasSession = new HashMap<String, JonasSession>();
        for (JonasSession jSes : jonasEjbJar.getJonasSessionList()) {
            jonasSession.put(jSes.getEjbName(), jSes);
        }
        if (ejbJar.getEnterpriseBeans() != null) {
            Iterator i = ejbJar.getEnterpriseBeans().getSessionList().iterator();
            while (i.hasNext()) {
                SessionDesc bd = null;
                Session ses = (Session)i.next();
                JonasSession jSes = (JonasSession)jonasSession.get(ses.getEjbName());
                if (jSes == null) {
                    jSes = new JonasSession();
                    jSes.setEjbName(ses.getEjbName());
                }
                if (ses.getSessionType().equals("Stateful")) {
                    bd = new SessionStatefulDesc(classLoader, ses, this.asd, jSes, this.jonasMDList, fileName);
                } else if (ses.getSessionType().equals("Stateless")) {
                    bd = new SessionStatelessDesc(classLoader, ses, this.asd, jSes, this.jonasMDList, fileName);
                } else {
                    throw new DeploymentDescException("invalid session-type content for bean " + ses.getEjbName());
                }
                bd.setDeploymentDesc(this);
                ((BeanDesc)bd).check();
                this.beanDesc.put(bd.getEjbName(), bd);
            }
        }
        HashMap<String, JonasEntity> jonasEntity = new HashMap<String, JonasEntity>();
        for (JonasEntity jEnt : jonasEjbJar.getJonasEntityList()) {
            jonasEntity.put(jEnt.getEjbName(), jEnt);
        }
        if (ejbJar.getEnterpriseBeans() != null) {
            Iterator i = ejbJar.getEnterpriseBeans().getEntityList().iterator();
            while (i.hasNext()) {
                BeanDesc bd = null;
                Entity ent = (Entity)i.next();
                JonasEntity jEnt = (JonasEntity)jonasEntity.get(ent.getEjbName());
                if (jEnt == null) {
                    throw new DeploymentDescException("jonas-entity missing for bean " + ent.getEjbName());
                }
                if (ent.getPersistenceType().equals("Bean")) {
                    bd = new EntityBmpDesc(classLoader, ent, this.asd, jEnt, this.jonasMDList, fileName);
                } else if (ent.getPersistenceType().equals("Container")) {
                    bd = this.newEntityBeanDesc(classLoader, ent, this.asd, jEnt, this.jonasMDList);
                } else {
                    throw new DeploymentDescException("Invalid persistence-type content for bean " + ent.getEjbName());
                }
                bd.setDeploymentDesc(this);
                bd.check();
                this.beanDesc.put(bd.getEjbName(), bd);
            }
        }
    }

    public Iterator getBeanDescIterator() {
        return this.beanDesc.values().iterator();
    }

    public BeanDesc[] getBeanDesc() {
        BeanDesc[] ret = new BeanDesc[this.beanDesc.size()];
        int j = 0;
        Iterator i = this.beanDesc.values().iterator();
        while (i.hasNext()) {
            ret[j] = (BeanDesc)i.next();
            ++j;
        }
        return ret;
    }

    public String[] getRolesForRunAsPrincipal(String principalName) {
        return (String[])this.runAsMapping.get(principalName);
    }

    public BeanDesc getBeanDesc(String ejbName) {
        return (BeanDesc)this.beanDesc.get(ejbName);
    }

    public EntityCmp2Desc asn2BeanDesc(String asn) {
        for (BeanDesc bd : this.beanDesc.values()) {
            if (!(bd instanceof EntityCmp2Desc) || !asn.equals(((EntityCmp2Desc)bd).getAbstractSchemaName())) continue;
            return (EntityCmp2Desc)bd;
        }
        return null;
    }

    public List getMethodPermissionsDescList() {
        return this.methodPermissionsDescList;
    }

    public ExcludeListDesc getExcludeListDesc() {
        return this.excludeListDesc;
    }

    public BeanDesc getBeanDescWithLocalInterface(String itfLocalName) {
        for (BeanDesc bd : this.beanDesc.values()) {
            if (bd.getLocalClass() == null || !itfLocalName.equals(bd.getLocalClass().getName())) continue;
            return bd;
        }
        return null;
    }

    public boolean getMessageDestination(String mdLink) {
        MessageDestination md2 = null;
        if (this.asd != null && this.asd.getMessageDestinationList() != null) {
            for (MessageDestination md2 : this.asd.getMessageDestinationList()) {
                if (!md2.getMessageDestinationName().equals(mdLink)) continue;
                return true;
            }
        }
        return false;
    }

    public JonasMessageDestination getJonasMessageDestination(String mdLink) {
        JonasMessageDestination jmd2 = null;
        if (this.jonasMDList != null) {
            for (JonasMessageDestination jmd2 : this.jonasMDList) {
                if (!jmd2.getMessageDestinationName().equals(mdLink)) continue;
                return jmd2;
            }
        }
        return null;
    }

    protected abstract BeanDesc newEntityBeanDesc(ClassLoader var1, Entity var2, AssemblyDescriptor var3, JonasEntity var4, JLinkedList var5) throws DeploymentDescException;

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEjbClientJar() {
        return this.ejbClientJar;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getXmlContent() {
        return this.xmlContent;
    }

    public String getJOnASXmlContent() {
        return this.jonasXmlContent;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\ngetDisplayName()=" + this.getDisplayName());
        ret.append("\ngetEjbClientJar()=" + this.getEjbClientJar());
        BeanDesc[] b = this.getBeanDesc();
        for (int i = 0; i < b.length; ++i) {
            ret.append("\ngetBeanDesc(" + i + ")=" + b[i].getClass().getName());
            ret.append(b[i].toString());
        }
        return ret.toString();
    }

    public void setXmlContent(String xmlContent) {
        this.xmlContent = xmlContent;
    }

    public void setJOnASXmlContent(String jonasXmlContent) {
        this.jonasXmlContent = jonasXmlContent;
    }
}

