/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.JTimerHandle;
import org.ow2.jonas.lib.ejb21.JTimerService;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.timer.TimerEvent;
import org.ow2.jonas.lib.timer.TimerEventListener;
import org.ow2.jonas.lib.timer.TimerManager;
import org.ow2.jonas.lib.timer.TraceTimer;

public class JTimer
implements Timer,
TimerEventListener,
Synchronization {
    private boolean oneshot;
    private long period;
    private long initialduration;
    private JTimerService timerservice;
    private Serializable info;
    private TimerManager tim = TimerManager.getInstance();
    private TimerEvent te1 = null;
    private TimerEvent te2 = null;
    private long starttime;
    private long endtime;
    private boolean createdInTx = false;
    private boolean cancelledInTx = false;
    private boolean cancelled = false;
    private TimerHandle myHandle = null;
    private File myfile = null;

    public JTimer(JTimerService timerservice, long initial, long period, Serializable info) {
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("New JTimer initial = " + initial + ", period = " + period));
        }
        this.timerservice = timerservice;
        this.info = info;
        this.period = period;
        this.initialduration = initial;
        this.oneshot = period == 0L;
    }

    public String toString() {
        String ret = "Timer:";
        ret = ret + " starttime=" + this.starttime;
        ret = ret + " endtime=" + this.endtime;
        ret = ret + " period=" + this.period;
        return ret;
    }

    public void setFile(File file) {
        this.myfile = file;
    }

    public long getStartTime() {
        return this.starttime;
    }

    public long getInitialDuration() {
        return this.initialduration;
    }

    public long getPeriod() {
        return this.period;
    }

    public JTimerService getTimerService() {
        return this.timerservice;
    }

    public void startTimer() {
        TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"");
        TransactionManager tm = this.timerservice.getTransactionManager();
        try {
            Transaction tx = tm.getTransaction();
            if (tx != null) {
                tx.registerSynchronization(this);
                this.createdInTx = true;
            }
        }
        catch (SystemException e) {
            TraceTimer.logger.log(BasicLevel.ERROR, (Object)"Cannot get Transaction", (Throwable)e);
        }
        catch (IllegalStateException e) {
            TraceTimer.logger.log(BasicLevel.ERROR, (Object)"Cannot register synchronization:", (Throwable)e);
        }
        catch (RollbackException e) {
            TraceTimer.logger.log(BasicLevel.ERROR, (Object)"transaction already rolled back", (Throwable)e);
        }
        this.starttime = System.currentTimeMillis();
        this.endtime = this.starttime + this.initialduration;
        this.te1 = this.tim.addTimerMs(this, this.initialduration, null, false);
    }

    public void stopTimer() {
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"Stop JTimer");
        }
        this.cancelled = true;
        if (this.te1 != null) {
            this.te1.unset();
            this.te1 = null;
        }
        if (this.te2 != null) {
            this.te2.unset();
            this.te2 = null;
        }
        if (this.myfile != null) {
            this.myfile.delete();
        }
    }

    public boolean isCancelled() {
        return this.cancelled || this.cancelledInTx;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JTimer) {
            JTimer timer2 = (JTimer)obj;
            if (timer2.getInitialDuration() != this.initialduration) {
                if (TraceTimer.isDebug()) {
                    TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"different duration");
                }
                return false;
            }
            if (timer2.getPeriod() != this.period) {
                if (TraceTimer.isDebug()) {
                    TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"different period");
                }
                return false;
            }
            if (timer2.getTimerService() != this.timerservice) {
                if (TraceTimer.isDebug()) {
                    TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"different timerservice");
                }
                return false;
            }
            if (timer2.getStartTime() != this.starttime) {
                if (TraceTimer.isDebug()) {
                    TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"different startTime");
                }
                return false;
            }
            if (TraceTimer.isDebug()) {
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"timers are equal");
            }
            return true;
        }
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"not a Timer");
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.getPeriod() / 1000L);
    }

    public boolean sameas(Object obj) {
        if (obj instanceof JTimer) {
            JTimer timer2 = (JTimer)obj;
            if (timer2.getInitialDuration() != this.initialduration) {
                if (TraceTimer.isDebug()) {
                    TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"different duration");
                }
                return false;
            }
            if (timer2.getPeriod() != this.period) {
                if (TraceTimer.isDebug()) {
                    TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"different period");
                }
                return false;
            }
            if (timer2.getTimerService() != this.timerservice) {
                if (TraceTimer.isDebug()) {
                    TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"different timerservice");
                }
                return false;
            }
            if (TraceTimer.isDebug()) {
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"timers are equal");
            }
            return true;
        }
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"not a Timer");
        }
        return false;
    }

    public void timeoutExpired(Object arg) {
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"JTimer expires");
        }
        this.timerservice.notify(this);
        if (this.cancelled) {
            if (TraceTimer.isDebug()) {
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"JTimer cancelled during timeout");
            }
            return;
        }
        if (this.te2 == null) {
            this.te1 = null;
            if (this.oneshot) {
                this.doCancel();
            } else {
                if (TraceTimer.isDebug()) {
                    TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"Start periodic jonas timer");
                }
                this.endtime = System.currentTimeMillis() + this.period;
                this.te2 = this.tim.addTimerMs(this, this.period, null, true);
            }
        } else {
            this.endtime = System.currentTimeMillis() + this.period;
        }
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (this.cancelled || this.cancelledInTx) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"Timer cancelled");
            throw new NoSuchObjectLocalException("Timer already cancelled");
        }
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"");
        }
        TransactionManager tm = this.timerservice.getTransactionManager();
        try {
            Transaction tx = tm.getTransaction();
            if (tx != null) {
                tx.registerSynchronization(this);
                this.cancelledInTx = true;
            } else {
                this.doCancel();
            }
        }
        catch (SystemException e) {
            TraceTimer.logger.log(BasicLevel.ERROR, (Object)"Cannot get Transaction", (Throwable)e);
        }
        catch (IllegalStateException e) {
            TraceTimer.logger.log(BasicLevel.ERROR, (Object)"Cannot register synchronization:", (Throwable)e);
        }
        catch (RollbackException e) {
            TraceTimer.logger.log(BasicLevel.ERROR, (Object)"transaction already rolled back", (Throwable)e);
        }
    }

    private void doCancel() {
        this.stopTimer();
        this.timerservice.remove(this);
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (this.cancelled || this.cancelledInTx) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"Timer cancelled");
            throw new NoSuchObjectLocalException("Timer cancelled or expired");
        }
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.endtime - System.currentTimeMillis();
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (this.cancelled || this.cancelledInTx) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"Timer cancelled");
            throw new NoSuchObjectLocalException("Timer cancelled or expired");
        }
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"");
        }
        return new Date(this.endtime);
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (this.cancelled || this.cancelledInTx) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"Timer cancelled");
            throw new NoSuchObjectLocalException("Timer cancelled or expired");
        }
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.info;
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (this.cancelled || this.cancelledInTx) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"Timer cancelled");
            throw new NoSuchObjectLocalException("Timer cancelled or expired");
        }
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.myHandle == null) {
            this.myHandle = new JTimerHandle(this.starttime, this.initialduration, this.period, this.info, this.timerservice.getEjbName(), this.timerservice.getContainer(), this.timerservice.getPK());
        }
        return this.myHandle;
    }

    public void afterCompletion(int status) {
        if (TraceEjb.isDebugTx()) {
            TraceEjb.tx.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.createdInTx) {
            if (status != 3 && !this.cancelled) {
                this.doCancel();
            }
            this.createdInTx = false;
        }
        if (this.cancelledInTx) {
            if (status == 3 && !this.cancelled) {
                this.doCancel();
            }
            this.cancelledInTx = false;
        }
    }

    public void beforeCompletion() {
    }
}

