/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jmbeans;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.ow2.jonas.lib.jmbeans.J2EEServer;
import org.ow2.jonas.lib.jmbeans.ServiceItem;
import org.ow2.jonas.lib.jmbeans.ServiceName;
import org.ow2.jonas.lib.jmbeans.ServiceState;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManager {
    private Log logger = LogFactory.getLog(J2EEServer.class);
    private J2EEServer server = null;
    private Hashtable<String, Object> servicesState = null;

    public ServiceManager(J2EEServer server) {
        this.server = server;
        this.servicesState = new Hashtable();
    }

    public void addService(ServiceItem serviceItem) {
        this.servicesState.put(serviceItem.getName(), serviceItem);
    }

    public void setMandatoryService(String serviceName) {
        ServiceItem serviceItem = (ServiceItem)this.servicesState.get(serviceName);
        if (serviceItem != null) {
            serviceItem.setMandatory(true);
        }
    }

    public void deleteAllServices() {
        this.servicesState.clear();
    }

    public ArrayList<String> getServices() {
        ArrayList<String> sl = new ArrayList<String>();
        for (ServiceItem serviceItem : this.servicesState.values()) {
            sl.add(serviceItem.getName());
        }
        return sl;
    }

    public ServiceState setServiceState(String serviceName, ServiceState state) {
        if (this.servicesState == null) {
            this.logger.error("setServiceState called but servicesState table null", new Object[0]);
            return null;
        }
        ServiceItem serviceItem = (ServiceItem)this.servicesState.get(serviceName);
        if (serviceItem == null) {
            this.logger.error("setServiceState called but service " + serviceName + " not known", new Object[0]);
            return null;
        }
        ServiceState prevState = serviceItem.getState();
        if (prevState != null && prevState.equals((Object)state)) {
            return prevState;
        }
        serviceItem.setState(state);
        this.checkServerState(serviceName);
        return state;
    }

    public ServiceState getServiceState(String serviceName) {
        ServiceItem serviceItem = (ServiceItem)this.servicesState.get(serviceName);
        if (serviceItem != null) {
            return serviceItem.getState();
        }
        this.logger.error("getServiceState called but service " + serviceName + " not known", new Object[0]);
        return null;
    }

    public String getServiceDescription(String serviceName) {
        ServiceItem serviceItem = (ServiceItem)this.servicesState.get(serviceName);
        if (serviceItem != null) {
            return serviceItem.getDescription();
        }
        this.logger.error("getServiceDescription called but service " + serviceName + " not known", new Object[0]);
        return null;
    }

    private boolean allServicesRunning() {
        boolean servicesRunning = true;
        for (ServiceItem serviceItem : this.servicesState.values()) {
            ServiceState state = serviceItem.getState();
            if (state.equals((Object)ServiceState.RUNNING)) continue;
            servicesRunning = false;
            break;
        }
        return servicesRunning;
    }

    private boolean allServicesStopped() {
        boolean servicesStopped = true;
        for (ServiceItem serviceItem : this.servicesState.values()) {
            ServiceState state = serviceItem.getState();
            if (state.equals((Object)ServiceState.STOPPED) || serviceItem.isMandatory()) continue;
            servicesStopped = false;
            break;
        }
        return servicesStopped;
    }

    protected void checkServerState(String serviceName) {
        if (this.server.isStarting() && this.allServicesRunning()) {
            this.server.setServicesRunning();
        }
        if (this.server.isRunning() && "depmonitor".equals(serviceName) && this.depMonitorRunning()) {
            this.server.setDepmonitoringRunning(null);
        }
        if ((this.server.isRunning() || this.server.isStopping()) && this.allServicesStopped()) {
            this.server.setStopped();
        }
    }

    private boolean depMonitorRunning() {
        ServiceState depMonitorState;
        ServiceItem depMonitorItem = (ServiceItem)this.servicesState.get((Object)ServiceName.DEPMONITOR);
        return depMonitorItem != null && ServiceState.RUNNING.equals((Object)(depMonitorState = depMonitorItem.getState()));
    }

    private void dumpServicesState() {
        Iterator<Object> items = this.servicesState.values().iterator();
        System.out.println("********************");
        while (items.hasNext()) {
            ServiceItem serviceItem = (ServiceItem)items.next();
            String name = serviceItem.getName();
            String desc = serviceItem.getDescription();
            ServiceState state = serviceItem.getState();
            boolean mandatory = serviceItem.isMandatory();
            if (mandatory) {
                System.out.println("** Mandatory Service " + name + " (" + desc + ") is " + (Object)((Object)state));
                continue;
            }
            System.out.println("** Service " + name + " (" + desc + ") is " + (Object)((Object)state));
        }
    }
}

