/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.naming;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.naming.ComponentNameParser;
import org.ow2.jonas.lib.naming.SingletonNamingManager;
import org.ow2.jonas.lib.util.Log;

public class ComponentContext
implements Context {
    private static Logger logger = null;
    private Hashtable myEnv = null;
    private Hashtable bindings = new Hashtable();
    private static NameParser myParser = new ComponentNameParser();
    private String compId;
    private Context wrappedContext = null;

    public ComponentContext(String id, Hashtable env) {
        if (env != null) {
            this.myEnv = (Hashtable)env.clone();
        }
        this.compId = id;
        logger = Log.getLogger("org.ow2.jonas.naming");
    }

    public ComponentContext(String id) {
        this.myEnv = new Hashtable();
        this.compId = id;
        logger = Log.getLogger("org.ow2.jonas.naming");
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        CompositeName n;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"empty name");
            }
            return this;
        }
        if (n.size() == 1) {
            Object ret;
            if (this.wrappedContext != null && (ret = this.bindings.get(name)) == null) {
                return this.wrappedContext.lookup(name);
            }
            ret = this.bindings.get(name);
            if (ret == null) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(" " + name + " not found."));
                }
                throw new NameNotFoundException(name);
            }
            if (ret instanceof LinkRef) {
                InitialContext ictx = SingletonNamingManager.getInstance().getInitialContext();
                RefAddr ra = ((Reference)ret).get(0);
                try {
                    ret = ictx.lookup((String)ra.getContent());
                }
                catch (Exception e) {
                    NamingException ne = new NamingException(e.getMessage());
                    ne.setRootCause(e);
                    logger.log(BasicLevel.WARN, (Object)("Unexpected exception when looking up '" + name + "'"), (Throwable)e);
                    throw ne;
                }
            }
            if (ret instanceof Reference) {
                try {
                    Object o = NamingManager.getObjectInstance(ret, n, this, this.myEnv);
                    ret = o;
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    NamingException ne = new NamingException(e.getMessage());
                    ne.setRootCause(e);
                    throw ne;
                }
                if (ret == null) {
                    logger.log(BasicLevel.WARN, (Object)("Can not build an object with the reference " + name));
                    throw new NamingException("Can not build an object with the reference '" + name + "'");
                }
            }
            return ret;
        }
        String suffix = n.getSuffix(1).toString();
        Context subctx = this.lookupCtx(n.get(0));
        return subctx.lookup(suffix);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        CompositeName n;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            logger.log(BasicLevel.ERROR, (Object)"ComponentContext bind empty name ?");
            throw new InvalidNameException("ComponentContext cannot bind empty name");
        }
        if (n.size() == 1) {
            if (this.wrappedContext != null) {
                this.wrappedContext.bind(name, obj);
                return;
            }
            if (this.bindings.get(name) != null) {
                logger.log(BasicLevel.ERROR, (Object)"ComponentContext: trying to overbind");
                throw new NameAlreadyBoundException("ComponentContext: Use rebind to bind over a name");
            }
            this.bindings.put(name, obj);
        } else {
            Context subctx;
            String suffix = n.getSuffix(1).toString();
            try {
                subctx = this.lookupCtx(n.get(0));
            }
            catch (NameNotFoundException e) {
                subctx = this.createSubcontext(n.get(0));
            }
            subctx.bind(suffix, obj);
        }
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        CompositeName n;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            logger.log(BasicLevel.ERROR, (Object)"ComponentContext rebind empty name ?");
            throw new InvalidNameException("ComponentContext cannot rebind empty name");
        }
        if (n.size() == 1) {
            this.bindings.put(name, obj);
        } else {
            Context subctx;
            String suffix = n.getSuffix(1).toString();
            try {
                subctx = this.lookupCtx(n.get(0));
            }
            catch (NameNotFoundException e) {
                subctx = this.createSubcontext(n.get(0));
            }
            subctx.rebind(suffix, obj);
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void unbind(String name) throws NamingException {
        CompositeName n;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            logger.log(BasicLevel.ERROR, (Object)"ComponentContext unbind empty name ?");
            throw new InvalidNameException("ComponentContext cannot unbind empty name");
        }
        if (n.size() == 1) {
            if (this.bindings.get(name) == null) {
                logger.log(BasicLevel.ERROR, (Object)"ComponentContext nothing to unbind");
                throw new NameNotFoundException(name);
            }
            this.bindings.remove(name);
        } else {
            String suffix = n.getSuffix(1).toString();
            Context subctx = this.lookupCtx(n.get(0));
            subctx.unbind(suffix);
        }
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    public void rename(String oldName, String newName) throws NamingException {
        logger.log(BasicLevel.ERROR, (Object)("ComponentContext rename " + oldName + " in " + newName));
        Object obj = this.lookup(oldName);
        this.rebind(newName, obj);
        this.unbind(oldName);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)name);
        }
        if (name.length() == 0) {
            return new ListOfNames(this.bindings);
        }
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            return ((Context)obj).list("");
        }
        logger.log(BasicLevel.ERROR, (Object)"ComponentContext: can only list a Context");
        throw new NotContextException(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)name);
        }
        if (name.length() == 0) {
            return new ListOfBindings(this.bindings);
        }
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            return ((Context)obj).listBindings("");
        }
        logger.log(BasicLevel.ERROR, (Object)"ComponentContext: can only list a Context");
        throw new NotContextException(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        logger.log(BasicLevel.ERROR, (Object)("ComponentContext try to destroySubcontext " + name));
        throw new OperationNotSupportedException("ComponentContext: destroySubcontext");
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        CompositeName n;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            logger.log(BasicLevel.ERROR, (Object)"ComponentContext createSubcontext with empty name ?");
            throw new InvalidNameException("ComponentContext cannot create empty Subcontext");
        }
        Context ctx = null;
        if (n.size() == 1) {
            ctx = new ComponentContext(this.compId, this.myEnv);
            this.bindings.put(name, ctx);
        } else {
            Context subctx;
            String suffix = n.getSuffix(1).toString();
            name = n.get(0);
            try {
                subctx = this.lookupCtx(name);
            }
            catch (NameNotFoundException e) {
                subctx = this.createSubcontext(name);
            }
            ctx = subctx.createSubcontext(suffix);
        }
        return ctx;
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)name);
        }
        logger.log(BasicLevel.ERROR, (Object)"ComponentContext lookupLink not implemented yet!");
        return this.lookup(name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        logger.log(BasicLevel.ERROR, (Object)"ComponentContext composeName not implemented!");
        throw new OperationNotSupportedException("ComponentContext composeName");
    }

    public String composeName(String name, String prefix) throws NamingException {
        logger.log(BasicLevel.ERROR, (Object)("ComponentContext composeName " + name + " " + prefix));
        throw new OperationNotSupportedException("ComponentContext composeName");
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)propName);
        }
        if (this.myEnv == null) {
            this.myEnv = new Hashtable();
        }
        return this.myEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)propName);
        }
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.myEnv == null) {
            this.myEnv = new Hashtable();
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    public String getNameInNamespace() {
        return this.compId;
    }

    protected void addWrapped(Context wrappedContext) {
        this.wrappedContext = wrappedContext;
    }

    private Context lookupCtx(String name) throws NamingException {
        Object obj = this.bindings.get(name);
        if (obj == null) {
            throw new NameNotFoundException();
        }
        if (obj instanceof ComponentContext) {
            return (Context)obj;
        }
        throw new NameAlreadyBoundException(name);
    }

    private class ListOfBindings
    extends ListOfNames {
        ListOfBindings(Hashtable bindings) {
            super(bindings);
        }

        public Object next() throws NamingException {
            String name = (String)this.getNames().nextElement();
            return new Binding(name, this.getBindings().get(name));
        }
    }

    private class ListOfNames
    implements NamingEnumeration {
        private Enumeration names;
        private Hashtable bindings;

        ListOfNames(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public boolean hasMore() throws NamingException {
            return this.names.hasMoreElements();
        }

        public Object next() throws NamingException {
            String name = (String)this.names.nextElement();
            String className = this.bindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        public void close() {
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new NoSuchElementException(e.toString());
            }
        }

        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                return false;
            }
        }

        protected Hashtable getBindings() {
            return this.bindings;
        }

        protected Enumeration getNames() {
            return this.names;
        }
    }
}

