/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jotm.ots;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.InternalTransactionContext;
import org.objectweb.jotm.TransactionContext;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.ow2.jotm.ots.OTSInterceptor;

public class OTSServerTransactionInterceptor
extends OTSInterceptor
implements ServerRequestInterceptor {
    private static final long serialVersionUID = -1340704299832740597L;
    private static Current current = null;
    private Map<Integer, TransactionContext> contexts = new ConcurrentHashMap<Integer, TransactionContext>();
    private static final String NAME = "OTSServerTransactionInteceptor";

    public OTSServerTransactionInterceptor(ORBInitInfo info) {
        super(info);
    }

    public String name() {
        return NAME;
    }

    public void receive_request_service_contexts(ServerRequestInfo jri) throws ForwardRequest {
        try {
            ServiceContext serviceContext = jri.get_request_service_context(0);
            TransactionContext txCtx = this.decodeCorbaPropagationContext(serviceContext);
            if (txCtx != null) {
                Integer key = new Integer(jri.request_id());
                this.contexts.put(key, txCtx);
            }
        }
        catch (BAD_PARAM b) {
        }
        catch (Exception e) {
            throw new ForwardRequest();
        }
    }

    public void receive_request(ServerRequestInfo jri) throws ForwardRequest {
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            Integer key = new Integer(jri.request_id());
            InternalTransactionContext txCtx = null;
            txCtx = (InternalTransactionContext)this.contexts.remove(key);
            current.setPropagationContext(txCtx, false);
        }
    }

    public void send_reply(ServerRequestInfo jri) {
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            try {
                TransactionContext txCtx = current.getPropagationContext(true);
                ServiceContext pContext = null;
                if (txCtx != null) {
                    pContext = this.buildCorbaPropagationContext(txCtx);
                    jri.add_reply_service_context(pContext, true);
                    current.setPropagationContext(null, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void send_exception(ServerRequestInfo jri) throws ForwardRequest {
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            try {
                TransactionContext txCtx = current.getPropagationContext(true);
                ServiceContext pContext = null;
                if (txCtx != null) {
                    pContext = this.buildCorbaPropagationContext(txCtx);
                    jri.add_reply_service_context(pContext, true);
                    current.setPropagationContext(null, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void send_other(ServerRequestInfo jri) throws ForwardRequest {
    }

    public void destroy() {
    }
}

