/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.war.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.metadata.war.api.IWarClassMetadata;
import org.ow2.util.ee.metadata.war.api.IWarDeployableMetadata;
import org.ow2.util.ee.metadata.war.impl.WarDeployableMetadata;
import org.ow2.util.ee.metadata.war.impl.configurator.WarDeployableMetadataConfigurator;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.ArchiveScanner;
import org.ow2.util.scan.api.ArchiveScannerFactory;
import org.ow2.util.scan.api.ScanException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarExternLibraries {
    private static final Log LOGGER = LogFactory.getLog(WarExternLibraries.class);
    private Map<String, IWarClassMetadata> classMetadata = new HashMap<String, IWarClassMetadata>();
    private Map<ArchiveScanner, IWarDeployableMetadata> scanners = new HashMap<ArchiveScanner, IWarDeployableMetadata>();

    public WarExternLibraries(ArchiveScannerFactory archiveScannerFactory, List<IArchive> archiveList) {
        for (IArchive archive : archiveList) {
            WarDeployableMetadataConfigurator warArchiveMetadataConfigurator = new WarDeployableMetadataConfigurator(null);
            ArchiveScanner archiveScanner = archiveScannerFactory.createArchiveScanner(archive);
            archiveScanner.addArchiveConfigurator(warArchiveMetadataConfigurator);
            this.scanners.put(archiveScanner, warArchiveMetadataConfigurator.getWarDeployableMetadata());
        }
    }

    public void attachClassMetadata(WarDeployableMetadata warDeployableMetadata, String className) {
        IWarClassMetadata warClassMetadata = this.classMetadata.get(className);
        if (warClassMetadata == null) {
            ArrayList<String> classNameList = new ArrayList<String>();
            classNameList.add(className);
            Iterator<Map.Entry<ArchiveScanner, IWarDeployableMetadata>> entries = this.scanners.entrySet().iterator();
            while (warClassMetadata == null && entries.hasNext()) {
                Map.Entry<ArchiveScanner, IWarDeployableMetadata> entry = entries.next();
                try {
                    entry.getKey().scanCollection(classNameList);
                    warClassMetadata = entry.getValue().getWarClassMetadata(className);
                }
                catch (ScanException e) {
                    LOGGER.debug("error when scan collection", e);
                }
            }
        }
        if (warClassMetadata != null) {
            this.classMetadata.put(className, warClassMetadata);
            try {
                warClassMetadata.attachClone(warDeployableMetadata);
                warDeployableMetadata.addWarClassMetadata(warClassMetadata);
            }
            catch (CloneNotSupportedException e) {
                LOGGER.debug("Can not add metadata", e);
            }
        }
    }

    public void close() {
        for (ArchiveScanner archiveScanner : this.scanners.keySet()) {
            archiveScanner.endScan();
        }
    }
}

