/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.api;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.scan.api.IArchiveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArchiveHelper
implements IArchiveHelper {
    private IArchive archive;

    public DefaultArchiveHelper(IArchive archive) {
        this.archive = archive;
    }

    @Override
    public URL getClassURL(String className) throws ArchiveException {
        return this.archive.getResource(className.replace('.', '/').concat(".class"));
    }

    @Override
    public List<URL> listClassURL() throws ArchiveException {
        ArrayList<URL> classURLList = new ArrayList<URL>();
        Iterator<URL> iterator = this.archive.getResources();
        while (iterator.hasNext()) {
            URL url = iterator.next();
            String className = url.getPath().toLowerCase();
            if (!className.endsWith(".class")) continue;
            classURLList.add(url);
        }
        return classURLList;
    }

    @Override
    public IArchive getArchive() {
        return this.archive;
    }
}

