/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.base;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.easybeans.deployment.InjectionHolder;
import org.ow2.easybeans.deployment.api.EZBInjectionHolder;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.easybeans.resolver.api.EZBJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBJNDIResolverException;
import org.ow2.jonas.deployment.api.IEnvEntryDesc;
import org.ow2.jonas.deployment.api.IResourceEnvRefDesc;
import org.ow2.jonas.deployment.api.IResourceRefDesc;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.EjbLocalRefDesc;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.deployment.common.MessageDestinationRefDesc;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.deployment.web.lib.WarDeployableMetadataFactoryHolder;
import org.ow2.jonas.deployment.web.lib.WebDeploymentDescManager;
import org.ow2.jonas.ear.EarServiceException;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.loader.SimpleWebappClassLoader;
import org.ow2.jonas.lib.loader.WebappClassLoader;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.naming.ComponentContext;
import org.ow2.jonas.lib.security.PermissionManagerException;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.wsgen.WsGenChecker;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JNamingManager;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.web.base.BaseWebContainerServiceMBean;
import org.ow2.jonas.web.base.WARDeployer;
import org.ow2.jonas.web.base.War;
import org.ow2.jonas.web.base.lib.JarTools;
import org.ow2.jonas.web.base.lib.PermissionManager;
import org.ow2.jonas.ws.WebServicesService;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.metadata.common.api.struct.IJEjbEJB;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceContext;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceUnit;
import org.ow2.util.ee.metadata.war.api.IWarDeployableMetadataFactory;
import org.ow2.util.ee.metadata.war.impl.enc.EZBENCBindingHolder;
import org.ow2.util.ee.metadata.war.impl.enc.IBinding;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWebContainerService
extends AbsServiceImpl
implements JWebContainerService,
BaseWebContainerServiceMBean {
    protected static final String JONAS_BASE = JProp.getJonasBase();
    protected static final String WORK_DIR = JProp.getWorkDir();
    protected static final String WORK_WEBAPPS_DIR = WORK_DIR + File.separator + "webapps";
    protected static final String SINGLE_WORK_WEBAPPS_DIR_SUFFIX = "single";
    protected static final String INEAR_WORK_WEBAPPS_DIR_SUFFIX = "ear";
    private static final int WAR_EXTENSION_LENGTH = ".war".length();
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.web");
    private JNamingManager naming;
    private WARDeployer warDeployer = null;
    private JComponentContextFactory contextFactory;
    private Hashtable warLoaders = new Hashtable();
    private Hashtable warBindings = new Hashtable();
    protected JmxService jmxService = null;
    private IWarDeployableMetadataFactory warDeployableMetadataFactory = null;
    private List warDeployed = new Vector();
    private String serverName = null;
    private String serverVersion = null;
    private WebServicesService wsService = null;
    private ClassLoader extClassLoader;
    private IDeployerManager deployerManager;
    private VersioningService versioningService;

    public BaseWebContainerService() {
        this.warDeployer = new WARDeployer();
    }

    public void setParsingwithvalidation(boolean validate) {
        WebDeploymentDescManager.setParsingWithValidation((boolean)validate);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            if (!validate) {
                logger.log(BasicLevel.DEBUG, (Object)"Web XML parsing without validation");
            } else {
                logger.log(BasicLevel.DEBUG, (Object)"Web XML parsing with validation");
            }
        }
    }

    protected void doStart() throws ServiceException {
        try {
            LoaderManager lm = LoaderManager.getInstance();
            this.extClassLoader = lm.getExternalLoader();
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get the Applications ClassLoader from Web Container Service: " + e));
            throw new ServiceException("Cannot get the Applications ClassLoader from Web Container Service", (Throwable)e);
        }
        this.warDeployer.setWebContainerService(this);
        this.deployerManager.register((IDeployer)this.warDeployer);
        this.registerWebServiceMBean(this, this.getDomainName());
    }

    protected void doStop() throws ServiceException {
        this.deployerManager.unregister((IDeployer)this.warDeployer);
        for (int i = this.warDeployed.size() - 1; i >= 0; --i) {
            War war = (War)this.warDeployed.get(i);
            URL warURL = war.getWarURL();
            String fileName = warURL.getFile();
            try {
                if (war.isInEarCase()) continue;
                ComponentContext ctx = new ComponentContext(fileName);
                ctx.rebind("warURL", (Object)warURL);
                ctx.rebind("isEarCase", (Object)new Boolean(false));
                this.unRegisterWar((Context)ctx);
                continue;
            }
            catch (Exception e) {
                String err = "Error when undeploying the war :" + fileName;
                logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            }
        }
        this.unregisterWebServiceMBean(this.getDomainName());
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"WebContainerService stopped");
        }
    }

    protected abstract void doRegisterWar(Context var1) throws JWebContainerServiceException;

    protected abstract void doUnRegisterWar(Context var1) throws JWebContainerServiceException;

    protected URL getUnpackDir(URL warURL, String earAppName) throws JWebContainerServiceException {
        String destDir = WORK_WEBAPPS_DIR + File.separator + this.getJonasServerName() + File.separator;
        URL unpackedWarURL = null;
        String fileName = warURL.getFile();
        File warFile = new File(fileName);
        if (warFile.isFile()) {
            destDir = earAppName != null ? destDir + INEAR_WORK_WEBAPPS_DIR_SUFFIX + File.separator + earAppName + File.separator : destDir + SINGLE_WORK_WEBAPPS_DIR_SUFFIX + File.separator;
            try {
                destDir = destDir + FileUtils.lastModifiedFileName((File)warFile);
            }
            catch (FileUtilsException e) {
                throw new JWebContainerServiceException("Failed creating the unpackedWarURL", (Throwable)e);
            }
            JarTools.unpack(fileName, destDir);
        } else {
            destDir = fileName;
        }
        try {
            unpackedWarURL = new File(destDir).toURL();
        }
        catch (MalformedURLException mue) {
            throw new JWebContainerServiceException("Failed getting the unpackedWarURL", (Throwable)mue);
        }
        return unpackedWarURL;
    }

    public URLClassLoader getClassLoader(URL warURL, String earAppName, ClassLoader parentLoader) throws JWebContainerServiceException {
        URLClassLoader loaderForCls = null;
        try {
            WebLoaderHolder holder = (WebLoaderHolder)this.warLoaders.get(warURL);
            if (holder != null) {
                loaderForCls = holder.getJonasWebLoader();
            }
        }
        catch (Exception e) {
            throw new JWebContainerServiceException("Error when getting '" + warURL + "' in cache", (Throwable)e);
        }
        if (loaderForCls == null) {
            URL unpackedWarURL = this.getUnpackDir(warURL, earAppName);
            try {
                loaderForCls = parentLoader != null ? new WebappClassLoader(unpackedWarURL, parentLoader) : new WebappClassLoader(unpackedWarURL, this.extClassLoader);
            }
            catch (IOException ioe) {
                throw new JWebContainerServiceException("Cannot create WebAppClassLoader from '" + unpackedWarURL + "'", (Throwable)ioe);
            }
            try {
                WebLoaderHolder holder = new WebLoaderHolder(loaderForCls, null);
                this.warLoaders.put(warURL, holder);
            }
            catch (Exception e) {
                throw new JWebContainerServiceException("Error when adding '" + warURL + "' in cache", (Throwable)e);
            }
        }
        return loaderForCls;
    }

    public ClassLoader getContextLinkedClassLoader(URL warURL) {
        WebLoaderHolder holder = (WebLoaderHolder)this.warLoaders.get(warURL);
        if (holder != null) {
            return holder.getEnvWebLoader();
        }
        return null;
    }

    protected void registerWar(Context ctx) throws JWebContainerServiceException {
        EZBInjectionHolder ezbInjectionHolder;
        String userURI;
        String earAppName;
        String contextRoot;
        EARDeployable earDeployable;
        URL earURL;
        block50: {
            earURL = null;
            earDeployable = null;
            contextRoot = null;
            earAppName = null;
            userURI = null;
            ezbInjectionHolder = null;
            try {
                earURL = (URL)ctx.lookup("earURL");
                earDeployable = (EARDeployable)ctx.lookup("earDeployable");
                contextRoot = (String)ctx.lookup("contextRoot");
            }
            catch (NamingException e) {
                if (earURL == null && earDeployable == null && contextRoot == null) break block50;
                String err = "Error while getting parameter from context param :" + e.getMessage();
                logger.log(BasicLevel.ERROR, (Object)err);
                throw new JWebContainerServiceException(err, (Throwable)e);
            }
        }
        if (earDeployable != null) {
            earAppName = earDeployable.getModuleName();
        }
        URL warURL = null;
        try {
            warURL = (URL)ctx.lookup("warURL");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param :" + e.getMessage();
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        try {
            ezbInjectionHolder = (EZBInjectionHolder)ctx.lookup(EZBInjectionHolder.class.getName());
        }
        catch (NamingException e) {
            logger.log(BasicLevel.DEBUG, (Object)"No injection holder, create a new one");
            ezbInjectionHolder = new InjectionHolder();
        }
        File warFile = new File(warURL.getFile());
        if (!warFile.exists()) {
            String err = "registerWar: '" + warFile.getPath() + "' not found";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new JWebContainerServiceException(err);
        }
        War war = this.getWar(warURL);
        if (war != null) {
            String err = "Cannot deploy war '" + warURL.getFile() + "' is already deployed." + " You must undeploy the war before a new deployment.";
            throw new JWebContainerServiceException(err);
        }
        URLClassLoader parentLoader = null;
        URLClassLoader earClassLoader = null;
        boolean isInEar = true;
        try {
            parentLoader = (URLClassLoader)ctx.lookup("parentClassLoader");
            earClassLoader = (URLClassLoader)ctx.lookup("earClassLoader");
        }
        catch (NamingException ne) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Not an ear case");
            }
            isInEar = false;
        }
        if (!isInEar) {
            try {
                ObjectName j2eeServer = J2eeObjectName.J2EEServer((String)this.getDomainName(), (String)this.getJonasServerName());
                WsGenChecker wsgc = new WsGenChecker(warFile.getCanonicalPath(), j2eeServer, this.jmxService.getJmxServer());
                wsgc.checkWsGen(this.getDomainName());
            }
            catch (Exception e) {
                throw new EarServiceException("Cannot apply WsGen on the war : " + warFile, (Throwable)e);
            }
        }
        URLClassLoader loaderForCls = this.getClassLoader(warURL, earAppName, parentLoader);
        URL unpackedWarURL = this.getUnpackDir(warURL, earAppName);
        if (this.wsService != null && earClassLoader == null) {
            try {
                ComponentContext contctx = null;
                try {
                    contctx = new ComponentContext(unpackedWarURL.getFile());
                    contctx.rebind("unpackDir", (Object)unpackedWarURL.toExternalForm());
                    contctx.rebind("jarUrls", (Object)new URL[0]);
                    contctx.rebind("warUrls", (Object)new URL[]{warURL});
                    if (parentLoader != null) {
                        contctx.rebind("ejbClassLoader", (Object)parentLoader);
                    }
                }
                catch (NamingException e) {
                    String err = "Can not bind params for the WebServices service, Can't deploy Web Services Endpoint";
                    throw new JWebContainerServiceException(err, (Throwable)e);
                }
                this.wsService.deployWebServices((Context)contctx);
            }
            catch (ServiceException se) {
                String err = "Error during the deployment of the WebServices of the War file '" + warURL + "'";
                logger.log(BasicLevel.ERROR, (Object)(err + " : " + se.getMessage()));
                throw new JWebContainerServiceException(err, (Throwable)se);
            }
        }
        WebContainerDeploymentDesc webDD = null;
        try {
            WebDeploymentDescManager manager = WebDeploymentDescManager.getInstance();
            webDD = manager.getDeploymentDesc(unpackedWarURL, warURL, (ClassLoader)loaderForCls, (ClassLoader)earClassLoader);
        }
        catch (DeploymentDescException e) {
            String err = "Cannot read the deployment descriptors '" + warURL.getFile() + "'";
            logger.log(BasicLevel.ERROR, (Object)(err + ": " + (Object)((Object)e)));
            e.printStackTrace(System.err);
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        SimpleWebappClassLoader webClassLoader = null;
        try {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Populating environment of the file " + warURL.getFile()));
            }
            ComponentContext ctxParam = new ComponentContext(unpackedWarURL.getFile());
            ctxParam.rebind("DeploymentDesc", (Object)webDD);
            ctxParam.rebind("warName", (Object)unpackedWarURL.getFile());
            webClassLoader = parentLoader == null ? new SimpleWebappClassLoader(unpackedWarURL, this.extClassLoader) : new SimpleWebappClassLoader(unpackedWarURL, (ClassLoader)parentLoader);
            if (earDeployable != null) {
                ctxParam.rebind("earDeployable", (Object)earDeployable);
            }
            ctxParam.rebind("parentCL", (Object)webClassLoader);
            this.setWebEnvironment((Context)ctxParam, ezbInjectionHolder, (ClassLoader)webClassLoader);
        }
        catch (Exception e) {
            String err = "Error when populating ";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        WebLoaderHolder holder = (WebLoaderHolder)this.warLoaders.get(warURL);
        holder.setEnvWebLoader((ClassLoader)webClassLoader);
        contextRoot = this.getContextRoot(contextRoot, earClassLoader, warURL, webDD);
        String versionID = null;
        if (this.isVersioningEnabled()) {
            versionID = earURL != null ? this.versioningService.getVersionID((IDeployable)earDeployable) : this.versioningService.getVersionID(warURL);
        }
        if (versionID == null) {
            userURI = contextRoot;
        } else if (!contextRoot.contains(versionID)) {
            userURI = contextRoot;
            contextRoot = contextRoot + versionID;
        } else {
            userURI = contextRoot.replace(versionID, "");
        }
        String hostName = webDD.getHost();
        List deployedWars = this.getWar(contextRoot);
        for (War deployedWar : deployedWars) {
            String hostDeployed = deployedWar.getHostName();
            if ((hostDeployed != null || hostName != null) && (hostDeployed == null || !hostDeployed.equals(hostName))) continue;
            String err = "Cannot deploy war '" + warURL.getFile() + "' is already deployed with the context '" + contextRoot + "'." + " You must undeploy the war before a new deployment.";
            throw new JWebContainerServiceException(err);
        }
        boolean java2DelegationModel = webDD.getJava2DelegationModel();
        war = new War(warURL, earURL, hostName, contextRoot, java2DelegationModel, webDD.getXmlContent(), webDD.getJOnASXmlContent(), webDD.getServletsName());
        PermissionManager permissionManager = null;
        try {
            boolean removePContext = true;
            if (earClassLoader != null) {
                removePContext = false;
            }
            permissionManager = new PermissionManager(webDD, war.getContextId(), removePContext);
            permissionManager.translateServletDeploymentDescriptor();
            if (earClassLoader == null) {
                permissionManager.commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String err = "Cannot build permission manager object for the webapp '" + unpackedWarURL + "' : ";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        ComponentContext ctxParam = null;
        try {
            ctxParam = new ComponentContext(unpackedWarURL.getFile());
            ctxParam.rebind("warURL", (Object)warURL);
            if (earURL != null) {
                ctxParam.rebind("earURL", (Object)earURL);
            }
            ctxParam.rebind("unpackedWarURL", (Object)unpackedWarURL);
            ctxParam.rebind("parentCL", (Object)webClassLoader);
            if (hostName != null) {
                ctxParam.rebind("hostName", (Object)hostName);
            }
            ctxParam.rebind("contextRoot", (Object)contextRoot);
            if (earAppName != null) {
                ctxParam.rebind("earAppName", (Object)earAppName);
            }
            ctxParam.rebind("jonasDD", (Object)webDD.getJOnASXmlContent());
            ctxParam.rebind("java2DelegationModel", (Object)new Boolean(java2DelegationModel));
            ctxParam.rebind("permissionManager", (Object)permissionManager);
            ctxParam.rebind("userURI", (Object)userURI);
        }
        catch (NamingException e) {
            String err = "Error when deploying the war  '" + unpackedWarURL.getFile() + "'";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        war.setPermissionManager(permissionManager);
        this.doRegisterWar((Context)ctxParam);
        this.warDeployed.add(war);
        this.warBindings.put(warURL, webClassLoader);
        this.registerWarMBean(war, this.getDomainName(), warURL.getFile());
        if (this.wsService != null && earClassLoader == null) {
            try {
                ComponentContext contctx = null;
                try {
                    contctx = new ComponentContext(unpackedWarURL.getFile());
                    contctx.rebind("classloader", (Object)loaderForCls);
                    contctx.rebind("parentObjectName", ctxParam.lookup("WebModule"));
                    contctx.rebind("isInEar", (Object)Boolean.FALSE);
                }
                catch (NamingException e) {
                    String err = "Can not bind params for the WebServices service, can't complete deployment of Web Services Endpoints";
                    throw new JWebContainerServiceException(err, (Throwable)e);
                }
                this.wsService.completeWSDeployment((Context)contctx);
            }
            catch (ServiceException se) {
                String err = "Error during the deployment of the WebServices of the War file '" + warURL + "'";
                logger.log(BasicLevel.ERROR, (Object)(err + " : " + se.getMessage()));
                throw new JWebContainerServiceException(err, (Throwable)se);
            }
        }
        StringBuffer txtInfo = new StringBuffer("War " + warURL.getFile() + " available at the context ");
        if (!contextRoot.startsWith("/")) {
            txtInfo.append("/");
        }
        txtInfo.append(contextRoot);
        if (hostName != null) {
            txtInfo.append(" on the host ");
            txtInfo.append(hostName);
        }
        txtInfo.append(".");
        logger.log(BasicLevel.INFO, (Object)txtInfo.toString());
        if (this.wsService != null && earClassLoader == null) {
            this.wsService.removeCache((ClassLoader)loaderForCls);
        }
    }

    protected String getContextRoot(String contextRoot, URLClassLoader earClassLoader, URL warURL, WebContainerDeploymentDesc webDD) {
        if (earClassLoader == null && contextRoot == null) {
            String file;
            String cRoot = webDD.getContextRoot();
            contextRoot = cRoot == null ? ((file = new File(warURL.getFile()).getName()).toLowerCase().endsWith(".war") ? file.substring(0, file.length() - WAR_EXTENSION_LENGTH) : file.substring(0, file.length())) : cRoot;
        }
        if (contextRoot.startsWith("/") && !contextRoot.equals("/")) {
            logger.log(BasicLevel.WARN, (Object)("Context-Root '" + contextRoot + "' contains invalid starting / in the name. Fixing it."));
            int c = 0;
            while (contextRoot.charAt(c) == '/') {
                ++c;
            }
            contextRoot = contextRoot.substring(c);
        }
        return contextRoot;
    }

    public void registerWar(String fileName) throws RemoteException, JWebContainerServiceException {
        URL warURL = this.checkWarFile(fileName);
        ComponentContext ctx = null;
        try {
            ctx = new ComponentContext(fileName);
            ctx.rebind("warURL", (Object)warURL);
        }
        catch (NamingException e) {
            String err = "Error when deploying the war  '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        this.registerWar((Context)ctx);
    }

    protected void setWebEnvironment(Context ctxParam, EZBInjectionHolder ezbInjectionHolder, ClassLoader webAppClassLoader) throws JWebContainerServiceException {
        EARDeployable earDeployable;
        ClassLoader parentClassLoader;
        String warName;
        WebContainerDeploymentDesc dd;
        block29: {
            dd = null;
            warName = null;
            parentClassLoader = null;
            earDeployable = null;
            try {
                dd = (WebContainerDeploymentDesc)ctxParam.lookup("DeploymentDesc");
                warName = (String)ctxParam.lookup("warName");
                earDeployable = (EARDeployable)ctxParam.lookup("earDeployable");
            }
            catch (NamingException e) {
                if (earDeployable == null) break block29;
                String err = "Error while getting parameter from context param ";
                logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
                throw new JWebContainerServiceException(err, (Throwable)e);
            }
        }
        try {
            parentClassLoader = (ClassLoader)ctxParam.lookup("parentCL");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param ";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        try {
            String unitName;
            String encName;
            LinkRef lref;
            String resname;
            Context javaCtx = this.contextFactory.createComponentContext(warName);
            this.naming.setComponentContext(javaCtx, parentClassLoader);
            Context envCtx = javaCtx.createSubcontext("comp/env");
            IEnvEntryDesc[] envt = dd.getEnvEntryDesc();
            for (int i = 0; i < envt.length; ++i) {
                String name = envt[i].getName();
                Object obj = envt[i].getValue();
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(warName + ": Binding object " + name + " -> " + obj));
                }
                envCtx.rebind(name, obj);
            }
            IResourceRefDesc[] resref = dd.getResourceRefDesc();
            for (int i = 0; i < resref.length; ++i) {
                String name = resref[i].getName();
                String type = resref[i].getTypeName();
                resname = resref[i].getJndiName();
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(warName + ": Linking resource " + name + " -> " + resname));
                }
                if (type.equalsIgnoreCase("java.net.URL")) {
                    Reference ref = new Reference("java.net.URL", "org.ow2.jonas.lib.naming.URLFactory", null);
                    StringRefAddr refAddr = new StringRefAddr("url", resname);
                    ref.add(refAddr);
                    envCtx.rebind(name, (Object)ref);
                    continue;
                }
                lref = new LinkRef(resname);
                envCtx.rebind(name, (Object)lref);
            }
            IResourceEnvRefDesc[] resEnvref = dd.getResourceEnvRefDesc();
            for (int i = 0; i < resEnvref.length; ++i) {
                String name = resEnvref[i].getName();
                resname = resEnvref[i].getJndiName();
                lref = new LinkRef(resname);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(warName + ": Linking resource environment " + name + " -> " + resname));
                }
                envCtx.rebind(name, (Object)lref);
            }
            EjbRefDesc[] ejbref = dd.getEjbRefDesc();
            for (int i = 0; i < ejbref.length; ++i) {
                String name = ejbref[i].getEjbRefName();
                String ejbname = null;
                ejbname = ejbref[i].getJndiName();
                LinkRef lref2 = new LinkRef(ejbname);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(warName + ": Linking ejb " + name + " -> " + ejbname));
                }
                envCtx.rebind(name, (Object)lref2);
            }
            EjbLocalRefDesc[] ejblocalref = dd.getEjbLocalRefDesc();
            for (int i = 0; i < ejblocalref.length; ++i) {
                String name = ejblocalref[i].getEjbRefName();
                String ejbname = ejblocalref[i].getJndiLocalName();
                LinkRef lref3 = new LinkRef(ejbname);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(warName + ": Linking ejb " + name + " -> " + ejbname));
                }
                envCtx.rebind(name, (Object)lref3);
            }
            MessageDestinationRefDesc[] mdref = dd.getMessageDestinationRefDesc();
            for (int i = 0; i < mdref.length; ++i) {
                String name = mdref[i].getMessageDestinationRefName();
                String mdname = null;
                mdname = mdref[i].getJndiName();
                LinkRef lref4 = new LinkRef(mdname);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(warName + ": Linking message-destination " + name + " -> " + mdname));
                }
                envCtx.rebind(name, (Object)lref4);
            }
            if (this.wsService != null) {
                IServiceRefDesc[] serviceRefs = dd.getServiceRefDesc();
                for (int i = 0; i < serviceRefs.length; ++i) {
                    String name = serviceRefs[i].getServiceRefName();
                    Reference ref = this.wsService.buildServiceRef(serviceRefs[i], parentClassLoader);
                    envCtx.rebind(name, (Object)ref);
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("Adding service-ref 'java:comp/env/" + name + "'"));
                }
            }
            EZBENCBindingHolder encBindingHolder = dd.getENCBindingHolder();
            EZBPersistenceUnitManager persistenceUnitManager = ezbInjectionHolder.getPersistenceUnitManager();
            for (IBinding binding : encBindingHolder.getPersistenceContextBindings()) {
                encName = binding.getName();
                unitName = ((IJavaxPersistenceContext)binding.getValue()).getUnitName();
                PersistenceContextType type = ((IJavaxPersistenceContext)binding.getValue()).getType();
                EntityManager em = persistenceUnitManager.getEntityManager(unitName, type);
                envCtx.rebind(encName, (Object)em);
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Adding persistence-context 'java:comp/env/" + encName + "'"));
            }
            for (IBinding binding : encBindingHolder.getPersistenceUnitBindings()) {
                encName = binding.getName();
                unitName = ((IJavaxPersistenceUnit)binding.getValue()).getUnitName();
                EntityManagerFactory emf = persistenceUnitManager.getEntityManagerFactory(unitName);
                envCtx.rebind(encName, (Object)emf);
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Adding persistence-unit 'java:comp/env/" + encName + "'"));
            }
            EZBJNDIResolver jndiResolver = ezbInjectionHolder.getJNDIResolver();
            if (jndiResolver != null) {
                for (IBinding binding : encBindingHolder.getEJBBindings()) {
                    String encName2 = binding.getName();
                    IJEjbEJB jEjbEJB = (IJEjbEJB)binding.getValue();
                    String interfaceName = jEjbEJB.getBeanInterface();
                    String beanName = jEjbEJB.getBeanName();
                    try {
                        String jndiName = jndiResolver.getUniqueName(interfaceName, beanName);
                        envCtx.rebind(encName2, (Object)new LinkRef(jndiName));
                        if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                        logger.log(BasicLevel.DEBUG, (Object)("Adding ejb 'java:comp/env/" + encName2 + "' from JNDIName '" + jndiName + "'."));
                    }
                    catch (EZBJNDIResolverException e) {
                        logger.log(BasicLevel.ERROR, (Object)("Cannot get JNDI name for enc name '" + encName2 + "'"), (Throwable)e);
                    }
                }
            }
            if (earDeployable != null && this.isVersioningEnabled()) {
                envCtx.rebind("JNDILookupPrefix", (Object)this.versioningService.getPrefix((IDeployable)earDeployable));
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"Adding JNDI-lookup-prefix 'java:comp/env/JNDILookupPrefix'");
                }
            }
        }
        catch (NamingException e) {
            String err = "Error while populating environment of the war file " + warName;
            logger.log(BasicLevel.ERROR, (Object)(err + "  :" + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
    }

    protected void unRegisterWar(Context ctx) throws JWebContainerServiceException {
        URL warURL = null;
        boolean isEarCase = true;
        try {
            warURL = (URL)ctx.lookup("warURL");
            isEarCase = (Boolean)ctx.lookup("isEarCase");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param.";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        String fileName = warURL.getFile();
        War war = null;
        war = this.getWar(warURL);
        if (war == null) {
            String err = "Cannot undeploy war: '" + fileName + "' is not deployed.";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new JWebContainerServiceException(err);
        }
        if (isEarCase != war.isInEarCase()) {
            String err = "Cannot undeploy war: '" + fileName + "' it is in an ear application. You must undeploy the ear associated.";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new JWebContainerServiceException(err);
        }
        try {
            String hostName = war.getHostName();
            if (hostName != null) {
                ctx.rebind("hostName", (Object)war.getHostName());
            }
            ctx.rebind("contextRoot", (Object)war.getContextRoot());
            ctx.rebind("webClassLoader", this.warBindings.get(warURL));
        }
        catch (NamingException e) {
            String err = "Error when undeploying the war  '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        PermissionManager permissionManager = war.getPermissionManager();
        try {
            permissionManager.delete();
            permissionManager = null;
        }
        catch (PermissionManagerException pme) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot remove permission manager for file '" + fileName + "'."), (Throwable)pme);
        }
        this.doUnRegisterWar(ctx);
        if (this.wsService != null) {
            this.wsService.undeployWebServices(ctx);
        }
        URLClassLoader loader = (URLClassLoader)this.warBindings.remove(warURL);
        this.naming.unSetComponentContext((ClassLoader)loader);
        this.warLoaders.remove(warURL);
        this.warDeployed.remove(war);
        this.unregisterWarMBean(this.getDomainName(), fileName);
        logger.log(BasicLevel.INFO, (Object)("War " + fileName + " no longer available"));
    }

    public void unRegisterWar(String fileName) throws RemoteException, JWebContainerServiceException {
        URL warURL = this.checkWarDeployed(fileName);
        ComponentContext ctx = null;
        try {
            ctx = new ComponentContext(fileName);
            ctx.rebind("warURL", (Object)warURL);
            ctx.rebind("isEarCase", (Object)new Boolean(false));
        }
        catch (NamingException e) {
            String err = "Error when undeploying the war file '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        this.unRegisterWar((Context)ctx);
    }

    public void deployWars(Context ctx) throws JWebContainerServiceException {
        URL[] urls = null;
        URL earURL = null;
        EARDeployable earDeployable = null;
        ClassLoader parentClassLoader = null;
        ClassLoader earClassLoader = null;
        URL[] altDDs = null;
        String[] contextRoots = null;
        EZBInjectionHolder ejbInjectionHolder = null;
        try {
            urls = (URL[])ctx.lookup("urls");
            earURL = (URL)ctx.lookup("earURL");
            earDeployable = (EARDeployable)ctx.lookup("earDeployable");
            parentClassLoader = (ClassLoader)ctx.lookup("parentClassLoader");
            earClassLoader = (ClassLoader)ctx.lookup("earClassLoader");
            altDDs = (URL[])ctx.lookup("altDDs");
            contextRoots = (String[])ctx.lookup("contextRoots");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param ";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        try {
            ejbInjectionHolder = (EZBInjectionHolder)ctx.lookup(EZBInjectionHolder.class.getName());
        }
        catch (NamingException e) {
            logger.log(BasicLevel.DEBUG, (Object)"No persistence unit manager");
        }
        for (int i = 0; i < urls.length; ++i) {
            String fileName = URLUtils.urlToFile((URL)urls[i]).getPath();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Deploy war '" + fileName + "' for the ear service"));
            }
            ComponentContext contctx = null;
            try {
                contctx = new ComponentContext(fileName);
                contctx.rebind("warURL", (Object)urls[i]);
                contctx.rebind("parentClassLoader", (Object)parentClassLoader);
                contctx.rebind("earClassLoader", (Object)earClassLoader);
                contctx.rebind("earDeployable", (Object)earDeployable);
                contctx.rebind("earURL", (Object)earURL);
                if (altDDs[i] != null) {
                    contctx.rebind("altDD", (Object)altDDs[i]);
                }
                if (contextRoots[i] != null) {
                    contctx.rebind("contextRoot", (Object)contextRoots[i]);
                }
                if (ejbInjectionHolder != null) {
                    contctx.rebind(EZBInjectionHolder.class.getName(), (Object)ejbInjectionHolder);
                }
                this.registerWar((Context)contctx);
                continue;
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Error when deploying '" + fileName + "'"));
                logger.log(BasicLevel.ERROR, (Object)e.getMessage());
                logger.log(BasicLevel.ERROR, (Object)"Undeploy war of the ear application");
                for (int j = 0; j < i; ++j) {
                    String warFileName = urls[j].getFile();
                    try {
                        ComponentContext context = new ComponentContext(warFileName);
                        context.rebind("warURL", (Object)urls[j]);
                        context.rebind("isEarCase", (Object)new Boolean(true));
                        this.unRegisterWar((Context)context);
                        continue;
                    }
                    catch (Exception ex) {
                        logger.log(BasicLevel.ERROR, (Object)("Error when undeploying '" + warFileName + "'"));
                        logger.log(BasicLevel.ERROR, (Object)ex.getMessage());
                        logger.log(BasicLevel.ERROR, (Object)"Cannot undeploy war of the ear application");
                    }
                }
                throw new JWebContainerServiceException("Error during the deployment", (Throwable)e);
            }
        }
    }

    public void unDeployWars(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            String warFileName = urls[i].getFile();
            try {
                ComponentContext context = new ComponentContext(warFileName);
                context.rebind("warURL", (Object)urls[i]);
                context.rebind("isEarCase", (Object)new Boolean(true));
                this.unRegisterWar((Context)context);
                continue;
            }
            catch (Exception ex) {
                logger.log(BasicLevel.ERROR, (Object)("Error when undeploying '" + warFileName + "'"));
                logger.log(BasicLevel.ERROR, (Object)ex.getMessage());
                logger.log(BasicLevel.ERROR, (Object)"Cannot undeploy war of the ear application");
            }
        }
    }

    public War getWar(URL url) {
        for (War war : this.warDeployed) {
            if (!war.getWarURL().equals(url)) continue;
            return war;
        }
        return null;
    }

    protected List getWar(String pContext) {
        ArrayList<War> checkDeployed = new ArrayList<War>();
        for (War war : this.warDeployed) {
            if (!war.getContextRoot().equals(pContext)) continue;
            checkDeployed.add(war);
        }
        return checkDeployed;
    }

    public void removeCache(ClassLoader earClassLoader) {
        WebDeploymentDescManager.getInstance().removeCache(earClassLoader);
    }

    protected URL checkWarFile(String fileName) throws JWebContainerServiceException {
        File f = null;
        try {
            f = new File(fileName).getCanonicalFile();
            if (!f.exists()) {
                boolean found = false;
            }
        }
        catch (IOException e) {
            String err = "Invalid war file name '" + fileName;
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        URL warURL = null;
        try {
            warURL = f.toURL();
        }
        catch (MalformedURLException e) {
            String err = "Invalid war file name '" + fileName + "'.";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        return warURL;
    }

    protected URL checkWarDeployed(String fileName) throws JWebContainerServiceException {
        URL url = null;
        try {
            for (War war : this.warDeployed) {
                url = new File(fileName).getCanonicalFile().toURL();
                URL deployedWarURL = war.getWarURL();
                String deployedWarPath = deployedWarURL.toString();
                if (deployedWarPath.endsWith(File.separator)) {
                    deployedWarPath = deployedWarPath.substring(0, deployedWarPath.length() - 1);
                }
                if (!deployedWarPath.equals(url.toString())) continue;
                return deployedWarURL;
            }
            String err = "Cannot undeploy war: '" + fileName + "' is not deployed.";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new JWebContainerServiceException(err);
        }
        catch (MalformedURLException e) {
            String err = "Invalid war file name '" + fileName + "'.";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        catch (IOException e) {
            String err = "Invalid war file name '" + fileName;
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
    }

    @Override
    public Integer getCurrentNumberOfWars() {
        return new Integer(this.warDeployed.size());
    }

    @Override
    public boolean isWarLoaded(String fileName) {
        boolean isLoaded;
        block5: {
            URL url = null;
            isLoaded = false;
            try {
                try {
                    url = new File(fileName).getCanonicalFile().toURL();
                    if (this.getWar(url) != null) {
                        isLoaded = true;
                        break block5;
                    }
                    url = null;
                }
                catch (Exception e) {
                    url = null;
                }
            }
            catch (Exception e) {
                String err = "Can not found if the war is deployed or not";
                logger.log(BasicLevel.ERROR, (Object)err);
                return false;
            }
        }
        return isLoaded;
    }

    @Override
    public List<String> getDeployedWars() {
        ArrayList<String> al = new ArrayList<String>();
        for (War war : this.warDeployed) {
            URL warURL = war.getWarURL();
            al.add(warURL.getFile());
        }
        return al;
    }

    @Override
    public String getServerName() {
        if (this.serverName == null) {
            this.updateServerInfos();
        }
        return this.serverName;
    }

    @Override
    public String getServerVersion() {
        if (this.serverVersion == null) {
            this.updateServerInfos();
        }
        return this.serverVersion;
    }

    protected abstract void updateServerInfos();

    public abstract String getDefaultHost() throws JWebContainerServiceException;

    public abstract String getDefaultHttpPort() throws JWebContainerServiceException;

    public abstract String getDefaultHttpsPort() throws JWebContainerServiceException;

    protected static Logger getLogger() {
        return logger;
    }

    protected JNamingManager getNaming() {
        return this.naming;
    }

    protected void setServerName(String serverName) {
        this.serverName = serverName;
    }

    protected void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    protected JComponentContextFactory getContextFactory() {
        return this.contextFactory;
    }

    protected void registerWebServiceMBean(Object service, String domainName) {
        ObjectName on = JonasObjectName.webContainerService((String)domainName);
        this.jmxService.registerMBean(service, on);
    }

    protected void unregisterWebServiceMBean(String domainName) {
        ObjectName on = JonasObjectName.webContainerService((String)domainName);
        this.jmxService.unregisterMBean(on);
    }

    protected void registerWarMBean(War war, String domainName, String fileName) {
        try {
            ObjectName on = JonasObjectName.war((String)domainName, (String)fileName);
            this.jmxService.registerMBean((Object)war, on);
        }
        catch (MalformedObjectNameException e) {
            logger.log(BasicLevel.WARN, (Object)"Could not register War MBean", (Throwable)e);
        }
    }

    protected void unregisterWarMBean(String domainName, String fileName) {
        try {
            ObjectName on = JonasObjectName.war((String)domainName, (String)fileName);
            this.jmxService.unregisterMBean(on);
        }
        catch (MalformedObjectNameException e) {
            logger.log(BasicLevel.WARN, (Object)"Could not unregister War MBean", (Throwable)e);
        }
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setWsService(WebServicesService wsService) {
        this.wsService = wsService;
    }

    public void setNaming(JNamingManager naming) {
        this.naming = naming;
    }

    public void setContextFactory(JComponentContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    protected Hashtable getWarLoaders() {
        return this.warLoaders;
    }

    protected Hashtable getWarBindings() {
        return this.warBindings;
    }

    protected List getWarDeployed() {
        return this.warDeployed;
    }

    protected WebServicesService getWsService() {
        return this.wsService;
    }

    protected ClassLoader getAppsClassLoader() {
        return this.extClassLoader;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public void unsetVersioningService() {
        this.versioningService = null;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public boolean isVersioningEnabled() {
        return this.versioningService != null && this.versioningService.isVersioningEnabled();
    }

    public void setWarDeployableMetadataFactory(IWarDeployableMetadataFactory warDeployableMetadataFactory) {
        WarDeployableMetadataFactoryHolder.setWarDeployableMetadataFactory((IWarDeployableMetadataFactory)warDeployableMetadataFactory);
    }

    public class WebLoaderHolder {
        private URLClassLoader jonasWebLoader;
        private ClassLoader envWebLoader;

        public WebLoaderHolder(URLClassLoader jonas, ClassLoader env) {
            this.jonasWebLoader = jonas;
            this.envWebLoader = env;
        }

        public URLClassLoader getJonasWebLoader() {
            return this.jonasWebLoader;
        }

        public ClassLoader getEnvWebLoader() {
            return this.envWebLoader;
        }

        public void setEnvWebLoader(ClassLoader envWebLoader) {
            this.envWebLoader = envWebLoader;
        }

        public void setJonasWebLoader(URLClassLoader jonasWebLoader) {
            this.jonasWebLoader = jonasWebLoader;
        }
    }
}

