/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.javaee;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jonas.jmx.JManagementIdentifier;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSR77ManagementIdentifier<T>
implements JManagementIdentifier<T> {
    private static final String DEFAULT_DOMAIN_NAME = "";
    private static Log logger = LogFactory.getLog(JSR77ManagementIdentifier.class);
    private String domainName = null;
    private String serverName = null;

    protected JSR77ManagementIdentifier() {
    }

    protected static String getInheritedPropertiesAsString(ObjectName name) {
        Hashtable table = (Hashtable)name.getKeyPropertyList().clone();
        table.remove("j2eeType");
        table.remove("type");
        table.remove("subtype");
        table.remove("name");
        StringBuffer sb = new StringBuffer();
        for (String key : table.keySet()) {
            sb.append(key + "=" + table.get(key) + ",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    protected static String getParentNameProperty(String parentObjectName) {
        ObjectName on = null;
        try {
            on = ObjectName.getInstance(parentObjectName);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)"Cannot get objectname on {0}", new Object[]{parentObjectName, e});
            return DEFAULT_DOMAIN_NAME;
        }
        catch (NullPointerException e) {
            logger.error((Object)"Cannot get objectname on {0}", new Object[]{parentObjectName, e});
            return DEFAULT_DOMAIN_NAME;
        }
        String type = on.getKeyProperty("j2eeType");
        String name = on.getKeyProperty("name");
        return type + "=" + name;
    }

    public String getDomain() {
        if (this.domainName == null) {
            return DEFAULT_DOMAIN_NAME;
        }
        return this.domainName;
    }

    public void setDomain(String domainName) {
        this.domainName = domainName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getTypeName() {
        return "j2eeType";
    }

    public String getTypeProperty() {
        return this.getTypeName() + "=" + this.getTypeValue();
    }

    public static final Log getLogger() {
        return logger;
    }

    protected String getJ2EEServerString() {
        return "J2EEServer=" + this.serverName;
    }
}

