/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jmbeans;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.depmonitor.MonitoringService;
import org.ow2.jonas.generators.wsgen.wrapper.WsGenWrapper;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.jmbeans.J2EEDeployedObject;
import org.ow2.jonas.lib.jmbeans.J2EEManagedObject;
import org.ow2.jonas.lib.jmbeans.J2EEResource;
import org.ow2.jonas.lib.jmbeans.ServiceManager;
import org.ow2.jonas.lib.jmbeans.ServiceState;
import org.ow2.jonas.lib.jmbeans.monitoring.MemoryMonitoring;
import org.ow2.jonas.lib.management.javaee.J2EEState;
import org.ow2.jonas.lib.timer.TimerManager;
import org.ow2.jonas.lib.util.JModule;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.api.IArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2EEServer
extends J2EEManagedObject
implements NotificationListener,
MBeanRegistration {
    private Log logger = LogFactory.getLog(J2EEServer.class);
    private long sequenceNumber = 0L;
    private MBeanServer mbeanServer = null;
    private J2EEState serverState;
    private long startTime;
    private String serverVendor = null;
    private String serverVersion = null;
    private String serverName = null;
    private String domainName = null;
    private String jonasBase = null;
    private String jonasRoot = null;
    private String protocols = null;
    private String versions = null;
    private ServerProperties serverProperties = null;
    private MemoryMonitoring monitor = null;
    private IDeployerManager deployerManager = null;
    private IArchiveManager archiveManager = null;
    private ConfigurationManager configManager = null;
    private ArrayList<String> javaVMs = new ArrayList();
    private ArrayList<String> resources = null;
    private ArrayList<String> deployedObjects = null;
    private VersioningService versioningService;
    private static final String JONAS_BOOTSTRAP = "jonas.bootstrap";
    private BundleContext bc = null;
    private String[] eventTypes;
    private ArrayList<String> repositoryDirs = null;
    private ServiceManager serviceManager = null;
    private ArrayList<String> services = null;

    public J2EEServer(String objectName) {
        super(objectName);
    }

    public J2EEServer(String objectName, boolean stateManageable, boolean statisticsProvider, boolean eventProvider, BundleContext bc) {
        super(objectName, stateManageable, statisticsProvider, eventProvider);
        this.services = new ArrayList();
        if (eventProvider) {
            this.eventTypes = new String[J2EEState.values().length];
            for (J2EEState state : J2EEState.values()) {
                this.eventTypes[state.ordinal()] = state.getName();
            }
        }
        if (stateManageable) {
            Date d = new Date();
            this.startTime = d.getTime();
        }
        this.resources = new ArrayList();
        this.deployedObjects = new ArrayList();
        this.monitor = new MemoryMonitoring();
        this.bc = bc;
    }

    public String[] getEventTypes() {
        return this.eventTypes;
    }

    public J2EEState getState() {
        return this.serverState;
    }

    public boolean isStarting() {
        return this.serverState.equals((Object)J2EEState.STARTING);
    }

    public boolean isRunning() {
        return this.serverState.equals((Object)J2EEState.RUNNING);
    }

    public boolean isFailed() {
        return this.serverState.equals((Object)J2EEState.FAILED);
    }

    public boolean isStopping() {
        return this.serverState.equals((Object)J2EEState.STOPPING);
    }

    public boolean isStopped() {
        return this.serverState.equals((Object)J2EEState.STOPPED);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getServerVendor() {
        return this.serverVendor;
    }

    public void setServerVendor(String serverVendor) {
        this.serverVendor = serverVendor;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getJonasBase() {
        return this.jonasBase;
    }

    public void setJonasBase(String jonasBase) {
        this.jonasBase = jonasBase;
    }

    public String getJonasRoot() {
        return this.jonasRoot;
    }

    public void setJonasRoot(String jonasRoot) {
        this.jonasRoot = jonasRoot;
    }

    public String getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String protocols) {
        this.protocols = protocols;
    }

    public String getVersions() {
        return this.versions;
    }

    public void setVersions(String versions) {
        this.versions = versions;
    }

    public boolean isActivated() {
        return this.monitor.getActivated();
    }

    public void setActivated(boolean activated) {
        this.monitor.setActivated(activated);
    }

    public long getCurrentUsedMemory() {
        return this.monitor.usedMemory();
    }

    public long getCurrentTotalMemory() {
        return this.monitor.totalMemory();
    }

    public int getRange() {
        return this.monitor.getRange();
    }

    public void setRange(int range) {
        this.monitor.setRange(range);
    }

    public int getSizeTableMeasures() {
        return this.monitor.getSizeTableMeasures();
    }

    public void setSizeTableMeasures(int sizeTableMeasures) {
        this.monitor.setSizeTableMeasures(sizeTableMeasures);
    }

    public Long[] getTableMeasures() {
        return this.monitor.getTableMeasures();
    }

    public ArrayList<String> getResources() {
        return this.resources;
    }

    public ArrayList<String> getDeployedObjects() {
        return this.deployedObjects;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String[] getJavaVMs() {
        String[] result = new String[this.javaVMs.size()];
        int i = 0;
        for (String name : this.javaVMs) {
            result[i++] = name;
        }
        return result;
    }

    public void addJavaVM(String objectName) {
        this.javaVMs.add(objectName);
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public void unsetVersioningService() {
        this.versioningService = null;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public void start() throws Exception {
        if (!this.serverState.equals((Object)J2EEState.STOPPED) && !this.serverState.equals((Object)J2EEState.FAILED)) {
            throw new IllegalStateException("The start() operation can be invoked only when the server is in STOPPED or FAILED state");
        }
        this.setStarting();
        this.configManager.updateServiceConfigurations();
    }

    public void startRecursive() throws Exception {
        if (!this.serverState.equals((Object)J2EEState.STOPPED) && !this.serverState.equals((Object)J2EEState.FAILED)) {
            throw new IllegalStateException("The startRecursive() operation can be invoked only when the server is in STOPPED or FAILED state");
        }
        this.setStarting();
        this.configManager.updateServiceConfigurations();
    }

    public void stop() throws Exception {
        if (!(this.serverState.equals((Object)J2EEState.RUNNING) || this.serverState.equals((Object)J2EEState.STARTING) || this.serverState.equals((Object)J2EEState.FAILED))) {
            throw new IllegalStateException("The stop() operation can be invoked only when the server is in RUNNING, STARTING or FAILED state");
        }
        this.setStopping();
        this.configManager.deleteServiceConfigurations();
    }

    public void halt() throws Exception {
        this.configManager.haltServer();
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            ObjectName causeOn = ((MBeanServerNotification)notification).getMBeanName();
            String type = causeOn.getKeyProperty("j2eeType");
            if (J2EEResource.isJ2eeResourceType(type)) {
                this.handleResourceNotification(causeOn, notification.getType());
            }
            if (J2EEDeployedObject.isJ2EEDeployedObjectType(type)) {
                this.handleDeployedNotification(causeOn, notification.getType());
            }
        }
        if (notification instanceof AttributeChangeNotification) {
            String attName = ((AttributeChangeNotification)notification).getAttributeName();
            this.logger.debug((Object)("Received AttributeChangeNotification about attribute " + attName), new Object[0]);
            if ("readyToRunning".equals(attName)) {
                this.setRunning();
            }
        }
    }

    private void handleResourceNotification(ObjectName resourceOn, String notificationType) {
        if (notificationType.equals("JMX.mbean.registered")) {
            this.addResource(resourceOn.toString());
        } else if (notificationType.equals("JMX.mbean.unregistered")) {
            this.removeResource(resourceOn.toString());
        }
    }

    private void handleDeployedNotification(ObjectName resourceOn, String notificationType) {
        if (notificationType.equals("JMX.mbean.registered")) {
            this.addDeployedObject(resourceOn.toString());
        } else if (notificationType.equals("JMX.mbean.unregistered")) {
            this.removeDeployedObject(resourceOn.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResource(String name) {
        ArrayList<String> arrayList = this.resources;
        synchronized (arrayList) {
            if (!this.resources.contains(name)) {
                this.resources.add(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeployedObject(String name) {
        ArrayList<String> arrayList = this.deployedObjects;
        synchronized (arrayList) {
            if (!this.deployedObjects.contains(name)) {
                this.deployedObjects.add(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeResource(String name) {
        ArrayList<String> arrayList = this.resources;
        synchronized (arrayList) {
            int index = this.resources.indexOf(name);
            if (index > -1) {
                this.resources.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeployedObject(String name) {
        ArrayList<String> arrayList = this.deployedObjects;
        synchronized (arrayList) {
            int index = this.deployedObjects.indexOf(name);
            if (index > -1) {
                this.deployedObjects.remove(index);
            }
        }
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            return;
        }
        try {
            ObjectName on = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
            this.mbeanServer.addNotificationListener(on, this, null, null);
        }
        catch (JMException me) {
            me.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        if (Boolean.getBoolean(JONAS_BOOTSTRAP)) {
            this.setStopped();
        } else {
            this.setStarting();
        }
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbeanServer = server;
        if (name == null) {
            return ObjectName.getInstance(this.getObjectName());
        }
        return name;
    }

    protected void setServicesRunning() {
        ServiceReference reference = this.bc.getServiceReference(MonitoringService.class.getName());
        if (reference == null) {
            this.setRunning();
        } else {
            this.setDepmonitoringRunning(reference);
        }
    }

    protected void setDepmonitoringRunning(ServiceReference reference) {
        ServiceReference depMonitoringReference = reference;
        if (depMonitoringReference == null) {
            depMonitoringReference = this.bc.getServiceReference(MonitoringService.class.getName());
        }
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        filter.enableAttribute("readyToRunning");
        try {
            this.mbeanServer.addNotificationListener(JonasObjectName.deployableMonitorService((String)this.domainName), this, (NotificationFilter)filter, null);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        MonitoringService monitoringService = (MonitoringService)this.bc.getService(depMonitoringReference);
        monitoringService.startMonitoring();
    }

    private void info(String state) {
        this.logger.info((Object)"JOnAS server ''{0}'' {1}", new Object[]{this.serverName, state});
    }

    protected void setStarting() {
        this.serverState = J2EEState.STARTING;
        Notification notif = new Notification(this.serverState.getName(), this.getObjectName(), this.sequenceNumber++);
        this.sendNotification(notif);
        this.info("STARTING");
    }

    protected void setRunning() {
        this.serverState = J2EEState.RUNNING;
        Notification notif = new Notification(this.serverState.getName(), this.getObjectName(), this.sequenceNumber++);
        this.sendNotification(notif);
        this.info("RUNNING");
    }

    protected void setStopping() {
        this.serverState = J2EEState.STOPPING;
        Notification notif = new Notification(this.serverState.getName(), this.getObjectName(), this.sequenceNumber++);
        this.sendNotification(notif);
        this.info("STOPPING");
    }

    protected void setStopped() {
        this.serverState = J2EEState.STOPPED;
        Notification notif = new Notification(this.serverState.getName(), this.getObjectName(), this.sequenceNumber++);
        this.sendNotification(notif);
        this.info("STOPPED");
    }

    protected void setFailed() {
        this.serverState = J2EEState.FAILED;
        Notification notif = new Notification(this.serverState.getName(), this.getObjectName(), this.sequenceNumber++);
        this.sendNotification(notif);
        this.info("FAILED");
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public void setArchiveManager(IArchiveManager archiveManager) {
        this.archiveManager = archiveManager;
    }

    public void deploy(String fileName) {
        this.logger.debug((Object)"Deploying ", new Object[]{fileName});
        File f = new File(fileName);
        if (!f.isAbsolute()) {
            throw new RuntimeException("The given filename '" + fileName + "' is not an absolute file.");
        }
        final IDeployable deployable = this.getDeployable(fileName);
        IExecution<Void> exec = new IExecution<Void>(){

            public Void execute() throws RuntimeException {
                try {
                    J2EEServer.this.deployerManager.deploy(deployable);
                }
                catch (Exception e) {
                    J2EEServer.this.logger.error((Object)"Cannot deploy the deployable ", new Object[]{deployable, e});
                    throw new RuntimeException("Cannot deploy the deployable '" + deployable + "' : " + e.getMessage());
                }
                return null;
            }
        };
        ExecutionResult result = RunnableHelper.execute((ClassLoader)this.getClass().getClassLoader(), (IExecution)exec);
        if (result.hasException()) {
            throw new RuntimeException(result.getException());
        }
    }

    public void undeploy(String fileName) {
        this.logger.debug((Object)"Undeploying ", new Object[]{fileName});
        final IDeployable deployable = this.getDeployable(fileName);
        IExecution<Void> exec = new IExecution<Void>(){

            public Void execute() throws RuntimeException {
                try {
                    J2EEServer.this.deployerManager.undeploy(deployable);
                    J2EEServer.this.runGC();
                }
                catch (Exception e) {
                    J2EEServer.this.logger.error((Object)"Cannot undeploy the deployable ", new Object[]{deployable, e});
                    throw new RuntimeException("Cannot undeploy the deployable '" + deployable + "' : " + e.getMessage());
                }
                return null;
            }
        };
        ExecutionResult result = RunnableHelper.execute((ClassLoader)this.getClass().getClassLoader(), (IExecution)exec);
        if (result.hasException()) {
            throw new RuntimeException(result.getException());
        }
    }

    protected IDeployable getDeployable(String fileName) {
        IDeployable deployable = null;
        File file = new File(fileName);
        if (!file.exists()) {
            throw new RuntimeException("The file '" + fileName + "' is not present on the filesystem.");
        }
        IArchive archive = this.archiveManager.getArchive((Object)file);
        if (archive == null) {
            this.logger.error((Object)"No archive found for the invalid file ", new Object[]{file});
            throw new RuntimeException("No archive found for the invalid file '" + file + "'.");
        }
        try {
            deployable = DeployableHelper.getDeployable((IArchive)archive);
        }
        catch (DeployableHelperException e) {
            this.logger.error((Object)"Cannot get a deployable for the archive ", new Object[]{archive, e});
            throw new RuntimeException("Cannot get a deployable for the archive '" + archive + "' : " + e.getMessage());
        }
        return deployable;
    }

    public boolean isDeployed(String fileName) throws Exception {
        File file = new File(fileName);
        if (file.exists()) {
            try {
                return this.isDeployedFile(file.toURL());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return false;
    }

    public String getJvmInfos() {
        StringBuffer sb = new StringBuffer();
        sb.append("JVM used is ");
        sb.append(System.getProperty("java.version"));
        sb.append(" version of ");
        sb.append(System.getProperty("java.vm.name"));
        sb.append("-");
        sb.append(System.getProperty("java.vm.version"));
        sb.append("/");
        sb.append(System.getProperty("java.vendor"));
        sb.append(" vendor on ");
        sb.append(System.getProperty("os.name"));
        sb.append(" ");
        sb.append(System.getProperty("os.version"));
        sb.append("/");
        sb.append(System.getProperty("os.arch"));
        sb.append(" OS.");
        return sb.toString();
    }

    public void runGC() throws RemoteException {
        Runtime.getRuntime().gc();
    }

    public Properties getConfigFileEnv() {
        return this.serverProperties.getConfigFileEnv();
    }

    public void setConfigManager(ConfigurationManager configManager) {
        this.configManager = configManager;
    }

    public TimerManager getTimerManager() {
        return this.monitor.getTimerManager();
    }

    public void setTimerManager(TimerManager timerManager) {
        this.monitor.setTimerManager(timerManager);
    }

    public void setAllProperties(ServerProperties allProperties) {
        this.serverProperties = allProperties;
    }

    public void initRepositoryDirs() {
        this.repositoryDirs = new ArrayList();
        String deployDir = this.jonasBase + File.separator + "deploy";
        this.repositoryDirs.add(deployDir);
    }

    public void setDirectories(String dirs) {
        ArrayList<String> additionalDirectories = this.convertToList(dirs);
        Iterator<String> i$ = additionalDirectories.iterator();
        while (i$.hasNext()) {
            String dir;
            String dirName = dir = i$.next();
            File tmpFile = new File(dir);
            if (!tmpFile.isAbsolute()) {
                dirName = this.jonasBase + File.separator + dir;
                tmpFile = new File(dirName);
            }
            if (!tmpFile.exists()) continue;
            this.repositoryDirs.add(dirName);
        }
    }

    private ArrayList<String> convertToList(String value) {
        String[] values = value.split(",");
        ArrayList<String> injection = new ArrayList<String>();
        if (values.length != 1 || !"".equals(values[0])) {
            for (int i = 0; i < values.length; ++i) {
                String part = values[i];
                injection.add(part.trim());
            }
        }
        return injection;
    }

    private ArrayList<URL> getInstalledFiles() throws MalformedURLException, IOException {
        ArrayList<URL> al = this.getInstalledWars();
        ArrayList<URL> al1 = this.getInstalledJars();
        for (URL url : al1) {
            al.add(url);
        }
        al1 = this.getInstalledRars();
        for (URL url : al1) {
            al.add(url);
        }
        al1 = this.getInstalledEars();
        for (URL url : al1) {
            al.add(url);
        }
        return al;
    }

    private ArrayList<URL> getInstalledJars() throws MalformedURLException, IOException {
        ArrayList<URL> al = new ArrayList<URL>();
        ArrayList al1 = null;
        for (String dir : this.repositoryDirs) {
            al1 = JModule.getInstalledFileInDir((String)dir, (String)"jar");
            for (URL url : al1) {
                al.add(url);
            }
        }
        return al;
    }

    private ArrayList<URL> getInstalledWars() throws MalformedURLException, IOException {
        ArrayList<URL> al = new ArrayList<URL>();
        String extension = "war";
        ArrayList al1 = null;
        for (String dir : this.repositoryDirs) {
            al1 = JModule.getInstalledFileInDir((String)dir, (String)extension);
            for (URL url : al1) {
                al.add(url);
            }
        }
        return al;
    }

    private ArrayList<URL> getInstalledRars() throws MalformedURLException, IOException {
        ArrayList<URL> al = new ArrayList<URL>();
        String extension = "rar";
        ArrayList al1 = null;
        for (String dir : this.repositoryDirs) {
            al1 = JModule.getInstalledFileInDir((String)dir, (String)extension);
            for (URL url : al1) {
                al.add(url);
            }
        }
        return al;
    }

    private ArrayList<URL> getInstalledEars() throws MalformedURLException, IOException {
        ArrayList<URL> al = new ArrayList<URL>();
        String extension = "ear";
        ArrayList al1 = null;
        for (String dir : this.repositoryDirs) {
            al1 = JModule.getInstalledFileInDir((String)dir, (String)extension);
            for (URL url : al1) {
                al.add(url);
            }
        }
        return al;
    }

    private ArrayList<URL> getDeplyableFiles() throws MalformedURLException, IOException, MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        ArrayList<URL> installedUrls = this.getInstalledFiles();
        ArrayList<URL> deployableUrls = new ArrayList<URL>();
        for (URL installed : installedUrls) {
            if (this.isDeployedFile(installed)) continue;
            deployableUrls.add(installed);
        }
        return deployableUrls;
    }

    private ArrayList<URL> getDeplyableJars() throws MalformedURLException, IOException, MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        ArrayList<URL> installedUrls = this.getInstalledJars();
        ArrayList<URL> deployableUrls = new ArrayList<URL>();
        for (URL installed : installedUrls) {
            if (this.isDeployedFile(installed)) continue;
            deployableUrls.add(installed);
        }
        return deployableUrls;
    }

    private ArrayList<URL> getDeplyableWars() throws MalformedURLException, IOException, MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        ArrayList<URL> installedUrls = this.getInstalledWars();
        ArrayList<URL> deployableUrls = new ArrayList<URL>();
        for (URL installed : installedUrls) {
            if (this.isDeployedFile(installed)) continue;
            deployableUrls.add(installed);
        }
        return deployableUrls;
    }

    private ArrayList<URL> getDeplyableEars() throws MalformedURLException, IOException, MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        ArrayList<URL> installedUrls = this.getInstalledEars();
        ArrayList<URL> deployableUrls = new ArrayList<URL>();
        for (URL installed : installedUrls) {
            if (this.isDeployedFile(installed)) continue;
            deployableUrls.add(installed);
        }
        return deployableUrls;
    }

    private ArrayList<URL> getDeplyableRars() throws MalformedURLException, IOException, MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        ArrayList<URL> installedUrls = this.getInstalledRars();
        ArrayList<URL> deployableUrls = new ArrayList<URL>();
        for (URL installed : installedUrls) {
            if (this.isDeployedFile(installed)) continue;
            deployableUrls.add(installed);
        }
        return deployableUrls;
    }

    private boolean isDeployedWar(URL fileUrl) throws NullPointerException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        for (String deployed : this.deployedObjects) {
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            if (!j2eeType.equals("WebModule")) continue;
            try {
                URL url = (URL)this.mbeanServer.getAttribute(on, "warURL");
                if (!fileUrl.equals(url)) continue;
                return true;
            }
            catch (AttributeNotFoundException e) {
            }
        }
        return false;
    }

    private boolean isDeployedJar(URL fileUrl) throws NullPointerException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        for (String deployed : this.deployedObjects) {
            URL url;
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            if (!j2eeType.equals("EJBModule") || !fileUrl.equals(url = (URL)this.mbeanServer.getAttribute(on, "url"))) continue;
            return true;
        }
        return false;
    }

    private boolean isDeployedRar(URL fileUrl) throws NullPointerException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        for (String deployed : this.deployedObjects) {
            URL url;
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            if (!j2eeType.equals("ResourceAdapterModule") || !fileUrl.equals(url = (URL)this.mbeanServer.getAttribute(on, "rarURL"))) continue;
            return true;
        }
        return false;
    }

    private boolean isDeployedEar(URL fileUrl) throws NullPointerException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        for (String deployed : this.deployedObjects) {
            URL url;
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            if (!j2eeType.equals("J2EEApplication") || !fileUrl.equals(url = (URL)this.mbeanServer.getAttribute(on, "earUrl"))) continue;
            return true;
        }
        return false;
    }

    private boolean isDeployedFile(URL fileUrl) throws NullPointerException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.isDeployedJar(fileUrl)) {
            return true;
        }
        if (this.isDeployedWar(fileUrl)) {
            return true;
        }
        if (this.isDeployedRar(fileUrl)) {
            return true;
        }
        return this.isDeployedEar(fileUrl);
    }

    public ArrayList<String> getDeployableFiles() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ArrayList<URL> deployableUrls = this.getDeplyableFiles();
            for (URL url : deployableUrls) {
                result.add(this.extractPath(url));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<String> getDeployableJars() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ArrayList<URL> deployableUrls = this.getDeplyableJars();
            for (URL url : deployableUrls) {
                result.add(this.extractPath(url));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<String> getDeployableEars() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ArrayList<URL> deployableUrls = this.getDeplyableEars();
            for (URL url : deployableUrls) {
                result.add(this.extractPath(url));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<String> getDeployableWars() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ArrayList<URL> deployableUrls = this.getDeplyableWars();
            for (URL url : deployableUrls) {
                result.add(this.extractPath(url));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<String> getDeployableRars() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ArrayList<URL> deployableUrls = this.getDeplyableRars();
            for (URL url : deployableUrls) {
                result.add(this.extractPath(url));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<String> getDeployedWars() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (String deployed : this.deployedObjects) {
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            String j2eeApplication = on.getKeyProperty("J2EEApplication");
            boolean inEar = true;
            if ("none".equals(j2eeApplication)) {
                inEar = false;
            }
            if (!j2eeType.equals("WebModule") || inEar) continue;
            try {
                URL url = (URL)this.mbeanServer.getAttribute(on, "warURL");
                result.add(this.extractPath(url));
            }
            catch (AttributeNotFoundException e) {}
        }
        return result;
    }

    public ArrayList<String> getDeployedJars() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (String deployed : this.deployedObjects) {
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            String j2eeApplication = on.getKeyProperty("J2EEApplication");
            boolean inEar = true;
            if ("none".equals(j2eeApplication)) {
                inEar = false;
            }
            if (!j2eeType.equals("EJBModule") || inEar) continue;
            URL url = (URL)this.mbeanServer.getAttribute(on, "url");
            result.add(this.extractPath(url));
        }
        return result;
    }

    public ArrayList<String> getDeployedRars() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (String deployed : this.deployedObjects) {
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            String j2eeApplication = on.getKeyProperty("J2EEApplication");
            boolean inEar = true;
            if ("none".equals(j2eeApplication)) {
                inEar = false;
            }
            if (!j2eeType.equals("ResourceAdapterModule") || inEar) continue;
            URL url = (URL)this.mbeanServer.getAttribute(on, "rarURL");
            result.add(this.extractPath(url));
        }
        return result;
    }

    public ArrayList<String> getDeployedEars() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (String deployed : this.deployedObjects) {
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            if (!j2eeType.equals("J2EEApplication")) continue;
            URL url = (URL)this.mbeanServer.getAttribute(on, "earUrl");
            result.add(this.extractPath(url));
        }
        return result;
    }

    public ArrayList<String> getDeployedFiles() throws Exception {
        ArrayList<String> result = this.getDeployedEars();
        ArrayList<String> resultNext = this.getDeployedWars();
        for (String file : resultNext) {
            result.add(file);
        }
        resultNext = this.getDeployedJars();
        for (String file : resultNext) {
            result.add(file);
        }
        resultNext = this.getDeployedRars();
        for (String file : resultNext) {
            result.add(file);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String sendFile(byte[] fileContent, String fileName, boolean replaceExisting) throws Exception {
        File directoryUploadedFile;
        block9: {
            directoryUploadedFile = null;
            FileOutputStream fos = null;
            try {
                String dir = this.jonasBase + File.separator + "deploy";
                if (this.versioningService != null && this.versioningService.isVersioningEnabled()) {
                    File tempFile = File.createTempFile("jonas_renameUpload", ".tmp");
                    tempFile.deleteOnExit();
                    FileOutputStream tempFos = new FileOutputStream(tempFile);
                    tempFos.write(fileContent);
                    tempFos.close();
                    String versionID = this.versioningService.getVersionID(tempFile);
                    tempFile.delete();
                    if (versionID != null && !fileName.contains(versionID)) {
                        int extensionStarts = fileName.length() - 4;
                        fileName = fileName.substring(0, extensionStarts) + versionID + fileName.substring(extensionStarts);
                    }
                }
                if ((directoryUploadedFile = new File(dir, fileName)).exists() && !replaceExisting) {
                    throw new Exception("File '" + directoryUploadedFile + "' already exists on the server.");
                }
                fos = new FileOutputStream(directoryUploadedFile);
                fos.write(fileContent);
                if (fos == null) break block9;
            }
            catch (Throwable throwable) {
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    this.logger.debug((Object)"Cannot close the output stream", new Object[]{ioe});
                }
                throw throwable;
            }
            try {
                fos.close();
            }
            catch (IOException ioe) {
                this.logger.debug((Object)"Cannot close the output stream", new Object[]{ioe});
            }
        }
        if (directoryUploadedFile == null) return "error, no uploaded file";
        this.logger.info((Object)("sendFile return directoryUploadedFile= " + directoryUploadedFile.getPath()), new Object[0]);
        return directoryUploadedFile.getPath();
    }

    public String distribute(String fileName, byte[] fileContent) throws Exception {
        this.logger.info((Object)"Distribute file to the local filesystem with the name = ''{0}''.", new Object[]{fileName});
        String path = this.sendFile(fileContent, fileName, true);
        return path;
    }

    public boolean removeModuleFile(String fileName) throws Exception {
        boolean existFile = false;
        File searchedFile = new File(fileName);
        String dir = null;
        if (!searchedFile.exists()) {
            dir = this.jonasBase + File.separator + "deploy";
            searchedFile = new File(dir, fileName);
        }
        if (searchedFile.exists()) {
            existFile = true;
        } else {
            dir = this.getFolderDir(fileName);
            searchedFile = new File(dir, fileName);
            if (searchedFile.exists()) {
                existFile = true;
            }
        }
        if (existFile) {
            return searchedFile.delete();
        }
        throw new Exception("File '" + searchedFile + "' was not found on the JOnAS server. Cannot remove it");
    }

    private String getFolderDir(String fileName) throws Exception {
        String dir = null;
        if (fileName.toLowerCase().endsWith(".jar")) {
            dir = this.jonasBase + File.separator + "ejbjars";
        } else if (fileName.toLowerCase().endsWith(".war")) {
            dir = this.jonasBase + File.separator + "webapps";
        } else if (fileName.toLowerCase().endsWith(".ear")) {
            dir = this.jonasBase + File.separator + "apps";
        } else if (fileName.toLowerCase().endsWith(".rar")) {
            dir = this.jonasBase + File.separator + "rars";
        } else {
            throw new Exception("Invalid extension for the file '" + fileName + "'. Valid are .jar, .war, .ear, .rar");
        }
        return dir;
    }

    public String wsgenLocalFile(String pathname, Boolean unpacked) {
        try {
            WsGenWrapper wsgen = new WsGenWrapper();
            String outputFilename = wsgen.callWsGenExecute(pathname, unpacked);
            boolean modified = wsgen.callWsGenIsInputModifed();
            if (modified) {
                return outputFilename;
            }
            return null;
        }
        catch (Exception e) {
            this.logger.warn((Object)"Cannot generate web services for this component {0}", new Object[]{pathname, e});
            return null;
        }
    }

    private String extractPath(URL url) {
        String path;
        try {
            File file = new File(url.toURI());
            path = file.toURL().getFile();
        }
        catch (Exception e) {
            path = url.getPath();
        }
        return path;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public String[] getServices() {
        this.services = this.serviceManager.getServices();
        String[] result = new String[this.services.size()];
        int i = 0;
        for (String service : this.services) {
            result[i++] = service;
        }
        return result;
    }

    public String getServiceDescription(String service) {
        return this.serviceManager.getServiceDescription(service);
    }

    public String getServiceState(String service) {
        ServiceState state = this.serviceManager.getServiceState(service);
        return state.toString();
    }
}

