/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ws;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.HandlerDesc;
import org.ow2.jonas.deployment.common.xml.Handler;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;
import org.ow2.jonas.deployment.ws.xml.JonasPortComponent;
import org.ow2.jonas.deployment.ws.xml.PortComponent;
import org.ow2.jonas.lib.util.I18n;

public abstract class PortComponentDesc {
    private static I18n i18n = I18n.getInstance(PortComponentDesc.class);
    private String name;
    private Class sei;
    private String sibLink;
    private String sib;
    private List handlers = new Vector();
    private QName portQName;
    private URL endpoint = null;
    private ServiceDesc parent = null;
    private String endpointURI = null;
    private String mapping = null;
    private String serviceName = null;

    protected PortComponentDesc(ClassLoader jarCL, PortComponent pc, JonasPortComponent jpc, ServiceDesc parent) throws WSDeploymentDescException {
        this.parent = parent;
        this.name = pc.getPortComponentName();
        if ("".equals(this.name)) {
            String err = PortComponentDesc.getI18n().getMessage("PortComponentDesc.noPCName");
            throw new WSDeploymentDescException(err);
        }
        String seiClassName = pc.getServiceEndpointInterface();
        if ("".equals(seiClassName)) {
            String err = PortComponentDesc.getI18n().getMessage("PortComponentDesc.noInterfaceName");
            throw new WSDeploymentDescException(err);
        }
        try {
            this.sei = jarCL.loadClass(seiClassName);
        }
        catch (ClassNotFoundException e) {
            String err = PortComponentDesc.getI18n().getMessage("PortComponentDesc.loadError", (Object)seiClassName);
            throw new WSDeploymentDescException(err, e);
        }
        JLinkedList hl = pc.getHandlerList();
        Handler h = null;
        for (int i = 0; i < hl.size(); ++i) {
            if (hl.get(i) == null) continue;
            h = (Handler)hl.get(i);
            try {
                this.handlers.add(new HandlerDesc(jarCL, h));
                continue;
            }
            catch (DeploymentDescException dde) {
                throw new WSDeploymentDescException(dde);
            }
        }
        this.portQName = pc.getWsdlPort().getQName();
        if (jpc != null) {
            this.endpointURI = jpc.getEndpointURI();
            if (this.endpointURI != null) {
                if (!this.endpointURI.startsWith("/")) {
                    this.serviceName = this.endpointURI;
                    this.endpointURI = this.endpointURI + "/" + this.endpointURI;
                } else {
                    this.serviceName = this.endpointURI.substring(1);
                }
                if ("".equals(this.serviceName)) {
                    String err = PortComponentDesc.getI18n().getMessage("PortComponentDesc.invalidEndpointURI", (Object)this.name);
                    throw new WSDeploymentDescException(err);
                }
            }
        } else {
            this.serviceName = this.portQName.getLocalPart();
        }
    }

    public ServiceDesc getServiceDesc() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public Class getServiceEndpointInterface() {
        return this.sei;
    }

    public String getSIBClassname() {
        return this.sib;
    }

    protected void setSIBClassname(String sibClassName) {
        this.sib = sibClassName;
    }

    public QName getQName() {
        return this.portQName;
    }

    public List getHandlers() {
        return this.handlers;
    }

    public String getSibLink() {
        return this.sibLink;
    }

    public abstract boolean hasBeanImpl();

    public abstract boolean hasJaxRpcImpl();

    public URL getEndpointURL() {
        return this.endpoint;
    }

    public void setEndpointURL(URL url) {
        this.endpoint = url;
    }

    public String getMapping() {
        return this.mapping;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public abstract void setDesc(Object var1) throws WSDeploymentDescException;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n" + this.getClass().getName());
        sb.append("\ngetName()=" + this.getName());
        sb.append("\ngetServiceEndpointInterface()=" + this.getServiceEndpointInterface());
        sb.append("\ngetSibLink()=" + this.getSibLink());
        sb.append("\ngetSIBClassname()=" + this.getSIBClassname());
        sb.append("\ngetQName()=" + this.getQName());
        Iterator i = this.getHandlers().iterator();
        while (i.hasNext()) {
            sb.append("\ngetHandlers()=" + ((Handler)i.next()).toString());
        }
        return sb.toString();
    }

    public String getSib() {
        return this.sib;
    }

    public void setSib(String sib) {
        this.sib = sib;
    }

    public void setSibLink(String sibLink) {
        this.sibLink = sibLink;
    }

    public static I18n getI18n() {
        return i18n;
    }

    public String getEndpointURI() {
        return this.endpointURI;
    }
}

