/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.war.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.archive.impl.MemoryArchive;
import org.ow2.util.scan.api.DefaultArchiveHelper;
import org.ow2.util.scan.api.IArchiveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarArchiveHelper
implements IArchiveHelper {
    private static final String CLASS_PREFIX = "WEB-INF/classes/";
    private static final String CLASS_SUFFIX = ".class";
    private static final String LIB_PREFIX = "WEB-INF/lib/";
    private static final String LIB_SUFFIX = ".jar";
    private List<URL> classURLList;
    private List<IArchiveHelper> archiveHelperList;
    private IArchive archive;

    public WarArchiveHelper(IArchive archive) throws ArchiveException {
        throw new UnsupportedOperationException("please use WarArchiveHelper with classname contructor (temporary solution)");
    }

    public WarArchiveHelper(IArchive archive, List<String> classNames) throws ArchiveException {
        this.classURLList = new ArrayList<URL>();
        this.archive = archive;
        this.archiveHelperList = new ArrayList<IArchiveHelper>();
        if (archive instanceof MemoryArchive) {
            this.findClassesWithEntriesScan((MemoryArchive)archive);
        } else {
            this.findClassesCreateClassLoader(classNames);
        }
    }

    private void findClassesWithEntriesScan(MemoryArchive archive) throws ArchiveException {
        Iterator stringIterator = archive.getEntries();
        while (stringIterator.hasNext()) {
            String resourceName = (String)stringIterator.next();
            if (resourceName.startsWith(CLASS_PREFIX) && resourceName.endsWith(CLASS_SUFFIX)) {
                this.classURLList.add(archive.getResource(resourceName));
                continue;
            }
            if (!resourceName.startsWith(LIB_PREFIX) || !resourceName.endsWith(LIB_SUFFIX)) continue;
            IArchive libArchive = ArchiveManager.getInstance().getArchive((Object)archive.getResource(resourceName));
            DefaultArchiveHelper archiveHelper = new DefaultArchiveHelper(libArchive);
            this.classURLList.addAll(archiveHelper.listClassURL());
            this.archiveHelperList.add((IArchiveHelper)archiveHelper);
        }
    }

    private void findClassesCreateClassLoader(List<String> classNames) throws ArchiveException {
        Iterator itResources;
        try {
            itResources = this.archive.getResources();
        }
        catch (ArchiveException e) {
            throw new ArchiveException("Cannot get resources on the given archive '" + this.archive + "'.", (Throwable)e);
        }
        ArrayList<URL> classLoaderURLs = new ArrayList<URL>();
        URL warURL = this.archive.getURL();
        while (itResources.hasNext()) {
            String relativePath;
            int filePos;
            URL currentURL = (URL)itResources.next();
            if (currentURL.getPath().endsWith(CLASS_SUFFIX)) {
                this.classURLList.add(currentURL);
            }
            if ((filePos = currentURL.toExternalForm().indexOf(warURL.toExternalForm())) >= 0) {
                filePos += warURL.toExternalForm().length();
            }
            if ((relativePath = currentURL.toExternalForm().substring(filePos)).startsWith("!/")) {
                relativePath = relativePath.substring(2);
            } else if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if (!relativePath.startsWith(LIB_PREFIX) || !relativePath.endsWith(LIB_SUFFIX)) continue;
            classLoaderURLs.add(currentURL);
        }
        for (URL url : classLoaderURLs) {
            IArchive archive = ArchiveManager.getInstance().getArchive((Object)url);
            DefaultArchiveHelper archiveHelper = new DefaultArchiveHelper(archive);
            this.classURLList.addAll(archiveHelper.listClassURL());
            this.archiveHelperList.add((IArchiveHelper)archiveHelper);
        }
    }

    public URL getClassURL(String className) throws ArchiveException {
        URL url;
        block1: {
            IArchiveHelper archiveHelper;
            String classLocation = className.replace('.', '/').concat(CLASS_SUFFIX);
            url = this.archive.getResource(CLASS_PREFIX + classLocation);
            if (url != null) break block1;
            Iterator<IArchiveHelper> i$ = this.archiveHelperList.iterator();
            while (i$.hasNext() && (url = (archiveHelper = i$.next()).getClassURL(className)) == null) {
            }
        }
        return url;
    }

    public List<URL> listClassURL() {
        return this.classURLList;
    }

    public IArchive getArchive() {
        return this.archive;
    }
}

