/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.admin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.admin.CMIAdmin;
import org.ow2.cmi.admin.CMIMBeanConfigException;
import org.ow2.cmi.config.CMIConfig;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@ThreadSafe
public final class MBeanUtils {
    private static Log logger = LogFactory.getLog(MBeanUtils.class);
    private static volatile MBeanServer mbeanServer;
    private static volatile String mbeanDomainName;
    private static volatile String agentId;
    private static String mbeanServerName;
    private static boolean initialized;
    private static boolean registered;
    private static final Set<String> XTRAMBEANS;
    private static ObjectName cmiAdminObjectName;

    private MBeanUtils() {
    }

    private static void initMBeanServer() throws CMIMBeanConfigException {
        ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(agentId);
        if (mbeanServers.size() == 0) {
            if (CMIConfig.isEmbedded()) {
                logger.error((Object)"CMI is embedded but no MBeanServer is available !", new Object[0]);
                throw new CMIMBeanConfigException("CMI is embedded but no MBeanServer is available !");
            }
            logger.debug((Object)"Creating a new MBeanServer...", new Object[0]);
            mbeanServer = MBeanServerFactory.createMBeanServer(mbeanDomainName);
        } else {
            if (mbeanServers.size() > 1) {
                logger.info((Object)"Many MBeanServer available: taking the first of the list", new Object[0]);
            }
            mbeanServer = (MBeanServer)mbeanServers.get(0);
        }
    }

    public static synchronized void setMBeanParameters(String domainName, String serverName, String agentId) {
        mbeanDomainName = domainName;
        mbeanServerName = serverName;
        MBeanUtils.agentId = agentId;
        CMIConfig.setEmbedded();
    }

    public static MBeanServer getMBeanServer() {
        return mbeanServer;
    }

    private static String buildObjectName(String name) {
        StringBuffer sb = new StringBuffer();
        if (mbeanDomainName != null) {
            sb.append(mbeanDomainName);
        }
        sb.append(":type=cmi");
        sb.append(",name=" + name);
        if (CMIConfig.isEmbedded()) {
            sb.append(",J2EEServer=" + mbeanServerName);
        }
        return sb.toString();
    }

    public static String getMBeanDomainName() {
        return mbeanDomainName;
    }

    public static String getMBeanServerName() {
        return mbeanServerName;
    }

    public static synchronized void registerCMIMBean(ClusterViewManager clusterViewManager) throws CMIMBeanConfigException {
        if (!initialized) {
            logger.error((Object)"CMIMBean is not yet initialized: cannot register it", new Object[0]);
            throw new CMIMBeanConfigException("CMIMBean is not yet initialized: cannot register it");
        }
        if (registered) {
            logger.error((Object)"CMIMBean is already registered", new Object[0]);
            throw new CMIMBeanConfigException("CMIMBean is already registered");
        }
        String cmiAdminObjectNameRepresentation = MBeanUtils.buildObjectName(CMIConfig.getCMIAdminMBeanName());
        try {
            cmiAdminObjectName = new ObjectName(cmiAdminObjectNameRepresentation);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)"Cannot build an ObjectName for CMIAdmin with representation {0}", new Object[]{cmiAdminObjectNameRepresentation, e});
            throw new CMIMBeanConfigException("Cannot build an ObjectName for CMIAdmin with representation " + cmiAdminObjectNameRepresentation, e);
        }
        CMIAdmin cmiAdmin = CMIAdmin.getCMIAdmin(cmiAdminObjectName, clusterViewManager);
        try {
            mbeanServer.registerMBean(cmiAdmin, cmiAdminObjectName);
        }
        catch (Exception e) {
            logger.error((Object)"Cannot register the CMIAdmin MBean", new Object[]{e});
            throw new CMIMBeanConfigException("Cannot register the CMIAdmin MBean", e);
        }
        registered = true;
    }

    public static void unregisterCMIMBean() throws CMIMBeanConfigException {
        if (registered) {
            try {
                mbeanServer.unregisterMBean(cmiAdminObjectName);
            }
            catch (Exception e) {
                logger.error((Object)"Cannot unregister the CMIAdmin MBean", new Object[]{e});
                throw new CMIMBeanConfigException("Cannot unregister the CMIAdmin MBean", e);
            }
            CMIAdmin.setCMIAdmin(null);
            registered = false;
        }
    }

    public static synchronized ObjectName registerXtraMBean(String name, Object mbean) throws CMIMBeanConfigException {
        if (!registered) {
            logger.error((Object)"CMIMBean is not already registered", new Object[0]);
            throw new CMIMBeanConfigException("CMIMBean is not already registered");
        }
        if (XTRAMBEANS.contains(name)) {
            logger.error((Object)"{0} is already registered", new Object[]{name});
            throw new CMIMBeanConfigException(name + " is already registered");
        }
        ObjectName objectName = null;
        String objectNameRepresentation = MBeanUtils.buildObjectName(name);
        try {
            objectName = new ObjectName(objectNameRepresentation);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)"Cannot build an ObjectName with representation {0}", new Object[]{objectNameRepresentation, e});
            throw new CMIMBeanConfigException("Cannot build an ObjectName with representation " + objectNameRepresentation, e);
        }
        try {
            mbeanServer.registerMBean(mbean, objectName);
        }
        catch (Exception e) {
            logger.error((Object)"Cannot register the MBean", new Object[]{e});
            throw new CMIMBeanConfigException("Cannot register the MBean", e);
        }
        XTRAMBEANS.add(name);
        return objectName;
    }

    public static synchronized void initCMIMBean() throws CMIMBeanConfigException {
        if (initialized) {
            return;
        }
        if (!CMIConfig.isEmbedded()) {
            mbeanDomainName = CMIConfig.getMBeanDomainName();
            mbeanServerName = null;
        }
        logger.debug((Object)"MBeanDomainName: {0}", new Object[]{mbeanDomainName});
        logger.debug((Object)"MBeanServerName: {0}", new Object[]{mbeanServerName});
        MBeanUtils.initMBeanServer();
        initialized = true;
    }

    static {
        initialized = false;
        registered = false;
        XTRAMBEANS = new HashSet<String>();
        cmiAdminObjectName = null;
    }
}

