/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.lb.data;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import net.jcip.annotations.Immutable;
import org.ow2.cmi.lb.PropertyConfigurationException;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class PropertyData {
    private static Log logger = LogFactory.getLog(PropertyData.class);
    private final String propertyName;
    private final Class<? extends IPolicy<?>> policyClass;
    private final Type propertyType;
    private final Method getter;
    private final Method setter;

    public PropertyData(Method getter, Class<? extends IPolicy<?>> policyClass) throws PropertyConfigurationException {
        this.getter = getter;
        this.policyClass = policyClass;
        String formattedPropertyName = getter.getName().substring(3);
        this.propertyName = formattedPropertyName.substring(0, 1).toLowerCase() + formattedPropertyName.substring(1);
        this.propertyType = getter.getGenericReturnType();
        try {
            this.setter = policyClass.getDeclaredMethod("set" + formattedPropertyName, getter.getReturnType());
        }
        catch (Exception e) {
            logger.error((Object)"The class for name {0} doesn't contain a setter for property {1}", new Object[]{policyClass.getName(), this.propertyName, e});
            throw new PropertyConfigurationException("The class for name " + policyClass.getName() + "doesn't contain a setter for property " + this.propertyName, e);
        }
        Type[] parameterTypes = this.setter.getGenericParameterTypes();
        if (!parameterTypes[0].equals(this.propertyType)) {
            logger.error((Object)"Setter and getter doesn't have the same type !", new Object[0]);
            throw new PropertyConfigurationException("Setter and getter doesn't have the same type !");
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<? extends IPolicy<?>> getPolicyClass() {
        return this.policyClass;
    }

    public Type getPropertyType() {
        return this.propertyType;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }
}

