/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.war.impl;

import java.util.LinkedList;
import java.util.List;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.ee.metadata.war.api.IWarDeployableMetadata;
import org.ow2.util.ee.metadata.war.api.IWarDeployableMetadataFactory;
import org.ow2.util.ee.metadata.war.api.exceptions.WARDeploymentDescException;
import org.ow2.util.ee.metadata.war.impl.WarArchiveHelper;
import org.ow2.util.ee.metadata.war.impl.WarDeployableMetadata;
import org.ow2.util.ee.metadata.war.impl.WarExternLibraries;
import org.ow2.util.ee.metadata.war.impl.configurator.WarDeployableMetadataConfigurator;
import org.ow2.util.ee.metadata.war.impl.specific.ISpecificDeployableFactory;
import org.ow2.util.ee.metadata.war.impl.xml.Filter;
import org.ow2.util.ee.metadata.war.impl.xml.Listener;
import org.ow2.util.ee.metadata.war.impl.xml.Servlet;
import org.ow2.util.ee.metadata.war.impl.xml.Tag;
import org.ow2.util.ee.metadata.war.impl.xml.WAR;
import org.ow2.util.ee.metadata.war.impl.xml.WARDeploymentDesc;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.ArchiveScanner;
import org.ow2.util.scan.api.ArchiveScannerFactory;
import org.ow2.util.scan.api.IArchiveHelper;
import org.ow2.util.scan.api.IArchiveScannerFactory;
import org.ow2.util.scan.api.ScanException;
import org.ow2.util.scan.api.configurator.IArchiveConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarDeployableMetadataFactory
implements IWarDeployableMetadataFactory {
    private static final Log LOGGER = LogFactory.getLog(WarDeployableMetadataFactory.class);
    private IArchiveScannerFactory archiveScannerFactory;

    public WarDeployableMetadataFactory() throws ScanException {
        this((IArchiveScannerFactory)ArchiveScannerFactory.getInstance());
    }

    public WarDeployableMetadataFactory(IArchiveScannerFactory archiveScannerFactory) {
        this.archiveScannerFactory = archiveScannerFactory;
    }

    public IWarDeployableMetadata createDeployableMetadata(WARDeployable deployable) throws DeployableMetadataException {
        return this.createDeployableMetadata(deployable, null, null);
    }

    public IWarDeployableMetadata createDeployableMetadata(WARDeployable deployable, WarExternLibraries warExternLibraries, List<? extends ISpecificDeployableFactory> specificDeployableFactoryList) throws DeployableMetadataException {
        ArchiveScanner archiveScanner;
        WAR war;
        IArchive archive = deployable.getArchive();
        try {
            war = WARDeploymentDesc.getWAR(archive);
        }
        catch (WARDeploymentDescException e) {
            throw new DeployableMetadataException((Throwable)e);
        }
        long tAnalyzeStart = System.currentTimeMillis();
        LinkedList<String> classNames = new LinkedList<String>();
        for (Servlet servlet : war.getServlets()) {
            this.addClassIfNotAlreadyPresent(servlet.getClassName(), classNames);
        }
        for (Listener listener : war.getListeners()) {
            this.addClassIfNotAlreadyPresent(listener.getListenerClassName(), classNames);
        }
        for (Tag tag : war.getTags()) {
            this.addClassIfNotAlreadyPresent(tag.getTagClassName(), classNames);
        }
        for (Filter filter : war.getFilters()) {
            this.addClassIfNotAlreadyPresent(filter.getFilterClassName(), classNames);
        }
        try {
            archiveScanner = this.archiveScannerFactory.createArchiveScanner((IArchiveHelper)new WarArchiveHelper(archive, classNames));
        }
        catch (ArchiveException e) {
            throw new DeployableMetadataException((Throwable)e);
        }
        WarDeployableMetadataConfigurator warArchiveMetadataConfigurator = new WarDeployableMetadataConfigurator(deployable);
        if (specificDeployableFactoryList != null) {
            for (ISpecificDeployableFactory iSpecificDeployableFactory : specificDeployableFactoryList) {
                warArchiveMetadataConfigurator.addSpecificMetadataConfigurator(iSpecificDeployableFactory.beforeScan(deployable));
            }
        }
        if (war.isMetadataComplete()) {
            warArchiveMetadataConfigurator.setAnnotationParsingDesactived(true);
        }
        archiveScanner.addArchiveConfigurator((IArchiveConfigurator)warArchiveMetadataConfigurator);
        try {
            archiveScanner.scanCollection(classNames);
            if (warExternLibraries != null) {
                WarDeployableMetadata warDeployableMetadata = warArchiveMetadataConfigurator.getWarDeployableMetadata();
                for (String className : classNames) {
                    if (warDeployableMetadata.getWarClassMetadata(className) != null) continue;
                    warExternLibraries.attachClassMetadata(warDeployableMetadata, className);
                }
            }
        }
        catch (ScanException e) {
            throw new DeployableMetadataException((Throwable)e);
        }
        archiveScanner.endScan();
        if (specificDeployableFactoryList != null) {
            for (ISpecificDeployableFactory iSpecificDeployableFactory : specificDeployableFactoryList) {
                iSpecificDeployableFactory.afterScan();
            }
        }
        if (LOGGER.isDebugEnabled()) {
            long tAnalyzeStartEnd = System.currentTimeMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Analyze of file {0} took {1} ms.", new Object[]{archive.getName(), tAnalyzeStartEnd - tAnalyzeStart});
            }
        }
        return warArchiveMetadataConfigurator.getWarDeployableMetadata();
    }

    protected void addClassIfNotAlreadyPresent(String className, List<String> classNames) {
        if (className == null) {
            return;
        }
        if (!classNames.contains(className)) {
            classNames.add(className);
        }
    }

    public Class<IWarDeployableMetadata> getDeployableMetadataClass() {
        return IWarDeployableMetadata.class;
    }
}

