/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.versioning.internal;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.ObjectName;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.ModuleNamingUtils;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.versioning.contexts.VirtualJNDIBinding;
import org.ow2.jonas.versioning.internal.VersioningServiceImplMBean;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningServiceImpl
extends AbsServiceImpl
implements VersioningService,
VersioningServiceImplMBean,
Pojo {
    private InstanceManager _cm;
    private static Log logger = LogFactory.getLog(VersioningService.class);
    private boolean _FdefaultPolicy;
    private String defaultPolicy;
    private boolean _Fcontexts;
    private Map<String, List<String>> contexts;
    private boolean _FjmxService;
    private JmxService jmxService;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _MsetJmxServiceorg_ow2_jonas_jmx_JmxService;
    private boolean _MdoStart;
    private boolean _MdoStop;
    private boolean _MgetDefaultPolicy;
    private boolean _MsetDefaultPolicyjava_lang_String;
    private boolean _MisVersioningEnabled;
    private boolean _MaddContextjava_lang_Stringjava_lang_String;
    private boolean _MremoveContextjava_lang_String;
    private boolean _MgetContextNames;
    private boolean _MgetContextBeansjava_lang_String;
    private boolean _MgetVersionIDjava_io_File;
    private boolean _MgetVersionIDjava_net_URL;
    private boolean _MgetVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean _MgetPrefixjava_io_File;
    private boolean _MgetPrefixjava_net_URL;
    private boolean _MgetPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean _McreatePrefixjava_lang_Stringjava_lang_String;
    private boolean _MgetOriginalDeployableorg_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean _McreateJNDIBindingMBeansjava_lang_Stringjava_lang_Stringjava_lang_String;
    private boolean _MgarbageCollectJNDIBindingMBeans;

    private String _getdefaultPolicy() {
        if (!this._FdefaultPolicy) {
            return this.defaultPolicy;
        }
        return (String)this._cm.getterCallback("defaultPolicy");
    }

    private void _setdefaultPolicy(String string) {
        if (!this._FdefaultPolicy) {
            this.defaultPolicy = string;
            return;
        }
        this._cm.setterCallback("defaultPolicy", (Object)string);
    }

    private Map _getcontexts() {
        if (!this._Fcontexts) {
            return this.contexts;
        }
        return (Map)this._cm.getterCallback("contexts");
    }

    private void _setcontexts(Map map) {
        if (!this._Fcontexts) {
            this.contexts = map;
            return;
        }
        this._cm.setterCallback("contexts", (Object)map);
    }

    private JmxService _getjmxService() {
        if (!this._FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this._cm.getterCallback("jmxService");
    }

    private void _setjmxService(JmxService jmxService) {
        if (!this._FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this._cm.setterCallback("jmxService", (Object)jmxService);
    }

    public VersioningServiceImpl(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setdefaultPolicy("Reserved");
        this._setcontexts(new HashMap());
        this._setjmxService(null);
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setJmxService(JmxService jmxService) {
        void jmxService2;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.entryCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService");
        }
        this._setjmxService((JmxService)jmxService2);
        Object var2_2 = null;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.exitCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService", var2_2);
        }
    }

    public static ObjectName getObjectName(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=versioning");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get versioning service", e);
        }
    }

    protected void doStart() {
        if (this._MdoStart) {
            this._cm.entryCallback("doStart");
        }
        VirtualJNDIBinding.initialize(this, this._getjmxService());
        this._getjmxService().registerMBean((Object)this, VersioningServiceImpl.getObjectName(this.getDomainName()));
        logger.info((Object)"Versioning service management bean has been registered successfully", new Object[0]);
        Object var1_1 = null;
        if (this._MdoStart) {
            this._cm.exitCallback("doStart", var1_1);
        }
    }

    protected void doStop() {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        this._getjmxService().unregisterMBean(VersioningServiceImpl.getObjectName(this.getDomainName()));
        logger.info((Object)"Versioning service management bean has been unregistered successfully", new Object[0]);
        Object var1_1 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var1_1);
        }
    }

    @Override
    public String getDefaultPolicy() {
        if (this._MgetDefaultPolicy) {
            this._cm.entryCallback("getDefaultPolicy");
        }
        String string = this._getdefaultPolicy();
        if (this._MgetDefaultPolicy) {
            this._cm.exitCallback("getDefaultPolicy", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDefaultPolicy(String string) {
        void defaultPolicy;
        if (this._MsetDefaultPolicyjava_lang_String) {
            this._cm.entryCallback("setDefaultPolicyjava_lang_String");
        }
        this._setdefaultPolicy((String)defaultPolicy);
        Object var2_2 = null;
        if (this._MsetDefaultPolicyjava_lang_String) {
            this._cm.exitCallback("setDefaultPolicyjava_lang_String", var2_2);
        }
    }

    @Override
    public boolean isVersioningEnabled() {
        if (this._MisVersioningEnabled) {
            this._cm.entryCallback("isVersioningEnabled");
        }
        Boolean bl = new Boolean(this.isStarted());
        if (this._MisVersioningEnabled) {
            this._cm.exitCallback("isVersioningEnabled", (Object)bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addContext(String string, String string2) {
        void context;
        void appName;
        ArrayList<void> contexts;
        if (this._MaddContextjava_lang_Stringjava_lang_String) {
            this._cm.entryCallback("addContextjava_lang_Stringjava_lang_String");
        }
        if ((contexts = (ArrayList<void>)this._getcontexts().get(appName)) == null) {
            contexts = new ArrayList<void>();
            this._getcontexts().put(appName, contexts);
        }
        contexts.add(context);
        Object var4_4 = null;
        if (this._MaddContextjava_lang_Stringjava_lang_String) {
            this._cm.exitCallback("addContextjava_lang_Stringjava_lang_String", var4_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeContext(String string) {
        if (this._MremoveContextjava_lang_String) {
            this._cm.entryCallback("removeContextjava_lang_String");
        }
        ArrayList entries = new ArrayList(this._getcontexts().entrySet());
        for (Map.Entry entry : entries) {
            void context;
            ((List)entry.getValue()).remove(context);
            if (((List)entry.getValue()).size() >= 1) continue;
            this._getcontexts().remove(entry.getKey());
        }
        Object var5_5 = null;
        if (this._MremoveContextjava_lang_String) {
            this._cm.exitCallback("removeContextjava_lang_String", var5_5);
        }
    }

    @Override
    public String[] getContextNames() {
        if (this._MgetContextNames) {
            this._cm.entryCallback("getContextNames");
        }
        Set names = this._getcontexts().keySet();
        String[] stringArray = names.toArray(new String[names.size()]);
        if (this._MgetContextNames) {
            this._cm.exitCallback("getContextNames", (Object)stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] getContextBeans(String string) {
        void name;
        List beans;
        if (this._MgetContextBeansjava_lang_String) {
            this._cm.entryCallback("getContextBeansjava_lang_String");
        }
        if ((beans = (List)this._getcontexts().get(name)) == null) {
            String[] stringArray = null;
            if (this._MgetContextBeansjava_lang_String) {
                this._cm.exitCallback("getContextBeansjava_lang_String", stringArray);
            }
            return stringArray;
        }
        String[] stringArray = beans.toArray(new String[beans.size()]);
        if (this._MgetContextBeansjava_lang_String) {
            this._cm.exitCallback("getContextBeansjava_lang_String", (Object)stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getVersionID(File file) {
        void file2;
        if (this._MgetVersionIDjava_io_File) {
            this._cm.entryCallback("getVersionIDjava_io_File");
        }
        String versionID = null;
        JarFile manifestWarFile = null;
        try {
            manifestWarFile = new JarFile((File)file2);
            Manifest warManifest = manifestWarFile.getManifest();
            if (null != warManifest) {
                versionID = warManifest.getMainAttributes().getValue("Implementation-Version");
            }
            if (versionID != null) {
                String allowedSpecialChars = "-_,.";
                boolean versionIDFiltered = false;
                StringBuffer versionIDFilter = new StringBuffer();
                for (char c : versionID.toCharArray()) {
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "-_,.".indexOf(c) >= 0) {
                        versionIDFilter.append(c);
                        continue;
                    }
                    versionIDFiltered = true;
                    versionIDFilter.append('-');
                }
                if (versionIDFiltered) {
                    versionID = versionIDFilter.toString();
                    logger.info((Object)("Invalid characters detected in version ID for file " + file2 + ", setting version ID to " + versionID), new Object[0]);
                }
                versionID = "-version" + versionID;
            }
        }
        catch (Exception e) {
            logger.info((Object)("Failed reading version ID from file " + file2), new Object[]{e});
        }
        try {
            manifestWarFile.close();
        }
        catch (Exception e) {
            manifestWarFile = null;
        }
        String string = versionID;
        if (this._MgetVersionIDjava_io_File) {
            this._cm.exitCallback("getVersionIDjava_io_File", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getVersionID(URL uRL) {
        String string;
        block4: {
            void url;
            if (this._MgetVersionIDjava_net_URL) {
                this._cm.entryCallback("getVersionIDjava_net_URL");
            }
            try {
                string = this.getVersionID(URLUtils.urlToFile((URL)url));
                if (!this._MgetVersionIDjava_net_URL) break block4;
            }
            catch (Exception e) {
                String string2 = this.getVersionID(new File(url.getFile()));
                if (this._MgetVersionIDjava_net_URL) {
                    this._cm.exitCallback("getVersionIDjava_net_URL", (Object)string2);
                }
                return string2;
            }
            this._cm.exitCallback("getVersionIDjava_net_URL", (Object)string);
        }
        return string;
    }

    @Override
    public String getVersionID(IDeployable<?> iDeployable) {
        IDeployable<?> deployable;
        if (this._MgetVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.entryCallback("getVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable");
        }
        deployable = this.getOriginalDeployable(deployable);
        String versionID = null;
        try {
            versionID = this.getVersionID(deployable.getArchive().getURL());
        }
        catch (ArchiveException e) {
            logger.info((Object)("Failed reading version ID from deployable " + deployable), new Object[]{e});
        }
        String string = versionID;
        if (this._MgetVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.exitCallback("getVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getPrefix(File file) {
        void file2;
        if (this._MgetPrefixjava_io_File) {
            this._cm.entryCallback("getPrefixjava_io_File");
        }
        String string = this.getPrefix(URLUtils.fileToURL((File)file2));
        if (this._MgetPrefixjava_io_File) {
            this._cm.exitCallback("getPrefixjava_io_File", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getPrefix(URL uRL) {
        void url;
        if (this._MgetPrefixjava_net_URL) {
            this._cm.entryCallback("getPrefixjava_net_URL");
        }
        String string = this.createPrefix(ModuleNamingUtils.fromURL((URL)url), this.getVersionID((URL)url));
        if (this._MgetPrefixjava_net_URL) {
            this._cm.exitCallback("getPrefixjava_net_URL", (Object)string);
        }
        return string;
    }

    @Override
    public String getPrefix(IDeployable<?> iDeployable) {
        IDeployable<?> deployable;
        if (this._MgetPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.entryCallback("getPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable");
        }
        deployable = this.getOriginalDeployable(deployable);
        String applicationName = deployable.getModuleName();
        String string = this.createPrefix(applicationName, this.getVersionID(deployable));
        if (this._MgetPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.exitCallback("getPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String createPrefix(String string, String string2) {
        void versionID;
        void applicationName;
        if (this._McreatePrefixjava_lang_Stringjava_lang_String) {
            this._cm.entryCallback("createPrefixjava_lang_Stringjava_lang_String");
        }
        String prefix = applicationName;
        if (versionID != null && !applicationName.endsWith((String)versionID)) {
            prefix = prefix + (String)versionID;
        }
        prefix = prefix + '/';
        String allowedSpecialChars = "_./";
        boolean jndiPrefixFiltered = false;
        StringBuffer jndiPrefixFilter = new StringBuffer();
        for (char c : prefix.toCharArray()) {
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "_./".indexOf(c) >= 0) {
                jndiPrefixFilter.append(c);
                continue;
            }
            jndiPrefixFiltered = true;
            jndiPrefixFilter.append('_');
        }
        if (jndiPrefixFiltered) {
            prefix = jndiPrefixFilter.toString();
            logger.info((Object)("Invalid characters detected in the JNDI prefix for application " + (String)applicationName + ", setting JNDI prefix to " + prefix), new Object[0]);
        }
        String string3 = prefix;
        if (this._McreatePrefixjava_lang_Stringjava_lang_String) {
            this._cm.exitCallback("createPrefixjava_lang_Stringjava_lang_String", (Object)string3);
        }
        return string3;
    }

    private IDeployable<?> getOriginalDeployable(IDeployable<?> iDeployable) {
        IDeployable deployable;
        if (this._MgetOriginalDeployableorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.entryCallback("getOriginalDeployableorg_ow2_util_ee_deploy_api_deployable_IDeployable");
        }
        while (deployable.getOriginalDeployable() != null) {
            deployable = (IDeployable)deployable.getOriginalDeployable();
        }
        void var2_2 = deployable;
        if (this._MgetOriginalDeployableorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.exitCallback("getOriginalDeployableorg_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)var2_2);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createJNDIBindingMBeans(String string, String string2, String string3) {
        void prefix;
        String appName;
        void version;
        if (this._McreateJNDIBindingMBeansjava_lang_Stringjava_lang_Stringjava_lang_String) {
            this._cm.entryCallback("createJNDIBindingMBeansjava_lang_Stringjava_lang_Stringjava_lang_String");
        }
        if (version != null && appName.endsWith((String)version)) {
            appName = appName.substring(0, appName.length() - version.length());
        }
        VirtualJNDIBinding.createJNDIBindingMBeans(appName, (String)prefix);
        Object var4_4 = null;
        if (this._McreateJNDIBindingMBeansjava_lang_Stringjava_lang_Stringjava_lang_String) {
            this._cm.exitCallback("createJNDIBindingMBeansjava_lang_Stringjava_lang_Stringjava_lang_String", var4_4);
        }
    }

    @Override
    public void garbageCollectJNDIBindingMBeans() {
        if (this._MgarbageCollectJNDIBindingMBeans) {
            this._cm.entryCallback("garbageCollectJNDIBindingMBeans");
        }
        VirtualJNDIBinding.garbageCollectJNDIBindingMBeans();
        Object var1_1 = null;
        if (this._MgarbageCollectJNDIBindingMBeans) {
            this._cm.exitCallback("garbageCollectJNDIBindingMBeans", var1_1);
        }
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("contexts")) {
                this._Fcontexts = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
            if (set.contains("defaultPolicy")) {
                this._FdefaultPolicy = true;
            }
            if (set.contains("jmxService")) {
                this._FjmxService = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("setJmxServiceorg_ow2_jonas_jmx_JmxService")) {
                this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
            if (set.contains("getDefaultPolicy")) {
                this._MgetDefaultPolicy = true;
            }
            if (set.contains("setDefaultPolicyjava_lang_String")) {
                this._MsetDefaultPolicyjava_lang_String = true;
            }
            if (set.contains("isVersioningEnabled")) {
                this._MisVersioningEnabled = true;
            }
            if (set.contains("addContextjava_lang_Stringjava_lang_String")) {
                this._MaddContextjava_lang_Stringjava_lang_String = true;
            }
            if (set.contains("removeContextjava_lang_String")) {
                this._MremoveContextjava_lang_String = true;
            }
            if (set.contains("getContextNames")) {
                this._MgetContextNames = true;
            }
            if (set.contains("getContextBeansjava_lang_String")) {
                this._MgetContextBeansjava_lang_String = true;
            }
            if (set.contains("getVersionIDjava_io_File")) {
                this._MgetVersionIDjava_io_File = true;
            }
            if (set.contains("getVersionIDjava_net_URL")) {
                this._MgetVersionIDjava_net_URL = true;
            }
            if (set.contains("getVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this._MgetVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("getPrefixjava_io_File")) {
                this._MgetPrefixjava_io_File = true;
            }
            if (set.contains("getPrefixjava_net_URL")) {
                this._MgetPrefixjava_net_URL = true;
            }
            if (set.contains("getPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this._MgetPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("createPrefixjava_lang_Stringjava_lang_String")) {
                this._McreatePrefixjava_lang_Stringjava_lang_String = true;
            }
            if (set.contains("getOriginalDeployableorg_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this._MgetOriginalDeployableorg_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("createJNDIBindingMBeansjava_lang_Stringjava_lang_Stringjava_lang_String")) {
                this._McreateJNDIBindingMBeansjava_lang_Stringjava_lang_Stringjava_lang_String = true;
            }
            if (set.contains("garbageCollectJNDIBindingMBeans")) {
                this._MgarbageCollectJNDIBindingMBeans = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

