/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.jonasbase;

import java.io.File;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Replace;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.ow2.jonas.ant.JOnASAntTool;
import org.ow2.jonas.ant.jonasbase.BaseTaskItf;
import org.ow2.jonas.ant.jonasbase.JTask;

public class JmsRa
extends JTask
implements BaseTaskItf {
    private static final String INFO = "[JmsRa] ";
    private static final String JONAS_JORAMRA = "joram_ra_for_jonas.rar";
    private static final String RACONFIG_CLASS = "org.ow2.jonas.generators.raconfig.RAConfig";
    private static final String DEFAULT_PORT = "16010";
    private String serverPort = "16010";

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public void execute() {
        File tmpFile = new File(System.getProperty("java.io.tmpdir"), String.valueOf(new Date().getTime()));
        String srcRarDir = this.getJonasRoot().getPath() + File.separator + "deploy";
        String dstRarDir = this.getDestDir().getPath() + File.separator + "deploy";
        String dstRarFileName = dstRarDir + File.separator + JONAS_JORAMRA;
        Copy copy = new Copy();
        JOnASAntTool.configure(this, (Task)copy);
        copy.setTodir(new File(dstRarDir));
        FilenameSelector fns1 = new FilenameSelector();
        fns1.setName(JONAS_JORAMRA);
        FileSet fs1 = new FileSet();
        fs1.setDir(new File(srcRarDir));
        fs1.addFilename(fns1);
        copy.addFileset(fs1);
        copy.setOverwrite(true);
        try {
            copy.execute();
        }
        catch (Exception rae) {
            rae.printStackTrace();
            JOnASAntTool.deleteAllFiles(tmpFile);
            throw new BuildException("[JmsRa] Cannot copy joram_ra_for_jonas.rar file : ", (Throwable)rae);
        }
        Expand jarTask = new Expand();
        JOnASAntTool.configure(this, (Task)jarTask);
        jarTask.setDest(tmpFile);
        jarTask.setSrc(new File(dstRarFileName));
        try {
            jarTask.execute();
        }
        catch (Exception rae) {
            rae.printStackTrace();
            JOnASAntTool.deleteAllFiles(tmpFile);
            throw new BuildException("[JmsRa] Cannot extract jonas-ra.xml with jar command : ", (Throwable)rae);
        }
        Replace replaceTask = new Replace();
        JOnASAntTool.configure(this, (Task)replaceTask);
        replaceTask.setFile(new File(tmpFile.getPath() + File.separator + "META-INF/jonas-ra.xml"));
        String token = "<jonas-config-property-name>ServerPort</jonas-config-property-name>\n    <jonas-config-property-value></jonas-config-property-value>";
        String value = "<jonas-config-property-name>ServerPort</jonas-config-property-name>\n    <jonas-config-property-value>" + this.serverPort + "</jonas-config-property-value>";
        replaceTask.setToken(token);
        replaceTask.setValue(value);
        try {
            replaceTask.execute();
        }
        catch (Exception rae) {
            rae.printStackTrace();
            JOnASAntTool.deleteAllFiles(tmpFile);
            throw new BuildException("[JmsRa] Cannot replace port number in the jonas-ra.xml file : ", (Throwable)rae);
        }
        Java raConfigTask = this.getBootstraptask("", false);
        String clientJar = this.getJonasRoot().getPath() + File.separator + "lib" + File.separator + "client.jar";
        String raConfigJar = this.getJonasRoot().getPath() + File.separator + "lib" + File.separator + "jonas-generators-raconfig.jar";
        Path classpath = new Path(raConfigTask.getProject(), clientJar);
        classpath.append(new Path(raConfigTask.getProject(), raConfigJar));
        raConfigTask.setClasspath(classpath);
        JOnASAntTool.configure(this, (Task)raConfigTask);
        raConfigTask.clearArgs();
        raConfigTask.createArg().setValue(RACONFIG_CLASS);
        raConfigTask.createArg().setValue("-u");
        raConfigTask.createArg().setValue(tmpFile.getPath() + File.separator + "META-INF/jonas-ra.xml");
        raConfigTask.createArg().setValue(dstRarFileName);
        try {
            raConfigTask.execute();
        }
        catch (Exception rae) {
            rae.printStackTrace();
            throw new BuildException("[JmsRa] Cannot make a resource adaptor on RAConfig: ", (Throwable)rae);
        }
        finally {
            JOnASAntTool.deleteAllFiles(tmpFile);
        }
        this.log("[JmsRa] Setting Port number to :" + this.serverPort + " in the rar '" + dstRarFileName + "'.");
    }
}

