/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.api;

import org.ow2.util.archive.api.IArchive;
import org.ow2.util.scan.api.ArchiveScanner;
import org.ow2.util.scan.api.IArchiveHelper;
import org.ow2.util.scan.api.IArchiveScannerFactory;
import org.ow2.util.scan.api.ScanException;

public abstract class ArchiveScannerFactory
implements IArchiveScannerFactory {
    private static final String REFERENCE_IMPLEMENTATION_CLASS_NAME = "org.ow2.util.scan.impl.ArchiveScannerFactoryImpl";
    private static final ThreadLocal<ArchiveScannerFactory> INSTANCE = new InheritableThreadLocal<ArchiveScannerFactory>();

    public static ArchiveScannerFactory getInstance() throws ScanException {
        ArchiveScannerFactory archiveScannerFactory = INSTANCE.get();
        if (archiveScannerFactory == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class<ArchiveScannerFactory> clazz = classLoader.loadClass(REFERENCE_IMPLEMENTATION_CLASS_NAME).asSubclass(ArchiveScannerFactory.class);
                archiveScannerFactory = clazz.newInstance();
                INSTANCE.set(archiveScannerFactory);
            }
            catch (Exception e) {
                throw new ScanException("Unable to create RI", e);
            }
        }
        return archiveScannerFactory;
    }

    public static void setInstance(ArchiveScannerFactory archiveScannerFactory) {
        INSTANCE.set(archiveScannerFactory);
    }

    public abstract ArchiveScanner createArchiveScanner(IArchive var1);

    public abstract ArchiveScanner createArchiveScanner(IArchiveHelper var1);
}

