/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.admin.CMIMBeanConfigException;
import org.ow2.cmi.admin.MBeanUtils;
import org.ow2.cmi.config.CMIConfig;
import org.ow2.cmi.controller.client.CMIClientClassLoader;
import org.ow2.cmi.controller.client.ClientClusterViewCache;
import org.ow2.cmi.controller.client.ClientClusterViewManager;
import org.ow2.cmi.controller.client.ClientClusterViewManagerException;
import org.ow2.cmi.controller.common.AbsClusterViewManager;
import org.ow2.cmi.controller.common.CMIThreadFactory;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.provider.ClientClusterViewProvider;
import org.ow2.cmi.controller.provider.ClusteredClientClusterViewProvider;
import org.ow2.cmi.info.CMIInfoExtractor;
import org.ow2.cmi.info.CMIInfoExtractorException;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.cmi.lb.data.PolicyData;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.pool.StubOrProxyFactory;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.cmi.rpc.CMIProxy;
import org.ow2.cmi.rpc.POJOInvocationHandler;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class ClientClusterViewManagerImpl
extends AbsClusterViewManager
implements ClientClusterViewManager {
    private static final Log LOGGER = LogFactory.getLog(ClientClusterViewManagerImpl.class);
    private final String initialContextFactoryName;
    private final String protocol;
    private final Thread clientClusterViewUpdater;
    private static volatile ClientClusterViewProvider clientClusterViewProvider;
    private volatile boolean clusterViewProviderAvailable = false;
    private final ClientClusterViewCache clientClusterViewCache = new ClientClusterViewCache();

    private ClientClusterViewManagerImpl(String initialContextFactoryName, String protocol) {
        this.initialContextFactoryName = initialContextFactoryName;
        this.protocol = protocol;
        CMIThreadFactory cmiThreadFactory = this.getCmiThreadFactory();
        this.clientClusterViewUpdater = cmiThreadFactory.newThread(new Runnable(){

            public void run() {
                try {
                    clientClusterViewProvider.registerClient(ClientClusterViewManagerImpl.this.getUUID());
                }
                catch (Exception e) {
                    LOGGER.debug((Object)"Thread {0}> Cannot register the client", new Object[]{Thread.currentThread().getName(), e});
                }
                while (true) {
                    int refreshTime;
                    try {
                        refreshTime = ClientClusterViewManagerImpl.this.getDelayToRefresh();
                    }
                    catch (Exception e) {
                        refreshTime = 10000;
                    }
                    LOGGER.debug((Object)"Thread {0} is sleeping for {1} millis...", new Object[]{Thread.currentThread().getName(), refreshTime});
                    try {
                        Thread.sleep(refreshTime);
                    }
                    catch (InterruptedException e) {
                        LOGGER.debug((Object)"Thread client interrupted", new Object[]{e});
                    }
                    LOGGER.debug((Object)"Thread {0}> Updating the client cluster view...", new Object[]{Thread.currentThread().getName()});
                    try {
                        ClientClusterViewManagerImpl.this.updateClusterView();
                        ClientClusterViewManagerImpl.this.clusterViewProviderAvailable = true;
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"Thread {0}> Cannot update the cluster view", new Object[]{Thread.currentThread().getName(), e});
                        continue;
                    }
                    break;
                }
            }
        });
    }

    public static synchronized ClientClusterViewManager getClientClusterViewManager(String initialContextFactoryName, String protocol, List<ServerRef> serverRefs) throws ClientClusterViewManagerException {
        ClusterViewManager clusterViewManager = AbsClusterViewManager.getClusterViewManager();
        if (clusterViewManager == null) {
            LOGGER.debug((Object)"Constructing a ClientClusterviewManager...", new Object[0]);
            ClientClusterViewManagerImpl clientClusterViewManager = new ClientClusterViewManagerImpl(initialContextFactoryName, protocol);
            clientClusterViewManager.initDataOfProvider(serverRefs);
            clientClusterViewManager.initDataOfDummyRegistry();
            clientClusterViewManager.clientClusterViewUpdater.start();
            if (CMIConfig.isEmbedded()) {
                try {
                    MBeanUtils.initCMIMBean();
                }
                catch (CMIMBeanConfigException e) {
                    LOGGER.error((Object)"Cannot initializes CMIMBean", new Object[]{e});
                }
                try {
                    MBeanUtils.registerCMIMBean(clientClusterViewManager);
                }
                catch (CMIMBeanConfigException e) {
                    LOGGER.error((Object)"Cannot registers CMIMBean", new Object[]{e});
                }
            }
            clusterViewManager = clientClusterViewManager;
            AbsClusterViewManager.setClusterViewManager(clusterViewManager);
            LOGGER.info((Object)"The client-side manager was successfully started", new Object[0]);
        } else if (!(clusterViewManager instanceof ClientClusterViewManager)) {
            LOGGER.error((Object)"An instance of the manager that is not a ClientClusterViewManager already exists in the JVM", new Object[0]);
            throw new ClientClusterViewManagerException("An instance of the manager that is not a ClientClusterViewManager already exists in the JVM");
        }
        return (ClientClusterViewManager)clusterViewManager;
    }

    private void initDataOfProvider(List<ServerRef> serverRefs) throws ClientClusterViewManagerException {
        ClusteredObjectInfo clusteredObjectInfo;
        LOGGER.debug((Object)"**** Begin of initialization of the connection at provider...", new Object[0]);
        String providerName = CMIConfig.getBindNameForProvider();
        ArrayList<CMIReference> cmiReferences = new ArrayList<CMIReference>();
        for (ServerRef serverRef : serverRefs) {
            cmiReferences.add(new CMIReference(serverRef, providerName));
        }
        this.clientClusterViewCache.setCMIReferences(providerName, cmiReferences);
        try {
            clusteredObjectInfo = CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(providerName, ClientClusterViewProvider.class, ClusteredClientClusterViewProvider.class, false, false, null);
        }
        catch (CMIInfoExtractorException e) {
            LOGGER.error((Object)"Cannot extract the informations about provider", new Object[]{e});
            throw new ClientClusterViewManagerException("Cannot extract the informations about provider", e);
        }
        this.clientClusterViewCache.setItfName(providerName, ClientClusterViewProvider.class);
        Class<IPolicy<?>> policyClass = clusteredObjectInfo.getPolicyType();
        Class<IStrategy<?>> strategyClass = clusteredObjectInfo.getStrategyType();
        String policyClassname = policyClass.getName();
        String strategyClassname = strategyClass.getName();
        PolicyData policyDataForProvider = new PolicyData(policyClassname, strategyClassname, clusteredObjectInfo.getProperties());
        this.clientClusterViewCache.setPolicyData(providerName, policyDataForProvider);
        this.clientClusterViewCache.setPolicyClass(policyClassname, policyClass);
        this.clientClusterViewCache.setStrategyClass(strategyClassname, strategyClass);
        this.watch(providerName);
        try {
            this.updatePolicy(providerName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Cannot initialize informations of the provider", new Object[]{e});
            throw new ClientClusterViewManagerException("Cannot initialize informations of the provider", e);
        }
        JPool pool = new JPool((PoolFactory)new StubOrProxyFactory(this));
        pool.setPoolConfiguration(clusteredObjectInfo.getPoolConfiguration());
        this.setPool(providerName, (Pool<CMIReferenceable<?>, CMIReference>)pool);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        POJOInvocationHandler invocationHandler = new POJOInvocationHandler(classLoader, this, providerName, this.protocol, ClientClusterViewProvider.class);
        clientClusterViewProvider = (ClientClusterViewProvider)Proxy.newProxyInstance(classLoader, new Class[]{ClientClusterViewProvider.class, CMIProxy.class}, (InvocationHandler)invocationHandler);
        try {
            this.pullAndUpdateObjectInfos(providerName);
            this.clusterViewProviderAvailable = true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Provider not found", new Object[]{e});
        }
        LOGGER.debug((Object)"**** End of initialization of the connection at provider.", new Object[0]);
    }

    private void initDataOfDummyRegistry() {
        String dummyName = CMIConfig.getBindNameForDummyRegistry();
        this.watch(dummyName);
        try {
            this.pullAndUpdateObjectInfos(dummyName);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Dummy registry not found", new Object[]{e});
        }
    }

    @Override
    public synchronized void addObjectToWatch(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        if (!this.isWatched(objectName)) {
            Set<String> applicationExceptionNames;
            boolean hasState;
            String itfName;
            LOGGER.debug((Object)"Initializing local data for object with name {0}", new Object[]{objectName});
            try {
                itfName = clientClusterViewProvider.getItfName(objectName);
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"Cannot pull the name of interface for object with name {0}", new Object[]{objectName, e});
                throw new ClientClusterViewManagerException("Cannot get pull the name of interface for object with name " + objectName, e);
            }
            ClassLoader currentCLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> itfClass = Class.forName(itfName, true, currentCLoader);
                this.clientClusterViewCache.setItfName(objectName, itfClass);
            }
            catch (ClassNotFoundException e) {
                throw new ClientClusterViewManagerException("Cannot load the interface for name " + itfName, e);
            }
            if (Arrays.asList(this.getInterface(objectName).getInterfaces()).contains(EJBHome.class)) {
                String businessName;
                try {
                    businessName = clientClusterViewProvider.getBusinessName(objectName);
                }
                catch (RemoteException e) {
                    LOGGER.error((Object)"Cannot pull the name of business interface for object with name {0}", new Object[]{objectName, e});
                    throw new ClientClusterViewManagerException("Cannot get pull the name of business interface for object with name " + objectName, e);
                }
                try {
                    Class<?> businessClass = Class.forName(businessName, true, currentCLoader);
                    this.clientClusterViewCache.setBusinessName(objectName, businessClass);
                }
                catch (ClassNotFoundException e) {
                    throw new ClientClusterViewManagerException("Cannot load the business interface for name " + businessName, e);
                }
            }
            try {
                hasState = clientClusterViewProvider.hasState(objectName);
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"Cannot know if the object with name {0} has a state", new Object[]{objectName, e});
                throw new ClientClusterViewManagerException("Cannot know if the object with name " + objectName + " has a state", e);
            }
            if (hasState) {
                boolean replicated;
                this.clientClusterViewCache.setState(objectName);
                try {
                    replicated = clientClusterViewProvider.isReplicated(objectName);
                }
                catch (RemoteException e) {
                    LOGGER.error((Object)"Cannot know if the object with name {0} has a state", new Object[]{objectName, e});
                    throw new ClientClusterViewManagerException("Cannot know if the object with name " + objectName + " has a state", e);
                }
                if (replicated) {
                    this.clientClusterViewCache.setReplicated(objectName);
                }
            }
            try {
                applicationExceptionNames = clientClusterViewProvider.getApplicationExceptions(objectName);
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"Cannot get the application exception names for the object with name {0}", new Object[]{objectName, e});
                throw new ClientClusterViewManagerException("Cannot get the application exception names for the object with name " + objectName, e);
            }
            this.clientClusterViewCache.setApplicationExceptionNames(objectName, applicationExceptionNames);
            this.watch(objectName);
            this.pullAndUpdateObjectInfos(objectName);
        }
    }

    @Override
    public Class<?> getInterface(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        Class<?> itfName = this.clientClusterViewCache.getItfName(objectName);
        if (itfName == null) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return itfName;
    }

    @Override
    public Class<? extends EJBObject> getRemoteClass(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        Class<? extends EJBObject> businessName = this.clientClusterViewCache.getBusinessName(objectName);
        if (businessName == null) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return businessName;
    }

    @Override
    public Class<? extends IPolicy<?>> getPolicyClass(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        String classname = this.getPolicyClassName(objectName);
        Class<? extends IPolicy<?>> policy = this.clientClusterViewCache.getPolicyClass(classname);
        if (policy == null) {
            try {
                policy = this.pullPolicyClass(objectName);
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"Cannot set the class of policy for {0}", new Object[]{objectName, e});
                throw new ClientClusterViewManagerException("Cannot set the class of policy for " + objectName, e);
            }
            this.clientClusterViewCache.setPolicyClass(classname, policy);
        }
        return policy;
    }

    @Override
    public Class<? extends IStrategy<?>> getStrategyClass(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        String classname = this.getStrategyClassName(objectName);
        Class<? extends IStrategy<?>> strategy = this.clientClusterViewCache.getStrategyClass(classname);
        if (strategy == null) {
            try {
                strategy = this.pullStrategyClass(objectName);
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"Cannot set the class of strategy for {0}", new Object[]{objectName, e});
                throw new ClientClusterViewManagerException("Cannot set the class of strategy for " + objectName, e);
            }
            this.clientClusterViewCache.setStrategyClass(classname, strategy);
        }
        return strategy;
    }

    @Override
    public List<CMIReference> getCMIReferences(String objectName, String protocolName) throws ObjectNotFoundException {
        List<CMIReference> cmiReferences = this.clientClusterViewCache.getCMIReferences(objectName);
        if (cmiReferences == null) {
            LOGGER.debug((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return cmiReferences;
    }

    @Override
    public long getDateOfProperties(String objectName) throws ObjectNotFoundException {
        PolicyData lbPolicyData = this.clientClusterViewCache.getPolicyData(objectName);
        if (lbPolicyData == null) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return lbPolicyData.getDateOfProperties();
    }

    private Class<? extends IPolicy<?>> pullPolicyClass(String objectName) throws ObjectNotFoundException, RemoteException {
        Class<? extends IPolicy<?>> policyClass;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new CMIClientClassLoader(oldClassLoader, this));
        try {
            policyClass = clientClusterViewProvider.getPolicyClass(objectName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Cannot download the policy class for {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot download the policy class for " + objectName, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return policyClass;
    }

    private Class<? extends IStrategy<?>> pullStrategyClass(String objectName) throws RemoteException, ObjectNotFoundException {
        Class<? extends IStrategy<?>> strategyClass;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new CMIClientClassLoader(oldClassLoader, this));
        try {
            strategyClass = clientClusterViewProvider.getStrategyClass(objectName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Cannot download the strategy class for {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot download the strategy class for " + objectName, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return strategyClass;
    }

    @Override
    public boolean isPoolToEmpty(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        try {
            return clientClusterViewProvider.isPoolToEmpty(objectName);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)"Cannot pull the flag to reset or no the pool for object {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot pull the flag to reset or no the pool for object " + objectName, e);
        }
    }

    @Override
    public Map<String, Object> getPropertiesForPolicy(String objectName) throws ObjectNotFoundException {
        PolicyData policyData = this.clientClusterViewCache.getPolicyData(objectName);
        if (policyData == null) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return policyData.getProperties();
    }

    @Override
    public Object getPropertyForPolicy(String objectName, String propertyName) throws ObjectNotFoundException {
        PolicyData policyData = this.clientClusterViewCache.getPolicyData(objectName);
        if (policyData == null) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return policyData.getProperties().get(propertyName);
    }

    @Override
    public String getInitialContextFactoryName(String protocolName) {
        return this.initialContextFactoryName;
    }

    @Override
    public Set<String> getProtocols() {
        return Collections.singleton(this.protocol);
    }

    @Override
    public byte[] getBytecode(String binaryName) throws ClientClusterViewManagerException {
        try {
            return clientClusterViewProvider.getBytecode(binaryName);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot get bytecode for {0}", new Object[]{binaryName, e});
            throw new ClientClusterViewManagerException("Cannot get bytecode for " + binaryName, e);
        }
    }

    @Override
    public boolean isClustered(String objectName) throws ClientClusterViewManagerException {
        try {
            return clientClusterViewProvider.isClustered(objectName);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)"Connection has failed", new Object[]{e});
            throw new ClientClusterViewManagerException("Connection has failed", e);
        }
    }

    @Override
    public int getDelayToRefresh() throws ClientClusterViewManagerException {
        try {
            return clientClusterViewProvider.getDelayToRefresh();
        }
        catch (RemoteException e) {
            LOGGER.error((Object)"Cannot get delay to refresh", new Object[]{e});
            throw new ClientClusterViewManagerException("Cannot get delay to refresh", e);
        }
    }

    @Override
    public String getPolicyClassName(String objectName) throws ObjectNotFoundException {
        PolicyData policyData = this.clientClusterViewCache.getPolicyData(objectName);
        if (policyData == null) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return policyData.getPolicyType();
    }

    @Override
    public String getStrategyClassName(String objectName) throws ObjectNotFoundException {
        PolicyData policyData = this.clientClusterViewCache.getPolicyData(objectName);
        if (policyData == null) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return policyData.getStrategyType();
    }

    @Override
    public String getClusterName(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        try {
            return clientClusterViewProvider.getClusterName(objectName);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)"Cannot get name of cluster for object with name {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot get name of cluster for object with name " + objectName, e);
        }
    }

    @Override
    public void pullAndUpdateObjectInfos(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        LOGGER.debug((Object)"Updating infos for: {0} - thread is {1}", new Object[]{objectName, Thread.currentThread().getName()});
        try {
            this.pullAndUpdatePolicy(objectName);
            this.pullAndUpdateCMIReferences(objectName);
            if (this.hasPool(objectName)) {
                this.pullAndUpdatePoolConfiguration(objectName);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot pull the informations for object with name {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot pull the informations for object with name " + objectName, e);
        }
    }

    @Override
    public void updateClusterView() throws ClientClusterViewManagerException {
        for (String objectName : this.getNamesOfWatchedObject()) {
            try {
                this.pullAndUpdateObjectInfos(objectName);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.fatal((Object)"The object with name {0} is unknown", new Object[]{objectName, e});
                throw new ClientClusterViewManagerException("The object with name " + objectName + " is unknown", e);
            }
        }
        this.pullAndUpdateLoadFactors();
    }

    private void pullAndUpdatePolicy(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException, RemoteException {
        String lastPolicyName = clientClusterViewProvider.getPolicyClassName(objectName);
        if (lastPolicyName == null) {
            LOGGER.error((Object)"The new name of policy is null.", new Object[0]);
            throw new ClientClusterViewManagerException("The new name of policy is null.");
        }
        LOGGER.debug((Object)"New policy name: {0}", new Object[]{lastPolicyName});
        String lastStrategyName = clientClusterViewProvider.getStrategyClassName(objectName);
        if (lastStrategyName == null) {
            LOGGER.error((Object)"The new name of strategy is null.", new Object[0]);
            throw new ClientClusterViewManagerException("The new name of strategy is null.");
        }
        LOGGER.debug((Object)"New strategy name: {0}", new Object[]{lastStrategyName});
        long dateOfLastProps = clientClusterViewProvider.getDateOfProperties(objectName);
        LOGGER.debug((Object)"New date of properties: {0}", new Object[]{dateOfLastProps});
        if (this.clientClusterViewCache.getPolicyData(objectName) != null) {
            String policyName = this.getPolicyClassName(objectName);
            LOGGER.debug((Object)"Old policy name: {0}", new Object[]{policyName});
            long dateOfProps = this.getDateOfProperties(objectName);
            LOGGER.debug((Object)"Old date of properties: {0}", new Object[]{dateOfProps});
            String strategyName = this.getStrategyClassName(objectName);
            LOGGER.debug((Object)"Old strategy name: {0}", new Object[]{strategyName});
            if (policyName.equals(lastPolicyName) && dateOfProps == dateOfLastProps && strategyName.equals(lastStrategyName)) {
                return;
            }
        }
        Map<Object, Object> lastProperties = dateOfLastProps == 0L ? new HashMap() : clientClusterViewProvider.getPropertiesForPolicy(objectName);
        this.clientClusterViewCache.setPolicyData(objectName, new PolicyData(lastPolicyName, lastStrategyName, lastProperties, dateOfLastProps));
        try {
            this.updatePolicy(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Cannot get policy for object {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot get policy for object " + objectName, e);
        }
    }

    private void pullAndUpdateCMIReferences(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException, RemoteException {
        List<CMIReference> cmiReferences = clientClusterViewProvider.getCMIReferences(objectName, this.protocol);
        if (cmiReferences == null) {
            LOGGER.error((Object)"The new node list for {0} is null", new Object[]{objectName});
            throw new ClientClusterViewManagerException("The new node list for " + objectName + " is null");
        }
        for (CMIReference cmiRef : cmiReferences) {
            this.pullAndUpdateMissingLoadFactor(cmiRef.getServerRef());
        }
        this.clientClusterViewCache.setCMIReferences(objectName, cmiReferences);
    }

    private void pullAndUpdatePoolConfiguration(String objectName) throws ObjectNotFoundException {
        IPoolConfiguration poolConfiguration = this.getPoolConfiguration(objectName);
        if (poolConfiguration != null) {
            this.getPool(objectName).setPoolConfiguration(poolConfiguration);
        }
    }

    private void pullAndUpdateMissingLoadFactor(ServerRef serverRef) {
        try {
            this.clientClusterViewCache.getLoadFactor(serverRef);
        }
        catch (NullPointerException npe) {
            try {
                int loadFactor = clientClusterViewProvider.getLoadFactor(serverRef);
                this.clientClusterViewCache.setLoadFactor(serverRef, loadFactor);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Cannot pull the load factor for server with address {0}", new Object[]{serverRef, e});
                throw new ClientClusterViewManagerException("Cannot pull the load factor for server with address " + serverRef, e);
            }
        }
    }

    private void pullAndUpdateLoadFactors() {
        for (ServerRef address : this.clientClusterViewCache.getAddressesOfServer()) {
            try {
                int loadFactor = clientClusterViewProvider.getLoadFactor(address);
                this.clientClusterViewCache.setLoadFactor(address, loadFactor);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Cannot pull the load factor for server with address {0}", new Object[]{address, e});
                throw new ClientClusterViewManagerException("Cannot pull the load factor for server with address " + address, e);
            }
        }
    }

    @Override
    public IPoolConfiguration getPoolConfiguration(String objectName) throws ObjectNotFoundException {
        try {
            return clientClusterViewProvider.getPoolConfiguration(objectName);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)"Cannot get the configuration of pool for object with name {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot get the configuration of pool for object with name " + objectName, e);
        }
    }

    @Override
    public int getLoadFactor(ServerRef serverRef) {
        return this.clientClusterViewCache.getLoadFactor(serverRef);
    }

    @Override
    public boolean hasState(String objectName) throws ObjectNotFoundException {
        return this.clientClusterViewCache.hasState(objectName);
    }

    @Override
    public boolean isReplicated(String objectName) throws ObjectNotFoundException {
        return this.clientClusterViewCache.isReplicated(objectName);
    }

    @Override
    public Set<String> getApplicationExceptionNames(String objectName) throws ObjectNotFoundException {
        return this.clientClusterViewCache.getApplicationExceptionNames(objectName);
    }

    @Override
    public Set<String> getObjectNames() {
        return this.clientClusterViewCache.getObjectNames();
    }

    @Override
    public boolean isClusterViewProviderAvailable() {
        return this.clusterViewProviderAvailable;
    }
}

