/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server.manager;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.ow2.cmi.controller.server.AbsServerClusterViewManager;
import org.ow2.cmi.controller.server.IPolicyStrategyManager;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.cmi.controller.server.manager.PolicyStrategyManagerException;
import org.ow2.cmi.controller.server.manager.PolicyStrategyManagerUtil;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.loader.ArchiveId;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPolicyStrategyManager
implements IPolicyStrategyManager {
    private static final Log LOGGER = LogFactory.getLog(AbsServerClusterViewManager.class);
    private final ConcurrentHashMap<String, Class<? extends IPolicy>> policyMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<? extends IStrategy>> strategyMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> defaultStrategyMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> defaultPolicyMap = new ConcurrentHashMap();
    private ServerClusterViewManager serverClusterViewManager = null;

    public DefaultPolicyStrategyManager() {
    }

    public DefaultPolicyStrategyManager(ServerClusterViewManager srvClusterViewManager) {
        this.serverClusterViewManager = srvClusterViewManager;
    }

    @Override
    public final Class<? extends IPolicy<?>> getPolicyClass(String objectName) throws ObjectNotFoundException, ServerClusterViewManagerException {
        String policyClassName = this.serverClusterViewManager.getPolicyClassName(objectName);
        if (this.policyMap.containsKey(policyClassName)) {
            return this.policyMap.get(policyClassName);
        }
        try {
            Class<?> policyClass = Class.forName(policyClassName);
            this.policyMap.putIfAbsent(policyClassName, policyClass);
            return policyClass;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)("Cannot load the class for policy " + policyClassName), new Object[]{e});
            throw new ServerClusterViewManagerException("Cannot load the class for policy " + policyClassName, e);
        }
    }

    @Override
    public final Class<? extends IStrategy<?>> getStrategyClass(String objectName) throws ObjectNotFoundException, ServerClusterViewManagerException {
        String strategyClassName = this.serverClusterViewManager.getStrategyClassName(objectName);
        if (this.strategyMap.containsKey(strategyClassName)) {
            return this.strategyMap.get(strategyClassName);
        }
        try {
            Class<?> strategyClass = Class.forName(strategyClassName);
            this.strategyMap.putIfAbsent(strategyClassName, strategyClass);
            return strategyClass;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)("Cannot load the class for strategy " + strategyClassName), new Object[]{e});
            throw new ServerClusterViewManagerException("Cannot load the class for strategy " + strategyClassName, e);
        }
    }

    @Override
    public Object addLoadBalancingArchive(byte[] bytesOfFile, String location, Class<?>[] policies, Class<?>[] strategies) {
        LOGGER.debug((Object)"Sending load balancing archive located at '{0}'. Step 4: policy/strategy manager is sending archive data to be distrubuted in the JGroups cluster", new Object[]{location});
        ArchiveId id = PolicyStrategyManagerUtil.buildArchiveId(this.serverClusterViewManager.getUUID().toString(), location);
        LOGGER.debug((Object)"Archive Id is '{0}'", new Object[]{id.toString()});
        for (Class<?> policy : policies) {
            this.policyMap.put(policy.getName(), policy);
        }
        for (Class<?> strategy : strategies) {
            this.strategyMap.put(strategy.getName(), strategy);
        }
        if (!((AbsServerClusterViewManager)this.serverClusterViewManager).isAlreadyDistributed(id.toString())) {
            ((AbsServerClusterViewManager)this.serverClusterViewManager).broadCastArchive(id, bytesOfFile);
        }
        return id.toString();
    }

    public ServerClusterViewManager getServerClusterViewManager() {
        return this.serverClusterViewManager;
    }

    public void setServerClusterViewManager(ServerClusterViewManager serverClusterViewManager) {
        this.serverClusterViewManager = serverClusterViewManager;
    }

    @Override
    public void addPolicyClass(Class<? extends IPolicy<?>> policyClass, boolean overwrite) throws ServerClusterViewManagerException {
        if (overwrite && this.policyMap.contains(policyClass.getName())) {
            this.policyMap.remove(policyClass.getName());
            this.policyMap.put(policyClass.getName(), policyClass);
            return;
        }
        this.policyMap.putIfAbsent(policyClass.getName(), policyClass);
    }

    @Override
    public void addStrategyClass(Class<? extends IStrategy<?>> strategyClass, boolean overwrite) throws ServerClusterViewManagerException {
        if (overwrite && this.strategyMap.contains(strategyClass.getName())) {
            this.strategyMap.remove(strategyClass.getName());
            this.strategyMap.put(strategyClass.getName(), strategyClass);
            return;
        }
        this.strategyMap.putIfAbsent(strategyClass.getName(), strategyClass);
    }

    @Override
    public void removeLoadBalancingArchive(Object archiveId, String[] policies, String[] strategies, boolean isArchiveOwner) throws Exception {
        Set<String> objects = this.serverClusterViewManager.getObjectNames();
        for (String policy : policies) {
            for (String objectName : objects) {
                String objectPolicyName = this.serverClusterViewManager.getPolicyClassName(objectName);
                if (!objectPolicyName.equals(policy) || !isArchiveOwner) continue;
                this.serverClusterViewManager.setPolicyClassName(objectName, this.getDefaultPolicyClassName(objectName));
            }
            this.policyMap.remove(policy);
        }
        objects = this.serverClusterViewManager.getObjectNames();
        for (String strategy : strategies) {
            for (String objectName : objects) {
                String objectStrategyName = this.serverClusterViewManager.getStrategyClassName(objectName).getClass().getName();
                if (!objectStrategyName.equals(strategy) || !isArchiveOwner) continue;
                this.serverClusterViewManager.setStrategyClassName(objectName, this.getDefaultStrategyClassName(objectName));
            }
            this.strategyMap.remove(strategy);
        }
        if (isArchiveOwner) {
            ((AbsServerClusterViewManager)this.serverClusterViewManager).removeDistributedArchive(archiveId);
        }
    }

    private String getDefaultPolicyClassName(String objectName) throws PolicyStrategyManagerException {
        if (this.defaultPolicyMap.containsKey(objectName)) {
            return this.defaultPolicyMap.get(objectName);
        }
        throw new PolicyStrategyManagerException("No default policy found for " + objectName);
    }

    private String getDefaultStrategyClassName(String objectName) throws PolicyStrategyManagerException {
        if (this.defaultStrategyMap.contains(objectName)) {
            return this.defaultStrategyMap.get(objectName);
        }
        throw new PolicyStrategyManagerException("No default strategy found for " + objectName);
    }

    @Override
    public void addDefaultPolicyClassName(String objectName, String policyClassName) {
        LOGGER.debug((Object)"Object: {0}, default policy:{1} ", new Object[]{objectName, policyClassName});
        this.defaultPolicyMap.putIfAbsent(objectName, policyClassName);
    }

    @Override
    public void addDefaultStrategyClassName(String objectName, String strategyClassName) {
        LOGGER.debug((Object)"Object: {0}, default strategy:{1} ", new Object[]{objectName, strategyClassName});
        this.defaultStrategyMap.putIfAbsent(objectName, strategyClassName);
    }

    @Override
    public Collection<? extends String> getPolicyClassNames() {
        return this.policyMap.keySet();
    }

    @Override
    public Collection<? extends String> getStrategyClassNames() {
        return this.strategyMap.keySet();
    }
}

