/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.lb.loader;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancingClassLoader
extends URLClassLoader {
    private static final Log LOGGER = LogFactory.getLog(LoadBalancingClassLoader.class);
    private String name = null;
    private boolean recomputeToString = true;
    private boolean recomputeClassPath = true;
    private String toStringValue = null;
    private String classpath = null;
    private final ConcurrentHashMap<String, Class<? extends IStrategy>> strategyMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<? extends IPolicy>> policyMap = new ConcurrentHashMap();

    public LoadBalancingClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.name = name;
        this.recomputeToString = true;
        this.recomputeClassPath = true;
    }

    public LoadBalancingClassLoader(String name, URL[] urls) {
        super(urls, Thread.currentThread().getContextClassLoader());
        this.name = name;
        this.recomputeToString = true;
        this.recomputeClassPath = true;
    }

    @Override
    public void addURL(URL url) {
        if (url != null) {
            super.addURL(url);
        }
        this.recomputeToString = true;
        this.recomputeClassPath = true;
    }

    public void addURLs(URL[] urls) {
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                if (urls[i] == null) continue;
                super.addURL(urls[i]);
            }
        }
        this.recomputeToString = true;
        this.recomputeClassPath = true;
    }

    public void printURLs() {
        System.out.println(this.name + " ClassLoader :");
        URL[] urls = super.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            System.out.println("url=" + new File(urls[i].getFile()).getAbsolutePath());
        }
        if (this.getParent() != null && this.getParent() instanceof LoadBalancingClassLoader) {
            System.out.println("parent :");
            ((LoadBalancingClassLoader)this.getParent()).printURLs();
        }
    }

    public String getClassPath() {
        if (this.recomputeClassPath) {
            this.computeClassPath();
        }
        return this.classpath;
    }

    public String toString() {
        if (this.recomputeToString) {
            this.computeToString();
        }
        return this.toStringValue;
    }

    private void computeToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[");
        sb.append(this.name);
        sb.append(", urls=");
        URL[] urls = this.getURLs();
        for (int u = 0; u < urls.length; ++u) {
            sb.append(urls[u]);
            if (u == urls.length - 1) continue;
            sb.append(";");
        }
        sb.append("]");
        this.toStringValue = sb.toString();
        this.recomputeToString = false;
    }

    private void computeClassPath() {
        String cp = "";
        if (this.getParent() != null && this.getParent() instanceof LoadBalancingClassLoader) {
            cp = cp + ((LoadBalancingClassLoader)this.getParent()).getClassPath();
        }
        URL[] urls = super.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            cp = cp + File.pathSeparator + new File(urls[i].getFile()).getAbsolutePath();
        }
        this.classpath = cp;
        this.recomputeClassPath = false;
    }

    public void compute(Iterator<URL> archiveIterator) {
        LOGGER.debug((Object)(" Trying to get load balacing strategies and policies from URLs '" + this.getURLs() + "'"), new Object[0]);
        block4: while (true) {
            try {
                while (archiveIterator.hasNext()) {
                    URL url = archiveIterator.next();
                    if (!url.toExternalForm().endsWith(".class")) continue;
                    try {
                        String className = LoadBalancingClassLoader.getClassName(url.toExternalForm());
                        Class<?> myclass = this.loadClass(className);
                        Class[] args = new Class[]{List.class};
                        if (IPolicy.class.isInstance(myclass.getClassLoader())) {
                            LOGGER.debug((Object)("loading policy class named '" + className + "'"), new Object[0]);
                            this.policyMap.put(className, myclass);
                            continue block4;
                        }
                        if (!IStrategy.class.isInstance(myclass)) continue block4;
                        this.strategyMap.put(className, myclass);
                        continue block4;
                    }
                    catch (Exception exception) {
                    }
                }
                break;
            }
            catch (Exception exception) {
                // empty catch block
                break;
            }
        }
    }

    public ConcurrentHashMap<String, Class<? extends IStrategy>> getStrategyMap() {
        return this.strategyMap;
    }

    public ConcurrentHashMap<String, Class<? extends IPolicy>> getPolicyMap() {
        return this.policyMap;
    }

    private static String getClassName(String filePath) {
        int id = filePath.lastIndexOf("!");
        String unformattedClsName = filePath.substring(id + 2).replace(".class", "");
        String ret = unformattedClsName.replaceAll("/", ".");
        return ret;
    }

    private static boolean isA(Class<?> someClass, Class superItf) {
        Class<?>[] itfs = someClass.getInterfaces();
        for (int i = 0; i < itfs.length; ++i) {
            if (!itfs[i].getName().equals(superItf.getName())) continue;
            return true;
        }
        return false;
    }
}

