/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.imr.AdminPackage.IllegalServerName;
import org.jacorb.imr.ImRPOAInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.ResourceLock;
import org.jacorb.imr.ServerInfo;

public class ImRServerInfo
implements Serializable {
    protected String command;
    protected boolean holding = false;
    protected String host;
    protected String name;
    protected boolean active;
    protected boolean restarting = false;
    private Vector poas = null;
    private ResourceLock poas_lock = null;

    public ImRServerInfo(String string, String string2, String string3) throws IllegalServerName {
        if (string == null || string.length() == 0) {
            throw new IllegalServerName(string);
        }
        this.name = string;
        this.host = string2;
        this.command = string3;
        this.active = false;
        this.poas = new Vector();
        this.poas_lock = new ResourceLock();
    }

    public ServerInfo toServerInfo() {
        this.poas_lock.gainExclusiveLock();
        POAInfo[] pOAInfoArray = new POAInfo[this.poas.size()];
        Enumeration enumeration = this.poas.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            pOAInfoArray[n++] = ((ImRPOAInfo)enumeration.nextElement()).toPOAInfo();
        }
        this.poas_lock.releaseExclusiveLock();
        return new ServerInfo(this.name, this.command, pOAInfoArray, this.host, this.active, this.holding);
    }

    public void addPOA(ImRPOAInfo imRPOAInfo) {
        if (!this.active) {
            this.active = true;
        }
        this.poas_lock.gainSharedLock();
        this.poas.addElement(imRPOAInfo);
        this.poas_lock.releaseSharedLock();
    }

    protected String[] getPOANames() {
        String[] stringArray = new String[this.poas.size()];
        Enumeration enumeration = this.poas.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = ((ImRPOAInfo)enumeration.nextElement()).name;
        }
        return stringArray;
    }

    public void setDown() {
        for (int i = 0; i < this.poas.size(); ++i) {
            ((ImRPOAInfo)this.poas.elementAt((int)i)).active = false;
        }
        this.active = false;
        this.restarting = false;
    }

    public synchronized void awaitRelease() {
        while (this.holding) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void release() {
        this.holding = false;
        this.notifyAll();
    }

    public synchronized boolean shouldBeRestarted() {
        boolean bl;
        boolean bl2 = bl = !this.active && !this.restarting;
        if (bl) {
            this.restarting = true;
        }
        return bl;
    }

    public void setNotRestarting() {
        this.restarting = false;
    }
}

