/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.spi;

import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.carol.jndi.spi.MultiContext;
import org.ow2.jonas.versioning.VersioningService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualJNDILookup
extends MultiContext {
    private static Log logger = LogFactory.getLog(VirtualJNDILookup.class);
    private Hashtable<?, ?> environment;
    private static VersioningService versioningService;

    public VirtualJNDILookup(Hashtable<?, ?> env) throws NamingException {
        super(env);
        this.environment = env;
    }

    public Object lookup(String name) throws NamingException {
        String prefix = this.getPrefix();
        if (prefix != null) {
            Object result;
            try {
                result = super.lookup(prefix + name);
            }
            catch (NamingException ignored) {
                result = null;
            }
            if (result != null) {
                return result;
            }
            logger.info((Object)("No object found for the JNDI name '" + name + "' and prefix '" + prefix + "'. Now looking up for non-prefixed version of the same name."));
        }
        return super.lookup(name);
    }

    public Object lookup(Name name) throws NamingException {
        String prefix = this.getPrefix();
        if (prefix != null) {
            Object result;
            try {
                result = super.lookup(prefix + name);
            }
            catch (NamingException ignored) {
                result = null;
            }
            if (result != null) {
                return result;
            }
            logger.info((Object)("No object found for the JNDI name '" + name + "' and prefix '" + prefix + "'. Now looking up for non-prefixed version of the same name."));
        }
        return super.lookup(name);
    }

    public Object lookupLink(String name) throws NamingException {
        String prefix = this.getPrefix();
        if (prefix != null) {
            Object result;
            try {
                result = super.lookupLink(prefix + name);
            }
            catch (NamingException ignored) {
                result = null;
            }
            if (result != null) {
                return result;
            }
            logger.info((Object)("No object found for the JNDI name '" + name + "' and prefix '" + prefix + "'. Now looking up for non-prefixed version of the same name."));
        }
        return super.lookupLink(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        String prefix = this.getPrefix();
        if (prefix != null) {
            Object result;
            try {
                result = super.lookupLink(prefix + name);
            }
            catch (NamingException ignored) {
                result = null;
            }
            if (result != null) {
                return result;
            }
            logger.info((Object)("No object found for the JNDI name '" + name + "' and prefix '" + prefix + "'. Now looking up for non-prefixed version of the same name."));
        }
        return super.lookupLink(name);
    }

    protected String getPrefix() {
        String prefix;
        try {
            prefix = (String)new MultiContext(this.environment).lookup("java:comp/env/JNDILookupPrefix");
        }
        catch (NamingException e) {
            prefix = null;
        }
        if (prefix != null) {
            return prefix;
        }
        return null;
    }

    public static void setVersioningService(VersioningService versioningService) {
        VirtualJNDILookup.versioningService = versioningService;
    }

    public static void unsetVersioningService() {
        versioningService = null;
    }

    public static VersioningService getVersioningService() {
        return versioningService;
    }
}

