/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.auth;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.auth.Authenticator;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnknownUserException;
import org.apache.juddi.util.Config;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLDocAuthenticator
implements ContentHandler,
ErrorHandler,
Authenticator {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$auth$XMLDocAuthenticator == null ? (class$org$apache$juddi$auth$XMLDocAuthenticator = XMLDocAuthenticator.class$("org.apache.juddi.auth.XMLDocAuthenticator")) : class$org$apache$juddi$auth$XMLDocAuthenticator);
    private static final String FILE_NAME_KEY = "juddi.users";
    private static final String DEFAULT_FILE_NAME = "juddi-users.xml";
    Hashtable userTable;
    static /* synthetic */ Class class$org$apache$juddi$auth$XMLDocAuthenticator;

    public XMLDocAuthenticator() {
        this.init();
    }

    public synchronized void init() {
        try {
            this.userTable = new Hashtable();
            String usersFileName = Config.getStringProperty(FILE_NAME_KEY, DEFAULT_FILE_NAME);
            log.info("Using jUDDI Users File: " + usersFileName);
            this.build(new FileInputStream(usersFileName));
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        catch (SAXException saxex) {
            saxex.printStackTrace();
        }
        catch (ParserConfigurationException pcex) {
            pcex.printStackTrace();
        }
    }

    public String authenticate(String userID, String credential) throws RegistryException {
        if (userID == null) {
            throw new UnknownUserException("Invalid user ID = " + userID);
        }
        if (credential == null) {
            throw new UnknownUserException("Invalid credentials");
        }
        if (this.userTable.containsKey(userID)) {
            UserInfo userInfo = (UserInfo)this.userTable.get(userID);
            if (userInfo.password == null || !credential.equals(userInfo.password)) {
                throw new UnknownUserException("Invalid credentials");
            }
        } else {
            throw new UnknownUserException("Invalid user ID: " + userID);
        }
        return userID;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(100);
        Enumeration enumeration = this.userTable.keys();
        while (enumeration.hasMoreElements()) {
            UserInfo userInfo = (UserInfo)this.userTable.get(enumeration.nextElement());
            buff.append(userInfo.toString() + "\n");
        }
        return buff.toString();
    }

    Hashtable build(InputStream istream) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        XMLReader xr = spf.newSAXParser().getXMLReader();
        xr.setContentHandler(this);
        xr.setErrorHandler(this);
        xr.parse(new InputSource(istream));
        return (Hashtable)this.getObject();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String uri, String name, String qName, Attributes attributes) throws SAXException {
        if (name.equalsIgnoreCase("user")) {
            UserInfo userInfo = new UserInfo();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equalsIgnoreCase("userid")) {
                    userInfo.userid = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equalsIgnoreCase("password")) continue;
                userInfo.password = attributes.getValue(i);
            }
            this.userTable.put(userInfo.userid, userInfo);
        }
    }

    public void endElement(String name, String string2, String string3) throws SAXException {
    }

    public void characters(char[] chars, int int1, int int2) throws SAXException {
    }

    public void ignorableWhitespace(char[] chars, int int1, int int2) throws SAXException {
    }

    public void processingInstruction(String string1, String string2) throws SAXException {
    }

    public void startPrefixMapping(String string1, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void warning(SAXParseException spex) throws SAXException {
    }

    public void error(SAXParseException spex) throws SAXException {
    }

    public void fatalError(SAXParseException spex) throws SAXException {
    }

    Object getObject() {
        return this.userTable;
    }

    public static void main(String[] args) throws Exception {
        XMLDocAuthenticator auth = new XMLDocAuthenticator();
        try {
            System.out.print("anou_mana/password: ");
            auth.authenticate("anou_mana", "password");
            System.out.println("successfully authenticated");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        try {
            System.out.print("anou_mana/badpass: ");
            auth.authenticate("anou_mana", "badpass");
            System.out.println("successfully authenticated");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        try {
            System.out.print("bozo/clown: ");
            auth.authenticate("bozo", "clown");
            System.out.println("successfully authenticated");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        try {
            System.out.print("sviens/password: ");
            auth.authenticate("sviens", "password");
            System.out.println("successfully authenticated");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class UserInfo {
        public String userid;
        public String password;

        UserInfo() {
        }

        public String toString() {
            StringBuffer buff = new StringBuffer(75);
            buff.append(this.userid);
            buff.append(" | ");
            buff.append(this.password);
            return buff.toString();
        }
    }
}

