/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.text.NumberFormat;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.internal.core.Buffer;
import org.eclipse.jdt.internal.core.BufferCache;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OverflowingLRUCache;

public class BufferManager {
    protected static BufferManager DEFAULT_BUFFER_MANAGER;
    protected static boolean VERBOSE;
    protected OverflowingLRUCache openBuffers = new BufferCache(60);
    protected IBufferFactory defaultBufferFactory = new IBufferFactory(){

        public IBuffer createBuffer(IOpenable owner) {
            return BufferManager.this.createBuffer(owner);
        }
    };

    protected void addBuffer(IBuffer buffer) {
        if (VERBOSE) {
            String owner = ((Openable)buffer.getOwner()).toStringWithAncestors();
            System.out.println("Adding buffer for " + owner);
        }
        this.openBuffers.put(buffer.getOwner(), buffer);
        if (VERBOSE) {
            System.out.println("-> Buffer cache filling ratio = " + NumberFormat.getInstance().format(this.openBuffers.fillingRatio()) + "%");
        }
    }

    public IBuffer createBuffer(IOpenable owner) {
        IJavaElement element = (IJavaElement)((Object)owner);
        IResource resource = element.getResource();
        return new Buffer(resource instanceof IFile ? (IFile)resource : null, owner, element.isReadOnly());
    }

    public IBuffer getBuffer(IOpenable owner) {
        return (IBuffer)this.openBuffers.get(owner);
    }

    public static synchronized BufferManager getDefaultBufferManager() {
        if (DEFAULT_BUFFER_MANAGER == null) {
            DEFAULT_BUFFER_MANAGER = new BufferManager();
        }
        return DEFAULT_BUFFER_MANAGER;
    }

    public IBufferFactory getDefaultBufferFactory() {
        return this.defaultBufferFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getOpenBuffers() {
        OverflowingLRUCache overflowingLRUCache = this.openBuffers;
        synchronized (overflowingLRUCache) {
            this.openBuffers.shrink();
            return this.openBuffers.elements();
        }
    }

    protected void removeBuffer(IBuffer buffer) {
        if (VERBOSE) {
            String owner = ((Openable)buffer.getOwner()).toStringWithAncestors();
            System.out.println("Removing buffer for " + owner);
        }
        this.openBuffers.remove(buffer.getOwner());
        if (VERBOSE) {
            System.out.println("-> Buffer cache filling ratio = " + NumberFormat.getInstance().format(this.openBuffers.fillingRatio()) + "%");
        }
    }
}

