/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.lib;

import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.eval.api.BinaryEvaluatedTC;
import org.objectweb.medor.eval.api.NodeEvaluator;
import org.objectweb.medor.eval.lib.BasicBinaryEvalutedTC;
import org.objectweb.medor.eval.prefetch.api.PrefetchBuffer;
import org.objectweb.medor.eval.prefetch.api.PrefetchBufferHolder;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.medor.tuple.lib.MemoryTuple;
import org.objectweb.util.monolog.api.BasicLevel;

public class SelProjEvaluatedTC
extends BasicBinaryEvalutedTC
implements BinaryEvaluatedTC,
PrefetchBufferHolder {
    private QueryNode query;
    private Expression filter;
    private TupleCollection subTupleCollection;
    private ParameterOperand[] parameters;
    private Tuple tupleBuffer1;
    private Tuple tupleBuffer2;
    private VariableOperand[] operandBuffer1;
    private VariableOperand[] operandBuffer2;
    private int cursor;
    private boolean empty;
    private boolean isTheLast = false;
    private boolean isBuffer2Free = false;
    private boolean userHasClosed = false;
    Operand filterResult;
    PrefetchBuffer prefetchBuffer;

    public SelProjEvaluatedTC(QueryNode query, NodeEvaluator subNodeEvaluator, ParameterOperand[] parameters, PrefetchBuffer pb) throws MedorException {
        this.query = query;
        this.parameters = parameters;
        this.filter = query.getQueryFilter();
        try {
            this.filterResult = this.filter.compileExpression();
        }
        catch (ExpressionException e) {
            throw new MedorException(e);
        }
        this.prefetchBuffer = pb;
        if (this.prefetchBuffer != null) {
            pb.setTupleCollection(this);
        }
        int size = query.getTupleStructure().getSize();
        this.operandBuffer1 = new BasicVariableOperand[size];
        this.operandBuffer2 = new BasicVariableOperand[size];
        for (int cpt = 0; cpt < query.getTupleStructure().getSize(); ++cpt) {
            PType type = query.getTupleStructure().getField(cpt + 1).getType();
            this.operandBuffer1[cpt] = new BasicVariableOperand(type);
            this.operandBuffer2[cpt] = new BasicVariableOperand(type);
        }
        this.tupleBuffer1 = new MemoryTuple(this.operandBuffer1);
        this.tupleBuffer2 = new MemoryTuple(this.operandBuffer2);
        this.subTupleCollection = subNodeEvaluator.fetchData(parameters);
        this.empty = this.subTupleCollection.isEmpty();
        if (this.empty) {
            this.cursor = 0;
        } else {
            this.init();
        }
    }

    public void invalidatePrefetchBuffer() throws MedorException {
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("Invalidating PrefetchBuffer " + this.prefetchBuffer + " for " + this));
        }
        this.prefetchBuffer = null;
        if (this.userHasClosed) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)"The tupleCollection was closed earlier: closing it for real");
            }
            this.close();
        }
    }

    public void close() throws MedorException {
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("Closing TupleCollection " + this));
        }
        this.userHasClosed = true;
        if (this.prefetchBuffer == null || this.prefetchBuffer.isClosed()) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("PrefetchBuffer " + this.prefetchBuffer + " is null or was closed previously: real close of the TupleCollection"));
            }
            this.prefetchBuffer = null;
            super.close();
            if (this.subTupleCollection != null) {
                this.subTupleCollection.close();
            }
        }
    }

    public TupleStructure getMetaData() throws MedorException {
        return this.query.getTupleStructure();
    }

    public boolean isLast() throws MedorException {
        return this.isTheLast;
    }

    public int card() throws MedorException {
        return this.cursor;
    }

    public boolean next() throws MedorException {
        Tuple currentTuple = null;
        boolean moved = false;
        if (this.isEmpty() || this.cursor == -2) {
            moved = false;
        } else if (this.isLast()) {
            this.cursor = -2;
            moved = false;
        } else {
            try {
                moved = true;
                ++this.cursor;
                do {
                    if (this.subTupleCollection.next()) {
                        currentTuple = this.subTupleCollection.getTuple();
                        this.filter.evaluate(this.parameters, currentTuple);
                        continue;
                    }
                    this.isTheLast = true;
                } while (!this.isTheLast && !this.filterResult.getBoolean());
                if (!this.isTheLast) {
                    if (this.isBuffer2Free) {
                        this.query.getTupleLoader().loadTuple(currentTuple, this.operandBuffer2, this.parameters);
                        this.isBuffer2Free = false;
                    } else {
                        this.query.getTupleLoader().loadTuple(currentTuple, this.operandBuffer1, this.parameters);
                        this.isBuffer2Free = true;
                    }
                    if (this.prefetchBuffer != null) {
                        this.prefetchBuffer.addPrefetchTuple();
                    }
                } else {
                    this.isBuffer2Free = !this.isBuffer2Free;
                }
            }
            catch (ExpressionException e) {
                throw new MedorException(e);
            }
        }
        return moved;
    }

    private boolean init() throws MedorException {
        this.subTupleCollection.first();
        this.isTheLast = false;
        this.isBuffer2Free = false;
        Tuple currentTuple = this.subTupleCollection.getTuple();
        try {
            this.filter.evaluate(this.parameters, currentTuple);
            while (!this.empty && !this.filterResult.getBoolean()) {
                if (this.subTupleCollection.next()) {
                    currentTuple = this.subTupleCollection.getTuple();
                    this.filter.evaluate(this.parameters, currentTuple);
                    continue;
                }
                this.empty = true;
            }
            if (this.empty) {
                this.cursor = -2;
            } else {
                this.query.getTupleLoader().loadTuple(currentTuple, this.operandBuffer1, this.parameters);
                this.cursor = 1;
                if (this.prefetchBuffer != null) {
                    this.prefetchBuffer.addPrefetchTuple();
                }
                do {
                    if (this.subTupleCollection.next()) {
                        currentTuple = this.subTupleCollection.getTuple();
                        this.filter.evaluate(this.parameters, currentTuple);
                        continue;
                    }
                    this.isTheLast = true;
                } while (!this.isTheLast && !this.filterResult.getBoolean());
                if (!this.isTheLast) {
                    this.query.getTupleLoader().loadTuple(currentTuple, this.operandBuffer2, this.parameters);
                    if (this.prefetchBuffer != null) {
                        this.prefetchBuffer.addPrefetchTuple();
                    }
                }
            }
        }
        catch (ExpressionException e) {
            throw new MedorException(e);
        }
        return !this.empty;
    }

    public void first() throws MedorException {
        this.init();
    }

    public int getRow() throws MedorException {
        return this.empty || this.cursor < 1 ? this.cursor : (this.isBuffer2Free ? 1 : 0) + this.cursor;
    }

    public Tuple getTuple() throws MedorException {
        if (!this.isEmpty() && this.getRow() >= 1) {
            if (this.isBuffer2Free) {
                return this.tupleBuffer2;
            }
            return this.tupleBuffer1;
        }
        throw new MedorException(" No elements fetched in this TupleCollection");
    }

    public synchronized Tuple getTuple(int numTuple) throws MedorException {
        this.row(numTuple);
        return this.getTuple();
    }

    public boolean isEmpty() throws MedorException {
        return this.empty;
    }

    public boolean row(int numTuple) throws MedorException {
        this.first();
        int cpt = 1;
        boolean stop = false;
        while (cpt < numTuple && !stop) {
            if (!this.next()) {
                stop = true;
                continue;
            }
            ++cpt;
        }
        if (cpt < numTuple) {
            return false;
        }
        this.cursor = numTuple;
        return true;
    }

    public int getLeftTCCursor() throws MedorException {
        return this.subTupleCollection.getRow();
    }

    public int getRightTCCursor() throws MedorException {
        return -1;
    }
}

