/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cmi.internal;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import javax.ejb.EJBObject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.cmi.controller.server.AbsServerClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.info.CMIInfoExtractor;
import org.ow2.cmi.info.CMIInfoExtractorException;
import org.ow2.cmi.info.CMIInfoRepository;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.cmi.osgi.ILoadBalancingService;
import org.ow2.jonas.cmi.CmiService;
import org.ow2.jonas.cmi.internal.CmiServiceHelper;
import org.ow2.jonas.cmi.internal.CmiServicePolicyStrategyManager;
import org.ow2.jonas.cmi.internal.CmiServiceProperty;
import org.ow2.jonas.cmi.internal.LoadBalancingListener;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmiServiceImpl
extends AbsServiceImpl
implements CmiService {
    private static Logger cmilogger = Log.getLogger("org.ow2.jonas.cmi");
    private JmxService jmxService = null;
    private final BundleContext context;
    private ServerClusterViewManager clusterViewManager;
    private ServiceRegistration clusterViewManagerRegistration;
    private CmiServicePolicyStrategyManager policyStrategyManager = null;

    public CmiServiceImpl(BundleContext context) {
        this.context = context;
    }

    @Override
    protected void doStart() throws ServiceException {
        Properties cmiProperties = null;
        cmiProperties = CmiServiceHelper.buildCmiProperties();
        File deployDirectory = new File(JProp.getJonasBase(), CmiServiceProperty.DEFAULT_DEPLOY_DIRECTORY.getPropertyName());
        try {
            if (deployDirectory.exists()) {
                cmilogger.log(BasicLevel.DEBUG, (Object)("Deploy directory of CMI service is: " + deployDirectory.getAbsolutePath()));
                cmiProperties.put(CmiServiceProperty.DEPLOY_DIRECTORY_KEY.getPropertyName(), deployDirectory.toURL().toString());
            } else {
                cmilogger.log(BasicLevel.DEBUG, (Object)"No deploy directory for CMI service");
            }
            ConfigurationRepository.getServerConfiguration().enableCMI(cmiProperties);
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Cannot configure Carol to use CMI", (Throwable)e);
            throw new ServiceException("Cannot configure Carol to use CMI", e);
        }
        IExecution<Void> startExec = new IExecution<Void>(){

            @Override
            public Void execute() throws Exception {
                CmiServiceImpl.this.clusterViewManager = AbsServerClusterViewManager.start();
                return null;
            }
        };
        ExecutionResult<Void> startExecResult = RunnableHelper.execute(this.getClass().getClassLoader(), startExec);
        if (startExecResult.hasException()) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Cannot start the server-side manager", (Throwable)startExecResult.getException());
            throw new ServiceException("Cannot start the server-side manager", startExecResult.getException());
        }
        this.clusterViewManagerRegistration = this.context.registerService(ServerClusterViewManager.class.getName(), (Object)this.clusterViewManager, null);
        this.policyStrategyManager = new CmiServicePolicyStrategyManager(this.clusterViewManager);
        LoadBalancingListener listener = new LoadBalancingListener(this.policyStrategyManager);
        cmilogger.log(BasicLevel.DEBUG, (Object)"Adding listener for load balancing service ");
        try {
            this.context.addServiceListener((ServiceListener)listener, "(objectClass=" + ILoadBalancingService.class.getName() + ")");
        }
        catch (InvalidSyntaxException e) {
            cmilogger.log(BasicLevel.ERROR, (Object)("Unable to add service listener for " + ILoadBalancingService.class.getName() + " because: " + (Object)((Object)e)));
        }
    }

    @Override
    protected void doStop() throws ServiceException {
        if (this.clusterViewManagerRegistration != null) {
            this.clusterViewManagerRegistration.unregister();
        }
        try {
            ConfigurationRepository.getServerConfiguration().disableCMI();
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Cannot disable cmi in Carol", (Throwable)e);
        }
        if (this.clusterViewManager != null) {
            try {
                ((AbsServerClusterViewManager)this.clusterViewManager).stop();
            }
            catch (Exception e) {
                cmilogger.log(BasicLevel.ERROR, (Object)"Cannot stop the server-side manager", (Throwable)e);
                throw new ServiceException("Cannot stop the server-side manager", e);
            }
        }
    }

    @Override
    public void addClusteredObject(String jndiName, String clusterPolicyName, Class<?> homeClass, Class<? extends EJBObject> remoteClass, ClassLoader classLoader, boolean stateful, boolean clusterReplicated) throws Exception {
        if (clusterPolicyName == null) {
            cmilogger.log(BasicLevel.DEBUG, (Object)("The object with name " + jndiName + " is not clustered."));
            return;
        }
        URL url = classLoader.getResource(clusterPolicyName);
        if (url != null) {
            try {
                ClusteredObjectInfo clusteredObjectInfo = null;
                clusteredObjectInfo = CMIInfoExtractor.extractClusteringInfoFromDD(jndiName, homeClass, remoteClass, url, stateful, clusterReplicated, null);
                CMIInfoRepository.addClusteredObjectInfo(jndiName, clusteredObjectInfo);
                cmilogger.log(BasicLevel.INFO, (Object)("The object with name " + jndiName + " is clustered."));
            }
            catch (CMIInfoExtractorException e) {
                cmilogger.log(BasicLevel.ERROR, (Object)("Error when extracting infos about clustering for the object with name " + jndiName), (Throwable)e);
                throw new Exception("Error when extracting infos about clustering for the object with name " + jndiName, e);
            }
        } else {
            cmilogger.log(BasicLevel.ERROR, (Object)("Cannot find the policy of load-balancing with name " + clusterPolicyName));
            throw new Exception("Cannot find the policy of load-balancing with name " + clusterPolicyName);
        }
    }

    protected JmxService getJmxService() {
        return this.jmxService;
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }
}

