/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.EntityBean;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.carol.util.csiv2.SasComponent;
import org.ow2.carol.util.csiv2.struct.AsStruct;
import org.ow2.carol.util.csiv2.struct.SasStruct;
import org.ow2.carol.util.csiv2.struct.TransportStruct;
import org.ow2.jonas.deployment.api.IEnvEntryDesc;
import org.ow2.jonas.deployment.api.IResourceEnvRefDesc;
import org.ow2.jonas.deployment.api.IResourceRefDesc;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.EjbLocalRefDesc;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.deployment.common.JndiEnvRefsGroupDesc;
import org.ow2.jonas.deployment.common.MessageDestinationRefDesc;
import org.ow2.jonas.deployment.common.SecurityRoleRefDesc;
import org.ow2.jonas.deployment.common.lib.JavaType;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.RunAs;
import org.ow2.jonas.deployment.common.xml.SecurityRole;
import org.ow2.jonas.deployment.common.xml.SecurityRoleRef;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.deployment.ejb.EntityCmp2Desc;
import org.ow2.jonas.deployment.ejb.MethodDesc;
import org.ow2.jonas.deployment.ejb.xml.AsContextMapping;
import org.ow2.jonas.deployment.ejb.xml.AssemblyDescriptor;
import org.ow2.jonas.deployment.ejb.xml.CommonEjb;
import org.ow2.jonas.deployment.ejb.xml.ContainerTransaction;
import org.ow2.jonas.deployment.ejb.xml.IorSecurityConfigMapping;
import org.ow2.jonas.deployment.ejb.xml.JonasCommonEjb;
import org.ow2.jonas.deployment.ejb.xml.Method;
import org.ow2.jonas.deployment.ejb.xml.MethodPermission;
import org.ow2.jonas.deployment.ejb.xml.SasContextMapping;
import org.ow2.jonas.deployment.ejb.xml.TransportConfigMapping;
import org.ow2.jonas.lib.util.BeanNaming;

public abstract class BeanDesc
extends JndiEnvRefsGroupDesc {
    protected static final int BEAN_TRANSACTION_TYPE = 1;
    protected static final int CONTAINER_TRANSACTION_TYPE = 2;
    protected static final String[] TRANS = new String[]{null, "BEAN_TRANSACTION_TYPE", "CONTAINER_TRANSACTION_TYPE"};
    private static final String ejb10PropertiesPrefix = "ejb10-properties/";
    private static final String REMOTEDEFAULTSUFFIX = "Home";
    private static final String LOCALDEFAULTSUFFIX = "_L";
    public static final String GENERATED_PREFIX = "org.ow2.jonas_gen.";
    protected String ejbName = null;
    protected String jndiName = null;
    protected String jndiLocalName = null;
    protected Class home = null;
    protected Class remote = null;
    protected Class localhome = null;
    protected Class local = null;
    protected Class ejbClass = null;
    protected String beanIdentification = null;
    protected Properties ejb10EnvProps = new Properties();
    private ArrayList methodDesc = new ArrayList();
    private HashMap methodDescMap = new HashMap();
    protected List securityRoleRefDescList = new LinkedList();
    protected DeploymentDesc deploymentDesc = null;
    private String fullWrpRemoteName = null;
    private String wrpRemoteName = null;
    private String fullWrpHomeName = null;
    private String wrpHomeName = null;
    private String fullWrpLocalName = null;
    private String wrpLocalName = null;
    private String fullWrpLocalHomeName = null;
    private String wrpLocalHomeName = null;
    private String fullWrpHandleName = null;
    private String wrpHandleName = null;
    protected String fullDerivedBeanName = null;
    protected String derivedBeanName = null;
    private String runAsRole = null;
    private String runAsPrincipalName = null;
    protected int poolMin = 0;
    protected int cacheMax = 0;
    private SasComponent sasComponent = null;
    protected int timerTxAttribute = 4;
    protected String ejbTimeoutSignature;
    protected String clusterPolicy = null;
    protected boolean clusterReplicated = false;

    public BeanDesc(ClassLoader classLoader, CommonEjb ejb, JonasCommonEjb jonasEjb, AssemblyDescriptor asd, JLinkedList jMDRList, String fileName) throws DeploymentDescException {
        super(classLoader, ejb, jonasEjb, fileName);
        RunAs runAsElem;
        String localname;
        String localhomename;
        this.ejbName = ejb.getEjbName() != null ? ejb.getEjbName() : null;
        this.jndiName = jonasEjb.getJndiName() != null ? jonasEjb.getJndiName() : (ejb.getMappedName() != null ? ejb.getMappedName() : this.ejbName + REMOTEDEFAULTSUFFIX);
        this.jndiLocalName = jonasEjb.getJndiLocalName() != null ? jonasEjb.getJndiLocalName() : this.jndiName + LOCALDEFAULTSUFFIX;
        if (ejb.getHome() != null) {
            try {
                this.home = classLoader.loadClass(ejb.getHome());
                if (!EJBHome.class.isAssignableFrom(this.home)) {
                    throw new DeploymentDescException("Home class '" + ejb.getHome() + "' does not extend javax.ejb.EJBHome");
                }
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentDescException("Home class not found for bean " + this.ejbName, e);
            }
        }
        if (ejb.getRemote() != null) {
            try {
                this.remote = classLoader.loadClass(ejb.getRemote());
                if (!EJBObject.class.isAssignableFrom(this.remote)) {
                    throw new DeploymentDescException("Remote class '" + ejb.getRemote() + "' does not extend javax.ejb.EJBObject");
                }
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentDescException("Remote class not found for bean " + this.ejbName, e);
            }
        }
        if ((localhomename = ejb.getLocalHome()) == null && this instanceof EntityCmp2Desc) {
            localhomename = "javax.ejb.EJBLocalHome";
        }
        if (localhomename != null) {
            try {
                this.localhome = classLoader.loadClass(localhomename);
                if (!EJBLocalHome.class.isAssignableFrom(this.localhome)) {
                    throw new DeploymentDescException("LocalHome class '" + localhomename + "' does not extend javax.ejb.EJBLocalHome");
                }
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentDescException("LocalHome class not found for bean " + this.ejbName, e);
            }
        }
        if ((localname = ejb.getLocal()) == null && this instanceof EntityCmp2Desc) {
            localname = "javax.ejb.EJBLocalObject";
        }
        if (localname != null) {
            try {
                this.local = classLoader.loadClass(localname);
                if (!EJBLocalObject.class.isAssignableFrom(this.local)) {
                    throw new DeploymentDescException("Local class '" + localname + "' does not extend javax.ejb.EJBLocalObject");
                }
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentDescException("Local class not found for bean " + this.ejbName, e);
            }
        }
        this.loadExtraClasses(ejb, classLoader);
        try {
            this.ejbClass = classLoader.loadClass(ejb.getEjbClass());
            if (!EnterpriseBean.class.isAssignableFrom(this.ejbClass)) {
                throw new DeploymentDescException("Ejb class '" + ejb.getEjbClass() + "' does not extend javax.ejb.EnterpriseBean");
            }
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentDescException("Ejb class not found for bean " + this.ejbName, e);
        }
        IEnvEntryDesc[] envt = this.getEnvEntryDesc();
        for (int i = 0; i < envt.length; ++i) {
            if (!envt[i].getName().startsWith(ejb10PropertiesPrefix)) continue;
            String newName = envt[i].getName().substring(ejb10PropertiesPrefix.length());
            String value = new String();
            if (envt[i].hasValue()) {
                value = envt[i].getValue().toString();
            }
            this.ejb10EnvProps.put(newName, value);
        }
        if (ejb.getSecurityIdentity() != null && (runAsElem = ejb.getSecurityIdentity().getRunAs()) != null) {
            String roleName = runAsElem.getRoleName();
            if (roleName != null) {
                this.runAsRole = roleName;
                boolean runAsRoleFound = false;
                if (asd != null && asd.getSecurityRoleList() != null) {
                    for (SecurityRole securityRole : asd.getSecurityRoleList()) {
                        String r = securityRole.getRoleName();
                        if (!r.equals(this.runAsRole)) continue;
                        runAsRoleFound = true;
                    }
                }
                if (!runAsRoleFound) {
                    throw new DeploymentDescException("There is no security-role defined for the run-as role: " + this.runAsRole);
                }
            }
            this.runAsPrincipalName = jonasEjb.getRunAsPrincipalName();
            if (this.runAsPrincipalName == null) {
                this.runAsPrincipalName = this.runAsRole;
            }
        }
        try {
            int beginIdx = this.methodDesc.size();
            int len = 0;
            if (this.home != null && this.remote != null) {
                int i;
                java.lang.reflect.Method[] m = this.home.getMethods();
                for (i = 0; i < m.length; ++i) {
                    if (m[i].getDeclaringClass().equals(EJBHome.class) && !m[i].getName().equals("remove")) continue;
                    this.addMethodDesc(m[i], this.home);
                    ++len;
                    this.checkRemoteException(m[i], true);
                }
                m = this.remote.getMethods();
                for (i = 0; i < m.length; ++i) {
                    if (m[i].getDeclaringClass().equals(EJBObject.class) && !m[i].getName().equals("remove")) continue;
                    this.addMethodDesc(m[i], this.remote);
                    ++len;
                    this.checkRemoteException(m[i], true);
                }
            }
            if (this.localhome != null && this.local != null) {
                int i;
                java.lang.reflect.Method[] m = this.localhome.getMethods();
                for (i = 0; i < m.length; ++i) {
                    if (m[i].getDeclaringClass().equals(EJBLocalHome.class) && !m[i].getName().equals("remove")) continue;
                    this.addMethodDesc(m[i], this.localhome);
                    ++len;
                    this.checkRemoteException(m[i], false);
                }
                m = this.local.getMethods();
                for (i = 0; i < m.length; ++i) {
                    if (m[i].getDeclaringClass().equals(EJBLocalObject.class) && !m[i].getName().equals("remove")) continue;
                    this.addMethodDesc(m[i], this.local);
                    ++len;
                    this.checkRemoteException(m[i], false);
                }
            }
            if (this.home == null && this.localhome == null && ejb.getMessagingType() != null) {
                String msgType = ejb.getMessagingType();
                try {
                    java.lang.reflect.Method[] m = classLoader.loadClass(msgType).getMethods();
                    for (int i = 0; i < m.length; ++i) {
                        this.addMethodDesc(m[i], m[i].getDeclaringClass());
                        ++len;
                    }
                }
                catch (Exception ex) {
                    throw new DeploymentDescException("Cannot load messaging type class (" + msgType + ") for " + this.ejbName, ex);
                }
            }
            if (EntityBean.class.isAssignableFrom(this.ejbClass)) {
                java.lang.reflect.Method[] m = this.ejbClass.getMethods();
                for (int i = 0; i < m.length; ++i) {
                    if (!m[i].getName().startsWith("ejbSelect") || !Modifier.isAbstract(m[i].getModifiers())) continue;
                    this.addMethodDesc(m[i], this.ejbClass);
                    ++len;
                }
            }
            if (TimedObject.class.isAssignableFrom(this.ejbClass)) {
                try {
                    java.lang.reflect.Method timeout = this.ejbClass.getMethod("ejbTimeout", Timer.class);
                    this.addMethodDesc(timeout, this.ejbClass);
                    ++len;
                }
                catch (NoSuchMethodException e) {
                    throw new DeploymentDescException("ejbTimeout not implemented in " + this.ejbName);
                }
            }
            len = this.addEJBMethodDesc(len);
            this.orderMethodDesc(this.methodDesc, beginIdx, len);
        }
        catch (SecurityException e) {
            throw new DeploymentDescException("Cannot use java reflection on " + this.ejbName, e);
        }
        if (ejb.getSecurityRoleRefList() != null) {
            for (SecurityRoleRef sRoleRef : ejb.getSecurityRoleRefList()) {
                if (asd == null) {
                    throw new DeploymentDescException("No assembly-descriptor element (and security-role elements) whereas security-role-ref element(s) are defined");
                }
                if (asd.getSecurityRoleList().isEmpty()) {
                    throw new DeploymentDescException("No security-role elements defined in the assembly-descriptor element  whereas security-role-ref element(s) are defined");
                }
                if (sRoleRef.getRoleLink() == null) {
                    throw new DeploymentDescException("No role-link element in a security-role-ref element with role-name element : " + sRoleRef.getRoleName());
                }
                String roleLink = sRoleRef.getRoleLink();
                String roleRefName = sRoleRef.getRoleName();
                boolean correspondingRoles = false;
                for (SecurityRole securityRole : asd.getSecurityRoleList()) {
                    String roleName = securityRole.getRoleName();
                    if (!roleName.equals(roleLink)) continue;
                    this.securityRoleRefDescList.add(new SecurityRoleRefDesc(this.ejbName, sRoleRef, true));
                    correspondingRoles = true;
                }
                if (correspondingRoles) continue;
                throw new DeploymentDescException("No corresponding role-name in a security-role element for role-link : " + roleLink);
            }
        }
        if (asd != null) {
            this.verifyRoleName(asd);
            for (MethodPermission methodPermission : asd.getMethodPermissionList()) {
                for (Method m : methodPermission.getMethodList()) {
                    if (!m.getEjbName().equals(this.ejbName)) continue;
                    Class pClass = null;
                    if (m.getMethodIntf() != null) {
                        pClass = this.getParentClass(m.getMethodIntf());
                    }
                    for (int k = 0; k < this.methodDesc.size(); ++k) {
                        MethodDesc md = (MethodDesc)this.methodDesc.get(k);
                        int matchStatus = md.matchPattern(pClass, m.getMethodName(), m.getMethodParams());
                        for (String roleName : methodPermission.getRoleNameList()) {
                            if (matchStatus <= 0) continue;
                            md.addRoleName(roleName);
                        }
                    }
                }
            }
        }
        if (asd != null && asd.getExcludeList() != null) {
            for (Method m : asd.getExcludeList().getMethodList()) {
                if (!m.getEjbName().equals(this.ejbName)) continue;
                Class pClass = null;
                if (m.getMethodIntf() != null) {
                    pClass = this.getParentClass(m.getMethodIntf());
                }
                for (int k = 0; k < this.methodDesc.size(); ++k) {
                    MethodDesc md = (MethodDesc)this.methodDesc.get(k);
                    int matchStatus = md.matchPattern(pClass, m.getMethodName(), m.getMethodParams());
                    if (matchStatus <= 0) continue;
                    md.setExcluded(true);
                }
            }
        }
        if (asd != null) {
            for (ContainerTransaction cotr : asd.getContainerTransactionList()) {
                for (Method m : cotr.getMethodList()) {
                    if (!m.getEjbName().equals(this.ejbName)) continue;
                    Class pClass = null;
                    if (m.getMethodIntf() != null) {
                        pClass = this.getParentClass(m.getMethodIntf());
                    }
                    boolean found = false;
                    for (int k = 0; k < this.methodDesc.size(); ++k) {
                        MethodDesc md = (MethodDesc)this.methodDesc.get(k);
                        int matchStatus = md.matchPattern(pClass, m.getMethodName(), m.getMethodParams());
                        if (matchStatus != 0) {
                            found = true;
                        }
                        String transAttribute = null;
                        if (cotr.getTransAttribute() != null) {
                            transAttribute = cotr.getTransAttribute();
                        }
                        md.overwriteTxAttribute(transAttribute, matchStatus);
                    }
                    if (found) continue;
                    logger.log(BasicLevel.WARN, (Object)("Invalid container-transaction: method '" + MethodDesc.methodElementToString(m) + "' not declared in bean " + this.ejbName));
                }
            }
        }
        String packageName = "";
        String ejbIdentifier = this.getIdentifier();
        if (this.getRemoteClass() != null) {
            packageName = GENERATED_PREFIX + BeanNaming.getPackageName(this.getRemoteClass().getName());
            this.wrpRemoteName = new String("JOnAS" + ejbIdentifier + "Remote");
            this.wrpHandleName = new String("JOnAS" + ejbIdentifier + "Handle");
            this.fullWrpRemoteName = BeanNaming.getClassName(packageName, this.wrpRemoteName);
            this.fullWrpHandleName = BeanNaming.getClassName(packageName, this.wrpHandleName);
        }
        if (this.getLocalClass() != null) {
            packageName = GENERATED_PREFIX + BeanNaming.getPackageName(this.getLocalClass().getName());
            this.wrpLocalName = new String("JOnAS" + ejbIdentifier + "Local");
            this.fullWrpLocalName = BeanNaming.getClassName(packageName, this.wrpLocalName);
        }
        if (this.getHomeClass() != null) {
            packageName = GENERATED_PREFIX + BeanNaming.getPackageName(this.getHomeClass().getName());
            this.wrpHomeName = new String("JOnAS" + ejbIdentifier + REMOTEDEFAULTSUFFIX);
            this.fullWrpHomeName = BeanNaming.getClassName(packageName, this.wrpHomeName);
        }
        if (this.getLocalHomeClass() != null) {
            packageName = GENERATED_PREFIX + BeanNaming.getPackageName(this.getLocalHomeClass().getName());
            this.wrpLocalHomeName = new String("JOnAS" + ejbIdentifier + "LocalHome");
            this.fullWrpLocalHomeName = BeanNaming.getClassName(packageName, this.wrpLocalHomeName);
        }
        this.fullDerivedBeanName = this.getEjbClass().getName();
        this.derivedBeanName = BeanNaming.getBaseName(this.getEjbClass().getName());
        IorSecurityConfigMapping iorSecurityConfigMapping = jonasEjb.getIorSecurityConfig();
        if (iorSecurityConfigMapping != null) {
            this.processIorSecurityConfig(iorSecurityConfigMapping);
        }
        if (jonasEjb.getClusterPolicy() != null && !jonasEjb.getClusterPolicy().equals("")) {
            this.clusterPolicy = jonasEjb.getClusterPolicy();
        }
        if (jonasEjb.getClusterReplicated() != null) {
            if (jonasEjb.getClusterReplicated().equalsIgnoreCase("True")) {
                this.clusterReplicated = true;
            } else if (jonasEjb.getClusterReplicated().equalsIgnoreCase("False")) {
                this.clusterReplicated = false;
            } else {
                throw new DeploymentDescException("Invalid cluster-replicated value for bean " + this.ejbName);
            }
        }
    }

    protected void loadExtraClasses(CommonEjb ce, ClassLoader loader) throws DeploymentDescException {
    }

    protected int addEJBMethodDesc(int len) throws DeploymentDescException {
        return len;
    }

    protected Class getParentClass(String intfType) throws DeploymentDescException {
        Class pClass = null;
        if (intfType.equals(REMOTEDEFAULTSUFFIX)) {
            pClass = EJBHome.class;
        } else if (intfType.equals("Remote")) {
            pClass = EJBObject.class;
        } else if (intfType.equals("LocalHome")) {
            pClass = EJBLocalHome.class;
        } else if (intfType.equals("Local")) {
            pClass = EJBLocalObject.class;
        } else {
            throw new DeploymentDescException(intfType + " is invalid value for method-intf on bean " + this.ejbName);
        }
        return pClass;
    }

    protected String getHashCodeForIdentifier() {
        String hash = "";
        if (this.getJndiName() != null) {
            hash = hash + this.getJndiName();
        }
        if (this.getJndiLocalName() != null) {
            hash = hash + this.getJndiLocalName();
        }
        return Integer.toString(hash.hashCode());
    }

    public String getIdentifier() {
        if (this.beanIdentification == null) {
            String identifier = this.getEjbName();
            identifier = identifier + this.getHashCodeForIdentifier();
            char[] tabChar = new char[identifier.length()];
            for (int i = 0; i < identifier.length(); ++i) {
                tabChar[i] = !Character.isJavaIdentifierPart(identifier.charAt(i)) ? 95 : identifier.charAt(i);
            }
            this.beanIdentification = new String(tabChar);
        }
        return this.beanIdentification;
    }

    public void checkRemoteException(java.lang.reflect.Method m, boolean shouldThrow) throws DeploymentDescException {
        Class<?>[] excepts = m.getExceptionTypes();
        for (int j = 0; j < excepts.length; ++j) {
            if (!RemoteException.class.isAssignableFrom(excepts[j])) continue;
            if (shouldThrow) {
                return;
            }
            throw new DeploymentDescException("Method " + m.getName() + " of " + m.getDeclaringClass() + " should NOT throw RemoteException");
        }
        if (shouldThrow) {
            throw new DeploymentDescException("Method " + m.getName() + " of " + m.getDeclaringClass() + " must throw RemoteException");
        }
    }

    public void checkValidTypesForRmi(java.lang.reflect.Method m) {
        boolean isValid = true;
        Class<?>[] paramTypes = m.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (JavaType.isValidForRmi(paramTypes[i])) continue;
            isValid = false;
        }
        if (!(JavaType.isValidForRmi(m.getReturnType()) || JavaType.isVoid(m.getReturnType()) || JavaType.isCollecOrEnum(m.getReturnType()))) {
            isValid = false;
        }
        if (!isValid) {
            logger.log(BasicLevel.WARN, (Object)("Method " + m.getName() + " of " + m.getDeclaringClass() + " may be have an invalid argument or return type for RMI"));
        }
    }

    public void check() throws DeploymentDescException {
        for (int i = 0; i < this.methodDesc.size(); ++i) {
            this.checkTxAttribute((MethodDesc)this.methodDesc.get(i));
        }
        this.checkRunAsMapping();
    }

    public void checkRunAsMapping() throws DeploymentDescException {
        String[] runAsPrincipalRoles;
        if (this.runAsPrincipalName != null && (runAsPrincipalRoles = this.deploymentDesc.getRolesForRunAsPrincipal(this.runAsPrincipalName)) != null) {
            boolean isIncluded = false;
            for (int r = 0; r < runAsPrincipalRoles.length; ++r) {
                if (!runAsPrincipalRoles[r].equals(this.runAsRole)) continue;
                isIncluded = true;
            }
            if (!isIncluded) {
                throw new DeploymentDescException("The run-as roles defined for the runas principal name '" + this.runAsPrincipalName + "' does not contains the run-as role '" + this.runAsRole + "' in bean '" + this.getEjbName() + ".");
            }
        }
    }

    protected abstract void checkTxAttribute(MethodDesc var1) throws DeploymentDescException;

    protected void verifyRoleName(AssemblyDescriptor asd) throws DeploymentDescException {
        JLinkedList methodPermission = asd.getMethodPermissionList();
        if (methodPermission != null) {
            for (MethodPermission mPermission : methodPermission) {
                Iterator j = mPermission.getRoleNameList().iterator();
                while (j.hasNext()) {
                    boolean verify = false;
                    String mpRoleName = (String)j.next();
                    Iterator k = asd.getSecurityRoleList().iterator();
                    while (k.hasNext()) {
                        String srRoleName = ((SecurityRole)k.next()).getRoleName();
                        if (!mpRoleName.equals(srRoleName)) continue;
                        verify = true;
                    }
                    if (verify) continue;
                    throw new DeploymentDescException("a method-permission element defined a role-name element \"" + mpRoleName + "\" which doesn't correspond to any security-role element of the Deployment Descriptor");
                }
            }
        }
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJndiLocalName() {
        return this.jndiLocalName;
    }

    public void setJndiLocalName(String jndiLocalName) {
        this.jndiLocalName = jndiLocalName;
    }

    public Class getHomeClass() {
        return this.home;
    }

    public Class getRemoteClass() {
        return this.remote;
    }

    public Class getLocalHomeClass() {
        return this.localhome;
    }

    public Class getLocalClass() {
        return this.local;
    }

    public Class getEjbClass() {
        return this.ejbClass;
    }

    public Properties getEjb10Environment() {
        Properties ret = new Properties(this.ejb10EnvProps);
        return ret;
    }

    public MethodDesc getMethodDesc(java.lang.reflect.Method method) {
        if (!this.methodDescMap.containsKey(method)) {
            throw new Error(method.getName() + " is not a method of home/remote interfaces for bean " + this.getEjbName());
        }
        return (MethodDesc)this.methodDescMap.get(method);
    }

    public Iterator getMethodDescIterator() {
        return this.methodDesc.iterator();
    }

    public MethodDesc getMethodDesc(int index) {
        return (MethodDesc)this.methodDesc.get(index);
    }

    public List getSecurityRoleRefDescList() {
        return this.securityRoleRefDescList;
    }

    public int getPoolMin() {
        return this.poolMin;
    }

    public int getCacheMax() {
        return this.cacheMax;
    }

    public String getRunAsRole() {
        return this.runAsRole;
    }

    public int getTimerTxAttribute() {
        return this.timerTxAttribute;
    }

    public String getEjbTimeoutSignature() {
        return this.ejbTimeoutSignature;
    }

    public String toString() {
        int i;
        StringBuffer ret = new StringBuffer();
        ret.append("\ngetDisplayName()=" + this.getDisplayName());
        ret.append("\ngetEjbName()=" + this.getEjbName());
        if (this.jndiName != null) {
            ret.append("\ngetJndiName()=" + this.getJndiName());
        }
        if (this.home != null) {
            ret.append("\ngetHomeClass()=" + this.getHomeClass().toString());
        }
        if (this.remote != null) {
            ret.append("\ngetRemoteClass()=" + this.getRemoteClass().toString());
        }
        if (this.localhome != null) {
            ret.append("\ngetLocalHomeClass()=" + this.getLocalHomeClass().toString());
        }
        if (this.local != null) {
            ret.append("\ngetLocalClass()=" + this.getLocalClass().toString());
        }
        ret.append("\ngetEjbClass()=" + this.getEjbClass().toString());
        IEnvEntryDesc[] envE = this.getEnvEntryDesc();
        for (int i2 = 0; i2 < envE.length; ++i2) {
            ret.append("\ngetEnvEntryDesc(" + i2 + ")=" + envE[i2].toString());
        }
        IServiceRefDesc[] sr = this.getServiceRefDesc();
        for (int i3 = 0; i3 < sr.length; ++i3) {
            ret.append("\ngetServiceRefDesc(" + i3 + ")=" + sr[i3].toString());
        }
        IResourceEnvRefDesc[] resEnvR = this.getResourceEnvRefDesc();
        for (int i4 = 0; i4 < resEnvR.length; ++i4) {
            ret.append("\ngetResourceEnvRefDesc(" + i4 + ")=" + resEnvR[i4].toString());
        }
        IResourceRefDesc[] resR = this.getResourceRefDesc();
        for (int i5 = 0; i5 < resR.length; ++i5) {
            ret.append("\ngetResourceRefDesc(" + i5 + ")=" + resR[i5].toString());
        }
        EjbRefDesc[] ejbR = this.getEjbRefDesc();
        for (int i6 = 0; i6 < ejbR.length; ++i6) {
            ret.append("\ngetEjbRefDesc(" + i6 + ")=" + ((Object)ejbR[i6]).toString());
        }
        EjbLocalRefDesc[] ejbLR = this.getEjbLocalRefDesc();
        for (int i7 = 0; i7 < ejbLR.length; ++i7) {
            ret.append("\ngetEjbLocalRefDesc(" + i7 + ")=" + ((Object)ejbLR[i7]).toString());
        }
        MessageDestinationRefDesc[] mdR = this.getMessageDestinationRefDesc();
        for (i = 0; i < mdR.length; ++i) {
            ret.append("\ngetMessageDestinationRefDesc(" + i + ")=" + ((Object)mdR[i]).toString());
        }
        for (i = 0; i < this.methodDesc.size(); ++i) {
            MethodDesc md = (MethodDesc)this.methodDesc.get(i);
            ret.append("\ngetMethodDesc(" + i + ")=" + md.getClass().getName());
            ret.append(md.toString());
        }
        if (this.securityRoleRefDescList != null) {
            for (SecurityRoleRefDesc sRoleRefDesc : this.securityRoleRefDescList) {
                ret.append("\nsecurity-role-ref, role-name = '" + sRoleRefDesc.getRoleName() + "', role-link = '" + sRoleRefDesc.getRoleLink() + "'");
            }
        }
        ret.append("\ngetFullWrpRemoteName() = " + this.getFullWrpRemoteName());
        ret.append("\ngetFullWrpHomeName() = " + this.getFullWrpHomeName());
        ret.append("\ngetFullWrpLocalName() = " + this.getFullWrpLocalName());
        ret.append("\ngetFullWrpLocalHomeName() = " + this.getFullWrpLocalHomeName());
        ret.append("\ngetFullWrpHandleName() = " + this.getFullWrpHandleName());
        ret.append("\ngetFullDerivedBeanName() = " + this.getFullDerivedBeanName());
        ret.append("\ngetRunAsRole() = " + this.getRunAsRole());
        return ret.toString();
    }

    protected MethodDesc newMethodDescInstance(java.lang.reflect.Method meth, Class classDef, int index) {
        return new MethodDesc(this, meth, classDef, index);
    }

    protected MethodDesc addMethodDesc(java.lang.reflect.Method meth, Class classDef) {
        MethodDesc md = this.newMethodDescInstance(meth, classDef, this.methodDesc.size());
        this.methodDesc.add(md);
        this.methodDescMap.put(meth, md);
        return md;
    }

    public String getFullWrpRemoteName() {
        return this.fullWrpRemoteName;
    }

    public String getFullWrpLocalName() {
        return this.fullWrpLocalName;
    }

    public String getWrpRemoteName() {
        return this.wrpRemoteName;
    }

    public String getWrpLocalName() {
        return this.wrpLocalName;
    }

    public String getFullWrpHandleName() {
        return this.fullWrpHandleName;
    }

    public String getWrpHandleName() {
        return this.wrpHandleName;
    }

    public String getFullWrpHomeName() {
        return this.fullWrpHomeName;
    }

    public String getFullWrpLocalHomeName() {
        return this.fullWrpLocalHomeName;
    }

    public String getWrpHomeName() {
        return this.wrpHomeName;
    }

    public String getWrpLocalHomeName() {
        return this.wrpLocalHomeName;
    }

    public String getFullDerivedBeanName() {
        return this.fullDerivedBeanName;
    }

    public String getDerivedBeanName() {
        return this.derivedBeanName;
    }

    public DeploymentDesc getDeploymentDesc() {
        return this.deploymentDesc;
    }

    public void setDeploymentDesc(DeploymentDesc deploymentDesc) {
        this.deploymentDesc = deploymentDesc;
        logger = deploymentDesc.getLogger();
    }

    private void orderMethodDesc(ArrayList al, int begin, int length) {
        int i;
        MethodDesc[] mds = new MethodDesc[length];
        for (i = 0; i < length; ++i) {
            mds[i] = (MethodDesc)al.get(begin + i);
        }
        Arrays.sort(mds, 0, length, new MethodDescComparator());
        for (i = 0; i < length; ++i) {
            al.set(begin + i, mds[i]);
            mds[i].setIndex(begin + i);
        }
    }

    public String getRunAsPrincipalName() {
        return this.runAsPrincipalName;
    }

    public boolean hasDefinedLocalInterface() {
        if (this.localhome == null) {
            return false;
        }
        return !"javax.ejb.EJBLocalHome".equals(this.localhome.getName());
    }

    private void processIorSecurityConfig(IorSecurityConfigMapping iorSecurityConfigMapping) {
        TransportStruct transportStruct = new TransportStruct();
        AsStruct asStruct = new AsStruct();
        SasStruct sasStruct = new SasStruct();
        TransportConfigMapping transportConfigMapping = iorSecurityConfigMapping.getTransportConfig();
        AsContextMapping asContextMapping = iorSecurityConfigMapping.getAsContext();
        SasContextMapping sasContextMapping = iorSecurityConfigMapping.getSasContext();
        int targetRequires = 0;
        if (transportConfigMapping.getIntegrity().equals("required")) {
            targetRequires |= 2;
        }
        if (transportConfigMapping.getConfidentiality().equals("required")) {
            targetRequires |= 4;
        }
        if (transportConfigMapping.getEstablishTrustInClient().equals("required")) {
            targetRequires |= 0x40;
        }
        if (transportConfigMapping.getEstablishTrustInTarget().equals("required")) {
            targetRequires |= 0x20;
        }
        transportStruct.setTargetRequires(targetRequires);
        int targetSupports = 0;
        if (transportConfigMapping.getIntegrity().equals("supported") || transportConfigMapping.getIntegrity().equals("required")) {
            targetSupports |= 2;
        }
        if (transportConfigMapping.getConfidentiality().equals("supported") || transportConfigMapping.getConfidentiality().equals("required")) {
            targetSupports |= 4;
        }
        if (transportConfigMapping.getEstablishTrustInClient().equals("supported") || transportConfigMapping.getEstablishTrustInClient().equals("required")) {
            targetSupports |= 0x40;
        }
        if (transportConfigMapping.getEstablishTrustInTarget().equals("supported") || transportConfigMapping.getEstablishTrustInTarget().equals("required")) {
            targetSupports |= 0x20;
        }
        transportStruct.setTargetSupports(targetSupports);
        if (!asContextMapping.getAuthMethod().equals("none")) {
            asStruct.setTargetName(asContextMapping.getRealm());
            asStruct.setTargetSupports(64);
            if (asContextMapping.getRequired().equals("true")) {
                asStruct.setTargetRequires(64);
            }
        }
        if (sasContextMapping.getCallerPropagation().equals("supported")) {
            sasStruct.enableGSSUPSupportedNamingMechanisms();
            sasStruct.setSupportedIdentityTypes(15);
            sasStruct.setTargetSupports(1024);
        }
        this.sasComponent = new SasComponent(transportStruct, asStruct, sasStruct);
    }

    public SasComponent getSasComponent() {
        return this.sasComponent;
    }

    public void setSasComponent(SasComponent sasComponent) {
        this.sasComponent = sasComponent;
    }

    public String getClusterPolicy() {
        return this.clusterPolicy;
    }

    public boolean isClusterReplicated() {
        return this.clusterReplicated;
    }

    public void setClusterReplicated(boolean replicated) {
        this.clusterReplicated = replicated;
    }

    private class MethodDescComparator
    implements Comparator {
        private MethodDescComparator() {
        }

        public int compare(Object o1, Object o2) {
            Class<?>[] p2;
            Class<?>[] p1;
            MethodDesc md1 = (MethodDesc)o1;
            MethodDesc md2 = (MethodDesc)o2;
            int res = md1.getMethod().getDeclaringClass().getName().compareTo(md2.getMethod().getDeclaringClass().getName());
            if (res == 0 && (res = md1.getMethod().getName().compareTo(md2.getMethod().getName())) == 0 && (res = (p1 = md1.getMethod().getParameterTypes()).length - (p2 = md2.getMethod().getParameterTypes()).length) == 0) {
                for (int i = 0; i < p1.length && (res = p1[i].getName().compareTo(p2[i].getName())) == 0; ++i) {
                }
            }
            return res;
        }
    }
}

