/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.jgroups;

import java.util.ArrayList;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.base.BaseDiscovery;
import org.ow2.jonas.discovery.jgroups.JgroupsDiscoveryServiceImplMBean;
import org.ow2.jonas.discovery.jgroups.comm.exception.StopDiscException;
import org.ow2.jonas.discovery.jgroups.manager.DiscoveryManager;
import org.ow2.jonas.discovery.jgroups.utils.JGroupsDiscoveryUtils;
import org.ow2.jonas.ha.HaService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JgroupsDiscoveryServiceImpl
extends BaseDiscovery
implements JgroupsDiscoveryServiceImplMBean {
    private static final String DEFAULT_RECONNECTION_TIMEOUT = "5000";
    private static Logger logger = Log.getLogger("org.ow2.jonas.discovery");
    private long reconnectionTimeout;
    private String groupName;
    private String conf;
    private DiscoveryManager dm = null;
    private String multicastAddress = null;
    private String multicastPort = null;
    private HaService haService;

    @Override
    public void doStart() throws ServiceException {
        String discoveryType = "SLAVE";
        this.setMaster(this.getServerProperties().isMaster());
        if (this.getIsDiscoveryMaster()) {
            discoveryType = "MASTER";
        }
        JmxService jmx = this.getJmxService();
        logger.log(BasicLevel.DEBUG, (Object)("Starting discovery " + discoveryType + " on " + jmx.getDomainName() + "for " + jmx.getJonasServerName() + " server."));
        logger = Log.getLogger("org.ow2.jonas.discovery");
        String domainName = jmx.getDomainName();
        JMXServiceURL[] connectorServerURLs = jmx.getConnectorServerURLs();
        this.urlsList = new ArrayList();
        for (int i = 0; i < connectorServerURLs.length; ++i) {
            if (connectorServerURLs[i] == null) continue;
            this.urlsList.add(connectorServerURLs[i].toString());
        }
        String[] urls = new String[this.urlsList.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = (String)this.urlsList.get(i);
        }
        try {
            JGroupsDiscoveryUtils.init(jmx.getJonasServerName(), jmx.getDomainName(), discoveryType, this.conf, this.groupName, jmx.getJmxServer(), urls, this.reconnectionTimeout);
        }
        catch (Throwable e) {
            throw new ServiceException(e.getMessage(), e);
        }
        this.startDomainMonitor(discoveryType);
        try {
            this.multicastAddress = JGroupsDiscoveryUtils.getMulticastAddress();
            this.multicastPort = JGroupsDiscoveryUtils.getMulticastPort();
        }
        catch (Exception e1) {
            logger.log(BasicLevel.DEBUG, (Object)"Cannot retrieve multicast address. Communication protocol is not multicast \n");
        }
        try {
            jmx.registerMBean((Object)this, JonasObjectName.discoveryService(domainName));
        }
        catch (Exception e) {
            logger.log(BasicLevel.DEBUG, (Object)" Unable to register discovery MBean: ", (Throwable)e);
        }
        logger.log(BasicLevel.INFO, (Object)("JGroups based Discovery service started from " + this.conf + " Stack file \n"));
    }

    private void startDomainMonitor(String discoveryType) throws ServiceException {
        this.setTtl(JGroupsDiscoveryUtils.getInstance().getTtl());
        this.dm = new DiscoveryManager(discoveryType);
        try {
            this.dm.start();
        }
        catch (StopDiscException e) {
            logger.log(BasicLevel.DEBUG, (Object)"Discovery manager failed to start due to a pre-existing server in the domain with the same name.", (Throwable)e);
            throw new ServiceException("Problem when starting the Discovery Service: ", e);
        }
    }

    public void start(HashMap<String, Object> env, MBeanServer mbeanSrv, String discoveryType) throws Exception {
        if (discoveryType.equals("CLUSTERD")) {
            this.setMaster(false);
            this.groupName = (String)env.get("group.name");
            this.conf = (String)env.get("jgroups.conf");
            String hostName = (String)env.get("host.name");
            String domainName = (String)env.get("domain.name");
            String reconnectionTimeoutStr = (String)env.get("reconnection.timeout");
            if (reconnectionTimeoutStr == null) {
                reconnectionTimeoutStr = DEFAULT_RECONNECTION_TIMEOUT;
                logger.log(BasicLevel.DEBUG, (Object)" Reconnection timeout is set to default value\n");
            }
            long reconnectionTimeout = new Long(reconnectionTimeoutStr);
            logger.log(BasicLevel.DEBUG, (Object)(" Cluster daemon named " + hostName + " is starting discovery on domain " + domainName + ".\n"));
            String[] urls = null;
            if (this.urlsList == null) {
                this.urlsList = new ArrayList();
                try {
                    urls = (String[])env.get("connector.urls");
                    for (int i = 0; i < urls.length; ++i) {
                        this.urlsList.add(urls[i]);
                    }
                }
                catch (Exception e) {
                    logger.log(BasicLevel.DEBUG, (Object)(" Exception occurred while getting connector urls for host named " + hostName + " in JGroups discovery \n"));
                    throw new Exception("Exception occurred while getting connector urls for host named " + hostName + " in JGrpups discovery", e);
                }
            }
            try {
                JGroupsDiscoveryUtils.init(hostName, domainName, "CLUSTERD", this.conf, this.groupName, mbeanSrv, urls, reconnectionTimeout);
            }
            catch (Throwable e) {
                throw new ServiceException(e.getMessage(), e);
            }
            this.startDomainMonitor(discoveryType);
        } else {
            logger.log(BasicLevel.DEBUG, (Object)" JOnAS instance should not use this method");
        }
    }

    @Override
    public void doStop() throws ServiceException {
        this.dm.stop();
        if (JGroupsDiscoveryUtils.isRegistered(JonasObjectName.discoveryService(JGroupsDiscoveryUtils.getInstance().getDomainName()))) {
            logger.log(BasicLevel.DEBUG, (Object)" Discovery MBean is unregistered from the host MBean server\n");
            try {
                JGroupsDiscoveryUtils.unRegisterMBean(JonasObjectName.discoveryService(JGroupsDiscoveryUtils.getInstance().getDomainName()));
            }
            catch (InstanceNotFoundException e) {
                throw new ServiceException(e.getMessage());
            }
            catch (MBeanRegistrationException e) {
                throw new ServiceException(e.getMessage());
            }
        }
    }

    @Override
    public String getDiscoveryProtocolVersion() {
        return "1.3";
    }

    @Override
    public String getDiscoveryTtl() {
        return String.valueOf(this.getTtl());
    }

    @Override
    public void startDiscoveryMaster() throws JMException {
    }

    @Override
    public String getJonasName() {
        return JGroupsDiscoveryUtils.getInstance().getJonasName();
    }

    @Override
    public MBeanServer getMbeanServer() {
        return this.getJmxService().getJmxServer();
    }

    @Override
    public ObjectName getMyOn() {
        return JonasObjectName.discoveryService(JGroupsDiscoveryUtils.getInstance().getDomainName());
    }

    @Override
    public String getServerId() {
        return JGroupsDiscoveryUtils.getInstance().getServerId();
    }

    @Override
    public String[] getUrls() {
        return (String[])this.urlsList.toArray();
    }

    @Override
    public void setDomainName(String domainName) {
        JGroupsDiscoveryUtils.getInstance().setDomainName(domainName);
    }

    @Override
    public void setJonasName(String jonasName) {
        JGroupsDiscoveryUtils.getInstance().setJonasName(jonasName);
    }

    @Override
    public void setMbeanServer(MBeanServer mbeanServer) {
        JGroupsDiscoveryUtils.getInstance().setMbeanServer(mbeanServer);
    }

    @Override
    public void setMyOn(ObjectName myOn) {
    }

    @Override
    public void setServerId(String serverId) {
        JGroupsDiscoveryUtils.getInstance().setServerId(serverId);
    }

    @Override
    public void setUrls(String[] urls) {
        this.urlsList = this.toArrayList(urls);
    }

    private ArrayList toArrayList(String[] urls) throws NullPointerException {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            for (int i = 0; i < urls.length; ++i) {
                ret.add(urls[i]);
            }
        }
        catch (NullPointerException e) {
            throw new NullPointerException("NullPointerException occurred in JgroupsDiscoveryServiceImpl. Urls list must not be null in toArrayList method \n" + e);
        }
        return ret;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setJgroupsConf(String conf) {
        this.conf = conf;
    }

    @Override
    public String getListeningIp() {
        return JGroupsDiscoveryUtils.getInstance().getLocalAddress().getIpAddress().toString();
    }

    @Override
    public int getListeningPort() {
        return JGroupsDiscoveryUtils.getInstance().getDiscPort();
    }

    @Override
    public ArrayList getUrlsList() {
        return this.urlsList;
    }

    @Override
    public void setListeningIp(String listeningIp) {
    }

    @Override
    public void setListeningPort(int listeningPort) {
    }

    @Override
    public void setUrlsList(ArrayList urlsList) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting urls \n");
        this.urlsList = urlsList;
    }

    public int getGreetingListeningPort() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting listening port \n");
        return JGroupsDiscoveryUtils.getInstance().getDiscPort();
    }

    public void setTimeToLive(int ttl) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting ttl: not yet implemented \n");
    }

    @Override
    public String getMulticastAddress() {
        return this.multicastAddress;
    }

    @Override
    public String getMulticastPort() {
        return this.multicastPort;
    }

    public void setReconnectionTimeout(long reconnectionTimeout) {
        this.reconnectionTimeout = reconnectionTimeout;
    }

    public void setHaService(HaService haService) {
        this.haService = haService;
    }
}

