/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.mejb;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.j2ee.ListenerRegistration;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class ListenerRegistrationImpl
implements ListenerRegistration {
    private JMXServiceURL[] urls = null;
    private transient MBeanServerConnection connection = null;
    private transient JMXConnector connector = null;
    private transient String connectionId = null;

    public ListenerRegistrationImpl(JMXServiceURL[] urls) {
        this.urls = urls;
    }

    public void addNotificationListener(ObjectName arg0, NotificationListener arg1, NotificationFilter arg2, Object arg3) throws InstanceNotFoundException, RemoteException {
        MBeanServerConnection conn = null;
        try {
            conn = this.getConnection();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        if (conn != null) {
            try {
                conn.addNotificationListener(arg0, arg1, arg2, arg3);
            }
            catch (IOException e) {
                throw new RemoteException(e.toString());
            }
        }
    }

    public void removeNotificationListener(ObjectName arg0, NotificationListener arg1) throws InstanceNotFoundException, ListenerNotFoundException, RemoteException {
        MBeanServerConnection conn = null;
        try {
            conn = this.getConnection();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        if (conn != null) {
            try {
                conn.removeNotificationListener(arg0, arg1);
            }
            catch (IOException e) {
                throw new RemoteException(e.toString());
            }
        }
    }

    private void createConnection() throws Exception {
        int i = 0;
        if (i < this.urls.length) {
            JMXServiceURL jmxServiceUrl = this.urls[i];
            this.connector = JMXConnectorFactory.newJMXConnector(jmxServiceUrl, null);
            try {
                this.connector.connect();
                this.connection = this.connector.getMBeanServerConnection();
            }
            catch (Exception e) {
                this.connection = null;
                this.connector.close();
                this.connector = null;
                throw e;
            }
        }
    }

    private MBeanServerConnection getConnection() throws Exception {
        if (this.connection == null) {
            this.createConnection();
        }
        return this.connection;
    }
}

