/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb.easybeans;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.server.Embedded;
import org.ow2.jonas.ejb.easybeans.PrefixedNamingStrategy;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.util.Env;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansDeployer
implements IDeployer {
    private Log logger = LogFactory.getLog(EasyBeansDeployer.class);
    private Embedded easybeansServer = null;
    private Map<URL, EJB3Deployable> ejb3s = new HashMap<URL, EJB3Deployable>();
    private static final String WORK_EJB3S_DIR = JProp.getWorkDir() + File.separator + "ejb3s";
    private ServerProperties serverProperties = null;
    private VersioningService versioningService;

    @Override
    public void deploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof EJB3Deployable) {
            EJB3Deployable ejb3Deployable = (EJB3Deployable)deployable;
            if (Env.isOsWindows()) {
                File folder = new File(WORK_EJB3S_DIR, this.getServerProperties().getServerName());
                folder.mkdirs();
                try {
                    ejb3Deployable = UnpackDeployableHelper.unpack((EJB3Deployable)deployable, folder, FileUtils.lastModifiedFileName(URLUtils.urlToFile(deployable.getArchive().getURL())));
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get archive while deploying EJB3Deployable", e);
                }
                catch (FileUtilsException e) {
                    throw new DeployerException("Cannot get file last modified date while deploying EJB3Deployable", e);
                }
            }
            this.deployEJB3(ejb3Deployable);
        }
    }

    protected void deployEJB3(EJB3Deployable ejb3Deployable) throws DeployerException {
        EJB3Deployable originalDeployable = (EJB3Deployable)ejb3Deployable.getOriginalDeployable();
        if (originalDeployable == null) {
            originalDeployable = ejb3Deployable;
        }
        this.logger.info("Deploying ''{0}''...", originalDeployable);
        EZBContainer container = this.easybeansServer.createContainer(ejb3Deployable.getArchive());
        String prefix = null;
        String versionID = null;
        if (this.versioningService != null && this.versioningService.isVersioningEnabled()) {
            prefix = this.versioningService.getPrefix(originalDeployable);
            versionID = this.versioningService.getVersionID(originalDeployable);
        }
        if (prefix != null) {
            container.getConfiguration().setNamingStrategy(new PrefixedNamingStrategy(prefix, container.getConfiguration().getNamingStrategy()));
        }
        try {
            container.start();
        }
        catch (EZBContainerException e) {
            this.easybeansServer.removeContainer(container);
            throw new DeployerException("Cannot deploy the given EJB '" + originalDeployable + "'.", e);
        }
        try {
            URL initialURL = originalDeployable.getArchive().getURL();
            this.ejb3s.put(initialURL, ejb3Deployable);
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get  the url of the initial deployable for the EJB3 Module '" + originalDeployable + "'.", e);
        }
        if (prefix != null) {
            this.versioningService.createJNDIBindingMBeans(originalDeployable.getModuleName(), versionID, prefix);
        }
        this.logger.info("''{0}'' EJB3 Deployable is now deployed", originalDeployable);
    }

    protected void undeployEJB3(EJB3Deployable ejb3Deployable) throws DeployerException {
        EJB3Deployable originalDeployable = (EJB3Deployable)ejb3Deployable.getOriginalDeployable();
        if (originalDeployable == null) {
            originalDeployable = ejb3Deployable;
        }
        URL ejb3URL = null;
        try {
            ejb3URL = originalDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL on the EJB3 deployable '" + originalDeployable + "'.", e);
        }
        IArchive archive = null;
        EJB3Deployable unpackedDeployable = (EJB3Deployable)ejb3Deployable.getUnpackedDeployable();
        archive = unpackedDeployable != null ? unpackedDeployable.getArchive() : (this.ejb3s.containsKey(ejb3URL) ? this.ejb3s.get(ejb3URL).getArchive() : ejb3Deployable.getArchive());
        this.logger.info("Undeploying ''{0}''...", originalDeployable);
        Map<String, EZBContainer> containers = this.easybeansServer.getContainers();
        EZBContainer foundContainer = null;
        for (EZBContainer container : containers.values()) {
            IArchive containerArchive = container.getArchive();
            if (!archive.equals(containerArchive)) continue;
            foundContainer = container;
            break;
        }
        if (foundContainer == null) {
            throw new DeployerException("Cannot undeploy the deployable '" + originalDeployable + "' as this container is not deployed");
        }
        this.ejb3s.remove(ejb3URL);
        this.logger.debug("Found a matching container ''{0}'' for the archive ''{1}''", foundContainer, originalDeployable.getArchive());
        try {
            foundContainer.stop();
        }
        catch (Exception e) {
            throw new DeployerException("Cannot undeploy the deployable '" + originalDeployable + "'", e);
        }
        if (this.versioningService != null && this.versioningService.isVersioningEnabled()) {
            this.versioningService.garbageCollectJNDIBindingMBeans();
        }
        this.logger.info("''{0}'' EJB3 Deployable is now undeployed", originalDeployable);
    }

    private void check(IDeployable<?> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }

    @Override
    public void undeploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof EJB3Deployable) {
            this.undeployEJB3((EJB3Deployable)deployable);
        }
    }

    @Override
    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        throw new UnsupportedOperationException("IsDeployed not yet supported");
    }

    @Override
    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof EJB3Deployable;
    }

    public void setEmbedded(Embedded easybeansServer) {
        this.easybeansServer = easybeansServer;
    }

    public ServerProperties getServerProperties() {
        return this.serverProperties;
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public void unsetVersioningService() {
        this.versioningService = null;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }
}

