/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.security.Identity;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EnterpriseBean;
import javax.ejb.TimerService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.work.WorkManager;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.common.SecurityRoleRefDesc;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.JFactory;
import org.ow2.jonas.lib.ejb21.JHome;
import org.ow2.jonas.lib.ejb21.JLocalHome;
import org.ow2.jonas.lib.ejb21.PermissionManager;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.tm.TransactionManager;

public abstract class JContext
implements EJBContext {
    private static final String JAVA_COMP_ENV = "java:comp/env/";
    protected EnterpriseBean myinstance;
    protected final JFactory bf;
    protected final TransactionManager tm;
    private final JHome home;
    private final JLocalHome localhome;
    private final JContainer cont;
    private PermissionManager permissionManager = null;
    int instanceState = 0;

    protected JContext(JFactory bf, EnterpriseBean i) {
        this.bf = bf;
        this.myinstance = i;
        if (i == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"null EnterpriseBean!");
        }
        this.home = bf.getHome();
        this.localhome = bf.getLocalHome();
        this.cont = bf.getContainer();
        this.tm = bf.getTransactionManager();
        this.permissionManager = this.cont.getPermissionManager();
    }

    public void setState(int newState) {
        this.instanceState = newState;
        if (TraceEjb.isDebugContext()) {
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)("" + this.instanceState));
        }
    }

    public int getState() {
        if (TraceEjb.isDebugContext()) {
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)("" + this.instanceState));
        }
        return this.instanceState;
    }

    public WorkManager getWorkManager() {
        return this.bf.getWorkManager();
    }

    public Identity getCallerIdentity() {
        throw new RuntimeException("getCallerIdentity() method deprecated. use instead getCallerPrincipal()");
    }

    public Principal getCallerPrincipal() throws IllegalStateException {
        Principal principal;
        if (this.getState() == 0) {
            throw new IllegalStateException("the instance is not allowed to call this method");
        }
        boolean inRunAs = false;
        if (this.bf.dd.getRunAsRole() != null) {
            inRunAs = true;
        }
        if ((principal = this.cont.getPrincipalFactory().getCallerPrincipal(inRunAs)) == null) {
            throw new IllegalStateException("no security context exists");
        }
        return principal;
    }

    public EJBHome getEJBHome() throws IllegalStateException {
        return this.home;
    }

    public EJBLocalHome getEJBLocalHome() throws IllegalStateException {
        if (!this.bf.dd.hasDefinedLocalInterface()) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"No Local Interface declared for this bean");
            throw new IllegalStateException("No Local Interface declared for this bean");
        }
        return this.localhome;
    }

    public Properties getEnvironment() {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.bf.getEjb10Environment();
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.getState() == 0) {
            throw new IllegalStateException("the instance is not allowed to call this method");
        }
        try {
            switch (this.tm.getStatus()) {
                case 1: 
                case 9: {
                    return true;
                }
                case 0: 
                case 2: 
                case 7: 
                case 8: {
                    return false;
                }
                case 4: {
                    throw new IllegalStateException("Transaction already rolled back");
                }
                case 3: {
                    throw new IllegalStateException("Transaction already committed");
                }
                case 5: 
                case 6: {
                    throw new IllegalStateException("Cannot getRollbackOnly outside transaction");
                }
            }
        }
        catch (SystemException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot get transaction status:", (Throwable)e);
            throw new IllegalStateException("Cannot get transaction status");
        }
        return true;
    }

    public abstract TimerService getTimerService() throws IllegalStateException;

    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        if (!this.bf.isTxBeanManaged()) {
            throw new IllegalStateException("This bean is not allowed to use UserTransaction interface");
        }
        if (this.getState() == 0) {
            throw new IllegalStateException("the instance is not allowed to call this method");
        }
        return (UserTransaction)((Object)this.tm);
    }

    public boolean isCallerInRole(Identity role) {
        throw new RuntimeException("isCallerInRole(Identity) method deprecated. use instead isCallerInRole(String)");
    }

    public boolean isCallerInRole(String roleName) throws IllegalStateException {
        if (TraceEjb.isDebugSecurity()) {
            TraceEjb.security.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.getState() == 0) {
            throw new IllegalStateException("the instance is not allowed to call this method");
        }
        List list = this.bf.dd.getSecurityRoleRefDescList();
        if (list == null) {
            TraceEjb.logger.log(BasicLevel.WARN, (Object)"EJB 2.1 spec, Chapter 21 : 21.2.5.2 : No security-role-ref list. Invalid usage of isCallerInRole without security-role-ref elements.");
            return false;
        }
        boolean foundItem = false;
        Iterator it = this.bf.dd.getSecurityRoleRefDescList().iterator();
        String tmpRoleName = null;
        SecurityRoleRefDesc sRoleRefDesc = null;
        while (!foundItem && it.hasNext()) {
            sRoleRefDesc = (SecurityRoleRefDesc)it.next();
            tmpRoleName = sRoleRefDesc.getRoleName();
            if (!tmpRoleName.equals(roleName)) continue;
            foundItem = true;
        }
        if (!foundItem) {
            if (TraceEjb.isDebugSecurity()) {
                TraceEjb.security.log(BasicLevel.DEBUG, (Object)("No security-role-ref with role name '" + roleName + "' was found in the deployment descriptor of bean '" + this.bf.getEJBName() + "."));
            }
            return false;
        }
        boolean inRunAs = false;
        if (this.bf.dd.getRunAsRole() != null) {
            inRunAs = true;
        }
        boolean inRole = this.permissionManager.isCallerInRole(this.bf.getEJBName(), roleName, inRunAs);
        if (TraceEjb.isDebugSecurity()) {
            TraceEjb.security.log(BasicLevel.DEBUG, (Object)("isCallerInRole: " + inRole));
        }
        return inRole;
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.getRollbackOnly();
        try {
            this.tm.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"current thread not associated with transaction");
            throw e;
        }
        catch (SystemException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"setRollbackOnly unexpected exception:", (Throwable)e);
        }
    }

    public Object lookup(String name) {
        try {
            return new InitialContext().lookup(JAVA_COMP_ENV + name);
        }
        catch (NamingException ne) {
            try {
                return new InitialContext().lookup(name);
            }
            catch (NamingException e) {
                throw new IllegalArgumentException("Lookup on '" + name + "' was not found");
            }
        }
    }
}

