/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.ha;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.ejb21.JLocalHome;
import org.ow2.jonas.lib.ejb21.JSessionContext;
import org.ow2.jonas.lib.ejb21.JSessionFactory;
import org.ow2.jonas.lib.ejb21.JStatefulContext;
import org.ow2.jonas.lib.ejb21.JStatefulInputStream;
import org.ow2.jonas.lib.ejb21.JStatefulSwitch;
import org.ow2.jonas.lib.ejb21.JWrapper;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.ejb21.ha.JRepStatefulLocal;
import org.ow2.jonas.lib.ejb21.ha.JRepStatefulLocalHome;
import org.ow2.jonas.lib.ejb21.ha.JRepStatefulObjectId;
import org.ow2.jonas.lib.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRepStatefulInputStream
extends JStatefulInputStream {
    protected static Logger cmilogger = Log.getLogger("org.ow2.jonas.lib.ejb21.ha");

    public JRepStatefulInputStream(InputStream in, JStatefulSwitch jss) throws IOException {
        super(in, jss);
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        Object ret;
        if (obj instanceof JWrapper) {
            int type = ((JWrapper)obj).getType();
            switch (type) {
                case 5: {
                    TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"JEntityLocal");
                    String jndiname = (String)((JWrapper)obj).getObject();
                    Object pk = ((JWrapper)obj).getPK();
                    JLocalHome o = JLocalHome.getLocalHome(jndiname);
                    ret = null;
                    try {
                        ret = this.getFindByPKMethod(o.getClass(), pk.getClass()).invoke((Object)o, pk);
                        break;
                    }
                    catch (Exception e) {
                        cmilogger.log(BasicLevel.ERROR, (Object)("Cannot find an object with the primary key " + pk), (Throwable)e);
                        throw new IOException("Cannot find an object with the primary key " + pk);
                    }
                }
                default: {
                    ret = super.resolveObject(obj);
                    break;
                }
            }
        } else if (obj instanceof JRepStatefulObjectId) {
            JRepStatefulObjectId jrsoi = (JRepStatefulObjectId)obj;
            JRepStatefulLocalHome jrslh = (JRepStatefulLocalHome)JLocalHome.getLocalHome(jrsoi.getJndi());
            JRepStatefulLocal jrsl = null;
            JStatefulSwitch bs = null;
            JSessionFactory sf = (JSessionFactory)jrslh.getBeanFactory();
            try {
                bs = (JStatefulSwitch)sf.createEJB();
                JSessionContext bctx = sf.getJContext(bs);
                bs.bindICtx(null, (JStatefulContext)bctx);
                bctx.setState(2);
            }
            catch (AccessLocalException e) {
                throw new EJBException("Security Exception thrown by an enterprise Bean", e);
            }
            catch (EJBException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new EJBException("RuntimeException thrown by an enterprise Bean", e);
            }
            catch (Error e) {
                throw new EJBException("Error thrown by an enterprise Bean" + e);
            }
            catch (RemoteException e) {
                throw new EJBException("Remote Exception raised:", e);
            }
            jrsl = (JRepStatefulLocal)bs.getLocal();
            jrsl.setClusterOId(jrsoi.getClusterOId());
            ret = jrsl;
        } else {
            ret = super.resolveObject(obj);
        }
        return ret;
    }

    private Method getFindByPKMethod(Class<?> c, Class<?> pk) throws SecurityException {
        for (Method method : c.getMethods()) {
            if (!method.getName().equals("findByPrimaryKey")) continue;
            return method;
        }
        return null;
    }
}

