/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.sql;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.eval.api.QueryEvaluator;
import org.objectweb.medor.eval.lib.MedorEvaluator;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.optim.api.QueryTransformer;
import org.objectweb.medor.query.api.OrderField;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.jorm.api.JormExtent;
import org.objectweb.medor.query.jorm.lib.ClassExtent;
import org.objectweb.medor.query.jorm.lib.JormQueryTreeHelper;
import org.objectweb.medor.query.jorm.lib.QueryBuilder;
import org.objectweb.medor.query.lib.QueryTreePrinter;
import org.objectweb.medor.query.lib.SelectProject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.ejb.DeploymentDescEjb2;
import org.ow2.jonas.deployment.ejb.EntityCmp2Desc;
import org.ow2.jonas.deployment.ejb.MethodCmp2Desc;
import org.ow2.jonas.deployment.ejb.ejbql.ASTEJBQL;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.ejb21.jorm.RdbMappingBuilder;
import org.ow2.jonas.lib.ejb21.sql.EjbqlLimitVisitor;
import org.ow2.jonas.lib.ejb21.sql.EjbqlLimiterRange;
import org.ow2.jonas.lib.ejb21.sql.EjbqlOrderByVisitor;
import org.ow2.jonas.lib.ejb21.sql.EjbqlQueryFilterVisitor;
import org.ow2.jonas.lib.ejb21.sql.EjbqlSelectVisitor;
import org.ow2.jonas.lib.ejb21.sql.EjbqlVariableVisitor;

public class EjbqlQueryTreeHolder {
    QueryTree queryTree = null;
    QueryTransformer queryOptimizer = null;
    QueryEvaluator optimizedQuery = null;
    Field resField = null;
    EjbqlLimiterRange[] limiterRanges = null;
    private String beanName;
    private String methodName;
    private int prefetchIdentifierIndex;

    public EjbqlQueryTreeHolder(MethodCmp2Desc mDesc, ASTEJBQL ejbql, PMapper mapper, Manager mgr) throws Exception {
        EntityCmp2Desc eDesc = (EntityCmp2Desc)mDesc.getBeanDesc();
        DeploymentDescEjb2 dd = (DeploymentDescEjb2)eDesc.getDeploymentDesc();
        QueryBuilder qb = new QueryBuilder();
        EjbqlVariableVisitor visitor = new EjbqlVariableVisitor(ejbql, dd, qb, mgr);
        Map fields = visitor.getFields();
        SelectProject sp = new SelectProject("");
        if (mDesc.getPrefetch() && mapper != null) {
            ClassExtent ce = null;
            QueryTree qt = null;
            String jormClassName = ((EntityCmp2Desc)mDesc.getBeanDesc()).getJormClassName();
            Iterator itFields = fields.values().iterator();
            boolean found = false;
            while (itFields.hasNext() && !found) {
                QueryTree cqt = ((QueryTreeField)itFields.next()).getQueryTree();
                Collection extents = JormQueryTreeHelper.getJormExtents(cqt);
                Iterator it = extents.iterator();
                while (it.hasNext() && !found) {
                    JormExtent je = (JormExtent)it.next();
                    if (!jormClassName.equals(je.getJormName())) continue;
                    found = true;
                    ce = (ClassExtent)je;
                    qt = cqt;
                }
            }
            if (ce == null && qt == null) {
                throw new Error("EjbqlQueryTreeHolder: cannot do the prefetch !!!");
            }
            this.setMapper(qt, mapper);
            JormQueryTreeHelper.addPrefetchFields(ce, qt, sp);
            this.prefetchIdentifierIndex = sp.getTupleStructure().getSize() + 1;
        }
        EjbqlSelectVisitor selectVisitor = new EjbqlSelectVisitor(ejbql, fields, sp);
        Expression qf = new EjbqlQueryFilterVisitor(mapper, fields, mDesc.getMethod().getParameterTypes(), ejbql, qb).getQueryFilter();
        sp.setQueryFilter(qf);
        OrderField[] ofs = new EjbqlOrderByVisitor(ejbql, fields).getOrderFields();
        if (ofs.length > 0) {
            sp.setOrderBy(ofs);
        }
        this.limiterRanges = new EjbqlLimitVisitor(ejbql, mDesc.getMethod().getParameterTypes()).getLimiterRanges();
        this.queryTree = selectVisitor.getQueryTree();
        this.setMapper(this.queryTree, mapper);
        this.resField = this.queryTree.getTupleStructure().getField(this.queryTree.getTupleStructure().getSize());
        this.beanName = eDesc.getJormClassName();
        this.methodName = mDesc.getMethod().getName();
    }

    private void setMapper(QueryTree tree, PMapper mapper) {
        if (mapper != null) {
            Collection extents = JormQueryTreeHelper.getJormExtents(tree);
            for (JormExtent je : extents) {
                je.setPMapper(mapper, RdbMappingBuilder.getProjectName());
            }
        }
    }

    public int getPrefetchIndex() {
        return this.prefetchIdentifierIndex;
    }

    public QueryTree getQueryTree() {
        return this.queryTree;
    }

    public void setQueryOptimizer(QueryTransformer qtf) {
        this.optimizedQuery = null;
        this.queryOptimizer = qtf;
    }

    public QueryTransformer getQueryOptimizer() {
        return this.queryOptimizer;
    }

    public Field getResField() {
        return this.resField;
    }

    public EjbqlLimiterRange[] getLimiterRanges() {
        return this.limiterRanges;
    }

    public QueryEvaluator getOptimizedQueryTree() throws MedorException {
        if (this.optimizedQuery == null) {
            if (TraceEjb.isDebugQuery()) {
                TraceEjb.query.log(BasicLevel.DEBUG, (Object)("Initial QueryTree of the method " + this.methodName + " of the bean " + this.beanName));
                QueryTreePrinter.printQueryTree(this.queryTree, TraceEjb.query, BasicLevel.DEBUG);
            }
            QueryTree qt = this.queryOptimizer.transform(this.queryTree);
            if (TraceEjb.isDebugQuery()) {
                TraceEjb.query.log(BasicLevel.DEBUG, (Object)("Optimized QueryTree of the method " + this.methodName + " of the bean " + this.beanName));
                QueryTreePrinter.printQueryTree(qt, TraceEjb.query, BasicLevel.DEBUG);
            }
            this.optimizedQuery = new MedorEvaluator(qt, 0L);
        }
        return this.optimizedQuery;
    }
}

