/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.tools;

import javax.management.ObjectName;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.management.tools.BaseManagement;
import org.ow2.jonas.lib.management.tools.ManagementException;
import org.ow2.jonas.lib.management.tools.ManagementRepr;
import org.ow2.jonas.lib.util.Log;

public class ServerManagement
extends BaseManagement {
    private static final String serverVersionAttribute = "serverVersion";
    private static final String currentUsedMemoryAttribute = "currentUsedMemory";
    private ObjectName serverOn = J2eeObjectName.J2EEServer(this.getDomainName(), this.getServerName());
    protected static Logger serverManagement = Log.getLogger("org.ow2.jonas.management");

    public String getServerVersion(String pServer) throws ManagementException {
        String pDomain = this.getDomainName();
        ObjectName serverOn = this.getServerOn(pServer, pDomain);
        return (String)ManagementRepr.getAttribute(serverOn, serverVersionAttribute, pServer);
    }

    public String getServerVersion() throws ManagementException {
        return (String)ManagementRepr.getAttribute(this.serverOn, serverVersionAttribute, this.getServerName());
    }

    public long currentUsedMemory() throws ManagementException {
        Long usedMemory = (Long)ManagementRepr.getAttribute(this.serverOn, currentUsedMemoryAttribute, this.getServerName());
        return usedMemory;
    }

    public long currentUsedMemory(String pServer) throws ManagementException {
        String pDomain = this.getDomainName();
        ObjectName serverOn = this.getServerOn(pServer, pDomain);
        Long usedMemory = (Long)ManagementRepr.getAttribute(serverOn, currentUsedMemoryAttribute, this.getServerName());
        return usedMemory;
    }

    private ObjectName getServerOn(String pServer, String pDomain) throws ManagementException {
        return J2eeObjectName.J2EEServer(pDomain, pServer);
    }
}

