/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.management.ObjectName;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.Referenceable;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import org.apache.commons.modeler.Registry;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.ejb.ActivationConfigPropertyDesc;
import org.ow2.jonas.deployment.rar.ConfigPropertyDesc;
import org.ow2.jonas.deployment.rar.ConnectorDesc;
import org.ow2.jonas.deployment.rar.JdbcConnParamsDesc;
import org.ow2.jonas.deployment.rar.JonasConfigPropertyDesc;
import org.ow2.jonas.deployment.rar.JonasConnectorDesc;
import org.ow2.jonas.deployment.rar.PoolParamsDesc;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.naming.ComponentContext;
import org.ow2.jonas.lib.util.JNDIUtils;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.resource.internal.cm.ConnectionManagerImpl;
import org.ow2.jonas.resource.internal.cm.ConnectionManagerPoolParams;
import org.ow2.jonas.resource.internal.mbean.JCAConnectionFactory;
import org.ow2.jonas.resource.internal.mbean.JCAManagedConnectionFactory;
import org.ow2.jonas.resource.internal.mbean.JCAResource;
import org.ow2.jonas.resource.internal.naming.ResourceObjectFactory;
import org.ow2.jonas.tm.TransactionManager;

public class ResourceUtility {
    private static Logger logger = null;
    private static Logger setterLogger = null;
    private static Logger manageLogger = null;
    private Registry oRegistry = null;
    private JmxService jmx = null;
    public static final String JCD = "JCD";
    public static final String JAS = "JAS";
    public static final String JAO = "JAO";

    public ResourceUtility() {
    }

    public ResourceUtility(JmxService jmx, Logger log, Logger sLog, Logger mLog) {
        this.jmx = jmx;
        logger = log;
        setterLogger = sLog;
        manageLogger = mLog;
    }

    public ConfigPropertyDesc[] buildConfigProperty(List raCfg, List jRaCfg1, List jRaCfg2) {
        int j;
        String val;
        String name;
        Vector<ConfigPropertyDesc> cfVec = null;
        Object[] configs = null;
        if (raCfg != null) {
            Iterator i = raCfg.iterator();
            while (i.hasNext()) {
                if (cfVec == null) {
                    cfVec = new Vector<ConfigPropertyDesc>();
                }
                cfVec.add(new ConfigPropertyDesc((ConfigPropertyDesc)i.next()));
            }
        } else {
            Iterator i;
            ActivationConfigPropertyDesc acp = null;
            ConfigPropertyDesc cp = null;
            if (jRaCfg1 != null) {
                i = jRaCfg1.iterator();
                while (i.hasNext()) {
                    if (cfVec == null) {
                        cfVec = new Vector();
                    }
                    acp = (ActivationConfigPropertyDesc)i.next();
                    cp = new ConfigPropertyDesc();
                    cp.setConfigPropertyName(acp.getActivationConfigPropertyName());
                    cp.setConfigPropertyValue(acp.getActivationConfigPropertyValue());
                    cfVec.add(cp);
                }
            }
            if (cfVec == null) {
                if (jRaCfg2 != null) {
                    i = jRaCfg2.iterator();
                    while (i.hasNext()) {
                        if (cfVec == null) {
                            cfVec = new Vector();
                        }
                        acp = (ActivationConfigPropertyDesc)i.next();
                        cp = new ConfigPropertyDesc();
                        cp.setConfigPropertyName(acp.getActivationConfigPropertyName());
                        cp.setConfigPropertyValue(acp.getActivationConfigPropertyValue());
                        cfVec.add(cp);
                    }
                    if (cfVec != null) {
                        configs = new ConfigPropertyDesc[cfVec.size()];
                        cfVec.copyInto(configs);
                    }
                }
            } else {
                if (jRaCfg2 != null) {
                    boolean found = false;
                    Iterator i2 = jRaCfg2.iterator();
                    while (i2.hasNext()) {
                        found = false;
                        acp = (ActivationConfigPropertyDesc)i2.next();
                        String name2 = acp.getActivationConfigPropertyName();
                        String val2 = acp.getActivationConfigPropertyValue();
                        if (val2 == null || val2.length() <= 0) continue;
                        for (int j2 = 0; j2 < cfVec.size(); ++j2) {
                            cp = (ConfigPropertyDesc)cfVec.get(j2);
                            if (!name2.equalsIgnoreCase(cp.getConfigPropertyName())) continue;
                            cp.setConfigPropertyValue(val2);
                            cfVec.set(j2, cp);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        cp = new ConfigPropertyDesc();
                        cp.setConfigPropertyName(name2);
                        cp.setConfigPropertyValue(val2);
                        cfVec.add(cp);
                    }
                }
                configs = new ConfigPropertyDesc[cfVec.size()];
                cfVec.copyInto(configs);
            }
            if (cfVec == null) {
                return null;
            }
            return configs;
        }
        if (cfVec == null) {
            return null;
        }
        configs = new ConfigPropertyDesc[cfVec.size()];
        cfVec.copyInto(configs);
        JonasConfigPropertyDesc jcpNext2 = null;
        if (jRaCfg2 != null) {
            block5: for (JonasConfigPropertyDesc jcpNext2 : jRaCfg2) {
                name = jcpNext2.getJonasConfigPropertyName();
                val = jcpNext2.getJonasConfigPropertyValue();
                if (val == null || val.length() <= 0) continue;
                for (j = 0; j < configs.length; ++j) {
                    if (!name.equalsIgnoreCase(((ConfigPropertyDesc)configs[j]).getConfigPropertyName())) continue;
                    ((ConfigPropertyDesc)configs[j]).setConfigPropertyValue(val);
                    continue block5;
                }
            }
        }
        if (jRaCfg1 != null) {
            block7: for (JonasConfigPropertyDesc jcpNext2 : jRaCfg1) {
                name = jcpNext2.getJonasConfigPropertyName();
                val = jcpNext2.getJonasConfigPropertyValue();
                if (val == null || val.length() <= 0) continue;
                for (j = 0; j < configs.length; ++j) {
                    if (!name.equalsIgnoreCase(((ConfigPropertyDesc)configs[j]).getConfigPropertyName())) continue;
                    ((ConfigPropertyDesc)configs[j]).setConfigPropertyValue(val);
                    continue block7;
                }
            }
        }
        return configs;
    }

    private boolean checkLogEnabled(String inp) {
        return inp.equals("1") || inp.equalsIgnoreCase("on") || inp.equalsIgnoreCase("t") || inp.equalsIgnoreCase("true") || inp.equalsIgnoreCase("y") || inp.equalsIgnoreCase("yes");
    }

    public ConnectionManager createConnectionManager(String trans, TransactionManager tm, Logger logger, Logger poolLogger) throws Exception {
        ConnectionManagerImpl cm = new ConnectionManagerImpl(trans);
        ComponentContext c = new ComponentContext("");
        c.rebind("transactionManager", (Object)tm);
        c.rebind("org.objectweb.util.monolog.logger", (Object)logger);
        c.rebind("org.objectweb.util.monolog.logger_pool", (Object)poolLogger);
        cm.init(c);
        return cm;
    }

    public Object processMCF(ConnectorDesc conn, JonasConnectorDesc jonasConn, ClassLoader curLoader, String rarName, String mcfc, String jndiName, String logEnabled, String logTopic, ConfigPropertyDesc[] cfgRaJonas, ResourceAdapter resAdp, int idOff) throws Exception {
        if (mcfc == null) {
            logger.log(BasicLevel.ERROR, (Object)"ResourceService.createRA: managedconnectionfactoryclass property not found");
            throw new Exception("configuration file incorrect");
        }
        if (jndiName == null || jndiName.length() == 0) {
            logger.log(BasicLevel.ERROR, (Object)"ResourceService.createRA: jndi-name not set in jonas-ra.xml");
            throw new Exception("configuration file incorrect");
        }
        Class<?> mcfClass = curLoader.loadClass(mcfc);
        ManagedConnectionFactory mcf = (ManagedConnectionFactory)mcfClass.newInstance();
        if (resAdp != null) {
            try {
                ((ResourceAdapterAssociation)((Object)mcf)).setResourceAdapter(resAdp);
            }
            catch (ClassCastException ce) {
            }
            catch (Exception ex) {
                logger.log(BasicLevel.ERROR, (Object)("ResourceService: Error setting ResourceAdapter class to ManagedConnectionFactory (" + mcfc + ") for " + jndiName));
                throw ex;
            }
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("jndiName=" + jndiName));
        }
        if (logEnabled != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("log-enabled=" + logEnabled));
            }
            if (this.checkLogEnabled(logEnabled)) {
                if (logTopic != null && logTopic.length() > 0) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("log-topic=" + logTopic));
                    }
                    mcf.setLogWriter(Log.getLogWriter(logTopic));
                } else {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"default log-topic=org.ow2.jonas.jca");
                    }
                    mcf.setLogWriter(Log.getLogWriter("org.ow2.jonas.jca"));
                }
            }
        }
        this.processSetters(mcfClass, mcf, rarName, cfgRaJonas);
        PrintWriter pw = mcf.getLogWriter();
        if (pw != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
            String date = sdf.format(new Date());
            pw.println("MCF: output starting at " + date);
            pw.flush();
        }
        try {
            ((Object)mcf).hashCode();
        }
        catch (Exception ex) {
            String err = "Exception  in ManagedConnectionFactory.hashCode(): ";
            logger.log(BasicLevel.ERROR, (Object)(err + ex));
        }
        return mcf;
    }

    public void registerMBean(Referenceable cf, String jndiName, String rarName, String rarFileName, ConnectorDesc conn, JonasConnectorDesc jonasConn, String factType, int factOffset, JCAResource jcaResourceMBean, String jcaResourceName, String jDomain, String jServer, Context ictx, Properties prop, String description, ConnectionManagerImpl cm) throws Exception {
        try {
            Reference ref = new Reference(cf.getClass().getName(), ResourceObjectFactory.class.getName(), null);
            ref.add(new StringRefAddr("jndiname", jndiName));
            ref.add(new StringRefAddr("rarobjname", rarName));
            ref.add(new StringRefAddr("factorytype", factType));
            ref.add(new StringRefAddr("factoryoffset", "" + factOffset));
            byte[] bytes = JNDIUtils.getBytesFromObject(conn);
            if (bytes != null) {
                ref.add(new BinaryRefAddr("raxml", bytes));
            }
            if ((bytes = JNDIUtils.getBytesFromObject(jonasConn)) != null) {
                ref.add(new BinaryRefAddr("jonasraxml", bytes));
            }
            cf.setReference(ref);
            ictx.rebind(jndiName, (Object)cf);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("ResourceService: Cannot register ResourceAdapter in naming with the name " + jndiName));
            logger.log(BasicLevel.ERROR, (Object)("ResourceService: Exception caught : " + e));
        }
        if (this.jmx == null) {
            return;
        }
        String jcaConnectionFactoryName = jndiName;
        ObjectName onJCAConnectionFactory = J2eeObjectName.getJCAConnectionFactory(jDomain, jcaResourceName, jServer, jcaConnectionFactoryName);
        JCAConnectionFactory jcaConnectionFactoryMBean = new JCAConnectionFactory(onJCAConnectionFactory.toString(), jndiName, rarFileName, prop, description, cm);
        this.jmx.registerModelMBean((Object)jcaConnectionFactoryMBean, onJCAConnectionFactory);
        if (manageLogger.isLoggable(BasicLevel.DEBUG)) {
            manageLogger.log(BasicLevel.DEBUG, (Object)"JCAConnectionFactory created");
        }
        jcaResourceMBean.setConnectionFactory(onJCAConnectionFactory.toString());
        String jcaManagedConnectionFactoryName = this.getJcaMcfName(jcaConnectionFactoryName);
        ObjectName onJCAManagedConnectionFactory = J2eeObjectName.getJCAManagedConnectionFactory(jDomain, jServer, jcaManagedConnectionFactoryName);
        JCAManagedConnectionFactory jcaManagedConnectionFactoryMBean = new JCAManagedConnectionFactory(onJCAManagedConnectionFactory.toString());
        this.jmx.registerModelMBean((Object)jcaManagedConnectionFactoryMBean, onJCAManagedConnectionFactory);
        if (manageLogger.isLoggable(BasicLevel.DEBUG)) {
            manageLogger.log(BasicLevel.DEBUG, (Object)"JCAManagedConnectionFactory created");
        }
        jcaConnectionFactoryMBean.setManagedConnectionFactory(onJCAManagedConnectionFactory.toString());
        if (manageLogger.isLoggable(BasicLevel.DEBUG)) {
            manageLogger.log(BasicLevel.DEBUG, (Object)"JCAConnectionFactory updated");
        }
    }

    public void processSetters(Class clsClass, Object clsObj, String rarFileName, ConfigPropertyDesc[] cProp) throws Exception {
        for (int curParam = 0; cProp != null && curParam < cProp.length; ++curParam) {
            int i;
            String fieldName = cProp[curParam].getConfigPropertyName();
            String methodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            String fieldType = cProp[curParam].getConfigPropertyType();
            Method[] m = clsClass.getMethods();
            for (i = 0; i < m.length && (!m[i].getName().equals(methodName) || m[i].getParameterTypes().length != 1 || fieldType != null && !m[i].getParameterTypes()[0].getName().equals(fieldType)); ++i) {
            }
            if (i < m.length) {
                Class<?>[] paramtype = m[i].getParameterTypes();
                Object[] param = new Object[1];
                String curValue = cProp[curParam].getConfigPropertyValue();
                if (setterLogger.isLoggable(BasicLevel.DEBUG)) {
                    setterLogger.log(BasicLevel.DEBUG, (Object)("Processing Field Name: " + fieldName + " Type: " + fieldType + " Value: " + curValue));
                }
                if (paramtype[0].equals(Integer.TYPE) || paramtype[0].equals(Integer.class)) {
                    param[0] = new Integer(curValue);
                } else if (paramtype[0].equals(Boolean.TYPE) || paramtype[0].equals(Boolean.class)) {
                    param[0] = new Boolean(curValue);
                } else if (paramtype[0].equals(Double.TYPE) || paramtype[0].equals(Double.class)) {
                    param[0] = new Double(curValue);
                } else if (paramtype[0].equals(Byte.TYPE) || paramtype[0].equals(Byte.class)) {
                    param[0] = new Byte(curValue);
                } else if (paramtype[0].equals(Short.TYPE) || paramtype[0].equals(Short.class)) {
                    param[0] = new Short(curValue);
                } else if (paramtype[0].equals(Long.TYPE) || paramtype[0].equals(Long.class)) {
                    param[0] = new Long(curValue);
                } else if (paramtype[0].equals(Float.TYPE) || paramtype[0].equals(Float.class)) {
                    param[0] = new Float(curValue);
                } else if (paramtype[0].equals(Character.TYPE) || paramtype[0].equals(Character.class)) {
                    param[0] = new Character(curValue.charAt(0));
                } else if (paramtype[0].equals(String.class)) {
                    param[0] = curValue;
                    if (setterLogger.isLoggable(BasicLevel.DEBUG)) {
                        setterLogger.log(BasicLevel.DEBUG, (Object)("Calling String method with " + curValue));
                    }
                } else {
                    logger.log(BasicLevel.ERROR, (Object)("Type unsupported for setter method:" + methodName));
                    throw new Exception("incorrect type for setter method ");
                }
                try {
                    m[i].invoke(clsObj, param);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("method " + methodName + " not found for " + rarFileName + "check its configuration "));
                }
                continue;
            }
            logger.log(BasicLevel.ERROR, (Object)("Method not found in class '" + clsClass + "': " + methodName));
            throw new Exception("method name '" + methodName + "' not found in class '" + clsClass + "'");
        }
    }

    public ConnectionManagerPoolParams configurePoolParams(PoolParamsDesc pParams, JdbcConnParamsDesc jConnParams, ConnectionManagerPoolParams pool) throws Exception {
        ConnectionManagerPoolParams cmpp = null;
        cmpp = pool == null ? new ConnectionManagerPoolParams() : new ConnectionManagerPoolParams(pool);
        String tmpPool = null;
        try {
            if (pParams != null) {
                if (pParams.getPoolInit() != null && (tmpPool = pParams.getPoolInit()) != null && tmpPool.length() > 0) {
                    cmpp.setPoolInit(Integer.parseInt(tmpPool));
                }
                if (pParams.getPoolMin() != null && (tmpPool = pParams.getPoolMin()) != null && tmpPool.length() > 0) {
                    cmpp.setPoolMin(Integer.parseInt(tmpPool));
                }
                if (pParams.getPoolMax() != null && (tmpPool = pParams.getPoolMax()) != null && tmpPool.length() > 0) {
                    cmpp.setPoolMax(Integer.parseInt(tmpPool));
                }
                if (pParams.getPoolMaxAge() != null && (tmpPool = pParams.getPoolMaxAge()) != null && tmpPool.length() > 0) {
                    cmpp.setPoolMaxAge(Long.parseLong(tmpPool));
                }
                if (pParams.getPoolMaxAgeMinutes() != null && (tmpPool = pParams.getPoolMaxAgeMinutes()) != null && tmpPool.length() > 0) {
                    cmpp.setPoolMaxAgeMinutes(Integer.parseInt(tmpPool));
                }
                if (pParams.getPoolMaxOpentime() != null && (tmpPool = pParams.getPoolMaxOpentime()) != null && tmpPool.length() > 0) {
                    cmpp.setPoolMaxOpentime(Integer.parseInt(tmpPool));
                }
                if (pParams.getPoolMaxWaiters() != null && (tmpPool = pParams.getPoolMaxWaiters()) != null && tmpPool.length() > 0) {
                    cmpp.setPoolMaxWaiters(Integer.parseInt(tmpPool));
                }
                if (pParams.getPoolMaxWaittime() != null && (tmpPool = pParams.getPoolMaxWaittime()) != null && tmpPool.length() > 0) {
                    cmpp.setPoolMaxWaittime(Integer.parseInt(tmpPool));
                }
                if (pParams.getPoolSamplingPeriod() != null && (tmpPool = pParams.getPoolSamplingPeriod()) != null && tmpPool.length() > 0) {
                    cmpp.setPoolSamplingPeriod(Integer.parseInt(tmpPool));
                }
                if (pParams.getPstmtMax() != null && (tmpPool = pParams.getPstmtMax()) != null && tmpPool.length() > 0) {
                    cmpp.setPstmtMax(Integer.parseInt(tmpPool));
                }
            }
            if (jConnParams != null) {
                if (jConnParams.getJdbcCheckLevel() != null && (tmpPool = jConnParams.getJdbcCheckLevel()) != null && tmpPool.length() > 0) {
                    cmpp.setJdbcConnLevel(Integer.parseInt(tmpPool));
                }
                if (jConnParams.getJdbcTestStatement() != null) {
                    cmpp.setJdbcConnTestStmt(jConnParams.getJdbcTestStatement());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.log(BasicLevel.ERROR, (Object)("Invalid Pool parameter from jonas-ra.xml:  Ensure that numeric values are used. " + tmpPool));
            throw new Exception("incorrect pool parameter ");
        }
        return cmpp;
    }

    public Object getJonasXML(JonasConnectorDesc jonasConn, String id, int idOffset, String oType) throws Exception {
        try {
            Object obj = null;
            if (JCD.equals(oType)) {
                obj = jonasConn.getJonasConnectionDefinitionList().get(idOffset);
            } else if (JAS.equals(oType)) {
                obj = jonasConn.getJonasActivationspecList().get(idOffset);
            } else if (JAO.equals(oType)) {
                obj = jonasConn.getJonasAdminobjectList().get(idOffset);
            }
            return obj;
        }
        catch (IndexOutOfBoundsException e) {
            throw new Exception("Element " + oType + ", " + idOffset + " is not found in the jonas-ra.xml", e);
        }
    }

    public String getJcaMcfName(String jndiName) {
        return jndiName;
    }
}

