/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StringReader;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.security.jacc.handlers.JPolicyContextHandler;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.security.internal.JResources;
import org.ow2.jonas.security.internal.JonasSecurityServiceImplMBean;
import org.ow2.jonas.security.internal.PolicyProvider;
import org.ow2.jonas.security.internal.realm.factory.JResourceDS;
import org.ow2.jonas.security.internal.realm.factory.JResourceLDAP;
import org.ow2.jonas.security.internal.realm.factory.JResourceMemory;
import org.ow2.jonas.security.internal.realm.factory.JResourceRemoteImpl;
import org.ow2.jonas.security.internal.realm.lib.HashHelper;
import org.ow2.jonas.security.internal.realm.principal.Group;
import org.ow2.jonas.security.internal.realm.principal.Role;
import org.ow2.jonas.security.lib.JResourceManager;
import org.ow2.jonas.security.realm.factory.JResource;
import org.ow2.jonas.security.realm.principal.JUser;
import org.ow2.jonas.service.ServiceException;

public class JonasSecurityServiceImpl
extends AbsServiceImpl
implements SecurityService,
JonasSecurityServiceImplMBean {
    private static Logger logger = Log.getLogger("org.ow2.jonas.security");
    public static final String REMOTE_RESOUCE = "_remoteres";
    protected static final String CONFIG_FILE = "conf" + File.separator + "jonas-realm.xml";
    private JmxService jmxService = null;
    private RegistryService registryService;
    private JResources jResources;
    private Context ictx = null;
    private boolean bindResourcesIntoJndi = false;

    public void setRealmJndiRegistration(boolean register) {
        this.bindResourcesIntoJndi = register;
    }

    public void removeJResource(String resourceName) throws Exception {
        JResource jResource = this.jResources.remove(resourceName);
        if (this.bindResourcesIntoJndi) {
            try {
                this.ictx.unbind(resourceName);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("jResource " + resourceName + " remove from the registry."));
                }
            }
            catch (NamingException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot unbind the resource '" + resourceName + "' into JNDI"), (Throwable)e);
            }
        }
        try {
            jResource.removeMBeans();
            if (jResource instanceof JResourceMemory) {
                this.jmxService.unregisterMBean(JonasObjectName.securityMemoryFactory(this.getDomainName(), resourceName));
            } else if (jResource instanceof JResourceDS) {
                this.jmxService.unregisterMBean(JonasObjectName.securityDatasourceFactory(this.getDomainName(), resourceName));
            } else if (jResource instanceof JResourceLDAP) {
                this.jmxService.unregisterMBean(JonasObjectName.securityLdapFactory(this.getDomainName(), resourceName));
            }
        }
        catch (ServiceException se) {
            logger.log(BasicLevel.ERROR, (Object)"JMX service not available", (Throwable)se);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Can not unregister the MBean for the resource " + resourceName + " : " + e.getMessage()));
            throw new ServiceException("Can not unregister the MBean for the resource " + resourceName + " : " + e.getMessage());
        }
    }

    public void setRegistryService(RegistryService registry) {
        this.registryService = registry;
    }

    private RegistryService getRegistryService() {
        return this.registryService;
    }

    private void initJACCPolicyContextHandlers() throws PolicyContextException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        JPolicyContextHandler policyContextHandler = new JPolicyContextHandler();
        String[] keys = policyContextHandler.getKeys();
        for (int k = 0; k < keys.length; ++k) {
            logger.log(BasicLevel.DEBUG, (Object)("key " + keys[k]));
            PolicyContext.registerHandler(keys[k], policyContextHandler, true);
        }
    }

    public void doStart() throws ServiceException {
        PolicyProvider.init();
        try {
            this.initJACCPolicyContextHandlers();
        }
        catch (PolicyContextException e1) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot init JACCPolicyContextHandlers");
            throw new ServiceException("Cannot init JACCPolicyContextHandlers :" + e1);
        }
        try {
            JonasSecurityServiceImpl ss = this;
            this.jResources = new JResources(this);
            try {
                JResourceRemoteImpl jrri = new JResourceRemoteImpl(ss);
                this.ictx = this.getRegistryService().getRegistryContext();
                this.ictx.rebind(this.getJonasServerName() + REMOTE_RESOUCE, (Object)jrri);
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)"Cannot create initial context when Security service initializing");
                throw new ServiceException("Cannot create initial context when Security service initializing", e);
            }
            this.jmxService.registerMBean((Object)this, JonasObjectName.securityService(this.getDomainName()));
        }
        catch (ServiceException se) {
            logger.log(BasicLevel.ERROR, (Object)"JMX service not available", (Throwable)se);
        }
        catch (Throwable e) {
            logger.log(BasicLevel.ERROR, (Object)("SecurityService: Cannot start the Security service:\n" + e));
            e.printStackTrace();
            throw new ServiceException("SecurityService: Cannot start the Security service", e);
        }
        this.createRealm();
        try {
            this.registerResourcesMBeans();
        }
        catch (MalformedObjectNameException e) {
            throw new ServiceException("SecurityService: Cannot register mbeans", e);
        }
        logger.log(BasicLevel.INFO, (Object)"Security Service started");
    }

    private void registerResourcesMBeans() throws MalformedObjectNameException {
        Enumeration<JResource> resourcesEnum = this.jResources.getResources();
        String domainName = this.getDomainName();
        while (resourcesEnum.hasMoreElements()) {
            JResource aResource = resourcesEnum.nextElement();
            if (!(aResource instanceof JResourceMemory)) continue;
            String resourceName = aResource.getName();
            JResourceMemory aResourceMemory = (JResourceMemory)aResource;
            aResourceMemory.setJmxService(this.jmxService);
            aResourceMemory.setDomainName(domainName);
            Hashtable<String, JUser> usersTable = aResourceMemory.getUsers();
            Enumeration<String> userNames = usersTable.keys();
            while (userNames.hasMoreElements()) {
                String userName = userNames.nextElement();
                JUser user = usersTable.get(userName);
                this.jmxService.registerMBean((Object)user, JonasObjectName.user(domainName, resourceName, userName));
            }
            Hashtable<String, Group> groupsTable = aResourceMemory.getGroups();
            Enumeration<String> groupNames = groupsTable.keys();
            while (groupNames.hasMoreElements()) {
                String groupName = groupNames.nextElement();
                Group group = groupsTable.get(groupName);
                this.jmxService.registerMBean((Object)group, JonasObjectName.group(domainName, resourceName, groupName));
            }
            Hashtable<String, Role> rolesTable = aResourceMemory.getRoles();
            Enumeration<String> roleNames = rolesTable.keys();
            while (roleNames.hasMoreElements()) {
                String roleName = roleNames.nextElement();
                Role role = rolesTable.get(roleName);
                this.jmxService.registerMBean((Object)role, JonasObjectName.role(domainName, resourceName, roleName));
            }
        }
    }

    public void doStop() {
        if (this.jmxService != null) {
            try {
                this.removeJResources();
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)"Cannot remove JResources", (Throwable)e);
            }
            this.jmxService.unregisterMBean(JonasObjectName.securityService(this.getDomainName()));
        }
        try {
            this.ictx.unbind(this.getJonasServerName() + REMOTE_RESOUCE);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot unbind remote resource for security access", (Throwable)e);
            throw new ServiceException("Cannot unbind remote resource for security access", e);
        }
        logger.log(BasicLevel.INFO, (Object)"Security Service stopped");
    }

    private void removeJResources() throws Exception {
        Enumeration<JResource> resourcesEnum = this.jResources.getResources();
        while (resourcesEnum.hasMoreElements()) {
            JResource aResource = resourcesEnum.nextElement();
            this.removeJResource(aResource.getName());
        }
    }

    public JResource getJResource(String name) {
        return this.jResources.getJResource(name);
    }

    private void createRealm() throws ServiceException {
        File configFile = null;
        FileReader reader = null;
        try {
            configFile = this.getConfigFile();
            reader = new FileReader(configFile);
        }
        catch (FileNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot find config file " + configFile));
            throw new ServiceException(e.getMessage(), e);
        }
        try {
            JResourceManager resourceManager = JResourceManager.getInstance();
            resourceManager.addResources(this.jResources, reader, configFile.getPath());
        }
        catch (Throwable e) {
            String err = "Cannot add security resource from '" + configFile + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new ServiceException(err, e);
        }
    }

    protected File getConfigFile() throws FileNotFoundException {
        String fileName = System.getProperty("jonas.base");
        File file = new File(fileName = fileName + File.separator + CONFIG_FILE);
        if (!file.exists()) {
            String err = "Can't find configuration file : " + fileName;
            throw new FileNotFoundException(err);
        }
        return file;
    }

    public String toXML() {
        return this.jResources.toXML();
    }

    public String encryptPassword(String string, String algo) throws NoSuchAlgorithmException {
        String encrypt = HashHelper.hashPassword(string, algo);
        return "{" + algo.toUpperCase() + "}" + encrypt;
    }

    public boolean isValidAlgorithm(String algo) {
        boolean b = true;
        try {
            this.encryptPassword("test", algo);
        }
        catch (NoSuchAlgorithmException nsae) {
            b = false;
        }
        return b;
    }

    public void addResources(String xml) throws Exception {
        try {
            JResourceManager.getInstance().addResources(this.jResources, new StringReader(xml), "");
        }
        catch (Exception e1) {
            String err = "Cannot add security resource from xml '" + xml + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new ServiceException(err, e1);
        }
    }

    public void addJResourceMemory(String name) throws Exception {
        JResourceMemory jResourceMemory = new JResourceMemory();
        jResourceMemory.setSecurityService(this);
        jResourceMemory.setJmxService(this.jmxService);
        jResourceMemory.setDomainName(this.getDomainName());
        jResourceMemory.setName(name);
        StringBuffer xml = new StringBuffer("<?xml version='1.0' encoding='utf-8'?>\n<!DOCTYPE jonas-realm PUBLIC\n          \"-//ObjectWeb//DTD JOnAS realm 1.0//EN\"\n          \"http://www.objectweb.org/jonas/dtds/jonas-realm_1_0.dtd\">\n");
        xml.append("<jonas-realm>");
        xml.append("<jonas-memoryrealm>");
        xml.append(jResourceMemory.toXML());
        xml.append("</jonas-memoryrealm>");
        xml.append("</jonas-realm>");
        this.addResources(xml.toString());
    }

    public void addJResourceDS(String name, String dsName, String userTable, String userTableUsernameCol, String userTablePasswordCol, String roleTable, String roleTableUsernameCol, String roleTableRolenameCol, String algorithm) throws Exception {
        JResourceDS jResourceDS = new JResourceDS();
        jResourceDS.setSecurityService(this);
        jResourceDS.setJmxService(this.jmxService);
        jResourceDS.setDomainName(this.getDomainName());
        jResourceDS.setName(name);
        jResourceDS.setDsName(dsName);
        jResourceDS.setUserTable(userTable);
        jResourceDS.setUserTableUsernameCol(userTableUsernameCol);
        jResourceDS.setUserTablePasswordCol(userTablePasswordCol);
        jResourceDS.setRoleTable(roleTable);
        jResourceDS.setRoleTableUsernameCol(roleTableUsernameCol);
        jResourceDS.setRoleTableRolenameCol(roleTableRolenameCol);
        jResourceDS.setAlgorithm(algorithm);
        StringBuffer xml = new StringBuffer("<?xml version='1.0' encoding='utf-8'?>\n<!DOCTYPE jonas-realm PUBLIC\n          \"-//ObjectWeb//DTD JOnAS realm 1.0//EN\"\n          \"http://www.objectweb.org/jonas/dtds/jonas-realm_1_0.dtd\">\n");
        xml.append("<jonas-realm>");
        xml.append("<jonas-dsrealm>");
        xml.append(jResourceDS.toXML());
        xml.append("</jonas-dsrealm>");
        xml.append("</jonas-realm>");
        this.addResources(xml.toString());
    }

    public void addJResourceLDAP(String name, String initialContextFactory, String providerUrl, String securityAuthentication, String securityPrincipal, String securityCredentials, String securityProtocol, String language, String referral, String stateFactories, String authenticationMode, String userPasswordAttribute, String userRolesAttribute, String roleNameAttribute, String baseDN, String userDN, String userSearchFilter, String roleDN, String roleSearchFilter, String algorithm) throws Exception {
        JResourceLDAP jResourceLDAP = new JResourceLDAP();
        jResourceLDAP.setSecurityService(this);
        jResourceLDAP.setJmxService(this.jmxService);
        jResourceLDAP.setDomainName(this.getDomainName());
        jResourceLDAP.setName(name);
        jResourceLDAP.setInitialContextFactory(initialContextFactory);
        jResourceLDAP.setProviderUrl(providerUrl);
        jResourceLDAP.setSecurityAuthentication(securityAuthentication);
        jResourceLDAP.setSecurityPrincipal(securityPrincipal);
        jResourceLDAP.setSecurityCredentials(securityCredentials);
        jResourceLDAP.setSecurityProtocol(securityProtocol);
        jResourceLDAP.setLanguage(language);
        jResourceLDAP.setReferral(referral);
        jResourceLDAP.setStateFactories(stateFactories);
        jResourceLDAP.setAuthenticationMode(authenticationMode);
        jResourceLDAP.setUserPasswordAttribute(userPasswordAttribute);
        jResourceLDAP.setUserRolesAttribute(userRolesAttribute);
        jResourceLDAP.setRoleNameAttribute(roleNameAttribute);
        jResourceLDAP.setBaseDN(baseDN);
        jResourceLDAP.setUserDN(userDN);
        jResourceLDAP.setUserSearchFilter(userSearchFilter);
        jResourceLDAP.setRoleDN(roleDN);
        jResourceLDAP.setRoleSearchFilter(roleSearchFilter);
        jResourceLDAP.setAlgorithm(algorithm);
        StringBuffer xml = new StringBuffer("<?xml version='1.0' encoding='utf-8'?>\n<!DOCTYPE jonas-realm PUBLIC\n          \"-//ObjectWeb//DTD JOnAS realm 1.0//EN\"\n          \"http://www.objectweb.org/jonas/dtds/jonas-realm_1_0.dtd\">\n");
        xml.append("<jonas-realm>");
        xml.append("<jonas-ldaprealm>");
        xml.append(jResourceLDAP.toXML());
        xml.append("</jonas-ldaprealm>");
        xml.append("</jonas-realm>");
        this.addResources(xml.toString());
    }

    public void bindResource(String name, JResource jResource) {
        if (this.bindResourcesIntoJndi) {
            try {
                this.ictx.rebind(jResource.getName(), (Object)jResource);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("jResource " + jResource.getName() + " bound into the registry."));
                }
            }
            catch (NamingException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot bind the resource '" + jResource.getName() + "' into JNDI"), (Throwable)e);
            }
        }
        try {
            if (jResource instanceof JResourceMemory) {
                this.jmxService.registerMBean((Object)jResource, JonasObjectName.securityMemoryFactory(this.getDomainName(), jResource.getName()));
            } else if (jResource instanceof JResourceDS) {
                this.jmxService.registerMBean((Object)jResource, JonasObjectName.securityDatasourceFactory(this.getDomainName(), jResource.getName()));
            } else if (jResource instanceof JResourceLDAP) {
                this.jmxService.registerMBean((Object)jResource, JonasObjectName.securityLdapFactory(this.getDomainName(), jResource.getName()));
            }
        }
        catch (ServiceException se) {
            logger.log(BasicLevel.ERROR, (Object)"JMX service not available", (Throwable)se);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Can not register the MBean for the resource " + jResource.getName() + " : " + e.getMessage()));
            throw new ServiceException("Can not register the MBean for the resource " + jResource.getName() + " : " + e.getMessage());
        }
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }
}

