/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.versioning.internal;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.ObjectName;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.ModuleNamingUtils;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.versioning.contexts.VirtualJNDIBinding;
import org.ow2.jonas.versioning.internal.VersioningServiceImplMBean;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningServiceImpl
extends AbsServiceImpl
implements VersioningService,
VersioningServiceImplMBean {
    private static Log logger = LogFactory.getLog(VersioningService.class);
    private String defaultPolicy = "Reserved";
    private Map<String, List<String>> contexts = new HashMap<String, List<String>>();
    private JmxService jmxService = null;

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public static ObjectName getObjectName(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=versioning");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get versioning service", e);
        }
    }

    @Override
    protected void doStart() {
        VirtualJNDIBinding.initialize(this, this.jmxService);
        this.jmxService.registerMBean((Object)this, VersioningServiceImpl.getObjectName(this.getDomainName()));
        logger.info("Versioning service management bean has been registered successfully", new Object[0]);
    }

    @Override
    protected void doStop() {
        this.jmxService.unregisterMBean(VersioningServiceImpl.getObjectName(this.getDomainName()));
        logger.info("Versioning service management bean has been unregistered successfully", new Object[0]);
    }

    @Override
    public String getDefaultPolicy() {
        return this.defaultPolicy;
    }

    @Override
    public void setDefaultPolicy(String defaultPolicy) {
        this.defaultPolicy = defaultPolicy;
    }

    @Override
    public boolean isVersioningEnabled() {
        return this.isStarted();
    }

    @Override
    public void addContext(String appName, String context) {
        List<String> contexts = this.contexts.get(appName);
        if (contexts == null) {
            contexts = new ArrayList<String>();
            this.contexts.put(appName, contexts);
        }
        contexts.add(context);
    }

    @Override
    public void removeContext(String context) {
        ArrayList<Map.Entry<String, List<String>>> entries = new ArrayList<Map.Entry<String, List<String>>>(this.contexts.entrySet());
        for (Map.Entry entry : entries) {
            ((List)entry.getValue()).remove(context);
            if (((List)entry.getValue()).size() >= 1) continue;
            this.contexts.remove(entry.getKey());
        }
    }

    @Override
    public String[] getContextNames() {
        Set<String> names = this.contexts.keySet();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public String[] getContextBeans(String name) {
        List<String> beans = this.contexts.get(name);
        if (beans == null) {
            return null;
        }
        return beans.toArray(new String[beans.size()]);
    }

    @Override
    public String getVersionID(File file) {
        String versionID = null;
        JarFile manifestWarFile = null;
        try {
            manifestWarFile = new JarFile(file);
            Manifest warManifest = manifestWarFile.getManifest();
            if (null != warManifest) {
                versionID = warManifest.getMainAttributes().getValue("Implementation-Version");
            }
            if (versionID != null) {
                String allowedSpecialChars = "-_,.";
                boolean versionIDFiltered = false;
                StringBuffer versionIDFilter = new StringBuffer();
                for (char c : versionID.toCharArray()) {
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "-_,.".indexOf(c) >= 0) {
                        versionIDFilter.append(c);
                        continue;
                    }
                    versionIDFiltered = true;
                    versionIDFilter.append('-');
                }
                if (versionIDFiltered) {
                    versionID = versionIDFilter.toString();
                    logger.info("Invalid characters detected in version ID for file " + file + ", setting version ID to " + versionID, new Object[0]);
                }
                versionID = "-version" + versionID;
            }
        }
        catch (Exception e) {
            logger.info("Failed reading version ID from file " + file, e);
        }
        try {
            manifestWarFile.close();
        }
        catch (Exception e) {
            manifestWarFile = null;
        }
        return versionID;
    }

    @Override
    public String getVersionID(URL url) {
        try {
            return this.getVersionID(URLUtils.urlToFile(url));
        }
        catch (Exception e) {
            return this.getVersionID(new File(url.getFile()));
        }
    }

    @Override
    public String getVersionID(IDeployable<?> deployable) {
        deployable = this.getOriginalDeployable(deployable);
        String versionID = null;
        try {
            versionID = this.getVersionID(deployable.getArchive().getURL());
        }
        catch (ArchiveException e) {
            logger.info("Failed reading version ID from deployable " + deployable, e);
        }
        return versionID;
    }

    @Override
    public String getPrefix(File file) {
        return this.getPrefix(URLUtils.fileToURL(file));
    }

    @Override
    public String getPrefix(URL url) {
        return this.createPrefix(ModuleNamingUtils.fromURL(url), this.getVersionID(url));
    }

    @Override
    public String getPrefix(IDeployable<?> deployable) {
        deployable = this.getOriginalDeployable(deployable);
        String applicationName = deployable.getModuleName();
        return this.createPrefix(applicationName, this.getVersionID(deployable));
    }

    private String createPrefix(String applicationName, String versionID) {
        String prefix = applicationName;
        if (versionID != null && !applicationName.endsWith(versionID)) {
            prefix = prefix + versionID;
        }
        prefix = prefix + '/';
        String allowedSpecialChars = "_./";
        boolean jndiPrefixFiltered = false;
        StringBuffer jndiPrefixFilter = new StringBuffer();
        for (char c : prefix.toCharArray()) {
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "_./".indexOf(c) >= 0) {
                jndiPrefixFilter.append(c);
                continue;
            }
            jndiPrefixFiltered = true;
            jndiPrefixFilter.append('_');
        }
        if (jndiPrefixFiltered) {
            prefix = jndiPrefixFilter.toString();
            logger.info("Invalid characters detected in the JNDI prefix for application " + applicationName + ", setting JNDI prefix to " + prefix, new Object[0]);
        }
        return prefix;
    }

    private IDeployable<?> getOriginalDeployable(IDeployable<?> deployable) {
        while (deployable.getOriginalDeployable() != null) {
            deployable = (IDeployable)deployable.getOriginalDeployable();
        }
        return deployable;
    }

    @Override
    public void createJNDIBindingMBeans(String appName, String version2, String prefix) {
        if (version2 != null && appName.endsWith(version2)) {
            appName = appName.substring(0, appName.length() - version2.length());
        }
        VirtualJNDIBinding.createJNDIBindingMBeans(appName, prefix);
    }

    @Override
    public void garbageCollectJNDIBindingMBeans() {
        VirtualJNDIBinding.garbageCollectJNDIBindingMBeans();
    }
}

