/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.versioning;

import java.io.IOException;
import java.security.Principal;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyoteAdapter;
import org.apache.catalina.connector.CoyotePrincipal;
import org.apache.catalina.connector.Request;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.net.SocketStatus;
import org.ow2.jonas.web.tomcat6.versioning.ContextFinder;
import org.ow2.jonas.web.tomcat6.versioning.VersionedPathBean;

public class CoyoteAdapterWithDelegatedContextSearch
extends CoyoteAdapter {
    private static Log log = LogFactory.getLog(CoyoteAdapterWithDelegatedContextSearch.class);

    public CoyoteAdapterWithDelegatedContextSearch(Connector connector) {
        super(connector);
    }

    protected boolean postParseRequest(org.apache.coyote.Request req, Request request, Response res, org.apache.catalina.connector.Response response) throws Exception {
        return this.postParseRequest(req, request, res, response, null);
    }

    protected boolean postParseRequest(org.apache.coyote.Request req, Request request, Response res, org.apache.catalina.connector.Response response, VersionedPathBean vpb) throws Exception {
        MessageBytes serverName;
        String authtype;
        int semicolon;
        if (!req.scheme().isNull()) {
            request.setSecure(req.scheme().equals("https"));
        } else {
            req.scheme().setString(this.connector.getScheme());
            request.setSecure(this.connector.getSecure());
        }
        String proxyName = this.connector.getProxyName();
        int proxyPort = this.connector.getProxyPort();
        if (proxyPort != 0) {
            req.setServerPort(proxyPort);
        }
        if (proxyName != null) {
            req.serverName().setString(proxyName);
        }
        this.parseSessionId(req, request);
        MessageBytes decodedURI = req.decodedURI();
        decodedURI.duplicate(req.requestURI());
        if (decodedURI.getType() == 2) {
            ByteChunk uriBB = decodedURI.getByteChunk();
            semicolon = uriBB.indexOf(';', 0);
            if (semicolon > 0) {
                decodedURI.setBytes(uriBB.getBuffer(), uriBB.getStart(), semicolon);
            }
            try {
                req.getURLDecoder().convert(decodedURI, false);
            }
            catch (IOException ioe) {
                res.setStatus(400);
                res.setMessage("Invalid URI: " + ioe.getMessage());
                return false;
            }
            if (!CoyoteAdapterWithDelegatedContextSearch.normalize((MessageBytes)req.decodedURI())) {
                res.setStatus(400);
                res.setMessage("Invalid URI");
                return false;
            }
            this.convertURI(decodedURI, request);
        } else {
            decodedURI.toChars();
            CharChunk uriCC = decodedURI.getCharChunk();
            semicolon = uriCC.indexOf(';');
            if (semicolon > 0) {
                decodedURI.setChars(uriCC.getBuffer(), uriCC.getStart(), semicolon);
            }
        }
        String principal = req.getRemoteUser().toString();
        if (principal != null) {
            request.setUserPrincipal((Principal)new CoyotePrincipal(principal));
        }
        if ((authtype = req.getAuthType().toString()) != null) {
            request.setAuthType(authtype);
        }
        if (this.connector.getUseIPVHosts()) {
            serverName = req.localName();
            if (serverName.isNull()) {
                res.action(ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE, null);
            }
        } else {
            serverName = req.serverName();
        }
        MessageBytes versionedURI = ContextFinder.getContextURI(decodedURI, this.connector, request, vpb);
        this.connector.getMapper().map(serverName, versionedURI, request.getMappingData());
        request.setContext((Context)request.getMappingData().context);
        request.setWrapper((Wrapper)request.getMappingData().wrapper);
        if (!this.connector.getAllowTrace() && req.method().equalsIgnoreCase("TRACE")) {
            String[] methods;
            Wrapper wrapper = request.getWrapper();
            String header = null;
            if (wrapper != null && (methods = wrapper.getServletMethods()) != null) {
                for (int i = 0; i < methods.length; ++i) {
                    if ("TRACE".equals(methods[i])) continue;
                    header = header == null ? methods[i] : header + ", " + methods[i];
                }
            }
            res.setStatus(405);
            res.addHeader("Allow", header);
            res.setMessage("TRACE method is not allowed");
            return false;
        }
        String redirectPath = null;
        if (vpb.getUserPath() != null && vpb.getVersionedPath() != null && !vpb.isUserPathEndWithSlash()) {
            redirectPath = vpb.getUserPath() + '/';
        } else {
            MessageBytes redirectPathMB = request.getMappingData().redirectPath;
            if (!redirectPathMB.isNull()) {
                redirectPath = redirectPathMB.toString();
            }
        }
        if (null != redirectPath) {
            String query = request.getQueryString();
            if (request.isRequestedSessionIdFromURL()) {
                redirectPath = redirectPath + ";" + "jsessionid" + "=" + request.getRequestedSessionId();
            }
            if (query != null) {
                redirectPath = redirectPath + "?" + query;
            }
            response.sendRedirect(redirectPath);
            return false;
        }
        this.parseSessionCookiesId(req, request);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(org.apache.coyote.Request req, Response res) throws Exception {
        Request request = (Request)req.getNote(1);
        org.apache.catalina.connector.Response response = (org.apache.catalina.connector.Response)res.getNote(1);
        if (request == null) {
            request = this.connector.createRequest();
            request.setCoyoteRequest(req);
            response = this.connector.createResponse();
            response.setCoyoteResponse(res);
            request.setResponse(response);
            response.setRequest(request);
            req.setNote(1, (Object)request);
            res.setNote(1, (Object)response);
            req.getParameters().setQueryStringEncoding(this.connector.getURIEncoding());
        }
        if (this.connector.getXpoweredBy()) {
            response.addHeader("X-Powered-By", "Servlet/2.5");
        }
        boolean comet = false;
        try {
            String cookie;
            VersionedPathBean vpb = new VersionedPathBean();
            req.getRequestProcessor().setWorkerThreadName(Thread.currentThread().getName());
            if (this.postParseRequest(req, request, res, response, vpb)) {
                this.connector.getContainer().getPipeline().getFirst().invoke(request, response);
                if (request.isComet()) {
                    if (!response.isClosed() && !response.isError()) {
                        if (request.getAvailable()) {
                            if (this.event(req, res, SocketStatus.OPEN)) {
                                comet = true;
                                res.action(ActionCode.ACTION_COMET_BEGIN, null);
                            }
                        } else {
                            comet = true;
                            res.action(ActionCode.ACTION_COMET_BEGIN, null);
                        }
                    } else {
                        request.setFilterChain(null);
                    }
                }
            }
            if ((cookie = response.getHeader("Set-Cookie")) != null) {
                response.setHeader("Set-Cookie", cookie.replace("; Path=" + vpb.getVersionedPath(), "; Path=" + vpb.getUserPath()));
            }
            if (!comet) {
                response.finishResponse();
                req.action(ActionCode.ACTION_POST_REQUEST, null);
            }
        }
        catch (IOException e) {
        }
        catch (Throwable t) {
            log.error(this.sm.getString("coyoteAdapter.service"), t);
        }
        finally {
            req.getRequestProcessor().setWorkerThreadName(null);
            if (!comet) {
                request.recycle();
                response.recycle();
            } else {
                request.clearEncoders();
                response.clearEncoders();
            }
        }
    }
}

