/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.impl;

import java.util.ArrayList;
import java.util.List;
import org.ow2.util.asm.ClassVisitor;
import org.ow2.util.asm.FieldVisitor;
import org.ow2.util.asm.MethodVisitor;
import org.ow2.util.scan.api.configurator.IArchiveConfigurator;
import org.ow2.util.scan.api.configurator.IClassConfigurator;
import org.ow2.util.scan.api.configurator.IFieldConfigurator;
import org.ow2.util.scan.api.configurator.IMethodConfigurator;
import org.ow2.util.scan.api.metadata.structures.JClass;
import org.ow2.util.scan.api.metadata.structures.JField;
import org.ow2.util.scan.api.metadata.structures.JMethod;
import org.ow2.util.scan.impl.ScanCommonVisitor;
import org.ow2.util.scan.impl.ScanFieldVisitor;
import org.ow2.util.scan.impl.ScanMethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScanClassVisitor
extends ScanCommonVisitor<IClassConfigurator>
implements ClassVisitor {
    private List<IArchiveConfigurator> archiveConfigurators;

    public ScanClassVisitor(List<IArchiveConfigurator> archiveConfigurators) {
        this.archiveConfigurators = archiveConfigurators;
    }

    @Override
    public void visit(int version2, int access, String name, String signature, String superName, String[] interfaces) {
        ArrayList<IClassConfigurator> classConfigurators = new ArrayList<IClassConfigurator>();
        JClass jClass = new JClass(version2, access, name, signature, superName, interfaces);
        for (IArchiveConfigurator archiveConfigurator : this.archiveConfigurators) {
            classConfigurators.add(archiveConfigurator.createClassConfigurator(jClass));
        }
        this.setCommonConfigurators(classConfigurators);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        JMethod jMethod = new JMethod(access, name, desc, signature, exceptions);
        ArrayList<IMethodConfigurator> methodConfigurators = new ArrayList<IMethodConfigurator>();
        for (IClassConfigurator classConfigurator : this.getCommonConfigurators()) {
            methodConfigurators.add(classConfigurator.createMethodConfigurator(jMethod));
        }
        return new ScanMethodVisitor(methodConfigurators);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        JField jField = new JField(access, name, desc, signature, value);
        ArrayList<IFieldConfigurator> fieldConfigurators = new ArrayList<IFieldConfigurator>();
        for (IClassConfigurator classConfigurator : this.getCommonConfigurators()) {
            fieldConfigurators.add(classConfigurator.createFieldConfigurator(jField));
        }
        return new ScanFieldVisitor(fieldConfigurators);
    }

    @Override
    public void visitEnd() {
        for (IClassConfigurator classConfigurator : this.getCommonConfigurators()) {
            classConfigurator.configurationComplete();
        }
    }
}

