/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import java.lang.reflect.Field;
import org.jacorb.notification.filter.DynamicTypeException;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.ImmutableEvaluationResultWrapper;
import org.omg.CORBA.Any;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;

public class EvaluationResult {
    public static final EvaluationResult BOOL_TRUE;
    public static final EvaluationResult BOOL_FALSE;
    private int typeCode_;
    private Object value_;
    private Any any_;
    static /* synthetic */ Class class$org$omg$CORBA$TCKind;

    protected Object getValue() {
        return this.value_;
    }

    private Object setValue(Object object) {
        Object object2 = this.value_;
        this.value_ = object;
        return object2;
    }

    public boolean isLongLong() {
        return this.typeCode_ == 23;
    }

    public boolean isDouble() {
        return this.typeCode_ == 7;
    }

    public boolean isFloat() {
        return this.typeCode_ == 6;
    }

    public boolean isLong() {
        return this.typeCode_ == 3;
    }

    public boolean isString() {
        return this.typeCode_ == 18;
    }

    public void setString(String string) {
        this.setValue(string);
        this.typeCode_ = 18;
    }

    public void setFloat(float f) {
        this.setFloat(new Double(f));
    }

    public void setFloat(double d) {
        this.setFloat(new Double(d));
    }

    public void setFloat(Double d) {
        this.setValue(d);
        this.typeCode_ = 6;
    }

    public void setLongLong(long l) {
        this.setLongLong(new Double(l));
    }

    public void setLongLong(Double d) {
        this.setValue(d);
        this.typeCode_ = 23;
    }

    public void setLong(int n) {
        this.setLong(new Double(n));
    }

    public void setLong(Double d) {
        this.setValue(d);
        this.typeCode_ = 3;
    }

    public void setDouble(Double d) {
        this.setValue(d);
        this.typeCode_ = 7;
    }

    public void setDouble(double d) {
        this.setDouble(new Double(d));
    }

    public String getString() throws DynamicTypeException {
        try {
            return (String)this.getValue();
        }
        catch (ClassCastException classCastException) {
            throw this.newDynamicTypeException("String");
        }
    }

    private DynamicTypeException newDynamicTypeException(String string) {
        return new DynamicTypeException("could not convert value: " + this.getValue() + " to " + string);
    }

    private static DynamicTypeException newDynamicTypeException(String string, EvaluationResult evaluationResult, EvaluationResult evaluationResult2) {
        return new DynamicTypeException("failed to " + string + ": incompatible operands " + evaluationResult + " and " + evaluationResult2);
    }

    public long getLongLong() throws DynamicTypeException {
        try {
            return ((Double)this.getValue()).longValue();
        }
        catch (ClassCastException classCastException) {
            try {
                return (Boolean)this.getValue() != false ? 1L : 0L;
            }
            catch (ClassCastException classCastException2) {
                try {
                    String string = (String)this.getValue();
                    if (string.length() == 1) {
                        return string.charAt(0);
                    }
                }
                catch (ClassCastException classCastException3) {
                    // empty catch block
                }
                throw this.newDynamicTypeException("LongLong");
            }
        }
    }

    public int getLong() throws DynamicTypeException {
        block8: {
            if (this.getValue() != null) {
                try {
                    return ((Double)this.getValue()).intValue();
                }
                catch (ClassCastException classCastException) {
                    try {
                        return (Boolean)this.getValue() != false ? 1 : 0;
                    }
                    catch (ClassCastException classCastException2) {
                        try {
                            String string = (String)this.getValue();
                            if (string.length() == 1) {
                                return string.charAt(0);
                            }
                            break block8;
                        }
                        catch (ClassCastException classCastException3) {}
                        break block8;
                    }
                }
            }
            return this.any_.extract_long();
        }
        throw this.newDynamicTypeException("Long");
    }

    public double getDouble() throws DynamicTypeException {
        try {
            return (Double)this.getValue();
        }
        catch (ClassCastException classCastException) {
            try {
                return (Boolean)this.getValue() != false ? 1.0 : 0.0;
            }
            catch (ClassCastException classCastException2) {
                try {
                    String string = (String)this.getValue();
                    if (string.length() == 1) {
                        return string.charAt(0);
                    }
                }
                catch (ClassCastException classCastException3) {
                    // empty catch block
                }
                throw this.newDynamicTypeException("Double");
            }
        }
    }

    public float getFloat() throws DynamicTypeException {
        try {
            return ((Double)this.getValue()).floatValue();
        }
        catch (ClassCastException classCastException) {
            try {
                return (Boolean)this.getValue() != false ? 1.0f : 0.0f;
            }
            catch (ClassCastException classCastException2) {
                try {
                    String string = (String)this.getValue();
                    if (string.length() == 1) {
                        return string.charAt(0);
                    }
                }
                catch (ClassCastException classCastException3) {
                    // empty catch block
                }
                throw this.newDynamicTypeException("Float");
            }
        }
    }

    public boolean getBool() throws DynamicTypeException {
        try {
            return (Boolean)this.getValue();
        }
        catch (ClassCastException classCastException) {
            throw this.newDynamicTypeException("Boolean");
        }
    }

    public void setBool(boolean bl) {
        this.setValue(bl);
        this.typeCode_ = 8;
    }

    public Any getAny() {
        return this.any_;
    }

    public void addAny(Any any) {
        this.any_ = any;
    }

    private static String typeCodeToName(int n) {
        try {
            Field[] fieldArray = (class$org$omg$CORBA$TCKind == null ? (class$org$omg$CORBA$TCKind = EvaluationResult.class$("org.omg.CORBA.TCKind")) : class$org$omg$CORBA$TCKind).getDeclaredFields();
            return fieldArray[n].getName();
        }
        catch (Exception exception) {
            return "unknown: " + n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append(this.getValue());
        stringBuffer.append(";TC=");
        stringBuffer.append(EvaluationResult.typeCodeToName(this.typeCode_));
        stringBuffer.append(";any=");
        stringBuffer.append(this.any_);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof EvaluationResult) {
            return ((EvaluationResult)object).getValue().equals(this.getValue());
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public int compareTo(EvaluationResult evaluationResult) throws DynamicTypeException, EvaluationException {
        int n;
        if (this.getValue() == null && this.any_ != null && evaluationResult.getValue() instanceof String) {
            try {
                String string = this.any_.type().member_name(0);
                n = string.compareTo(evaluationResult.getString());
            }
            catch (BadKind badKind) {
                throw new EvaluationException(badKind);
            }
            catch (Bounds bounds) {
                throw new EvaluationException(bounds);
            }
        } else if (this.isString() || evaluationResult.isString()) {
            n = this.getString().compareTo(evaluationResult.getString());
        } else if (this.isFloat() || evaluationResult.isFloat()) {
            float f = this.getFloat();
            float f2 = evaluationResult.getFloat();
            n = Float.compare(f, f2);
        } else {
            int n2 = this.getLong();
            int n3 = evaluationResult.getLong();
            n = n2 - n3;
        }
        return n;
    }

    public static EvaluationResult wrapImmutable(EvaluationResult evaluationResult) {
        return new ImmutableEvaluationResultWrapper(evaluationResult);
    }

    public static EvaluationResult plus(EvaluationResult evaluationResult, EvaluationResult evaluationResult2) throws DynamicTypeException {
        EvaluationResult evaluationResult3 = new EvaluationResult();
        if (evaluationResult.isDouble() || evaluationResult2.isDouble()) {
            evaluationResult3.setDouble(evaluationResult.getDouble() + evaluationResult2.getDouble());
        } else if (evaluationResult.isFloat() || evaluationResult2.isFloat()) {
            evaluationResult3.setFloat(evaluationResult.getDouble() + evaluationResult2.getDouble());
        } else if (evaluationResult.isLongLong() || evaluationResult2.isLongLong()) {
            evaluationResult3.setLongLong(evaluationResult.getLongLong() + evaluationResult2.getLongLong());
        } else if (evaluationResult.isLong() || evaluationResult2.isLong()) {
            evaluationResult3.setLong(evaluationResult.getLong() + evaluationResult2.getLong());
        } else {
            throw EvaluationResult.newDynamicTypeException("add", evaluationResult, evaluationResult2);
        }
        return evaluationResult3;
    }

    public static EvaluationResult minus(EvaluationResult evaluationResult, EvaluationResult evaluationResult2) throws DynamicTypeException {
        EvaluationResult evaluationResult3 = new EvaluationResult();
        if (evaluationResult.isDouble() || evaluationResult2.isDouble()) {
            evaluationResult3.setDouble(evaluationResult.getDouble() - evaluationResult2.getDouble());
        } else if (evaluationResult.isFloat() || evaluationResult2.isFloat()) {
            evaluationResult3.setFloat(evaluationResult.getDouble() - evaluationResult2.getDouble());
        } else if (evaluationResult.isLongLong() || evaluationResult2.isLongLong()) {
            evaluationResult3.setLongLong(evaluationResult.getLongLong() - evaluationResult2.getLongLong());
        } else if (evaluationResult.isLong() || evaluationResult2.isLong()) {
            evaluationResult3.setLong(evaluationResult.getLong() - evaluationResult2.getLong());
        } else {
            throw EvaluationResult.newDynamicTypeException("subtract", evaluationResult, evaluationResult2);
        }
        return evaluationResult3;
    }

    public static EvaluationResult unaryMinus(EvaluationResult evaluationResult) throws DynamicTypeException {
        EvaluationResult evaluationResult2 = new EvaluationResult();
        if (evaluationResult.isFloat()) {
            evaluationResult2.setFloat(-evaluationResult.getFloat());
        } else {
            evaluationResult2.setDouble(-evaluationResult.getDouble());
        }
        return evaluationResult2;
    }

    public static EvaluationResult div(EvaluationResult evaluationResult, EvaluationResult evaluationResult2) throws DynamicTypeException {
        EvaluationResult evaluationResult3 = new EvaluationResult();
        if (evaluationResult.isDouble() || evaluationResult2.isDouble()) {
            evaluationResult3.setDouble(evaluationResult.getDouble() / evaluationResult2.getDouble());
        } else if (evaluationResult.isFloat() || evaluationResult2.isFloat()) {
            evaluationResult3.setFloat(evaluationResult.getDouble() / evaluationResult2.getDouble());
        } else if (evaluationResult.isLongLong() || evaluationResult2.isLongLong()) {
            evaluationResult3.setLongLong(evaluationResult.getLongLong() / evaluationResult2.getLongLong());
        } else if (evaluationResult.isLong() || evaluationResult2.isLong()) {
            evaluationResult3.setLong(evaluationResult.getLong() / evaluationResult2.getLong());
        } else {
            throw EvaluationResult.newDynamicTypeException("divide", evaluationResult, evaluationResult2);
        }
        return evaluationResult3;
    }

    public static EvaluationResult mult(EvaluationResult evaluationResult, EvaluationResult evaluationResult2) throws DynamicTypeException {
        EvaluationResult evaluationResult3 = new EvaluationResult();
        if (evaluationResult.isDouble() || evaluationResult2.isDouble()) {
            evaluationResult3.setDouble(evaluationResult.getDouble() * evaluationResult2.getDouble());
        } else if (evaluationResult.isFloat() || evaluationResult2.isFloat()) {
            evaluationResult3.setFloat(evaluationResult.getDouble() * evaluationResult2.getDouble());
        } else if (evaluationResult.isLongLong() || evaluationResult2.isLongLong()) {
            evaluationResult3.setLongLong(evaluationResult.getLongLong() * evaluationResult2.getLongLong());
        } else if (evaluationResult.isLong() || evaluationResult2.isLong()) {
            evaluationResult3.setLong(evaluationResult.getLong() * evaluationResult2.getLong());
        } else {
            throw EvaluationResult.newDynamicTypeException("multiply", evaluationResult, evaluationResult2);
        }
        return evaluationResult3;
    }

    public static EvaluationResult fromAny(Any any) {
        EvaluationResult evaluationResult;
        if (any == null) {
            return null;
        }
        switch (any.type().kind().value()) {
            case 11: {
                evaluationResult = EvaluationResult.fromAny(any.extract_any());
                break;
            }
            default: {
                evaluationResult = new EvaluationResult();
                EvaluationResult.extractIntoEvaluationResult(evaluationResult, any);
            }
        }
        return evaluationResult;
    }

    private static void extractIntoEvaluationResult(EvaluationResult evaluationResult, Any any) {
        switch (any.type().kind().value()) {
            case 8: {
                evaluationResult.setBool(any.extract_boolean());
                break;
            }
            case 18: {
                evaluationResult.setString(any.extract_string());
                break;
            }
            case 3: {
                evaluationResult.setLong(any.extract_long());
                break;
            }
            case 2: {
                evaluationResult.setLong(any.extract_short());
                break;
            }
            case 24: {
                evaluationResult.setLongLong(any.extract_ulonglong());
                break;
            }
            default: {
                evaluationResult.addAny(any);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        EvaluationResult evaluationResult = new EvaluationResult();
        evaluationResult.setBool(true);
        BOOL_TRUE = EvaluationResult.wrapImmutable(evaluationResult);
        evaluationResult = new EvaluationResult();
        evaluationResult.setBool(false);
        BOOL_FALSE = EvaluationResult.wrapImmutable(evaluationResult);
    }
}

