/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.offers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.trading.db.simple.offers.Offer;
import org.jacorb.trading.db.simple.offers.ProxyOffer;
import org.omg.CORBA.Object;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;
import org.omg.CosTrading.RegisterPackage.OfferInfo;

public class OfferList
implements Serializable {
    private String m_serviceType;
    private Hashtable m_offers;
    private Hashtable m_proxies;
    private int m_nextId;
    private transient boolean m_dirty = true;
    private static final char ID_SEP = '/';
    static final long serialVersionUID = -921492441298318523L;

    private OfferList() {
    }

    public OfferList(String string) {
        this.m_serviceType = string;
        this.m_offers = new Hashtable();
        this.m_proxies = new Hashtable();
        this.m_nextId = 1;
    }

    public String getServiceType() {
        return this.m_serviceType;
    }

    public static boolean validateOfferId(String string) {
        boolean bl = false;
        if (string != null) {
            int n = string.indexOf(47);
            bl = n > 0;
        }
        return bl;
    }

    public boolean exists(String string) {
        return this.m_offers.containsKey(string) || this.m_proxies.containsKey(string);
    }

    public boolean isProxy(String string) {
        return this.m_proxies.containsKey(string);
    }

    public String create(Object object, Property[] propertyArray) {
        String string = null;
        string = this.m_serviceType + '/' + this.m_nextId;
        ++this.m_nextId;
        Offer offer = new Offer(string, object, propertyArray);
        this.m_offers.put(string, offer);
        this.m_dirty = true;
        return string;
    }

    public String createProxy(Lookup lookup, Property[] propertyArray, boolean bl, String string, Policy[] policyArray) {
        String string2 = null;
        string2 = this.m_serviceType + '/' + this.m_nextId;
        ++this.m_nextId;
        ProxyOffer proxyOffer = new ProxyOffer(string2, lookup, propertyArray, bl, string, policyArray);
        this.m_proxies.put(string2, proxyOffer);
        this.m_dirty = true;
        return string2;
    }

    public void remove(String string) {
        if (this.m_offers.containsKey(string)) {
            this.m_offers.remove(string);
            this.m_dirty = true;
        }
    }

    public void removeProxy(String string) {
        if (this.m_proxies.containsKey(string)) {
            this.m_proxies.remove(string);
            this.m_dirty = true;
        }
    }

    public OfferInfo describe(String string) {
        OfferInfo offerInfo = null;
        Offer offer = (Offer)this.m_offers.get(string);
        if (offer != null) {
            offerInfo = offer.describe();
            offerInfo.type = this.m_serviceType;
        }
        return offerInfo;
    }

    public ProxyInfo describeProxy(String string) {
        ProxyInfo proxyInfo = null;
        ProxyOffer proxyOffer = (ProxyOffer)this.m_proxies.get(string);
        if (proxyOffer != null) {
            proxyInfo = proxyOffer.describe();
            proxyInfo.type = this.m_serviceType;
        }
        return proxyInfo;
    }

    public boolean modify(String string, Property[] propertyArray) {
        boolean bl = false;
        Offer offer = (Offer)this.m_offers.get(string);
        if (offer != null) {
            offer.modify(propertyArray);
            bl = true;
            this.m_dirty = true;
        }
        return bl;
    }

    public Hashtable getOffers() {
        Hashtable<String, OfferInfo> hashtable = new Hashtable<String, OfferInfo>();
        Enumeration enumeration = this.m_offers.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Offer offer = (Offer)this.m_offers.get(string);
            OfferInfo offerInfo = offer.describe();
            offerInfo.type = this.m_serviceType;
            hashtable.put(string, offerInfo);
        }
        return hashtable;
    }

    public String[] getOfferIds() {
        String[] stringArray = new String[this.m_offers.size()];
        int n = 0;
        Enumeration enumeration = this.m_offers.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public Hashtable getProxyOffers() {
        Hashtable<String, ProxyInfo> hashtable = new Hashtable<String, ProxyInfo>();
        Enumeration enumeration = this.m_proxies.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ProxyOffer proxyOffer = (ProxyOffer)this.m_proxies.get(string);
            ProxyInfo proxyInfo = proxyOffer.describe();
            proxyInfo.type = this.m_serviceType;
            hashtable.put(string, proxyInfo);
        }
        return hashtable;
    }

    public String[] getProxyOfferIds() {
        String[] stringArray = new String[this.m_proxies.size()];
        int n = 0;
        Enumeration enumeration = this.m_proxies.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public static String whichService(String string) {
        String string2 = null;
        int n = string.indexOf(47);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public int hashCode() {
        return this.m_serviceType.hashCode();
    }

    public boolean equals(java.lang.Object object) {
        OfferList offerList = (OfferList)object;
        return this.m_serviceType.equals(offerList.m_serviceType);
    }

    public boolean getDirty() {
        return this.m_dirty;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.m_dirty = false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_dirty = false;
    }
}

