/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal.realm.factory;

import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.security.internal.realm.factory.AbstractJResource;
import org.ow2.jonas.security.internal.realm.factory.JResourceDSMBean;
import org.ow2.jonas.security.internal.realm.lib.HashHelper;
import org.ow2.jonas.security.internal.realm.principal.User;
import org.ow2.jonas.security.realm.factory.JResourceException;
import org.ow2.jonas.security.realm.principal.JUser;

public class JResourceDS
extends AbstractJResource
implements JResourceDSMBean {
    private static final String FACTORY_TYPE = "org.ow2.jonas.security.realm.factory.JResourceDS";
    private static final String FACTORY_NAME = "org.ow2.jonas.security.realm.factory.JResourceDSFactory";
    private String dsName = null;
    private String userTable = null;
    private String userTableUsernameCol = null;
    private String userTablePasswordCol = null;
    private String roleTable = null;
    private String roleTableUsernameCol = null;
    private String roleTableRolenameCol = null;
    private String algorithm = null;
    private DataSource dataSource = null;
    private String userPrincipalsQuery = null;
    private String userRolesQuery = null;

    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }

    public void setUserTableUsernameCol(String userTableUsernameCol) {
        this.userTableUsernameCol = userTableUsernameCol;
    }

    public void setUserTablePasswordCol(String userTablePasswordCol) {
        this.userTablePasswordCol = userTablePasswordCol;
    }

    public void setRoleTable(String roleTable) {
        this.roleTable = roleTable;
    }

    public void setRoleTableUsernameCol(String roleTableUsernameCol) {
        this.roleTableUsernameCol = roleTableUsernameCol;
    }

    public void setRoleTableRolenameCol(String roleTableRolenameCol) {
        this.roleTableRolenameCol = roleTableRolenameCol;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setUserPrincipalsQuery(String userPrincipalsQuery) {
        this.userPrincipalsQuery = userPrincipalsQuery;
    }

    public void setUserRolesQuery(String userRolesQuery) {
        this.userRolesQuery = userRolesQuery;
    }

    public String getDsName() {
        return this.dsName;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public String getUserTableUsernameCol() {
        return this.userTableUsernameCol;
    }

    public String getUserTablePasswordCol() {
        return this.userTablePasswordCol;
    }

    public String getRoleTable() {
        return this.roleTable;
    }

    public String getRoleTableUsernameCol() {
        return this.roleTableUsernameCol;
    }

    public String getRoleTableRolenameCol() {
        return this.roleTableRolenameCol;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String setUserPrincipalsQuery() {
        return this.userPrincipalsQuery;
    }

    public String setUserRolesQuery() {
        return this.userRolesQuery;
    }

    public JUser findUser(String username) throws JResourceException {
        Connection connection;
        User user;
        block12: {
            if (username == null) {
                return null;
            }
            user = new User();
            connection = this.getConnection();
            user.setName(username);
            ResultSet rs = null;
            String password = null;
            try {
                PreparedStatement usrStmt = this.userStatement(connection, username);
                rs = usrStmt.executeQuery();
                if (rs == null || !rs.next()) {
                    throw new JResourceException("No user found with username '" + username + "'.");
                }
                int records = rs.getRow();
                if (records > 1) {
                    JResourceDS.getLogger().log(BasicLevel.ERROR, (Object)("There are more than one user with the name" + username));
                }
                password = rs.getString(1).trim();
                rs.close();
                usrStmt.close();
            }
            catch (SQLException sqle) {
                this.closeConnection(connection);
                throw new JResourceException(sqle.getMessage(), (Throwable)sqle);
            }
            if (password == null) {
                this.closeConnection(connection);
                return null;
            }
            user.setPassword(password);
            try {
                PreparedStatement rlStmt = this.roleStatement(connection, username);
                rs = rlStmt.executeQuery();
                while (rs.next()) {
                    String role = rs.getString(1).trim();
                    user.addRole(role);
                }
                rs.close();
                rlStmt.close();
            }
            catch (SQLException sqle) {
                this.closeConnection(connection);
                throw new JResourceException(sqle.getMessage(), (Throwable)sqle);
            }
            try {
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException sqle) {
                if (!JResourceDS.getLogger().isLoggable(BasicLevel.DEBUG)) break block12;
                JResourceDS.getLogger().log(BasicLevel.DEBUG, (Object)("Cannot commit on the current connection :  : '" + sqle.getMessage() + "'"));
            }
        }
        this.closeConnection(connection);
        return user;
    }

    public boolean isValidUser(JUser user, String credentials) {
        boolean validated = false;
        String pass = user.getHashPassword().getPassword();
        String algo = user.getHashPassword().getAlgorithm();
        if (algo != null) {
            try {
                validated = HashHelper.hashPassword(credentials, algo).equalsIgnoreCase(pass);
            }
            catch (NoSuchAlgorithmException nsae) {
                JResourceDS.getLogger().log(BasicLevel.ERROR, (Object)("Can't make a password with the algorithm " + algo + ". " + nsae.getMessage()));
            }
        } else if (this.algorithm != null && !this.algorithm.equals("")) {
            try {
                validated = HashHelper.hashPassword(credentials, this.algorithm).equalsIgnoreCase(pass);
            }
            catch (NoSuchAlgorithmException nsae) {
                JResourceDS.getLogger().log(BasicLevel.ERROR, (Object)("Can't make a password with the algorithm " + this.algorithm + ". " + nsae.getMessage()));
            }
        } else {
            validated = credentials.equals(pass);
        }
        return validated;
    }

    public ArrayList getArrayListCombinedRoles(JUser user) throws JResourceException {
        ArrayList<String> allCombinedRoles = new ArrayList<String>();
        if (user == null) {
            return allCombinedRoles;
        }
        String[] userRoles = user.getArrayRoles();
        for (int r = 0; r < userRoles.length; ++r) {
            String roleName = userRoles[r];
            if (allCombinedRoles.contains(roleName)) continue;
            allCombinedRoles.add(roleName);
        }
        user.setCombinedRoles(allCombinedRoles);
        return allCombinedRoles;
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("    <dsrealm name=\"");
        xml.append(this.getName());
        xml.append("\"\n             dsName=\"");
        if (this.dsName != null) {
            xml.append(this.dsName);
        }
        xml.append("\"\n             userTable=\"");
        if (this.userTable != null) {
            xml.append(this.userTable);
        }
        xml.append("\" userTableUsernameCol=\"");
        if (this.userTableUsernameCol != null) {
            xml.append(this.userTableUsernameCol);
        }
        xml.append("\" userTablePasswordCol=\"");
        if (this.userTablePasswordCol != null) {
            xml.append(this.userTablePasswordCol);
        }
        xml.append("\"\n             roleTable=\"");
        if (this.roleTable != null) {
            xml.append(this.roleTable);
        }
        xml.append("\" roleTableUsernameCol=\"");
        if (this.roleTableUsernameCol != null) {
            xml.append(this.roleTableUsernameCol);
        }
        xml.append("\" roleTableRolenameCol=\"");
        if (this.roleTableRolenameCol != null) {
            xml.append(this.roleTableRolenameCol);
        }
        if (this.userPrincipalsQuery != null && !this.userPrincipalsQuery.equals("")) {
            xml.append("\"\n             userPrincipalsQuery=\"");
            xml.append(this.userPrincipalsQuery);
        }
        if (this.userRolesQuery != null && !this.userRolesQuery.equals("")) {
            xml.append("\"\n             userRolesQuery=\"");
            xml.append(this.userRolesQuery);
        }
        if (this.algorithm != null && !this.algorithm.equals("")) {
            xml.append("\"\n             algorithm=\"");
            xml.append(this.algorithm);
        }
        xml.append("\" />");
        return xml.toString();
    }

    public String toString() {
        return this.toXML();
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(FACTORY_TYPE, FACTORY_NAME, null);
        reference.add(new StringRefAddr("name", this.getName()));
        reference.add(new StringRefAddr("dsName", this.dsName));
        reference.add(new StringRefAddr("userTable", this.userTable));
        reference.add(new StringRefAddr("userTableUsernameCol", this.userTableUsernameCol));
        reference.add(new StringRefAddr("userTablePasswordCol", this.userTablePasswordCol));
        reference.add(new StringRefAddr("roleTable", this.roleTable));
        reference.add(new StringRefAddr("roleTableUsernameCol", this.roleTableUsernameCol));
        reference.add(new StringRefAddr("roleTableRolenameCol", this.roleTableRolenameCol));
        reference.add(new StringRefAddr("userPrincipalsQuery", this.userPrincipalsQuery));
        reference.add(new StringRefAddr("userRolesQuery", this.userRolesQuery));
        reference.add(new StringRefAddr("algorithm", this.algorithm));
        return reference;
    }

    private void closeConnection(Connection c) {
        block3: {
            if (c == null) {
                return;
            }
            try {
                c.close();
            }
            catch (Exception e) {
                if (!JResourceDS.getLogger().isLoggable(BasicLevel.DEBUG)) break block3;
                JResourceDS.getLogger().log(BasicLevel.DEBUG, (Object)"Can not close the connection");
            }
        }
    }

    private Connection getConnection() throws JResourceException {
        if (this.dataSource == null) {
            InitialContext initialContext = null;
            try {
                initialContext = new InitialContext();
                this.dataSource = (DataSource)initialContext.lookup(this.dsName);
            }
            catch (Exception e) {
                String err = "Cannot find resource " + this.dsName + " in the registry " + e.getMessage();
                JResourceDS.getLogger().log(BasicLevel.ERROR, (Object)err);
                throw new JResourceException(err, (Throwable)e);
            }
        }
        Connection c = null;
        try {
            c = this.dataSource.getConnection();
        }
        catch (SQLException sqle) {
            JResourceDS.getLogger().log(BasicLevel.ERROR, (Object)sqle.getMessage());
            throw new JResourceException(sqle.getMessage(), (Throwable)sqle);
        }
        return c;
    }

    private String userQuery() {
        if (this.userPrincipalsQuery != null) {
            if (JResourceDS.getLogger().isLoggable(BasicLevel.DEBUG)) {
                JResourceDS.getLogger().log(BasicLevel.DEBUG, (Object)("Return user defined SQL query for user" + this.userPrincipalsQuery));
            }
            return this.userPrincipalsQuery;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        stringBuffer.append(this.userTablePasswordCol);
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.userTable);
        stringBuffer.append(" WHERE ");
        stringBuffer.append(this.userTableUsernameCol);
        stringBuffer.append(" = ?");
        return stringBuffer.toString();
    }

    private String rolesOfUserQuery() {
        if (this.userRolesQuery != null) {
            if (JResourceDS.getLogger().isLoggable(BasicLevel.DEBUG)) {
                JResourceDS.getLogger().log(BasicLevel.DEBUG, (Object)("Return user defined SQL query for roles" + this.userRolesQuery));
            }
            return this.userRolesQuery;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT r.");
        stringBuffer.append(this.roleTableRolenameCol);
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.userTable);
        stringBuffer.append(" u, ");
        stringBuffer.append(this.roleTable);
        stringBuffer.append(" r WHERE u.");
        stringBuffer.append(this.userTableUsernameCol);
        stringBuffer.append(" = r.");
        stringBuffer.append(this.roleTableUsernameCol);
        stringBuffer.append(" AND u.");
        stringBuffer.append(this.userTableUsernameCol);
        stringBuffer.append(" = ?");
        return stringBuffer.toString();
    }

    private PreparedStatement userStatement(Connection connection, String username) throws SQLException {
        if (JResourceDS.getLogger().isLoggable(BasicLevel.DEBUG)) {
            JResourceDS.getLogger().log(BasicLevel.DEBUG, (Object)("Creating user statement for the user '" + username + "'"));
        }
        PreparedStatement userStatement = connection.prepareStatement(this.userQuery());
        userStatement.setString(1, username);
        return userStatement;
    }

    private PreparedStatement roleStatement(Connection connection, String username) throws SQLException {
        if (JResourceDS.getLogger().isLoggable(BasicLevel.DEBUG)) {
            JResourceDS.getLogger().log(BasicLevel.DEBUG, (Object)("Creating role statement for the user " + username + "'"));
        }
        PreparedStatement roleStatement = connection.prepareStatement(this.rolesOfUserQuery());
        roleStatement.setString(1, username);
        return roleStatement;
    }

    public void removeMBeans() throws JResourceException {
    }
}

