/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cmi.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.ow2.cmi.config.CMIConfig;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.jonas.cmi.internal.BundleContent;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CmiServiceHelper {
    public static final String CMI_CONFIGURATION_FILE_NAME = "cmi.properties";
    private static Log LOGGER = LogFactory.getLog(CmiServiceHelper.class);
    private static final int BUFFER_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String sendBundle(ServerClusterViewManager clusterViewManager, BundleContent bundle) throws FileNotFoundException {
        String archiveId;
        block14: {
            int len;
            LOGGER.debug((Object)("Sending new load balancing archive located at '" + bundle.getLocation() + "' step 2: trying to transfer data array of the archive to the server-side manager"), new Object[0]);
            InputStream inputStream = null;
            archiveId = null;
            try {
                URL url = new URL(bundle.getLocation());
                inputStream = url.openStream();
            }
            catch (MalformedURLException e1) {
                LOGGER.error((Object)"Unable to send load balancing archive bacause:  ", new Object[]{e1});
            }
            catch (IOException e1) {
                LOGGER.error((Object)"Unable to send load balancing archive bacause: ", new Object[]{e1});
            }
            ByteArrayOutputStream baos = null;
            byte[] buf = new byte[1024];
            baos = new ByteArrayOutputStream();
            while ((len = inputStream.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            byte[] bytesOfFile = baos.toByteArray();
            archiveId = (String)clusterViewManager.addLoadBalancingArchive(bytesOfFile, bundle.getLocation(), (Class[])bundle.getPolicyClasses(), (Class[])bundle.getStrategyClasses());
            try {
                inputStream.close();
                baos.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)" Unable to close archive or stream for file located at ", new Object[]{bundle.getLocation()});
            }
            break block14;
            catch (Exception e) {
                try {
                    LOGGER.error((Object)"Unable to send load balancing archive", new Object[]{e});
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                        baos.close();
                    }
                    catch (IOException e2) {
                        LOGGER.error((Object)" Unable to close archive or stream for file located at ", new Object[]{bundle.getLocation()});
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                    baos.close();
                }
                catch (IOException e3) {
                    LOGGER.error((Object)" Unable to close archive or stream for file located at ", new Object[]{bundle.getLocation()});
                }
            }
        }
        return archiveId;
    }

    public static Properties buildCmiProperties() throws ServiceException {
        CMIConfig.setConfDir((String)JProp.getConfDir());
        File cmiConf = new File(JProp.getConfDir(), CMI_CONFIGURATION_FILE_NAME);
        Properties cmiProperties = new Properties();
        InputStream is = null;
        if (cmiConf.exists()) {
            try {
                is = cmiConf.toURL().openStream();
                LOGGER.debug((Object)("Cmi properties will be loaded from " + cmiConf.getAbsolutePath()), new Object[0]);
            }
            catch (MalformedURLException e) {
                LOGGER.debug((Object)("Unable to load InputStream from " + cmiConf.getPath()), new Object[]{e});
            }
            catch (IOException e) {
                LOGGER.debug((Object)("Unable to load InputStream from " + cmiConf.getPath()), new Object[]{e});
            }
        } else {
            LOGGER.info((Object)("Missing file 'cmi.properties' in JONAS_BASE : " + JProp.getConfDir()), new Object[0]);
            LOGGER.info((Object)"Cmi is configured with default configuration", new Object[0]);
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(CMI_CONFIGURATION_FILE_NAME);
        }
        try {
            cmiProperties.load(is);
            LOGGER.debug((Object)"Cmi properties successfully loaded", new Object[0]);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Unable to load Cmi properties", new Object[0]);
            throw new ServiceException(e.getMessage() + "Unable to load Cmi properties");
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Unnable to close InpuStream for Cmi properties", new Object[0]);
            }
        }
        return cmiProperties;
    }
}

